/*
 * Decompiled with CFR 0.152.
 */
package com.fr.adhoc.report.core;

import com.fr.adhoc.report.core.ADHOCExchangeCalculator;
import com.fr.adhoc.report.core.ADHOCFunctionCalculator;
import com.fr.adhoc.report.core.ADHOCNormalCalculator;
import com.fr.adhoc.report.core.ADHOCPercentGrowthCalculator;
import com.fr.adhoc.report.core.ADHOCSelectFunctionCalculator;
import com.fr.base.Formula;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.json.JSONTransform;
import com.fr.stable.ColumnRow;
import java.util.Map;

public abstract class ADHOCCalculator
implements JSONTransform {
    private int type;
    private String[] colNames;
    private boolean isUseNumber;
    private String numberString;

    public static ADHOCCalculator parseCalculator(JSONObject jSONObject) throws Exception {
        int n2 = jSONObject.getInt("type");
        ADHOCCalculator aDHOCCalculator = null;
        switch (n2) {
            case 0: {
                aDHOCCalculator = new ADHOCNormalCalculator();
                break;
            }
            case 1: {
                aDHOCCalculator = new ADHOCExchangeCalculator();
                break;
            }
            case 2: {
                aDHOCCalculator = new ADHOCNormalCalculator();
                break;
            }
            case 3: {
                aDHOCCalculator = new ADHOCExchangeCalculator();
                break;
            }
            case 4: {
                aDHOCCalculator = new ADHOCSelectFunctionCalculator();
                break;
            }
            case 5: {
                aDHOCCalculator = new ADHOCSelectFunctionCalculator();
                break;
            }
            case 6: {
                aDHOCCalculator = new ADHOCSelectFunctionCalculator();
                break;
            }
            case 7: {
                aDHOCCalculator = new ADHOCSelectFunctionCalculator();
                break;
            }
            case 8: {
                aDHOCCalculator = new ADHOCSelectFunctionCalculator();
                break;
            }
            case 9: {
                aDHOCCalculator = new ADHOCExchangeCalculator();
                break;
            }
            case 10: {
                aDHOCCalculator = new ADHOCPercentGrowthCalculator();
                break;
            }
            case 11: {
                aDHOCCalculator = new ADHOCFunctionCalculator();
                break;
            }
            case 12: {
                aDHOCCalculator = new ADHOCFunctionCalculator();
                break;
            }
            case 13: {
                aDHOCCalculator = new ADHOCFunctionCalculator();
                break;
            }
            default: {
                aDHOCCalculator = new ADHOCNormalCalculator();
            }
        }
        aDHOCCalculator.parseJSON(jSONObject);
        return aDHOCCalculator;
    }

    protected boolean isUserNumber() {
        return this.isUseNumber;
    }

    protected String getNumber() {
        return this.numberString;
    }

    protected int getType() {
        return this.type;
    }

    public void parseJSON(JSONObject jSONObject) throws Exception {
        this.type = jSONObject.getInt("type");
        JSONArray jSONArray = jSONObject.getJSONArray("colnames");
        this.colNames = new String[jSONArray.length()];
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            this.colNames[i2] = jSONArray.getString(i2);
        }
        this.isUseNumber = jSONObject.getBoolean("isUseNumber");
        this.numberString = jSONObject.getString("number");
    }

    public JSONObject createJSON() throws Exception {
        JSONArray jSONArray = new JSONArray();
        for (int i2 = 0; i2 < this.colNames.length; ++i2) {
            jSONArray.put(this.colNames[i2]);
        }
        return new JSONObject().put("type", this.type).put("colnames", jSONArray).put("isUseNumber", this.isUseNumber).put("number", this.numberString);
    }

    public Formula parseFormula(Map map, int n2) {
        String[] stringArray = new String[this.colNames.length];
        for (int i2 = 0; i2 < this.colNames.length; ++i2) {
            stringArray[i2] = ColumnRow.valueOf((Integer)map.get(this.colNames[i2]), n2).toString();
        }
        return new Formula(this.parse2FormulaContent(stringArray));
    }

    protected abstract String parse2FormulaContent(String[] var1);

    protected String getOperator() {
        switch (this.type) {
            case 0: {
                return "+";
            }
            case 1: {
                return "-";
            }
            case 2: {
                return "*";
            }
            case 3: {
                return "/";
            }
            case 4: {
                return "POWER";
            }
            case 5: {
                return "ABS";
            }
            case 6: {
                return "ROUND";
            }
            case 7: {
                return "ROUNDDOWN";
            }
            case 8: {
                return "SQRT(ABS";
            }
            case 9: {
                return "/";
            }
            case 10: {
                return "/";
            }
            case 11: {
                return "AVERAGE";
            }
            case 12: {
                return "MAX";
            }
            case 13: {
                return "MIN";
            }
        }
        return "+";
    }
}

