/*
 * Decompiled with CFR 0.152.
 */
package com.fr.adhoc.report;

import com.fr.adhoc.report.NormalADHOCReport;
import com.fr.adhoc.report.SimpleADHOCStyle;
import com.fr.adhoc.report.core.ADHOCColumn;
import com.fr.adhoc.report.core.SimpleADHOCColumn;
import com.fr.base.BrowserI18N;
import com.fr.base.Formula;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.main.impl.WorkBook;
import com.fr.report.cell.DefaultTemplateCellElement;
import com.fr.report.cell.TemplateCellElement;
import com.fr.report.cell.cellattr.CellExpandAttr;
import com.fr.report.cell.cellattr.core.group.DSColumn;
import com.fr.report.cell.cellattr.core.group.FunctionGrouper;
import com.fr.report.cell.cellattr.core.group.RecordGrouper;
import com.fr.report.cell.cellattr.core.group.SummaryGrouper;
import com.fr.report.core.SheetUtils;
import com.fr.report.worksheet.WorkSheet;
import com.fr.stable.ColumnRow;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.web.core.A.l;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SimpleADHOCReport
extends NormalADHOCReport {
    public static int TYPE = 0;
    private SimpleADHOCColumn[] displayColumns;
    private ADHOCColumn[] groupColumns;
    private ADHOCColumn sortColumn;
    private SimpleADHOCStyle simpleADHOCStyle;
    private List detailColumns;

    public void setSimpleADHOCStyle(SimpleADHOCStyle simpleADHOCStyle) {
        this.simpleADHOCStyle = simpleADHOCStyle;
    }

    public void setDisplayColumns(SimpleADHOCColumn[] simpleADHOCColumnArray) {
        this.displayColumns = simpleADHOCColumnArray;
    }

    public void setGroupColumns(ADHOCColumn[] aDHOCColumnArray) {
        this.groupColumns = aDHOCColumnArray;
    }

    public void setSortColumns(ADHOCColumn aDHOCColumn) {
        this.sortColumn = aDHOCColumn;
    }

    private List getDetailColumns() {
        if (this.detailColumns == null) {
            this.detailColumns = new ArrayList();
            if (this.displayColumns != null) {
                int n2 = this.displayColumns.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this.isGroupOrSortColumn(this.displayColumns[i2])) continue;
                    this.detailColumns.add(this.displayColumns[i2]);
                }
            }
        }
        return this.detailColumns;
    }

    private boolean isGroupOrSortColumn(SimpleADHOCColumn simpleADHOCColumn) {
        if (this.groupColumns != null) {
            int n2 = this.groupColumns.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!this.groupColumns[i2].getColumnName().equals(simpleADHOCColumn.getColumnName())) continue;
                return true;
            }
        }
        if (this.getSummaryColumns().length > 0 && this.getSummaryColumns()[0].getColumnName().equals(simpleADHOCColumn.getColumnName())) {
            return true;
        }
        if (this.sortColumn != null) {
            return this.sortColumn.getColumnName().equals(simpleADHOCColumn.getColumnName());
        }
        return false;
    }

    public WorkBook createWorkBook() {
        WorkBook workBook = new WorkBook();
        workBook.putTableData(this.getViewName(), this.getADHOCData());
        WorkSheet workSheet = new WorkSheet();
        workBook.addReport(workSheet);
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.titleCells());
        arrayList.addAll(this.headerColumns());
        arrayList.addAll(this.generateContentColumns());
        arrayList.addAll(this.generateOtherColumns());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            workSheet.addCellElement((TemplateCellElement)iterator.next());
        }
        SheetUtils.calculateDefaultParent(workSheet);
        if (StringUtils.isNotBlank(this.getTitle())) {
            workSheet.setRowHeight(0, this.simpleADHOCStyle.getRowTitleHeight());
        }
        int n2 = this.totalWidth();
        for (int i2 = 0; i2 < n2; ++i2) {
            workSheet.setColumnWidth(i2, this.simpleADHOCStyle.getColumnWidth());
        }
        return workBook;
    }

    private int totalWidth() {
        return this.getDetailColumns().size() + (this.groupColumns == null ? 0 : this.groupColumns.length) + (this.getSummaryColumns().length == 0 ? 0 : 1) + (this.sortColumn == null ? 0 : 1);
    }

    private List titleCells() {
        ArrayList<DefaultTemplateCellElement> arrayList = new ArrayList<DefaultTemplateCellElement>();
        DefaultTemplateCellElement defaultTemplateCellElement = new DefaultTemplateCellElement(0, 0);
        defaultTemplateCellElement.setColumnSpan(this.totalWidth());
        defaultTemplateCellElement.setValue(this.getTitle());
        defaultTemplateCellElement.setStyle(this.simpleADHOCStyle.getTitleStyle());
        arrayList.add(defaultTemplateCellElement);
        DefaultTemplateCellElement defaultTemplateCellElement2 = new DefaultTemplateCellElement(0, 1);
        defaultTemplateCellElement2.setColumnSpan(this.totalWidth());
        defaultTemplateCellElement2.setValue(this.getSubtitle());
        defaultTemplateCellElement2.setStyle(this.simpleADHOCStyle.getSubTitleStyle());
        arrayList.add(defaultTemplateCellElement2);
        return arrayList;
    }

    private int titleHeight() {
        int n2 = 0;
        if (StringUtils.isNotEmpty(this.getTitle())) {
            ++n2;
            if (StringUtils.isNotEmpty(this.getSubtitle())) {
                ++n2;
            }
        }
        return n2;
    }

    private List headerColumns() {
        int n2;
        ArrayList<DefaultTemplateCellElement> arrayList = new ArrayList<DefaultTemplateCellElement>();
        int n3 = 0;
        if (this.groupColumns != null) {
            n3 = this.groupColumns.length;
            for (n2 = 0; n2 < n3; ++n2) {
                DefaultTemplateCellElement defaultTemplateCellElement = new DefaultTemplateCellElement(n2, this.titleHeight());
                defaultTemplateCellElement.setValue(this.groupColumns[n2].getColumnName());
                defaultTemplateCellElement.setStyle(this.simpleADHOCStyle.getReportHeaderStyle());
                arrayList.add(defaultTemplateCellElement);
            }
        }
        n2 = this.getDetailColumns().size();
        for (int i2 = 0; i2 < n2; ++i2) {
            DefaultTemplateCellElement defaultTemplateCellElement = new DefaultTemplateCellElement(n3 + i2, this.titleHeight());
            defaultTemplateCellElement.setValue(((SimpleADHOCColumn)this.getDetailColumns().get(i2)).getColumnName());
            defaultTemplateCellElement.setStyle(this.simpleADHOCStyle.getReportHeaderStyle());
            arrayList.add(defaultTemplateCellElement);
        }
        if (this.getSummaryColumns().length != 0) {
            DefaultTemplateCellElement defaultTemplateCellElement = new DefaultTemplateCellElement(n3 + n2, this.titleHeight());
            defaultTemplateCellElement.setValue(this.getSummaryColumns()[0].getColumnName());
            defaultTemplateCellElement.setStyle(this.simpleADHOCStyle.getReportHeaderStyle());
            arrayList.add(defaultTemplateCellElement);
        }
        return arrayList;
    }

    private List generateContentColumns() {
        XMLReadable xMLReadable;
        XMLable xMLable;
        XMLable xMLable2;
        XMLReadable xMLReadable2;
        int n2;
        int n3;
        ArrayList<XMLReadable> arrayList = new ArrayList<XMLReadable>();
        int n4 = this.titleHeight() + 1;
        int n5 = 0;
        int n6 = this.getDetailColumns().size() + (this.sortColumn == null ? 0 : 1);
        int n7 = n3 = n6 == 0 ? 0 : 1;
        if (this.groupColumns != null) {
            n5 = this.groupColumns.length;
            for (n2 = 0; n2 < n5; ++n2) {
                DefaultTemplateCellElement defaultTemplateCellElement = new DefaultTemplateCellElement(n2, n4);
                defaultTemplateCellElement.setStyle(this.simpleADHOCStyle.getReportCotentStyle());
                xMLReadable2 = new CellExpandAttr();
                ((CellExpandAttr)xMLReadable2).setDirection((byte)0);
                defaultTemplateCellElement.setCellExpandAttr((CellExpandAttr)xMLReadable2);
                if (this.getSummaryColumns().length != 0) {
                    defaultTemplateCellElement.setRowSpan(n5 - n2 + n3);
                }
                xMLable2 = new DSColumn();
                ((DSColumn)xMLable2).setColumnName(this.groupColumns[n2].getColumnName());
                ((DSColumn)xMLable2).setDSName(this.getViewName());
                if (n2 == 0) {
                    ((DSColumn)xMLable2).setCondition(this.getCondition());
                }
                xMLable = new FunctionGrouper();
                ((FunctionGrouper)xMLable).setDivideMode(0);
                ((FunctionGrouper)xMLable).setCustom(false);
                ((DSColumn)xMLable2).setGrouper((RecordGrouper)xMLable);
                defaultTemplateCellElement.setValue(xMLable2);
                arrayList.add(defaultTemplateCellElement);
                if (this.getSummaryColumns().length == 0 || n2 <= 0) continue;
                xMLReadable = new DefaultTemplateCellElement(n2, n4 + n5 - n2 + n3);
                xMLReadable.setStyle(this.simpleADHOCStyle.getSummaryStyle());
                xMLReadable.setValue(BrowserI18N.getLocText("Summary", l.a));
                xMLReadable.setColumnSpan(n5 - n2 + n6);
                arrayList.add(xMLReadable);
            }
        }
        int n8 = this.getDetailColumns().size();
        for (n2 = 0; n2 < n8; ++n2) {
            xMLReadable2 = new DefaultTemplateCellElement(n5 + n2, n4);
            xMLReadable2.setStyle(this.simpleADHOCStyle.getReportCotentStyle());
            xMLable2 = new CellExpandAttr();
            ((CellExpandAttr)xMLable2).setDirection((byte)0);
            xMLReadable2.setCellExpandAttr((CellExpandAttr)xMLable2);
            xMLable = new DSColumn();
            ((DSColumn)xMLable).setColumnName(((SimpleADHOCColumn)this.getDetailColumns().get(n2)).getColumnName());
            ((DSColumn)xMLable).setDSName(this.getViewName());
            if (n2 == 0 && this.groupColumns == null) {
                ((DSColumn)xMLable).setCondition(this.getCondition());
            }
            xMLReadable = new FunctionGrouper();
            ((FunctionGrouper)xMLReadable).setDivideMode(1);
            ((FunctionGrouper)xMLReadable).setCustom(false);
            ((DSColumn)xMLable).setGrouper((RecordGrouper)xMLReadable);
            xMLReadable2.setValue(xMLable);
            arrayList.add(xMLReadable2);
        }
        if (this.sortColumn != null) {
            DefaultTemplateCellElement defaultTemplateCellElement = new DefaultTemplateCellElement(n5 + this.getDetailColumns().size(), n4);
            defaultTemplateCellElement.setStyle(this.simpleADHOCStyle.getReportCotentStyle());
            CellExpandAttr cellExpandAttr = new CellExpandAttr();
            cellExpandAttr.setDirection((byte)0);
            defaultTemplateCellElement.setCellExpandAttr(cellExpandAttr);
            xMLReadable2 = new DSColumn();
            ((DSColumn)xMLReadable2).setColumnName(this.sortColumn.getColumnName());
            ((DSColumn)xMLReadable2).setDSName(this.getViewName());
            if (this.groupColumns == null && this.getDetailColumns().size() == 0) {
                ((DSColumn)xMLReadable2).setCondition(this.getCondition());
            }
            xMLable2 = new FunctionGrouper();
            ((FunctionGrouper)xMLable2).setDivideMode(1);
            ((FunctionGrouper)xMLable2).setCustom(false);
            ((DSColumn)xMLReadable2).setGrouper((RecordGrouper)xMLable2);
            defaultTemplateCellElement.setValue(xMLReadable2);
            arrayList.add(defaultTemplateCellElement);
        }
        if (this.getSummaryColumns().length != 0) {
            DefaultTemplateCellElement defaultTemplateCellElement = new DefaultTemplateCellElement(n5 + n6, n4);
            defaultTemplateCellElement.setStyle(this.simpleADHOCStyle.getReportCotentStyle());
            CellExpandAttr cellExpandAttr = new CellExpandAttr();
            cellExpandAttr.setDirection((byte)2);
            defaultTemplateCellElement.setCellExpandAttr(cellExpandAttr);
            xMLReadable2 = new DSColumn();
            ((DSColumn)xMLReadable2).setColumnName(this.getSummaryColumns()[0].getColumnName());
            ((DSColumn)xMLReadable2).setDSName(this.getViewName());
            if (this.groupColumns == null && this.getDetailColumns().size() == 0 && this.sortColumn == null) {
                ((DSColumn)xMLReadable2).setCondition(this.getCondition());
            }
            xMLable2 = new SummaryGrouper();
            ((SummaryGrouper)xMLable2).setFunction(this.getSummaryColumns()[0].getFunction());
            ((DSColumn)xMLReadable2).setGrouper((RecordGrouper)xMLable2);
            defaultTemplateCellElement.setValue(xMLReadable2);
            arrayList.add(defaultTemplateCellElement);
        }
        return arrayList;
    }

    private List generateOtherColumns() {
        int n2 = this.getDetailColumns().size() + (this.sortColumn == null ? 0 : 1);
        int n3 = n2 == 0 ? 0 : 1;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.getSummaryColumns().length != 0) {
            Object object;
            DefaultTemplateCellElement defaultTemplateCellElement = new DefaultTemplateCellElement(0, this.titleHeight() + this.groupColumns.length + 1 + n3);
            defaultTemplateCellElement.setValue(BrowserI18N.getLocText("Summary", l.a));
            defaultTemplateCellElement.setColumnSpan(this.totalWidth() - 1);
            defaultTemplateCellElement.setStyle(this.simpleADHOCStyle.getSummaryStyle());
            arrayList.add(defaultTemplateCellElement);
            if (n2 > 0) {
                object = new DefaultTemplateCellElement(this.groupColumns.length, this.titleHeight() + 2);
                object.setValue(BrowserI18N.getLocText("Summary", l.a));
                object.setColumnSpan(this.totalWidth() - 1 - this.groupColumns.length);
                object.setStyle(this.simpleADHOCStyle.getSummaryStyle());
                arrayList.add(object);
            }
            object = this.getSummaryColumns()[0].getFunction().getFormula() + "(" + this.getSummaryCell() + ")";
            int n4 = (this.groupColumns == null ? 0 : this.groupColumns.length) + n3;
            for (int i2 = 0; i2 < n4; ++i2) {
                DefaultTemplateCellElement defaultTemplateCellElement2 = new DefaultTemplateCellElement(this.summaryCellPosition()[0], this.summaryCellPosition()[1] + i2 + 1);
                defaultTemplateCellElement2.setValue(new Formula((String)object));
                defaultTemplateCellElement2.setStyle(this.simpleADHOCStyle.getSummaryStyle());
                arrayList.add(defaultTemplateCellElement2);
            }
        }
        return arrayList;
    }

    private String getSummaryCell() {
        return ColumnRow.valueOf(this.summaryCellPosition()[0], this.summaryCellPosition()[1]).toString();
    }

    private int[] summaryCellPosition() {
        return new int[]{this.totalWidth() - (this.getSummaryColumns().length == 0 ? 0 : 1), this.titleHeight() + 1};
    }

    public JSONObject createJSON() throws Exception {
        return null;
    }

    public void parseJSON(JSONObject jSONObject) throws Exception {
        SimpleADHOCColumn simpleADHOCColumn;
        int n2;
        SimpleADHOCColumn[] simpleADHOCColumnArray;
        int n3;
        Object object;
        super.parseJSON(jSONObject);
        if (jSONObject.has("displaycolumns")) {
            object = jSONObject.getJSONArray("displaycolumns");
            n3 = ((JSONArray)object).length();
            simpleADHOCColumnArray = new SimpleADHOCColumn[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                simpleADHOCColumn = new SimpleADHOCColumn();
                simpleADHOCColumn.parseJSON(((JSONArray)object).getJSONObject(n2));
                simpleADHOCColumnArray[n2] = simpleADHOCColumn;
            }
            this.setDisplayColumns(simpleADHOCColumnArray);
        }
        if (jSONObject.has("groupcolumns")) {
            object = jSONObject.getJSONArray("groupcolumns");
            n3 = ((JSONArray)object).length();
            simpleADHOCColumnArray = new ADHOCColumn[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                simpleADHOCColumn = new ADHOCColumn();
                ((ADHOCColumn)simpleADHOCColumn).parseJSON(((JSONArray)object).getJSONObject(n2));
                simpleADHOCColumnArray[n2] = simpleADHOCColumn;
            }
            this.setGroupColumns((ADHOCColumn[])simpleADHOCColumnArray);
        }
        if (jSONObject.has("sortcolumn")) {
            object = new ADHOCColumn();
            ((ADHOCColumn)object).parseJSON(jSONObject.getJSONObject("sortcolumn"));
            this.setSortColumns((ADHOCColumn)object);
        }
        if (jSONObject.has("simplestyle")) {
            this.setSimpleADHOCStyle(null);
        }
    }
}

