/*
 * Decompiled with CFR 0.152.
 */
package com.fr.adhoc.report;

import com.fr.adhoc.report.ADHOCUtils;
import com.fr.adhoc.report.CrossedADHOCStyle;
import com.fr.adhoc.report.NormalADHOCReport;
import com.fr.adhoc.report.core.ADHOCAddColumn;
import com.fr.adhoc.report.core.ADHOCColumn;
import com.fr.adhoc.report.core.ADHOCGroupAndResultColumn;
import com.fr.adhoc.report.core.ADHOCSummaryColumn;
import com.fr.adhoc.report.core.SimpleADHOCColumn;
import com.fr.base.BrowserI18N;
import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.chart.BaseChart;
import com.fr.base.chart.BaseChartCollection;
import com.fr.base.chart.BaseChartGetter;
import com.fr.base.chartdata.BaseNormalReportDefinition;
import com.fr.base.chartdata.BaseSeriesDefinition;
import com.fr.base.chartdata.TopDefinition;
import com.fr.data.util.function.CountFunction;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.main.impl.WorkBook;
import com.fr.report.cell.ADHOCCalCellElement;
import com.fr.report.cell.ADHOCCellElement;
import com.fr.report.cell.ADHOCDefaultCellElement;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.cellattr.CellExpandAttr;
import com.fr.report.cell.cellattr.core.group.DSColumn;
import com.fr.report.cell.cellattr.core.group.SummaryGrouper;
import com.fr.report.core.SheetUtils;
import com.fr.report.worksheet.WorkSheet;
import com.fr.stable.ArrayUtils;
import com.fr.stable.ColumnRow;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.core.A.l;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class CrossedADHOCReport
extends NormalADHOCReport {
    public static int TYPE = 1;
    private ADHOCColumn[] columnColumns;
    private ADHOCColumn[] rowColumns;
    private CrossedADHOCStyle crossedADHOCStyle = new CrossedADHOCStyle();
    private static String SEPARATE = "-:-";

    public void setColumnColumns(ADHOCColumn[] aDHOCColumnArray) {
        this.columnColumns = aDHOCColumnArray;
    }

    public void setRowColumns(ADHOCColumn[] aDHOCColumnArray) {
        this.rowColumns = aDHOCColumnArray;
    }

    public WorkBook createWorkBook() {
        WorkBook workBook = new WorkBook();
        workBook.putTableData(this.getViewName(), this.getADHOCData());
        WorkSheet workSheet = new WorkSheet();
        List list = this.cacuCells();
        for (ADHOCCellElement aDHOCCellElement : list) {
            workSheet.addCellElement(aDHOCCellElement);
        }
        workSheet.setRowHeight(0, this.crossedADHOCStyle.getRowTitleHeight());
        int n2 = this.extactTotalWidth();
        for (int i2 = 0; i2 < n2; ++i2) {
            workSheet.setColumnWidth(i2, this.crossedADHOCStyle.getColumnWidth());
        }
        SheetUtils.calculateDefaultParent(workSheet);
        workBook.addReport(workSheet);
        return workBook;
    }

    private int totalWidth() {
        return (this.getColLength() + 1) * this.getSummaryColumns().length + this.getRowLength() + this.getAddedColumns();
    }

    private int extactTotalWidth() {
        return this.totalWidth() - this.getAddedColumns() + this.getAddedCells().size();
    }

    private List cacuCells() {
        ArrayList<CellElement> arrayList = new ArrayList<CellElement>();
        arrayList.add(this.generateTopCell());
        arrayList.addAll(this.generateColumnCells());
        arrayList.addAll(this.generateRowCells());
        arrayList.addAll(this.generateSummaryCell());
        arrayList.addAll(this.generateOtherSummaryCells());
        arrayList.addAll(this.getAddedTitleCells());
        List list = this.getAddedCells();
        this.parseValue(list);
        arrayList.addAll(list);
        List list2 = this.getAddedBottomCells();
        this.parseValue(list2);
        arrayList.addAll(list2);
        arrayList.add(this.generateTitleCell(0, 0));
        arrayList.add(this.generateSubTitleCell(0, 1));
        if (this.chartDefine != null) {
            arrayList.add(this.generateChartCell());
        }
        return arrayList;
    }

    private void parseValue(List list) {
        for (CellElement cellElement : list) {
            if (!(cellElement.getValue() instanceof ADHOCAddColumn)) continue;
            ADHOCAddColumn aDHOCAddColumn = (ADHOCAddColumn)cellElement.getValue();
            cellElement.setValue(aDHOCAddColumn.getFormula(this.addedCellMap, cellElement.getRow()));
        }
    }

    private CellElement generateChartCell() {
        ADHOCCalCellElement aDHOCCalCellElement = new ADHOCCalCellElement(0, 2, "fr-chart");
        aDHOCCalCellElement.setColumnSpan(this.extactTotalWidth());
        aDHOCCalCellElement.setRowSpan(14);
        BaseChart[] baseChartArray = BaseChartGetter.getStaticChartTypes(this.chartDefine.getChartContent());
        try {
            BaseChart baseChart = (BaseChart)baseChartArray[this.chartDefine.getChartType()].clone();
            baseChart.changePlotFormat4ADHOC(this.getValueCellFormat());
            BaseChartCollection baseChartCollection = (BaseChartCollection)StableFactory.createXmlObject("CC");
            baseChartCollection.addChart(baseChart);
            TopDefinition topDefinition = this.crateChartDefinition();
            baseChart.setFilterDefinition(topDefinition);
            aDHOCCalCellElement.setValue(baseChartCollection);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRContext.getLogger().error(cloneNotSupportedException.getMessage(), cloneNotSupportedException);
        }
        return aDHOCCalCellElement;
    }

    private Format getValueCellFormat() {
        String string = this.getSummaryColumns()[0].getColumnName() + SEPARATE + "col";
        try {
            Object v2 = this.cellSettingMap.get(string);
            Format format = null;
            if (v2 instanceof JSONObject) {
                format = ADHOCUtils.parseFormat((JSONObject)v2);
            }
            if (format != null) {
                return format;
            }
            if (!(this.getSummaryColumns()[0].getFunction() instanceof CountFunction)) {
                return decimalFormat;
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
        }
        return null;
    }

    private TopDefinition crateChartDefinition() {
        BaseNormalReportDefinition baseNormalReportDefinition = (BaseNormalReportDefinition)StableFactory.createXmlObject("BaseNormalReportDefinition");
        baseNormalReportDefinition.addAll(this.getChartSeriesDefinitionList());
        baseNormalReportDefinition.setCategoryName(new Formula(this.getChartCategoryName()));
        return (TopDefinition)((Object)baseNormalReportDefinition);
    }

    private List getChartSeriesDefinitionList() {
        ArrayList<BaseSeriesDefinition> arrayList = new ArrayList<BaseSeriesDefinition>();
        int n2 = this.getColLength();
        int n3 = this.getRowLength();
        if (n2 == 0) {
            this.addNoneColSeriesDefinition(arrayList, n3);
        } else if (n2 == 1) {
            this.addOneColSeriesDefinition(arrayList, n3);
        } else {
            int n4 = this.getAddColumnsWithOutSum();
            int n5 = this.getSummaryColumns().length + n4 > 1 ? 1 : 0;
            ColumnRow columnRow = ColumnRow.valueOf(this.getChartCategoryName());
            int n6 = n3 + n4 + this.getSummaryColumns().length;
            for (int i2 = 0; i2 < this.getSummaryColumns().length; ++i2) {
                ColumnRow columnRow2 = ColumnRow.valueOf(columnRow.getColumn() + n4 + this.getSummaryColumns().length - 1 + n2 - 1 + i2, columnRow.getRow() + (n3 == 0 ? 0 : n3 - 1) + n2 + n5);
                BaseSeriesDefinition baseSeriesDefinition = (BaseSeriesDefinition)StableFactory.createNewObject("BaseSeriesDefinition");
                baseSeriesDefinition.setSeriesName(new Formula(this.getChartSericeName() + (n5 == 0 ? "" : "+\"-\"+INDEXOFARRAY((" + ColumnRow.valueOf(columnRow2.getColumn(), columnRow2.getRow() - 1).toString() + "), 1)")));
                baseSeriesDefinition.setValue(new Formula(columnRow2.toString()));
                arrayList.add(baseSeriesDefinition);
            }
        }
        return arrayList;
    }

    private void addNoneColSeriesDefinition(List list, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n3 = this.extactTotalWidth();
        for (int i2 = n2; i2 < n3; ++i2) {
            stringBuffer.append(ColumnRow.valueOf(i2, this.titleAppend() + n2).toString());
            if (i2 == n3 - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("]");
        BaseSeriesDefinition baseSeriesDefinition = (BaseSeriesDefinition)StableFactory.createNewObject("BaseSeriesDefinition");
        baseSeriesDefinition.setSeriesName(new Formula(this.getChartSericeName()));
        baseSeriesDefinition.setValue(new Formula(stringBuffer.toString()));
        list.add(baseSeriesDefinition);
    }

    private void addOneColSeriesDefinition(List list, int n2) {
        int n3 = this.getAddColumnsWithOutSum();
        int n4 = this.getSummaryColumns().length + n3 + n2;
        ColumnRow columnRow = ColumnRow.valueOf(this.getChartCategoryName());
        int n5 = n4 - n2 > 1 ? 1 : 0;
        for (int i2 = n2; i2 < n4; ++i2) {
            BaseSeriesDefinition baseSeriesDefinition = (BaseSeriesDefinition)StableFactory.createNewObject("BaseSeriesDefinition");
            baseSeriesDefinition.setSeriesName(new Formula(this.getChartSericeName() + (n5 == 0 ? "" : "+\"-\"+INDEXOFARRAY((" + ColumnRow.valueOf(columnRow.getColumn() + i2 - 1, columnRow.getRow() + 1).toString() + "), 1)")));
            baseSeriesDefinition.setValue(new Formula(ColumnRow.valueOf(i2, columnRow.getRow() + n5 + (n2 == 0 ? 0 : n2 - 1) + 1).toString()));
            list.add(baseSeriesDefinition);
        }
    }

    private String getChartCategoryName() {
        if (this.getColLength() == 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[");
            int n2 = this.extactTotalWidth();
            for (int i2 = this.getRowLength(); i2 < n2; ++i2) {
                stringBuffer.append(ColumnRow.valueOf(i2, this.titleAppend()).toString());
                if (i2 == n2 - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
        return this.getColumnCellsCR(0).toString();
    }

    private String getChartSericeName() {
        if (this.getRowLength() == 0) {
            return "\"" + this.getViewName() + "\"";
        }
        return this.getRowCellsCR(0).toString();
    }

    private ColumnRow getColumnCellsCR(int n2) {
        return ColumnRow.valueOf(this.getRowLength(), this.titleAppend() + n2);
    }

    private ColumnRow getRowCellsCR(int n2) {
        int n3 = this.getColLength();
        int n4 = this.titleAppend() + n3;
        if (n3 == 0 || this.getSummaryColumns().length + this.getAddColumnsWithOutSum() > 1) {
            ++n4;
        }
        return ColumnRow.valueOf(n2, n4);
    }

    private CellElement generateTitleCell(int n2, int n3) {
        ADHOCDefaultCellElement aDHOCDefaultCellElement = new ADHOCDefaultCellElement(n2, n3, "__Title");
        aDHOCDefaultCellElement.setColumnSpan(this.extactTotalWidth());
        aDHOCDefaultCellElement.setValue(this.getTitle());
        aDHOCDefaultCellElement.setStyle(this.crossedADHOCStyle.getTitleStyle());
        this.setCellAttribute(aDHOCDefaultCellElement);
        return aDHOCDefaultCellElement;
    }

    private CellElement generateSubTitleCell(int n2, int n3) {
        ADHOCDefaultCellElement aDHOCDefaultCellElement = new ADHOCDefaultCellElement(n2, n3, "__SubTitle");
        aDHOCDefaultCellElement.setColumnSpan(this.extactTotalWidth());
        aDHOCDefaultCellElement.setValue(this.getSubtitle());
        aDHOCDefaultCellElement.setStyle(this.crossedADHOCStyle.getSubTitleStyle());
        this.setCellAttribute(aDHOCDefaultCellElement);
        return aDHOCDefaultCellElement;
    }

    private CellElement generateTopCell() {
        ADHOCDefaultCellElement aDHOCDefaultCellElement = new ADHOCDefaultCellElement(0, this.titleAppend(), "__LeftTop");
        aDHOCDefaultCellElement.setColumnSpan(this.getRowLength());
        int n2 = this.getColLength();
        int n3 = n2 == 0 || this.getSummaryColumns().length + this.getAddColumnsWithOutSum() > 1 ? 1 : 0;
        aDHOCDefaultCellElement.setRowSpan(n2 + n3);
        aDHOCDefaultCellElement.setStyle(this.crossedADHOCStyle.getRowHeaderStyle());
        if (this.getSummaryColumns().length == 1) {
            aDHOCDefaultCellElement.setValue(this.getSummaryColumnName(0));
        }
        this.setCellAttribute(aDHOCDefaultCellElement);
        return aDHOCDefaultCellElement;
    }

    private List generateColumnCells() {
        Cloneable cloneable;
        int n2;
        ArrayList<ADHOCCellElement> arrayList = new ArrayList<ADHOCCellElement>();
        int n3 = this.getColLength();
        ArrayList<SimpleADHOCColumn> arrayList2 = new ArrayList<SimpleADHOCColumn>();
        int n4 = this.columnColumns.length;
        for (n2 = 0; n2 < n4; ++n2) {
            cloneable = this.getGroupColumn(this.columnColumns[n2].getColumnName());
            if (cloneable != null) {
                arrayList2.add((SimpleADHOCColumn)cloneable);
                continue;
            }
            arrayList2.add(this.columnColumns[n2]);
        }
        n4 = arrayList2.size();
        for (n2 = 0; n2 < n4; ++n2) {
            cloneable = this.getColumnCellsCR(n2);
            ADHOCGroupAndResultColumn aDHOCGroupAndResultColumn = (ADHOCGroupAndResultColumn)arrayList2.get(n2);
            ADHOCCellElement aDHOCCellElement = aDHOCGroupAndResultColumn.getADHOCCellElement((ColumnRow)cloneable);
            aDHOCCellElement.setStyle(this.crossedADHOCStyle.getColumnHeaderStyle());
            CellExpandAttr cellExpandAttr = new CellExpandAttr();
            cellExpandAttr.setDirection((byte)1);
            aDHOCCellElement.setCellExpandAttr(cellExpandAttr);
            int n5 = (n4 - n2) * this.getSummaryColumns().length + this.getAddColumnsWithOutSum();
            aDHOCCellElement.setColumnSpan(n5);
            DSColumn dSColumn = new DSColumn();
            dSColumn.setColumnName(((SimpleADHOCColumn)((Object)aDHOCGroupAndResultColumn)).getColumnName());
            dSColumn.setDSName(this.getViewName());
            if (n2 == 0) {
                dSColumn.setCondition(this.getCondition());
            }
            dSColumn.setGrouper(aDHOCGroupAndResultColumn.getGrouper());
            aDHOCCellElement.setValue(dSColumn);
            this.setCellAttribute(aDHOCCellElement);
            arrayList.add(aDHOCCellElement);
            int n6 = this.getColLength() == 0 || this.getSummaryColumns().length + this.getAddColumnsWithOutSum() > 1 ? 1 : 0;
            arrayList.addAll(this.generateColumnSummaryNameCells(((ColumnRow)cloneable).getColumn() + n5, ((ColumnRow)cloneable).getRow(), n4 - n2 + n6, true, n2 == 0));
        }
        return arrayList;
    }

    private int getAddColumnsWithOutSum() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.getSummaryColumns().length && i2 <= this.getSummaryColumns().length - 1; ++i2) {
            ADHOCAddColumn aDHOCAddColumn = this.getADHOCAddColumn(this.getColCellNameIndex(i2));
            if (aDHOCAddColumn == null) continue;
            n2 += aDHOCAddColumn.getAddColumns();
        }
        return n2;
    }

    private List generateRowCells() {
        Cloneable cloneable;
        int n2;
        ArrayList<ADHOCCellElement> arrayList = new ArrayList<ADHOCCellElement>();
        int n3 = 0;
        ArrayList<SimpleADHOCColumn> arrayList2 = new ArrayList<SimpleADHOCColumn>();
        int n4 = this.rowColumns.length;
        for (n2 = 0; n2 < n4; ++n2) {
            cloneable = this.getGroupColumn(this.rowColumns[n2].getColumnName());
            if (cloneable != null) {
                arrayList2.add((SimpleADHOCColumn)cloneable);
                continue;
            }
            arrayList2.add(this.rowColumns[n2]);
        }
        n4 = arrayList2.size();
        for (n2 = 0; n2 < n4; ++n2) {
            cloneable = this.getRowCellsCR(n2);
            ADHOCGroupAndResultColumn aDHOCGroupAndResultColumn = (ADHOCGroupAndResultColumn)arrayList2.get(n2);
            cloneable = ColumnRow.valueOf(((ColumnRow)cloneable).getColumn() + n3, ((ColumnRow)cloneable).getRow());
            ADHOCCellElement aDHOCCellElement = aDHOCGroupAndResultColumn.getADHOCCellElement((ColumnRow)cloneable);
            aDHOCCellElement.setStyle(this.crossedADHOCStyle.getRowHeaderStyle());
            CellExpandAttr cellExpandAttr = new CellExpandAttr();
            cellExpandAttr.setDirection((byte)0);
            aDHOCCellElement.setCellExpandAttr(cellExpandAttr);
            aDHOCCellElement.setRowSpan(n4 - n2);
            DSColumn dSColumn = new DSColumn();
            dSColumn.setColumnName(aDHOCGroupAndResultColumn.getColumnName());
            dSColumn.setDSName(this.getViewName());
            if (n2 == 0) {
                dSColumn.setCondition(this.getCondition());
            }
            dSColumn.setGrouper(aDHOCGroupAndResultColumn.getGrouper());
            aDHOCCellElement.setValue(dSColumn);
            this.setCellAttribute(aDHOCCellElement);
            arrayList.add(aDHOCCellElement);
            ADHOCDefaultCellElement aDHOCDefaultCellElement = new ADHOCDefaultCellElement(((ColumnRow)cloneable).getColumn(), ((ColumnRow)cloneable).getRow() + n4 - n2, this.getSumCellNameString(aDHOCGroupAndResultColumn.getColumnName()));
            aDHOCDefaultCellElement.setStyle(this.crossedADHOCStyle.getRowHeaderStyle());
            aDHOCDefaultCellElement.setValue(BrowserI18N.getLocText("Summary", l.a));
            aDHOCDefaultCellElement.setColumnSpan(n4 - n2);
            this.setCellAttribute(aDHOCDefaultCellElement);
            arrayList.add(aDHOCDefaultCellElement);
        }
        return arrayList;
    }

    private int generateAddCell(String string, ColumnRow columnRow) {
        ADHOCAddColumn aDHOCAddColumn = this.getADHOCAddColumn(string);
        int n2 = 0;
        if (aDHOCAddColumn != null) {
            Iterator iterator = aDHOCAddColumn.iterator();
            int n3 = 0;
            while (iterator.hasNext()) {
                ++n2;
                ADHOCAddColumn aDHOCAddColumn2 = (ADHOCAddColumn)iterator.next();
                columnRow = ColumnRow.valueOf(columnRow.getColumn() + n3 + 1, columnRow.getRow());
                ADHOCCalCellElement aDHOCCalCellElement = new ADHOCCalCellElement(columnRow.getColumn(), columnRow.getRow(), aDHOCAddColumn2.getColumnName());
                this.addCell(aDHOCAddColumn2.getColumnName(), columnRow.getColumn());
                aDHOCCalCellElement.setValue(aDHOCAddColumn2);
                aDHOCCalCellElement.setStyle(this.crossedADHOCStyle.getReportCotentStyle());
                if (aDHOCAddColumn2.isPercentFormat()) {
                    aDHOCCalCellElement.setStyle(aDHOCCalCellElement.getStyle().deriveFormat(percentFormat));
                } else {
                    aDHOCCalCellElement.setStyle(aDHOCCalCellElement.getStyle().deriveFormat(decimalFormat));
                }
                this.setCellAttribute(aDHOCCalCellElement);
                this.addAddCell(aDHOCCalCellElement);
                n3 = this.generateAddCell(aDHOCAddColumn2.getColumnName(), columnRow);
                n2 += n3;
            }
        }
        return n2;
    }

    private int generateAddCellTitle(String string, ColumnRow columnRow, int n2) {
        ADHOCAddColumn aDHOCAddColumn = this.getADHOCAddColumn(string);
        int n3 = 0;
        if (aDHOCAddColumn != null) {
            Iterator iterator = aDHOCAddColumn.iterator();
            int n4 = 0;
            while (iterator.hasNext()) {
                ++n3;
                ADHOCAddColumn aDHOCAddColumn2 = (ADHOCAddColumn)iterator.next();
                columnRow = ColumnRow.valueOf(columnRow.getColumn() + n4 + 1, columnRow.getRow());
                ADHOCDefaultCellElement aDHOCDefaultCellElement = new ADHOCDefaultCellElement(columnRow.getColumn(), columnRow.getRow(), "__CalCellTitle__" + aDHOCAddColumn2.getColumnName());
                aDHOCDefaultCellElement.setValue(aDHOCAddColumn2.getColumnName());
                aDHOCDefaultCellElement.setStyle(this.crossedADHOCStyle.getColumnHeaderStyle());
                aDHOCDefaultCellElement.setRowSpan(n2);
                this.setCellAttribute(aDHOCDefaultCellElement);
                this.addAddedTitle(aDHOCDefaultCellElement);
                n4 = this.generateAddCellTitle(aDHOCAddColumn2.getColumnName(), columnRow, n2);
                n3 += n4;
            }
        }
        return n3;
    }

    private int generateAddCellBottom(String string, ColumnRow columnRow, String string2) {
        ADHOCAddColumn aDHOCAddColumn = this.getADHOCAddColumn(string);
        int n2 = 0;
        if (aDHOCAddColumn != null) {
            Iterator iterator = aDHOCAddColumn.iterator();
            int n3 = 0;
            while (iterator.hasNext()) {
                ++n2;
                ADHOCAddColumn aDHOCAddColumn2 = (ADHOCAddColumn)iterator.next();
                columnRow = ColumnRow.valueOf(columnRow.getColumn() + n3 + 1, columnRow.getRow());
                ADHOCDefaultCellElement aDHOCDefaultCellElement = new ADHOCDefaultCellElement(columnRow.getColumn(), columnRow.getRow(), "__CalCellSummary__" + aDHOCAddColumn2.getColumnName());
                if (aDHOCAddColumn2.isNeedParse()) {
                    aDHOCDefaultCellElement.setValue(aDHOCAddColumn2);
                } else {
                    aDHOCDefaultCellElement.setValue(new Formula(string2 + "(" + ColumnRow.valueOf(columnRow.getColumn(), columnRow.getRow() - 1).toString() + ")"));
                }
                aDHOCDefaultCellElement.setStyle(this.crossedADHOCStyle.getReportCotentStyle());
                if (aDHOCAddColumn2.isPercentFormat()) {
                    aDHOCDefaultCellElement.setStyle(aDHOCDefaultCellElement.getStyle().deriveFormat(percentFormat));
                } else if (!ComparatorUtils.equals(new CountFunction().getFormula(), string2)) {
                    aDHOCDefaultCellElement.setStyle(aDHOCDefaultCellElement.getStyle().deriveFormat(decimalFormat));
                }
                this.setCellAttribute(aDHOCDefaultCellElement);
                this.addAddedBottom(aDHOCDefaultCellElement);
                n3 = this.generateAddCellBottom(aDHOCAddColumn2.getColumnName(), columnRow, string2);
                n2 += n3;
            }
        }
        return n2;
    }

    private List generateSummaryCell() {
        ArrayList<ADHOCCalCellElement> arrayList = new ArrayList<ADHOCCalCellElement>();
        int n2 = 0;
        for (int i2 = 0; i2 < this.getSummaryColumns().length; ++i2) {
            ColumnRow columnRow = ColumnRow.valueOf(this.summaryCellPosition(i2)[0] + n2, this.summaryCellPosition(i2)[1]);
            String string = this.getSummaryColumnName(i2);
            String string2 = this.getColCellNameIndex(i2);
            ADHOCCalCellElement aDHOCCalCellElement = new ADHOCCalCellElement(columnRow.getColumn(), columnRow.getRow(), string, string2);
            this.addCell(new Long(i2), columnRow.toString());
            this.addCell(string2, columnRow.getColumn());
            CellExpandAttr cellExpandAttr = new CellExpandAttr();
            cellExpandAttr.setDirection((byte)2);
            aDHOCCalCellElement.setCellExpandAttr(cellExpandAttr);
            DSColumn dSColumn = new DSColumn();
            dSColumn.setColumnName(this.getSummaryColumns()[i2].getColumnName());
            dSColumn.setDSName(this.getViewName());
            SummaryGrouper summaryGrouper = new SummaryGrouper();
            summaryGrouper.setFunction(this.getSummaryColumns()[i2].getFunction());
            dSColumn.setGrouper(summaryGrouper);
            aDHOCCalCellElement.setValue(dSColumn);
            aDHOCCalCellElement.setStyle(this.crossedADHOCStyle.getReportCotentStyle());
            if (!(summaryGrouper.getFunction() instanceof CountFunction)) {
                aDHOCCalCellElement.setStyle(aDHOCCalCellElement.getStyle().deriveFormat(decimalFormat));
            }
            this.setCellAttribute(aDHOCCalCellElement);
            arrayList.add(aDHOCCalCellElement);
            n2 += this.generateAddCell(string2, columnRow);
        }
        return arrayList;
    }

    private void checkOffset(int n2, List list) {
        if (n2 > 0) {
            list.addAll(this.generateColumnSummaryNameCells(this.summaryCellPosition(0)[0], this.summaryCellPosition(0)[1] - 1, 1, false, true));
        }
    }

    private List generateOtherSummaryCells() {
        ArrayList arrayList = new ArrayList();
        int n2 = this.getSummaryColumns().length;
        int n3 = this.getColLength();
        int n4 = this.getRowLength();
        int n5 = n3 == 0 || n2 + this.getAddColumnsWithOutSum() > 1 ? 1 : 0;
        int n6 = n3 + n4 + n5;
        this.checkOffset(n5, arrayList);
        int n7 = this.totalWidth() - this.getAddedColumns();
        int n8 = n7 / n2;
        int[] nArray = new int[n8];
        Arrays.fill(nArray, 0);
        this.initEveCells(n7, n8, n2, n6, n4, arrayList, nArray);
        return arrayList;
    }

    private void initEveCells(int n2, int n3, int n4, int n5, int n6, List list, int[] nArray) {
        int n7 = this.getAddColumnsWithOutSum();
        for (int i2 = 0; i2 < n4; ++i2) {
            int n8 = 0;
            for (int i3 = this.summaryCellPosition(i2)[0]; i3 < n2; i3 += n4) {
                int n9 = 0;
                int n10 = n5 + 1 + this.titleAppend();
                for (int i4 = this.summaryCellPosition(i2)[1]; i4 < n10; ++i4) {
                    ADHOCCellElement aDHOCCellElement;
                    String string;
                    if (i3 == this.summaryCellPosition(i2)[0] && i4 == this.summaryCellPosition(i2)[1]) continue;
                    int n11 = 0;
                    int n12 = nArray[0];
                    if (n8 > 0) {
                        nArray[0] = n7;
                    }
                    for (int i5 = 0; i5 < n8 + 1 && i5 < n3; ++i5) {
                        n11 += nArray[i5];
                    }
                    nArray[0] = n12;
                    ColumnRow columnRow = ColumnRow.valueOf(i3 + n11, i4);
                    String string2 = i3 == this.summaryCellPosition(i2)[0] ? this.getSummaryColumnName(i2) : this.getColumnSummaryName(i2);
                    String string3 = string = i3 == this.summaryCellPosition(i2)[0] ? this.getColCellNameIndex(i2) : this.getSumCellNameIndex(i2);
                    if (i4 >= n10 - n6) {
                        aDHOCCellElement = new ADHOCDefaultCellElement(columnRow.getColumn(), columnRow.getRow(), this.getSumCellNameString(string2));
                        if (i3 <= this.summaryCellPosition(n4 - 1)[0] || i3 >= n2 - this.getSummaryColumns().length) {
                            n9 = this.generateAddCellBottom(string, columnRow, this.getSummaryFunctionName(this.getSummaryColumns()[i2].getFunction().getFormula()));
                        }
                    } else if (i3 < n2 - this.getSummaryColumns().length) {
                        aDHOCCellElement = new ADHOCDefaultCellElement(columnRow.getColumn(), columnRow.getRow(), this.getSumCellNameString(string2));
                        n9 = 0;
                    } else {
                        aDHOCCellElement = new ADHOCCalCellElement(columnRow.getColumn(), columnRow.getRow(), string2, string);
                        this.addCell(string, columnRow.getColumn());
                        n9 = this.generateAddCell(string, columnRow);
                    }
                    aDHOCCellElement.setValue(new Formula(this.getSummaryFunctionName(this.getSummaryColumns()[i2].getFunction().getFormula()) + "(" + this.getCellCal(new Long(i2)) + ")"));
                    aDHOCCellElement.setStyle(this.crossedADHOCStyle.getReportCotentStyle());
                    if (!(this.getSummaryColumns()[i2].getFunction() instanceof CountFunction)) {
                        aDHOCCellElement.setStyle(aDHOCCellElement.getStyle().deriveFormat(decimalFormat));
                    }
                    this.setCellAttribute(aDHOCCellElement);
                    list.add(aDHOCCellElement);
                }
                int n13 = n8++;
                nArray[n13] = nArray[n13] + n9;
            }
        }
    }

    private String getSummaryFunctionName(String string) {
        if ("count".equalsIgnoreCase(string)) {
            return "sum";
        }
        return string;
    }

    private List generateColumnSummaryNameCells(int n2, int n3, int n4, boolean bl, boolean bl2) {
        ArrayList<ADHOCDefaultCellElement> arrayList = new ArrayList<ADHOCDefaultCellElement>();
        int n5 = this.getSummaryColumns().length;
        int n6 = 0;
        for (int i2 = 0; i2 < n5; ++i2) {
            ColumnRow columnRow = ColumnRow.valueOf(n2 + i2 + n6, n3);
            String string = bl ? this.getColumnSummaryName(i2) : this.getSummaryColumnName(i2);
            String string2 = bl ? this.getSumCellNameIndex(i2) : this.getColCellNameIndex(i2);
            ADHOCDefaultCellElement aDHOCDefaultCellElement = new ADHOCDefaultCellElement(columnRow.getColumn(), columnRow.getRow(), string + SEPARATE + "sumtitle");
            aDHOCDefaultCellElement.setStyle(this.crossedADHOCStyle.getRowHeaderStyle());
            aDHOCDefaultCellElement.setValue(string);
            aDHOCDefaultCellElement.setRowSpan(n4);
            this.setCellAttribute(aDHOCDefaultCellElement);
            arrayList.add(aDHOCDefaultCellElement);
            if (!bl2) continue;
            n6 += this.generateAddCellTitle(string2, columnRow, n4);
        }
        return arrayList;
    }

    private String getColumnSummaryName(int n2) {
        ADHOCSummaryColumn aDHOCSummaryColumn = this.getSummaryColumns()[n2];
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(BrowserI18N.getLocText("Summary", l.a)).append('(').append(aDHOCSummaryColumn.getColumnName()).append(':').append(aDHOCSummaryColumn.getFunctionName()).append(')');
        return stringBuffer.toString();
    }

    private StringBuffer getCellNameIndexBaseName(int n2) {
        ADHOCSummaryColumn aDHOCSummaryColumn = this.getSummaryColumns()[n2];
        return new StringBuffer().append(aDHOCSummaryColumn.getColumnName()).append(SEPARATE);
    }

    private String getSumCellNameIndex(int n2) {
        return this.getCellNameIndexBaseName(n2).append("sum").toString();
    }

    private String getSumCellNameString(String string) {
        return new StringBuffer().append(string).append(SEPARATE).append("sum").toString();
    }

    private String getColCellNameIndex(int n2) {
        return this.getCellNameIndexBaseName(n2).append("col").toString();
    }

    private String getSummaryColumnName(int n2) {
        ADHOCSummaryColumn aDHOCSummaryColumn = this.getSummaryColumns()[n2];
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(aDHOCSummaryColumn.getColumnName()).append(':').append(aDHOCSummaryColumn.getFunctionName());
        return stringBuffer.toString();
    }

    private int[] summaryCellPosition(int n2) {
        int n3 = this.getRowLength() + n2;
        int n4 = this.getColLength();
        int n5 = n4 + this.titleAppend();
        if (n4 == 0 || this.getSummaryColumns().length + this.getAddColumnsWithOutSum() > 1) {
            ++n5;
        }
        ColumnRow columnRow = ColumnRow.valueOf(n3, n5);
        return new int[]{columnRow.getColumn(), columnRow.getRow()};
    }

    private int getRowLength() {
        return this.rowColumns.length;
    }

    private int getColLength() {
        return this.columnColumns.length;
    }

    private int getRowColumnGroupLength() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.rowColumns.length; ++i2) {
            if (this.getGroupColumn(this.rowColumns[i2].getColumnName()) == null) continue;
            ++n2;
        }
        return n2;
    }

    private int getColColumnGroupLength() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.columnColumns.length; ++i2) {
            if (this.getGroupColumn(this.columnColumns[i2].getColumnName()) == null) continue;
            ++n2;
        }
        return n2;
    }

    public JSONObject createJSON() throws Exception {
        int n2;
        JSONArray jSONArray;
        JSONObject jSONObject = super.createJSON();
        if (!ArrayUtils.isEmpty(this.columnColumns)) {
            jSONArray = new JSONArray();
            for (n2 = 0; n2 < this.columnColumns.length; ++n2) {
                jSONArray.put(this.columnColumns[n2].createJSON());
            }
            jSONObject.put("columns", jSONArray);
        }
        if (!ArrayUtils.isEmpty(this.rowColumns)) {
            jSONArray = new JSONArray();
            for (n2 = 0; n2 < this.rowColumns.length; ++n2) {
                jSONArray.put(this.rowColumns[n2].createJSON());
            }
            jSONObject.put("rows", jSONArray);
        }
        jSONObject.put("crossedstyle", this.crossedADHOCStyle.createJSON());
        return jSONObject;
    }

    public void parseJSON(JSONObject jSONObject) throws Exception {
        ADHOCColumn aDHOCColumn;
        int n2;
        ADHOCColumn[] aDHOCColumnArray;
        int n3;
        JSONArray jSONArray;
        super.parseJSON(jSONObject);
        if (jSONObject.has("columns")) {
            jSONArray = jSONObject.getJSONArray("columns");
            n3 = jSONArray.length();
            aDHOCColumnArray = new ADHOCColumn[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                aDHOCColumn = new ADHOCColumn();
                aDHOCColumn.parseJSON(jSONArray.getJSONObject(n2));
                aDHOCColumnArray[n2] = aDHOCColumn;
            }
            this.setColumnColumns(aDHOCColumnArray);
        }
        if (jSONObject.has("rows")) {
            jSONArray = jSONObject.getJSONArray("rows");
            n3 = jSONArray.length();
            aDHOCColumnArray = new ADHOCColumn[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                aDHOCColumn = new ADHOCColumn();
                aDHOCColumn.parseJSON(jSONArray.getJSONObject(n2));
                aDHOCColumnArray[n2] = aDHOCColumn;
            }
            this.setRowColumns(aDHOCColumnArray);
        }
        if (jSONObject.has("crossedstyle")) {
            this.crossedADHOCStyle.parseJSON((JSONObject)jSONObject.get("crossedstyle"));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        int n2;
        CrossedADHOCReport crossedADHOCReport = (CrossedADHOCReport)super.clone();
        if (!ArrayUtils.isEmpty(this.columnColumns)) {
            for (n2 = 0; n2 < this.columnColumns.length; ++n2) {
                crossedADHOCReport.columnColumns[n2] = (ADHOCColumn)this.columnColumns[n2].clone();
            }
        }
        if (!ArrayUtils.isEmpty(this.rowColumns)) {
            for (n2 = 0; n2 < this.rowColumns.length; ++n2) {
                crossedADHOCReport.rowColumns[n2] = (ADHOCColumn)this.rowColumns[n2].clone();
            }
        }
        return crossedADHOCReport;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("CCArray".equals(string)) {
                this.columnColumns = new ADHOCColumn[xMLableReader.getAttrAsInt("len", 0)];
                xMLableReader.readXMLObject(new XMLReadable(){
                    private int size = 0;

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && "AC".equals(xMLableReader.getTagName())) {
                            ADHOCColumn aDHOCColumn = new ADHOCColumn();
                            xMLableReader.readXMLObject(aDHOCColumn);
                            ((CrossedADHOCReport)CrossedADHOCReport.this).columnColumns[this.size] = aDHOCColumn;
                            ++this.size;
                        }
                    }
                });
            } else if ("RCArray".equals(string)) {
                this.rowColumns = new ADHOCColumn[xMLableReader.getAttrAsInt("len", 0)];
                xMLableReader.readXMLObject(new XMLReadable(){
                    private int size = 0;

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && "AC".equals(xMLableReader.getTagName())) {
                            ADHOCColumn aDHOCColumn = new ADHOCColumn();
                            xMLableReader.readXMLObject(aDHOCColumn);
                            ((CrossedADHOCReport)CrossedADHOCReport.this).rowColumns[this.size] = aDHOCColumn;
                            ++this.size;
                        }
                    }
                });
            } else if ("style".equals(string)) {
                try {
                    this.crossedADHOCStyle.parseJSON(new JSONObject(xMLableReader.getElementValue()));
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage(), exception);
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        int n2;
        super.writeXML(xMLPrintWriter);
        if (!ArrayUtils.isEmpty(this.columnColumns)) {
            xMLPrintWriter.startTAG("CCArray").attr("len", this.columnColumns.length);
            for (n2 = 0; n2 < this.columnColumns.length; ++n2) {
                xMLPrintWriter.startTAG("AC");
                this.columnColumns[n2].writeXML(xMLPrintWriter);
                xMLPrintWriter.end();
            }
            xMLPrintWriter.end();
        }
        if (!ArrayUtils.isEmpty(this.rowColumns)) {
            xMLPrintWriter.startTAG("RCArray").attr("len", this.rowColumns.length);
            for (n2 = 0; n2 < this.rowColumns.length; ++n2) {
                xMLPrintWriter.startTAG("AC");
                this.rowColumns[n2].writeXML(xMLPrintWriter);
                xMLPrintWriter.end();
            }
            xMLPrintWriter.end();
        }
        try {
            xMLPrintWriter.startTAG("style").textNode("" + this.crossedADHOCStyle.createJSON().toString()).end();
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
        }
    }

    private void setCellAttribute(ADHOCCellElement aDHOCCellElement) {
        String string;
        Object v2;
        if (this.cellSettingMap != null && aDHOCCellElement != null && (v2 = this.cellSettingMap.get(string = aDHOCCellElement.getCellIndex())) instanceof JSONObject) {
            try {
                ADHOCUtils.setStyleFromJSON((JSONObject)v2, aDHOCCellElement);
                ADHOCUtils.setHighlightGroupFromJSON((JSONObject)v2, aDHOCCellElement);
                ADHOCUtils.setSortAttrFromJSON((JSONObject)v2, aDHOCCellElement);
                ADHOCUtils.setFilterAttrFromJSON((JSONObject)v2, aDHOCCellElement);
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), exception);
            }
        }
    }
}

