/*
 * Decompiled with CFR 0.152.
 */
package com.fr.adhoc.report;

import com.fr.base.Style;
import com.fr.base.TextFormat;
import com.fr.base.background.ColorBackground;
import com.fr.data.condition.AbstractCondition;
import com.fr.data.condition.CommonCondition;
import com.fr.data.condition.ListCondition;
import com.fr.data.condition.ObjectCondition;
import com.fr.data.core.Compare;
import com.fr.general.FRFont;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.report.cell.ADHOCCellElement;
import com.fr.report.cell.cellattr.CellExpandAttr;
import com.fr.report.cell.cellattr.core.group.DSColumn;
import com.fr.report.cell.cellattr.highlight.BackgroundHighlightAction;
import com.fr.report.cell.cellattr.highlight.DefaultHighlight;
import com.fr.report.cell.cellattr.highlight.FRFontHighlightAction;
import com.fr.report.cell.cellattr.highlight.Highlight;
import com.fr.report.cell.cellattr.highlight.HighlightAction;
import com.fr.report.cell.cellattr.highlight.HighlightGroup;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLable;
import java.awt.Color;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;

public class ADHOCUtils {
    private static FRFont parseFont(JSONObject jSONObject, FRFont fRFont) throws JSONException {
        String string;
        if (jSONObject.has("fontFamily")) {
            string = jSONObject.getString("fontFamily");
            fRFont = fRFont.applyName(string);
        }
        if (jSONObject.has("fontSize")) {
            float f2 = (float)jSONObject.getDouble("fontSize");
            fRFont = fRFont.applySize(f2);
        }
        if (jSONObject.has("fontColor")) {
            string = jSONObject.getString("fontColor");
            fRFont = fRFont.applyForeground(Color.decode(string));
        }
        int n2 = 0;
        if (jSONObject.has("fontWeight")) {
            n2 += jSONObject.getInt("fontWeight");
        }
        if (jSONObject.has("fontItalic")) {
            n2 += jSONObject.getInt("fontItalic");
        }
        fRFont = fRFont.applyStyle(n2);
        if (jSONObject.has("underline")) {
            fRFont = fRFont.applyUnderline(jSONObject.getInt("underline"));
        }
        if (jSONObject.has("deleteline")) {
            fRFont = fRFont.applyStrikethrough(jSONObject.getBoolean("deleteline"));
        }
        return fRFont;
    }

    private static Style getFontStyleFromJSON(JSONObject jSONObject, Style style) throws JSONException {
        FRFont fRFont = style.getFRFont();
        fRFont = ADHOCUtils.parseFont(jSONObject, fRFont);
        return style.deriveFRFont(fRFont);
    }

    private static Style getBackgroundStyleFromJSON(JSONObject jSONObject, Style style) throws JSONException {
        if (jSONObject.has("background")) {
            String string = jSONObject.getString("background");
            style = style.deriveBackground(ColorBackground.getInstance(Color.decode(string)));
        }
        return style;
    }

    private static Style getBorderStyleFromJSON(JSONObject jSONObject, Style style) throws JSONException {
        if (jSONObject.has("border")) {
            String string = jSONObject.getString("border");
            int n2 = string.indexOf("top") > -1 ? 1 : 0;
            int n3 = string.indexOf("bottom") > -1 ? 1 : 0;
            int n4 = string.indexOf("left") > -1 ? 1 : 0;
            int n5 = string.indexOf("right") > -1 ? 1 : 0;
            style = style.deriveBorder(n2, style.getBorderTopColor(), n3, style.getBorderBottomColor(), n4, style.getBorderLeftColor(), n5, style.getBorderRightColor());
        }
        return style;
    }

    private static Style getAlignStyleFromJSON(JSONObject jSONObject, Style style) throws JSONException {
        if (jSONObject.has("align")) {
            String string = jSONObject.getString("align");
            int n2 = -1;
            if (string.equals("left")) {
                n2 = 2;
            } else if (string.equals("right")) {
                n2 = 4;
            } else if (string.equals("center")) {
                n2 = 0;
            }
            style = style.deriveHorizontalAlignment(n2);
        }
        return style;
    }

    private static Style getVerticalAlignStyleFromJSON(JSONObject jSONObject, Style style) throws JSONException {
        if (jSONObject.has("vertical-align")) {
            String string = jSONObject.getString("vertical-align");
            int n2 = -1;
            if (string.equals("top")) {
                n2 = 1;
            } else if (string.equals("middle")) {
                n2 = 0;
            } else if (string.equals("bottom")) {
                n2 = 3;
            }
            style = style.deriveVerticalAlignment(n2);
        }
        return style;
    }

    public static Format parseFormat(JSONObject jSONObject) throws JSONException {
        String string;
        int n2;
        JSONObject jSONObject2;
        Format format = null;
        if (jSONObject.has("format") && (jSONObject2 = jSONObject.getJSONObject("format")).has("type") && (n2 = jSONObject2.getInt("type")) > 0 && n2 < 8 && (format = n2 < 5 ? new DecimalFormat() : (n2 < 7 ? new SimpleDateFormat() : TextFormat.getInstance())) != null && (string = jSONObject2.getString("value")) != null) {
            if (format instanceof DecimalFormat) {
                ((DecimalFormat)format).applyPattern(string);
            } else if (format instanceof SimpleDateFormat) {
                ((SimpleDateFormat)format).applyPattern(string);
            }
        }
        return format;
    }

    private static Style getFormatStyleFromJSON(JSONObject jSONObject, Style style) throws JSONException {
        return style.deriveFormat(ADHOCUtils.parseFormat(jSONObject));
    }

    public static void setStyleFromJSON(JSONObject jSONObject, ADHOCCellElement aDHOCCellElement) throws Exception {
        Style style = aDHOCCellElement.getStyle();
        style = ADHOCUtils.getFontStyleFromJSON(jSONObject, style);
        style = ADHOCUtils.getBackgroundStyleFromJSON(jSONObject, style);
        style = ADHOCUtils.getBorderStyleFromJSON(jSONObject, style);
        style = ADHOCUtils.getAlignStyleFromJSON(jSONObject, style);
        style = ADHOCUtils.getVerticalAlignStyleFromJSON(jSONObject, style);
        style = ADHOCUtils.getFormatStyleFromJSON(jSONObject, style);
        aDHOCCellElement.setStyle(style);
    }

    public static void setHighlightGroupFromJSON(JSONObject jSONObject, ADHOCCellElement aDHOCCellElement) throws JSONException {
        if (jSONObject.has("condition")) {
            JSONArray jSONArray = jSONObject.getJSONArray("condition");
            Highlight[] highlightArray = new Highlight[jSONArray.length()];
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                DefaultHighlight defaultHighlight = new DefaultHighlight();
                if (jSONObject2.has("style")) {
                    XMLable xMLable;
                    JSONObject jSONObject3 = jSONObject2.getJSONObject("style");
                    FRFont fRFont = ADHOCUtils.parseFont(jSONObject3, FRFont.getInstance());
                    FRFontHighlightAction fRFontHighlightAction = new FRFontHighlightAction(fRFont, 0);
                    defaultHighlight.addHighlightAction(fRFontHighlightAction);
                    if (jSONObject3.has("background")) {
                        xMLable = new BackgroundHighlightAction(ColorBackground.getInstance(Color.decode(jSONObject3.getString("background"))), 0);
                        defaultHighlight.addHighlightAction((HighlightAction)xMLable);
                    }
                    xMLable = new Compare(jSONObject2.getInt("op"), jSONObject2.get("value"));
                    ObjectCondition objectCondition = new ObjectCondition((Compare)xMLable);
                    defaultHighlight.setCondition(objectCondition);
                }
                highlightArray[i2] = defaultHighlight;
            }
            HighlightGroup highlightGroup = new HighlightGroup(highlightArray);
            aDHOCCellElement.setHighlightGroup(highlightGroup);
        }
    }

    public static void setSortAttrFromJSON(JSONObject jSONObject, ADHOCCellElement aDHOCCellElement) throws JSONException {
        if (jSONObject.has("sort")) {
            JSONObject jSONObject2 = jSONObject.getJSONObject("sort");
            CellExpandAttr cellExpandAttr = aDHOCCellElement.getCellExpandAttr();
            if (cellExpandAttr != null) {
                cellExpandAttr.setOrder(jSONObject2.getInt("sortType") + 1);
                cellExpandAttr.setSortFormula(jSONObject2.getString("formula"));
            }
        }
    }

    public static void setFilterAttrFromJSON(JSONObject jSONObject, ADHOCCellElement aDHOCCellElement) throws Exception {
        if (jSONObject.has("filter")) {
            Object object = aDHOCCellElement.getValue();
            JSONObject jSONObject2 = jSONObject.getJSONObject("filter");
            if (object instanceof DSColumn && jSONObject2.has("islist") && jSONObject2.has("info")) {
                boolean bl = jSONObject2.getBoolean("islist");
                String string = jSONObject2.getString("info");
                String string2 = ((DSColumn)object).getColumnName();
                AbstractCondition abstractCondition = null;
                if (bl) {
                    JSONArray jSONArray = new JSONArray(string);
                    abstractCondition = new ListCondition();
                    for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                        CommonCondition commonCondition = new CommonCondition(string2, 1, jSONArray.get(i2));
                        ((ListCondition)abstractCondition).addCondition(commonCondition);
                    }
                } else {
                    JSONObject jSONObject3;
                    Compare compare = null;
                    if (StringUtils.isNotBlank(string) && (jSONObject3 = new JSONObject(string)).get("compare") != null) {
                        compare = new Compare();
                        compare.parseJSON(jSONObject3.getJSONObject("compare"));
                    }
                    if (compare != null) {
                        abstractCondition = new CommonCondition(string2, compare);
                    }
                }
                ((DSColumn)object).setCondition(abstractCondition);
            }
        }
    }
}

