//FR.Hyper = FR.extend(FR.Widget, {
//	init : function() {
//		
//	}
//});
//$.shortcut('hyper', FR.Hyper);
if (!FS) {
	window.FS = {};
}
FS.ProcessList = {
	todoJob : 0,
	
	startProcess : 1,
	
	finishedJob : 2,
	
	allJob : 3
};

$.extend(FS.Trans, {
	getTodoJob : function() {
		return this.ajax({
			url : FR.servletURL + "?op=process_task&cmd=usertask"
		});
	},
	
	getProcessDefine : function() {
		return this.ajax({
			url : FR.servletURL + "?op=process_task&cmd=userprocess"
		});		
	},
	
	getFinishedJob : function() {
		return this.ajax({
			url : FR.servletURL + "?op=process_task&cmd=userfinishtask"
		});		
	},
	
	getAllJob : function() {
		return this.ajax({
			url : FR.servletURL + "?op=process_task&cmd=alltask"
		});	
	},
	
	getMyStartJob : function() {
		return this.ajax({
			url : FR.servletURL + "?op=process_task&cmd=mytasks"
		});	
	},
	
	startProcess : function(id) {
		return this.ajax({
			url : FR.servletURL + "?op=process_task&cmd=start",
			data : {
				id : id
			}
		});
	}
});

if (!FS.Process) {
	FS.Process = {};
}

$.extend(FS.Process, {		
	showTaskInfo : function(process) {
		var el = this.createTaskPane(process);
		if(!process.type) {
			FS.tabPane.addItem({
				title : process.text,
				contentEl : el,
				css : {
					background : 'none repeat scroll 0 0 #E0FBF9',
					'overflow' : 'auto'
				}
			});
		} else {
			FS.tabPane.addItem({
				title : process.text,
				contentEl : el
			});
		}
	},
	
	createTaskPane : function(process, height) {
		$.extend(process, {
			width : FS.center.width(),
			height : FS.center.height() - 30,
			gridHeight : height
		});
		if (process.type == FS.ProcessList.todoJob) {
			return this.createTodoPane(process);
		} else if (process.type == FS.ProcessList.startProcess) {
			return this.createProcessPane(process);
		} else if (process.type == FS.ProcessList.finishedJob) {
			return this.createFinishedJobPane(process);
		} else if (process.type == FS.ProcessList.allJob) {
			return this.createAllJobPane(process);
		} else {
			//wei : ݲѯ
			return this.createQueryResultPane(process);
		}
	},
	
	createTodoPane : function(process) {
		if (this.todoJobPane) {
			return this.todoJobPane.element;
		}
		this.todoJobPane = new FS.TodoTask(process);
		this.todoJobPane.element.data('container', this.todoJobPane);
		return  this.todoJobPane.element;
	},
	
	createProcessPane : function(process) {
		if (this.processPane) {
			return this.processPane.element;
		}
		this.processPane = new FS.MyProcessTask(process);
		this.processPane.element.data('container', this.processPane);
		return  this.processPane.element;
	},
	
	createFinishedJobPane : function(process) {
		if (this.finishedJobPane) {
			return this.finishedJobPane.element;
		}
		this.finishedJobPane = new FS.FinishTask(process);
		this.finishedJobPane.element.data('container', this.finishedJobPane);
		return  this.finishedJobPane.element;
	},
	
	createAllJobPane : function(process) {
		if (this.allJobPane) {
			return this.allJobPane.element;
		}
		this.allJobPane = new FS.AllTask(process);
		this.allJobPane.element.data('container', this.allJobPane);
		return this.allJobPane.element;
	},

    createQueryResultPane : function(process) {
        if(process.length < 1) {
            return $("<div/>").addClass("fs_process_querytaskinfo").text(FR.i18nText("No_Wanted_Result")).css({
                "padding-left" : "50px",
                "padding-top" : "30px"
            });
        }
        var self = this;
        FR.$defaultImport('/com/fr/fs/web/css/fsdesign.css', 'css');

        var columnsconfig = [
            {
                key: 'bugstatus',
                value: '״̬',
                width: 65,
                onHeadCellCreate: function (colIdx, itemcfg) {
                    return self.createSortCell(itemcfg, process);
                },
                desc: true
            },
            {
                key: 'bugiteration',
                value: '',
                width: 65,
                onHeadCellCreate: function (colIdx, itemcfg) {
                    return self.createSortCell(itemcfg, process);
                },
                desc: true
            },
            {
                key: 'bugtitle',
                value: '',
                width: 525,
                onHeadCellCreate: function (colIdx, itemcfg) {
                    return self.createSortCell(itemcfg, process);
                },
                desc: true
            },
            {
                key: 'bugmodule',
                value: 'ģ',
                width: 65,
                onHeadCellCreate: function (colIdx, itemcfg) {
                    return self.createSortCell(itemcfg, process);
                },
                desc: true
            },
            {
                key: 'FR_SYSTEM_ID',
                value: 'ϵͳID',
                width: 65,
                onHeadCellCreate: function (colIdx, itemcfg) {
                    return self.createSortCell(itemcfg, process);
                },
                desc: true
            },
            {
                key: 'creator',
                value: '',
                width: 65,
                onHeadCellCreate: function (colIdx, itemcfg) {
                    return self.createSortCell(itemcfg, process);
                },
                desc: true
            },
            {
                value: '',
                onCellCreate : function(rowIdx, colIdx, item, colCfg) {
                    var btn = FR.createWidget({
                        text: FR.i18nText("Face_View"),
                        width: 40,
                        height: 21,
                        type: 'quickbutton',
                        style: 'blue',
                        handler : function() {
                            var data = item;
                            var src = "?op=process_exe&cmd=seejob&processexecutorid=" + data.FR_SYSTEM_ID
                                + "&processid=" + data.fr_process_id;
                            var tabPane = FS.tabPane ? FS.tabPane : window.parent.FS.tabPane;
                            tabPane.addItem({
                                'title' : FR.i18nText("Handle_Affairs") + data.FR_SYSTEM_ID,
                                src : src
                            });
                        }
                    });
                    return btn.element;
                },
                width: 40
            }
        ];
        this.grid = new FR.QuickGrid({
            widgetName: 'tasksGrid',
            marginLeft: 20,
            marginRight: 10,
            isFootShow: true,
            isHeadShow: true,
            page: true,
            pageCount : 15,
            intervalColor : true,
            items : process,
            columnsConfig : columnsconfig
        });
        var gridpane = $('<div/>').addClass('fs_process_tasksgrid').css({
            'padding-top' : 30,
            'margin-left' : 'auto',
            'margin-right' : 'auto',
            width : this.grid.element.width()
        });
        this.grid.element.appendTo(gridpane);
        return $("<div/>").css({
            'height' : '100%',
            'width' : '100%',
            'overflow' : 'auto'
        }).append(gridpane);
    },

    createSortCell : function (itemcfg, items) {
        var self = this;
        var $cell = $('<div/>').css(
            'cursor', 'pointer'
        ).click(
            function () {
                var columnKey = itemcfg.key;
                var len = items.length;
                if(len < 2) {
                    return ;
                }
                var needTransposition = false;
                if(itemcfg.desc !== false) {
                    for(; len > 1; len --) {
                        for(var m = 0; m < len - 1; m ++) {
                            needTransposition = false;
                            if(!isNaN(items[m][columnKey]) && !isNaN(items[m+1][columnKey])) {
                                needTransposition = (items[m][columnKey] - items[m + 1][columnKey] > 0)
                            } else {
                                needTransposition = items[m][columnKey] > items[m + 1][columnKey];
                            }
                            if(needTransposition) {
                                var temp = items[m];
                                items[m] = items[m + 1];
                                items[m+1] = temp;
                            }
                        }
                    }
                    itemcfg.desc = false;
                } else {
                    for(; len > 1; len --) {
                        for(var m = 0; m < len - 1; m ++) {
                            needTransposition = false;
                            if(!isNaN(items[m][columnKey]) && !isNaN(items[m+1][columnKey])) {
                                needTransposition = (items[m][columnKey] - items[m + 1][columnKey] < 0)
                            } else {
                                needTransposition = items[m][columnKey] < items[m + 1][columnKey];
                            }
                            if(needTransposition) {
                                var temp = items[m];
                                items[m] = items[m+1];
                                items[m+1] = temp;
                            }
                        }
                    }
                    itemcfg.desc = true;
                }
                self.grid.refresh(items);
            }
        ).append($('<span/>').text(itemcfg.value));
        return $cell;
    },


    //b:ȡʱУ250ms wait
	refreshTask : function() {
		setTimeout(function() {
			if (this.todoJobPane) {
				this.todoJobPane.refresh();
			}
			
			if (this.finishedJobPane) {
				this.finishedJobPane.refresh();
			}
			
			if (this.processPane) {
				this.processPane.refreshTask();
			}
			
			if (this.allJobPane) {
				this.allJobPane.refresh();
			}
			
		}.createDelegate(this), 500);
	},
	
	refreshProcess : function() {
		setTimeout(function() {
			if (this.processPane) {
				this.processPane.refreshProcess();
			}
		}.createDelegate(this), 500);
	},
	
	showNewTaskInfo : function() {
		if (!this.alertTaskInfo) {
			this.alertTaskInfo = $('<div/>').css({
				width : 150,
				height : 60,
				border : "1px solid #97C5E0",
				position : 'absolute',
				top : 100,
				right : 20,
				background : 'white'
			}).appendTo($('body'));
			//b:copy fs.dialog close
			var self = this;
			headclose = $('<a>&nbsp;</a>').attr('id', 'fs_dialogheaderclose').css('top', 2).appendTo(this.alertTaskInfo)
				.mouseover(function() {
                    $(this).addClass('fs_mousein');
                }).mouseout(function() {
                    $(this).removeClass('fs_mousein');
                }).click(function() {
                    self.alertTaskInfo.hide();
                });
            $('<div/>').css({
            	position : 'absolute',
            	top : 15,
            	left : 20,
            	right : 20
            }).text(FR.i18nText("NewAffairToHandle")+'!').appendTo(this.alertTaskInfo);
		}
		this.alertTaskInfo.show();
	}
});

FS.ValueIncreaseList = function(array) {
	this.list = {};
	this.size = 0;
	if (array) {
		array = $.isArray(array) ? array : [array];
		for (var i = 0, len = array.length; i < len; i++) {
			this.add(array[i]);		
		}
	}
}

$.extend(FS.ValueIncreaseList.prototype, {
	add : function(value) {
		var hasValue = false;
		for (var i = 0, len = this.size; i < len; i++) {
			if (this.list[i].value == value) {
				this.list[i].count++;
				hasValue = true;
				break;
			}
		}
		if (!hasValue) {
			this.list[this.size++] = {
				count : 0,
				value : value
			};
		}
	},
	
	get : function(index) {
		return this.list[index].value;
	},
	
	getValueByCount : function(count) {
		var values = [];
		for (var i = 0, len = this.size; i < len; i++) {
			if (this.list[i].count == count) {
				values.push(this.list[i].value);
			}
		}
		return values;
	},
	
	sortCountsArray : function() {
		var counts = [];
		for (var i = 0, len = this.size; i < len; i++) {
			counts[i] = this.list[i].count;
		}
		var sortcounts = [];
		while(counts.length > 0) {
			var max = Math.max.apply(null, counts);
			if (sortcounts.indexOf(max) < 0) {
				sortcounts.push(max);
			}			
			counts.remove(max);
		}
		return sortcounts;
	},
	
	getMaxRepeatedValue : function(count) {
		if (!this.size) {
			return;
		}
		var sortcounts = this.sortCountsArray();
		var values = [];
		for (var i = 0, len = sortcounts.length; i < len; i++) {
			Array.prototype.push.apply(values, this.getValueByCount(sortcounts[i]));
			if (count && values.length >= count) {
				values.splice(count);
				return values;
			}
		}
		return values;
	},
	
	remove : function(index) {
		
	},
	
	size : function() {
		return this.size;
	}
});

FS.Map = function() {
	this.keys = [];
	this.values = [];
	this.index = 0;
}

$.extend(FS.Map.prototype, {
	put : function(key, value) {
		var i = this.keys.indexOf(key);
		if (i > -1) {
			this.values[i] = value;
		} else {
			this.keys[this.index] = key;
			this.values[this.index] = value;
			this.index++;
		}
	},
	
	remove : function(key) {
		var i = this.keys.indexOf(key);
		if (i > -1) {
			this.keys.splice(i, 1);
			this.values.splice(i, 1);
		}
	},
	
	get : function(key) {
		var i = this.keys.indexOf(key);
		if (i > -1) {
			return this.values[i];
		}
	},
	
	getKeys : function() {
		return this.keys;
	},
	
	getValues : function() {
		return this.values;
	}
});

FS.ProcessTasks = FS.extend(FS.Widget, {
	init : function(config) {
		this.control = config.control;
		this.element = $('<div/>').addClass('fs_process_taskspane');
		this.tagspane = $('<div/>').addClass('fs_process_taskstags').css({
			position : 'absolute',
			height : 60
		}).hide().appendTo(this.element);
		this.gridpane = $('<div/>').addClass('fs_process_tasksgrid').css({			
			position : 'absolute',
			top : 0
		}).appendTo(this.element);
		this.generateInquiryButton();
		this.resize(config);
	},
	
	isEmpty : function() {
		return this.element.children(":visible").length === 0;
	},
	
	generateInquiryButton : function() {
		var self = this;
		this.inquiry = new FR.Button({
            text : FR.i18nText("Query"),
            width : 64,
            height : 24,
            handler :function() {
                self.searchResult();
            }
        });
        this.tagspane.append(this.inquiry.element.addClass('fs_processtagpane_search'));
	},
	
	searchResult : function() {
		if (!this.mulcombs || !this.mulcombs.length) {
			return;
		}
		var orz = [];
		for (var i = 0, len = this.mulcombs.length; i < len; i++) {
			var value = this.mulcombs[i].getValue();
			if (value && value.length > 0) {
				orz.push(value);
			}
		}
		var jr = [];
		for (var i = 0, len = orz.length - 1; i < len; i++) {
			jr = this.joinResults(orz[i], orz[i + 1]);
		}
		
		this.filterGrid(jr);
	},
	
	joinResults : function(array1, array2) {
		var result = [];
		for (var i = 0, len = array1.length; i < len; i++) {
			var v1 = []
			if (array1[i] != '') {
				v1 = array1[i];
				if (!$.isArray(v1)) {
					v1 = [v1];
				}
			}

			for (var j = 0, jen = array2.length; j < jen; j++) {
				if (array2[j] != '') {
					v1.push(array2[j]);
				}
				result.push(v1);
			}
		}
		return result;
	},
	
	//b:tagmap cache later Ϊѡ& ֶ
	generateTagNames : function() {
		var datas = this.tasks;
		if (!datas) {
			return;
		}
		var paranames = [];
		this.realparanames = [];
		for (var i = 0, len = datas.length; i < len; i++) {
			var paras = datas[i].tags;
			for (var j = 0, jen = paras.length; j < jen; j++) {
				paranames.push(paras[j].name);
			}
		}
		if (paranames.length > 0) {
			var il = new FS.ValueIncreaseList(paranames);
			this.realparanames = il.getMaxRepeatedValue();
		}
	},
	
	tags2Fields : function() {
		var datas = this.tasks;
		if (!datas || datas[0].fielded) {
			return;
		}		
		for (var i = 0, len = datas.length; i < len; i++) {
			var data = datas[i];
			var paras = data.tags;
			for (var j = 0, jen = paras.length; j < jen; j++) {
				data[paras[j].name] = paras[j].value;
			}
			data.fielded = true;
		}
	},
	
	//b:ѡֵ
	getTagValues : function(tag) {
		var datas = this.tasks;
		if (!datas || tag == null) {
			return;
		}
		var values = [], realvalues = [];
		for (var i = 0, len = datas.length; i < len; i++) {
			var paras = datas[i].tags;
			for (var j = 0, jen = paras.length; j < jen; j++) {
				if (paras[j].name == tag) {
					values.push(paras[j].value);
				}			
			}
		}
		if (values.length > 0) {
			var il = new FS.ValueIncreaseList(values);
			var values = il.getMaxRepeatedValue();
			
			for (var i = 0, len = values.length; i < len; i++) {
				realvalues.push({
					text : values[i],
					value : values[i]
				});
			}
		}
		return realvalues;
	},
	
	popTasks : function(tasks) {
		if (this.tasks == tasks) {
			return;
		}
		this.tasks = tasks;
		this.dealTasks4Show();
		this.buildMultiTags();
		this.buildGrid();
	},
	
	clearContent : function() {
		this.tasks = null;
		this.realparanames = null;
		if (this.tagtable) {
			this.tagtable.empty();
		}
		if (this.grid) {
			this.grid.clearBody();
		}		
	},
	
	dealTasks4Show : function() {
		this.generateTagNames();
		this.tags2Fields();
	},
	
	//b:4 every row
	buildMultiTags : function() {
		if (!this.realparanames || !this.realparanames.length) {
			this.fillPane(true);
			return;
		}
		this.fillPane(false);
		if (!this.tagtable) {
			this.tagtable = $('<tbody/>').appendTo($('<table/>').css('margin-left', 20).appendTo(this.tagspane));
		}
		this.tagtable.empty();
		this.mulcombs = [];
		for (var i = 0, len = Math.ceil(this.realparanames.length/4); i < len; i++) {
			var tr = $('<tr/>');
			for (var j = 0, jen = 4, al = this.realparanames.length; j < jen; j++) {
				if (4*i + j == al) {
					break;
				}
				var tagname = this.realparanames[4*i + j];
				$('<td/>').text(tagname + ':').appendTo(tr);
				//b: todo
				var items = this.getTagValues(tagname);
				var multicombo = new FR.CheckBoxEditor({
					width : 100,
					height : 24,
					items : items,
					directEdit : true,
					returnArray : true
				});
				
				this.mulcombs.push(multicombo);
				$('<td/>').append(multicombo.element).appendTo(tr);
			}
			tr.appendTo(this.tagtable);
		}
	},
	
	fillPane : function(hidetags) {
		if (hidetags) {
			this.tagspane.hide();
			this.gridpane.css('top', 0);
//			this.gridpane.height(this.gridpane.height() + 60);
		} else {
			this.tagspane.show();
			this.gridpane.css('top', 60);
//			this.gridpane.height(this.gridpane.height() - 60);
		}
	},
	
	//b: 3 & 80 == ʼ3column, С80, todo
	buildGrid : function(data) {
		if (data) {
			this.grid.popData(data);
			return;
		}
		var columncounts = 3 + this.realparanames.length - (this.control ? 0 : 1);
		var width = Math.floor(900/columncounts);
		if (width < 80) {
			width = 80;
		}
		var columnsconfig = [{
			text : 'name',
			showValue : FR.i18nText("TaskName"),
			width : width
		},{
			text : 'starttime',
			showValue : FR.i18nText("FS_Start_Time"),
			width : width
		}];
		if (this.control) {
			var self = this;
			columnsconfig.push({
					showWidget : true,
					showValue : FR.i18nText("Form-Action"),
					width : width,
					widget : {text : FR.i18nText("Handle_Affairs"), type : 'button', listeners : [{
						eventName : FR.Events.CLICK,
						action : function() {
							var data = self.grid.options.items[this.element.data('index')];
							
							self.showBook(data);
						}
					}]}
				});
		}
		for (var i = 0, len = this.realparanames.length; i < len; i++) {
			columnsconfig.push({
				text : this.realparanames[i],
				showValue : this.realparanames[i],
				width : width
			});
		}
		if (!this.grid) {
			this.grid = new FS.LGrid({
				title : FR.i18nText("AffairToHandle")+":",
				cls : 'fs_process_tasks',
				intervalcolor : false,
				pagecount : 15,
				items : this.tasks,
				columnsconfig : columnsconfig
			});
			this.grid.element.appendTo(this.gridpane);
			return;
		}
		this.grid.rebuildFields(columnsconfig);
		this.grid.popData(this.tasks);
	},
	
	showBook : function(taskinfo) {
		var src = "?op=process_exe&cmd=showbook&taskname=" + FR.cjkEncode(taskinfo.name) + "&processexecutorid=" + taskinfo.processexecutorid;
		FS.tabPane.addItem({
			'title' : FR.i18nText("Handle_Affairs") + taskinfo.processexecutorid,
			src : src
		});
	},
	
	filterGrid : function(fd) {
		if (!fd || !fd.length) {
			this.buildGrid();
			return;
		}
		var filterdata = [];
		for (var i = 0, len = this.tasks.length; i < len; i++) {
			var tags = this.tasks[i].tags;
			var values = $.map(tags, function(tag) {
				return tag.value;
			});
			for (var j = 0, jen = fd.length; j < jen; j++) {
				var match = true;
				var inner = fd[j];
				for (var n = 0, nen = inner.length; n < nen; n++) {
					if (values.indexOf(inner[n]) < 0) {
						match = false;
						break;
					}
		
				}
				if (match && filterdata.indexOf(this.tasks[i]) < 0) {
					filterdata.push(this.tasks[i]);
				}	
			}

		}
		this.buildGrid(filterdata);
	},
	
	resize : function(rec) {
		this.element.height(rec.height).width(rec.width);
		this.tagspane.width(rec.width);
		this.gridpane.width(rec.width);
		this.gridpane.height(rec.height - (this.tagspane.is(':visible') ? 60 : 0));
	}
});

FS.ProcessTriggerTaskPane = FS.extend(FS.Widget, {
	init : function(config) {
		this.element = $('<div/>').addClass('fs_process_pttpane');
		this.processpane = $('<div/>').addClass('fs_process_processpane').css({
			position : 'absolute',
			left : 0,
			top : 0,
			width : 120,
			height : 400
		}).appendTo(this.element);
		this.processtaskspane = $('<div/>').addClass('fs_process_processtaskspane').css({
			position : 'absolute',
			left : 120,
			top : 0,
			width : 1000,
			height : 400
		}).appendTo(this.element);
		this.noTasks = $('<div/>').addClass('fs_process_processnotasks').css({
			position : 'absolute',
			left : 20,
			top : 20
		}).text(FR.i18nText("NoAffairToHandle")+'.').appendTo(this.element);
		this.control = config ? config.control : null;
	},
	
	popTasks : function(tasks) {
		if (!tasks || tasks.length === 0 || this.tasks == tasks) {
			this.processpane.empty();
			this.processtaskspane.empty();
			this.noTasks.show();
			return;
		}
		this.noTasks.hide();

		this.tasks = tasks;
		this.resolveRealData();
		this.generateProcesses();
		this.generateProcessTasks();
		//b:todo
		if (this.buttons) {
			this.buttons[0].fireEvent(FR.Events.CLICK);
		}
	},
	
	resolveRealData : function() {
		//b:process tag
		var processnames  = $.map(this.tasks, function(task) {
			return task.processname;
		});
		this.processnames = [];
		if (processnames.length > 0) {
			var il = new FS.ValueIncreaseList(processnames);
			this.processnames = il.getMaxRepeatedValue();
		}
		
		//b:processݷ
		this.map = new FS.Map();
		for (var i = 0, len = this.processnames.length; i < len; i++) {
			var pn = this.processnames[i], data = [];
			for (var j = 0, jen = this.tasks.length; j < jen; j++) {
				if (this.tasks[j].processname == pn) {
					data.push(this.tasks[j]);
				}
			}
			this.map.put(pn, data);
		}
	},
	
	//b:Ϊؼ todo
	generateProcesses : function() {
		this.processpane.empty();
		this.buttons = [];
		var self = this;
		for (var i = 0, len = this.processnames.length; i < len; i++) {
			var button = new FS.ToolbarButton({
				text : this.processnames[i],
				height : 20,
				width : 116,			
				handler : function() {	
					self.show(this.options.text);							
				}
			});
			button.element.css({
				position : 'absolute',
				left : 2,
				top : 40 + 24*i
			}).appendTo(this.processpane);
			this.buttons.push(button);
		}
	},
	
	show : function(process) {
		for (var i = 0, len = this.buttons.length; i < len; i++) {
			this.buttons[i].element.removeClass('fs_button_selected');
		}
		var data = this.map.get(process);
		if (this.processtasks && data != this.processtasks.tasks) {
			this.processtasks.popTasks(data);
		}
	},
	
	generateProcessTasks : function() {
		if (!this.processtasks || this.processtasks.isEmpty()) {
			//b:to do control ̫
			this.processtasks = new FS.ProcessTasks({
				control : this.control,
				width : this.element.width() - 120,
				height : this.element.height()
			});
			this.processtaskspane.append(this.processtasks.element);
		}
		this.processtasks.clearContent();
	},
	
	resize : function(rec) {
		this.element.width(rec.width).height(rec.height);
		this.processpane.height(rec.height);
		this.processtaskspane.width(rec.width - 120).height(rec.height);
		if (this.processtasks) {
			this.processtasks.resize({
				width : rec.width - 120,
				height : rec.height
			});		
		}
	}
});

FS.AllTask = FS.extend(FS.Widget, {
	init : function(config) {
		this.type = config.type;
		this.element = $('<div/>').attr('id', 'fs_process_taskinfo' + this.type).addClass('fs_process_taskpane').css('overflow', 'auto');
		this.generatePane();
		this.resize(config);
	},
	
	generatePane : function() {
		this.pttp = new FS.ProcessTriggerTaskPane();
		this.element.append(this.pttp.element);
		this.refresh();	
	},
	
	refresh : function(data) {
		setTimeout(function() {
			this.pttp.popTasks(FS.Trans.getAllJob());
		}.createDelegate(this), 25);
	},
	
	resize : function(rec) {
		this.element.width(rec.width).height(rec.height);
		this.pttp.resize(rec);
	}
});

FS.FinishTask = FS.extend(FS.Widget, {
	init : function(config) {
		this.type = config.type;
		this.element = $('<div/>').attr('id', 'fs_process_taskinfo' + this.type).addClass('fs_process_taskpane').css('overflow', 'auto');
		this.generatePane();
		this.resize(config);		
	},
	
	generatePane : function() {
		var gridConfig = {
			title : FR.i18nText("DONE_WORK") + ':',
			cls : 'fs_process_tasks',
			intervalcolor : false,
			pagecount : 15,
			items : []
		};
		$.extend(gridConfig, {
			columnsconfig : [{
					text : 'name',
					showValue : FR.i18nText("TaskName"),
					width : 340
				}, {
					text : 'starttime',
					showValue : FR.i18nText("FS_Start_Time"),
					width : 340
				}, {
					text : 'endtime',
					showValue : FR.i18nText("FS_End_Time"),
					width : 340
				}]
		});	
		this.taskgrid = new FS.LGrid(gridConfig);
		this.element.append(this.taskgrid.element);
		this.refresh();		
	},
	
	refresh : function() {
		setTimeout(function() {
			this.taskgrid.popData(FS.Trans.getFinishedJob());
		}.createDelegate(this), 25);		
	},
	
	resize : function(rec) {
		this.element.width(rec.width).height(rec.height);
	}	
});

FS.MyProcessTask = FS.extend(FS.Widget, {
	init : function(config) {
		this.type = config.type;
		this.element = $('<div/>').attr('id', 'fs_process_taskinfo' + this.type).addClass('fs_process_taskpane').css('overflow', 'auto');
		this.generatePane();
		this.resize(config);		
	},
	
	generatePane : function() {
		this.processgridpane = $('<div/>').attr('id', 'fs_processgrid').css({
			position : 'absolute', 
			top : 40,
			background : '#B9E1F9'
		});
		this.mystarttaskpane = $('<div/>').attr('id', 'fs_processmytask').css({
			position : 'absolute', 
			top : 40,
			background : '#B9E1F9'
		}).hide();
		this.toolbar = $('<div/>').attr('id', 'fs_processbar').css({
			height : 40
		});
		var self = this;
		this.myprocess = new FS.ToolbarButton({
			text : FR.i18nText("StartProcess"),
				height : 24,
				handler : function() {
					self.mytask.element.removeClass('fs_button_selected');
					self.mystarttaskpane.hide();
					self.processgridpane.show();								
				}
			});
		this.myprocess.element.attr('id', 'fs_processstart_button').css({
			position : 'absolute',
			left : 20,
			top : 3
		}).addClass('fs_button_selected');
		this.mytask = new FS.ToolbarButton({
			text : FR.i18nText("ProcessStartedBySelf"),
			height : 24,
			width : 100,
			handler : function() {
				self.myprocess.element.removeClass('fs_button_selected');
				self.processgridpane.hide();
				self.mystarttaskpane.show();			
			}
		});
		this.mytask.element.attr('id', 'fs_processmytask_button').css({
			position : 'absolute',
			left : 130,
			top : 3
		});
		this.toolbar.append(this.myprocess.element).append(this.mytask.element).appendTo(this.element);
		
		this.generateProcessGrid();
		this.generateMyProcessTasks();
	},
	
	generateProcessGrid : function() {
		var gridConfig = {
			title : FR.i18nText("StartProcess")+':',
			cls : 'fs_process_tasks',
			intervalcolor : false,
			pagecount : 15,
			items : []
		};
		var self = this;
		$.extend(gridConfig, {
			columnsconfig : [{
				text : 'name',
				showValue : FR.i18nText("ProcessName"),
				width : 540
			},  {
				showValue : FR.i18nText("Form-Action"),
				width : 340,
				showWidget : true,
				widget : {text : FR.i18nText("StartProcess"), type : 'button', listeners : [{						
					eventName : FR.Events.CLICK,
					action : function() {
						var id = self.processgrid.options.items[this.element.data('index')].id;
						try {
							var result = FS.Trans.startProcess(id);
							if (result.start) {
								FR.Msg.toast(FR.i18nText("StartSuccessfully") + "!");
							} else {
								FS.Process.refreshTask();
								self.showBook(result);
							}
						} catch(e) {
							FR.Msg.toast(FR.i18nText("StartFailed") + "!");
						}
					}
				}]}
			}]
		});	
		this.processgrid = new FS.LGrid(gridConfig);
		this.processgridpane.append(this.processgrid.element).appendTo(this.element);
		this.refreshProcess();
	},
	
	//b:repeat do delete
	showBook : function(taskinfo) {
		var src = "?op=process_exe&cmd=showbook&taskname=" + FR.cjkEncode(taskinfo.name) + "&processexecutorid=" + taskinfo.processexecutorid;
		FS.tabPane.addItem({
			'title' : FR.i18nText("Handle_Affairs") + taskinfo.processexecutorid,
			src : src
		});
	},
	
	refreshProcess : function() {
		setTimeout(function() {
			this.processgrid.popData(FS.Trans.getProcessDefine());
		}.createDelegate(this), 25);
	},
	
	refreshTask : function() {
		setTimeout(function() {
			this.processtasks.popTasks(FS.Trans.getMyStartJob());
		}.createDelegate(this), 25);	
	},
	
	generateMyProcessTasks : function() {
		this.processtasks = new FS.ProcessTriggerTaskPane();
		this.mystarttaskpane.append(this.processtasks.element).appendTo(this.element);
		this.refreshTask();
	},
	
	resize : function(rec) {
		this.toolbar.width(rec.width);
		this.processgridpane.width(rec.width).height(rec.height - this.toolbar.height());
		this.mystarttaskpane.width(rec.width).height(rec.height - this.toolbar.height());
		this.processtasks.resize({
			width : rec.width,
			height : rec.height - this.toolbar.height()
		});
	}
});

//b:ʱֻųtodotaskĶʱ
FS.TodoTask = FS.extend(FS.Widget, {
	init : function(config) {
		this.type = config.type;
		this.element = $('<div/>').attr('id', 'fs_process_taskinfo' + this.type).addClass('fs_process_taskpane').css('overflow', 'auto');
		this.generatePane();
		this.triggerRefresh();
		this.resize(config);
	},
	
	generatePane : function() {
		this.pttp = new FS.ProcessTriggerTaskPane({
			control : true
		});
		this.element.append(this.pttp.element);
		this.refresh();	
	},
	
	refresh : function(data) {
		setTimeout(function() {
			var tasks = data ? data : FS.Trans.getTodoJob();
			this.pttp.popTasks(tasks);
		}.createDelegate(this), 25);
	},

	
	getTableData : function() {
		var data;
		if (this.type == FS.ProcessList.todoJob) {
			data = FS.Trans.getTodoJob();
//			data = [{
//				name : "task1",
//				starttime : '2011/11/24'
//			}, {
//				name : 'task2',
//				starttime : '2011/11/24'
//			}];
		} else if (this.type == FS.ProcessList.startProcess) {
			data = FS.Trans.getProcessDefine();
		} else if (this.type == FS.ProcessList.finishedJob) {
			data = FS.Trans.getFinishedJob();
//			data = [{
//				name : "endtask1",
//				starttime : '2011/11/24',
//				endtime : '2011/11/24'
//			}, {
//				name : 'endtask2',
//				starttime : '2011/11/24',
//				endtime : '2011/11/24'
//			}];
		}
		
		return data;
	},
	
	getOldData : function() {
		return this.pttp.tasks;
	},
	
	//b:5Զˢһ,ѣʾ˸title later
	triggerRefresh : function() {
		setInterval(function() {
			var data = null;
			if (this.type == FS.ProcessList.todoJob) {
				data = FS.Trans.getTodoJob();
				if (!this.checkTask(this.getOldData(), data)) {
					FS.Process.showNewTaskInfo();
					this.refresh(data);
				}
			}			
		}.createDelegate(this), 300000);
	},
	
	checkTask : function(oldtasks, tasks) {
		if(tasks == null || tasks.length === 0) {
			return true;
		}
		var oids = $.map(oldtasks, function(task) {
			return task.id;
		});
		var ids = $.map(tasks, function(task) {
			return task.id;
		});

		if (ids.length > oids.length) {
			return false;
		}
		for (var i = 0, len = ids.length; i < len; i++) {
			if (oids.indexOf(ids[i]) < 0) {
				return false;
			}
		}
		return true;
	},
	
	resize : function(rec) {
		this.element.width(rec.width).height(rec.height);
		this.pttp.resize(rec);
	}
});