/*
 * Copyright (c) 2001-2014,FineReport Inc, All Rights Reserved.
 */

/**
 * Created by wei on 14-4-9.
 * ϵͳõһЩСĿؼ
 */

/**
 * wei:FSҪõĿذťؼ
 */
;
FS.SwitchButton = FR.extend(FR.Widget, {
    _defaultConfig: function () {
        return $.extend(FS.SwitchButton.superclass._defaultConfig.call(), {
            width: 128,
            height: 25,
            value: false,
            hoverCls: "fs_siwthbutton_hover",
            onTurnOn: function(){
                return true;
            },
            onTurnOff: function(){
                return true;
            }
        });
    },

    _init: function () {
        FS.SwitchButton.superclass._init.apply(this, arguments);
        var self = this;
        var o = this.options;
        var buttonBody = $("<div/>").attr("id", "fs_switchbutton_body").appendTo(this.element);
        var leftPart = $("<div/>").attr("id", "fs_switchbutton_left").appendTo(buttonBody)
            .hover(function () {
                if (!self.options.value) {
                    $(buttonBody).addClass(o.hoverCls);
                }
            },function () {
                $(buttonBody).removeClass(o.hoverCls);
            }).click(function () {
                $(buttonBody).removeClass(o.hoverCls);
                if(FR.applyFunc(self, o.onTurnOn, [], false) !== false){
                    self.setValue(true);
                }
            });
        var rightPart = $("<div/>").attr("id", "fs_switchbutton_right").appendTo(buttonBody)
            .hover(function () {
                if (self.options.value) {
                    $(buttonBody).addClass(o.hoverCls);
                }
            },function () {
                $(buttonBody).removeClass(o.hoverCls);
            }).click(function () {
                $(buttonBody).removeClass(o.hoverCls);
                if(FR.applyFunc(self, o.onTurnOff, [], false) !== false){
                    self.setValue(false);
                }
            });
        this.textAreaL = $("<div/>").addClass("fs_switchbutton_textarea").appendTo(leftPart);
        this.textAreaR = $("<div/>").addClass("fs_switchbutton_textarea").appendTo(rightPart);
        this.setValue(this.options.value);
    },

    /**
     * °ť״̬
     */
    _refreshButton: function () {
        if (this.options.value) {
            //״̬
            this.element.removeClass("fs_switchbutton_off");
            this.element.addClass("fs_switchbutton_on");
            this.textAreaL.text(FR.i18nText('Opened'));
            this.textAreaR.text(FR.i18nText('TurnOff'));
        } else {
            //ر״̬
            this.element.removeClass("fs_switchbutton_on");
            this.element.addClass("fs_switchbutton_off");
            this.textAreaL.text(FR.i18nText('TurnOn'));
            this.textAreaR.text(FR.i18nText('Closed'));
        }
    },

    /**
     * ðť/ر
     */
    setValue: function (value) {
        var o = this.options;
        o.value = value;
        this._refreshButton();
        if (arguments[1] === true) {
            if (value) {
                if ($.isFunction(o.onTurnOn)) {
                    o.onTurnOn.call();
                }
            } else {
                if ($.isFunction(o.onTurnOff)) {
                    o.onTurnOff.call();
                }
            }
        }
    },

    /**
     * ȡťǷѡ
     */
    getValue: function () {
        return this.options.value;
    }
});
$.shortcut("switch", FS.SwitchButton);

/**
 * Sean:FSпõL(Light)TabPanel
 */
FS.LTabPane = FR.extend(FR.Widget, {
    _defaultConfig: function () {
        return $.extend(FS.LTabPane.superclass._defaultConfig.call(), {
            height: 500,
            width: 400,
            headerCls : 'fs_ltabpane_tabs',
            baseCls: 'fs_ltabpane',
            tabsCls: 'fs_ltabpane_tabs_general',//ѡǩ࣬ڹǩͨʽ
            selectedTabCls: 'fs_ltabpane_tabs_selected',//ѡеıǩ
            hoverTabCls: 'fs_ltabpane_tabs_hover',//ѡǩϵЧ
            unselectedContentCls: 'fs_ltabpane_content_unselected',//صѡ
            selectedContentCls: 'fs_ltabpane_content_selected',//ʾѡ
            defaultIdx: 0,//ʼʱĬѡеıǩ,ĬΪһǩ
            type: "ltabpanel",
            style: null,
            items: [],
            vgap: 25, //ǩݲֵ¼
            initAfterActions: [],  //ǩһαſʼڲԪأ״μغ¼
            opAfterActions: [],  //ǩÿһαĲ
            tabLeft : 21,    //ǩleftԣ21Ϊһǩleft
            tabDistance : 35,
            marginLeft: 20
        });
    },
    _init: function () {
        FS.LTabPane.superclass._init.apply(this, arguments);
        var o = this.options;
        var self = this;
        if (o.widgetName) {
            this.element.attr("widgetName", o.widgetName);
        }
        this.element.addClass(o.baseCls);
        var n = o.items.length;
        //ǩ
        if (n > 0) {
            this.tabs = $('<div/>').addClass(o.headerCls);
            this.tabs.appendTo(this.element);
        }
        this.tabs.css('margin-bottom', o.vgap + 'px');
        //ݲ
        for (var i = 0; i < n; i++) {
            var tabDiv = this._createTabDiv(i);
            //ע¼
            tabDiv.on('click', function () {
                self.tabDivOnClick(this);
            });
            //ע¼
            tabDiv.on('mouseover', function () {
                //ѡеıǩhoverЧ
                if ($(this).hasClass(o.selectedTabCls)) {
                    return;
                }
                $(this).addClass(o.hoverTabCls);
            });
            //עƳ¼
            tabDiv.on('mouseout', function () {
                $(this).removeClass(o.hoverTabCls);
            });
            tabDiv.appendTo(this.tabs);
            var tabOuterWidth = tabDiv.outerWidth();
            if(o.items[i].width) {
                tabOuterWidth = o.items[i].width;
            }
            o.tabLeft += tabOuterWidth + o.tabDistance;
        }
        this.tabs.find('.' + o.tabsCls + '[tabindex=' + o.defaultIdx + ']').trigger('click');
    },

    tabDivOnClick : function(tabElement) {
        //ǩл
        var o = this.options;
        if ($(tabElement).hasClass(o.selectedTabCls)) {
            return false;
        }
        this.removeSelected();
        var tabindex = $(tabElement).attr("tabindex");
        $(tabElement).addClass(o.selectedTabCls);
        //л
        this._contentSwitchTo(tabindex);
        return true;
    },

    _createTabDiv : function(index) {
        var o = this.options;
        return $('<div/>').attr('tabindex', index)
            .attr('unselectable', 'on')
            .css({left: o.tabLeft})
            .addClass(o.tabsCls).text(o.items[index].title);
    },

    removeSelected : function() {
        var o = this.options;
        var $selected = this.tabs.find('.' + o.selectedTabCls);
        if ($selected.length > 0) {
            $selected.css({left: $selected.get(0).oldValue});
            $selected.removeClass(o.selectedTabCls);
        }
    },

    /**
     * ǩݽл
     * @param idx : tab±
     */
    _contentSwitchTo: function (idx) {
        var o = this.options;
        if (!this._isLoaded(idx) || this.options.loadEveryTime === true) {
            this.element.children('div[contentindex=' + idx + ']').remove();
            var contentPane = $('<div/>')
                .attr('contentindex', idx)
                .css({'margin-left': o.marginLeft})
                .addClass(o.selectedContentCls)
                .appendTo(this.element);
            if (o.items[idx].content instanceof $) {
                o.items[idx].content.appendTo(contentPane);
            } else {
                o.items[idx].content.renderEl = contentPane;
                o.items[idx].content.style = o.style;   //´styleԣԺͳһʽ
                this.container = FR.createWidget($.extend(o.items[idx].content, {
                    resultWidgets: this.options.resultWidgets
                }));
            }
            if ($.isFunction(o.initAfterActions[idx])) {
                o.initAfterActions[idx].apply(this);
            }
        }
        if ($.isFunction(o.opAfterActions[idx])) {
            o.opAfterActions[idx].apply(this);
        }
    },

    /**
     * жtabǷѾع
     * @param idx : tab±
     * @return boolean
     */
    _isLoaded: function (idx) {
        var o = this.options;
        var content = this.element.children('div[contentindex=' + idx + ']');
        //
        this.element.children('.' + o.selectedContentCls).addClass(o.unselectedContentCls).removeClass(o.selectedContentCls);
        //ǵһμأֱʾʼ̬
        if (content.length !== 0) {
            //ʾ
            content.removeClass(o.unselectedContentCls).addClass(o.selectedContentCls);
            return true;
        }
        return false;
    }
});
$.shortcut("ltab", FS.LTabPane);

/**
 * wei : FSǩҳʹõtabPane
 */
FS.InsideTabPane = FR.extend(FS.LTabPane, {
    _defaultConfig : function() {
        return $.extend(FS.InsideTabPane.superclass._defaultConfig.call(), {
            baseCls : 'fs_inside_tabpane',
            headerCls : 'fs_inside_tab_header',
            tabsCls : 'fs_inside_tab',
            selectedTabCls : 'fs_inside_tab_selected',
            selectedContentCls : 'fs_inside_content_selected',
            tabNoRightBorderCls : 'fs_inside_tab_no_right_border',
            tabNoLeftBorderCls : 'fs_inside_tab_no_left_border',
            tabLeft : 0,    //ǩleftԣ21Ϊһǩleft
            tabDistance : 0,
            vgap : 0,
            marginLeft : 0,
            elementMarginLeft : 0
        })
    },

    _init : function() {
        FS.InsideTabPane.superclass._init.call(this, arguments);
        if(this.options.elementMarginLeft) {
            this.element.css('marginLeft', this.options.elementMarginLeft);
        }
    },

    tabDivOnClick : function(tabElement) {
        var o = this.options;
        var tabindex = parseInt($(tabElement).attr("tabindex"));
        if(o.items[tabindex].keepActive === true) {
            return ;
        }
        var activeChanged = FS.InsideTabPane.superclass.tabDivOnClick.call(this, arguments);
        if(!activeChanged) {
            return ;
        }
        if (o.afterTabClick && $.isFunction(o.afterTabClick[tabindex])) {
            o.afterTabClick[tabindex].apply(this);
        }
        var nextTab = o.items[tabindex + 1];
        var keepActiveTab;
        if(nextTab && nextTab.keepActive === true) {
            //һһֱ״̬Ļмborderȥ
            $(tabElement).addClass(o.tabNoRightBorderCls);
            keepActiveTab = this.tabs.find('.' + o.tabsCls + '[tabindex=' + (tabindex+1) + ']');
            keepActiveTab.addClass(o.tabNoLeftBorderCls);
            this.fixTabWidth(keepActiveTab, false, true);
        } else if(nextTab) {
            //ȼ򵥴Ŀǰʹõһֱּ̬tab
            keepActiveTab = this.tabs.find('.' + o.tabNoLeftBorderCls);
            if(keepActiveTab.length > 0) {
                this.fixTabWidth(keepActiveTab, true, true);
            }
            this.tabs.find('.' + o.tabsCls).removeClass(o.tabNoRightBorderCls);
            this.tabs.find('.' + o.tabsCls).removeClass(o.tabNoLeftBorderCls);
        }
        this.fixTabWidth($(tabElement), true);
    },

    fixTabWidth : function(element, isGetActive, isKeepActive) {
        var o = this.options;
        var width = element.width();
        if(isGetActive) {
            //ɼ̬tab-2/-1
            if(isKeepActive || element.hasClass(o.tabNoRightBorderCls) || element.hasClass(o.tabNoRightBorderCls)) {
                element.width(width - 1);
            } else {
                element.width(width - 2);
            }
        } else {
            //ʧȥ̬tab+2/+1
            if(isKeepActive || element.hasClass(o.tabNoRightBorderCls) || element.hasClass(o.tabNoRightBorderCls)) {
                element.width(width + 1);
            } else {
                element.width(width + 2);
            }
        }
    },

    _createTabDiv : function(index) {
        var o = this.options;
        var keepActive = this.isTabKeepActive(index);
        var tabDiv = $("<div/>").attr('tabindex', index)
            .attr('unselectable', 'on').attr('keepActive', keepActive)
            .css({left: o.tabLeft}).addClass(o.tabsCls);
        if(o.items[index].title instanceof $) {
            tabDiv.append(o.items[index].title);
        } else {
            tabDiv.text(o.items[index].title);
        }
        if(keepActive) {
            tabDiv.addClass(o.selectedTabCls);
        }
        if(o.items[index].width) {
            //ŵûҳǰͿʼʼĿؼˣouterWidthȡ... ôˡ
            tabDiv.width(o.items[index].width - (o.items[index].borderWidth ? o.items[index].borderWidth : 0));
        }
        return tabDiv;
    },

    removeSelected : function() {
        var o = this.options;
        var $selected = this.tabs.find('.' + o.selectedTabCls);
        if ($selected.length > 0) {
            for(var i = 0, len = $selected.length; i < len; i ++) {
                var selectedElement = $($selected.get(i));
                selectedElement.css({left: $selected.get(i).oldValue});
                if(selectedElement.attr("keepActive") != "true") {
                    selectedElement.removeClass(o.selectedTabCls);
                    this.fixTabWidth(selectedElement, false);
                }
            }
        }
    },

    isTabKeepActive : function(index) {
        return this.options.items[index].keepActive === true;
    },

    getActiveIndex: function() {
        var o = this.options;
        return parseInt(this.tabs.find('.' + o.selectedTabCls).attr("tabindex"));
    },

    getActiveTab: function() {
        var o = this.options;
        return this.element.find('.' + o.selectedContentCls);
    }
});
$.shortcut("insidetab", FS.InsideTabPane);

/**
 * Sean:
 */
FS.FloatPane = FR.extend(FR.Widget, {
    _defaultConfig: function () {
        return $.extend(FS.FloatPane.superclass._defaultConfig.apply(this, arguments), {
            baseCls: 'fs-floatpane',
            width: 715,
            anchor: null,
            confirm: true,
            contentWidget: null,
            isDefaultShow: false,
            contentHieght: 260
        });
    },
    _init: function () {
        FS.FloatPane.superclass._init.apply(this, arguments);
        var o = this.options, self = this;
        this.element.appendTo(o.anchor);
        this.$content = $('<div class="fs-floatpane-content"/>')
            .css({
                height: o.contentHieght,
                width: o.width - 10
            }).appendTo(this.element);
        var widget = FR.createWidget($.extend(o.contentWidget, {
            renderEl: $('<div/>').appendTo(this.$content),
            resultWidgets: o.resultWidgets
        }));
        var settingsMarginLeft = parseInt(FR.i18nText("FS-System_Settings_Button_Margin_Left") || 55);
        var settingsButtonWidth = parseInt(FR.i18nText("FS-System_Settings_Button_Width") || 50);
        var $btn = $('<div class="fs-floatpane-btn"/>').css({
            'margin-left': o.width - settingsMarginLeft,
            width : settingsButtonWidth
        }).click(
            function(){
                self.doSlide();
            }
        ).appendTo(this.element);
        this.$icon = $('<a class="fs-floatpane-icon fs-floatpane-down"/>').text(FR.i18nText("FS-System_Settings")).appendTo($btn);
        if(!o.isDefaultShow){
            this.doHide();
        }
    },
    doHide: function(){
        this.$content.hide();
    },
    doSlide: function(){
        this.$icon.switchClass("fs-floatpane-down", "fs-floatpane-up");
        this.$content.slideToggle('fast');
    }
});
$.shortcut('floatpane', FS.FloatPane);
/**
 * Sean:չؼ
 */
FS.Accordion = FR.extend(FR.Widget, {
    _defaultConfig: function () {
        return $.extend(FS.Accordion.superclass._defaultConfig.apply(this, arguments), {
            baseCls: 'fs-accordion',
            width: 731,
            items: []
        });
    },
    _init: function () {
        FS.Accordion.superclass._init.apply(this, arguments);
        var o = this.options;
        for(var i= 0, len = o.items.length; i < len; i++){
            var menu = o.items[i].menu;
            var content = o.items[i].content;
            var $menu = $('<div/>').addClass('fs-accordion-menu').click(
                function(){
                    $(this).children('div').toggleClass('fs-accordion-icon-fold');
                    $(this).next().slideToggle('fast');
                }
            ).appendTo(this.element);
            $('<div/>').addClass('fs-accordion-icon-unfold').appendTo($menu);
            $('<span/>').text(menu).appendTo($menu);
            var $context = $('<div/>').addClass('fs-accordion-content').hide().appendTo(this.element);
            var widget = FR.createWidget($.extend(content, {
                resultWidgets: o.resultWidgets
            }));
            widget.element.appendTo($context);
        }
    }
});
$.shortcut('accordion', FS.Accordion);
/**
 * Sean:
 */
FS.TablePane = FR.extend(FR.Widget, {
    _defaultConfig: function () {
        return $.extend(FS.TablePane.superclass._defaultConfig.apply(this, arguments), {
            rowSize: [],
            colSize: [],
            hgap: 0,
            vgap: 0,
            items: []
        });
    },
    _init: function () {
        FS.TablePane.superclass._init.apply(this, arguments);
        this.$rows = [];
        var  o = this.options;
        for(var i = 0, size = o.rowSize.length; i<size;i++){
            var $row = $('<div class="fr-tablepane-row"/>').appendTo(this.element);
            for(var j = 0, len = o.colSize.length; j<len; j++){
                var $cell = $('<div class="fr-tablepane-item"/>').appendTo($row);
                var item = o.items[i][j];
                if(!item){
                    continue;
                }
                if(!item.type){
                    $cell.css({width: o.colSize[j], height: o.rowSize[i]}).append(item);
                }else{
                    var widget = FR.createWidget($.extend(item, {
                        resultWidgets: this.options.resultWidgets,
                        width: item.width?item.width:o.colSize[j],
                        height: item.height?item.height:o.rowSize[i],
                        renderEl: $cell
                    }));
                }
                if(i>0){
                    $cell.css({'margin-left': o.hgap});
                }
            }
            if(i>0){
                $row.css({'margin-top': o.vgap});
            }
            this.$rows.push($row);
        }
    },
    /**
     * ȡָеdomԪ
     * @param index 0ʼ
     */
    getRowAt: function(index){
        return this.$rows[index];
    },
    setRowVisible: function(rowIdxs, isVisible){
        for(var i= 0,len = rowIdxs.length;i<len;i++){
            if(isVisible){
                this.$rows[rowIdxs[i]].show();
            }else{
                this.$rows[rowIdxs[i]].hide();
            }
        }
    }
});
$.shortcut('tablepane', FS.TablePane);
