/**
 * Coder: Sean
 * Date: 13-10-27
 * Time: 12:55
 */

(function ($) {
    FS.TableTree = FR.extend(FR.Widget, {
        _defaultConfig: function () {
            return $.extend(FS.TableTree.superclass._defaultConfig.apply(this, arguments), {
                widgetName: 'fstabletree',
                treeID: 'tabletree',  //Ҫԣãڱʶ󣬵һҳڶtabletreeʱ򣬿ʶͬtree
                setting: {}, //
                Nodes: null, //
                width: 200,
                height: 300,
                fit:false, //Sean:ӦСΪ100%fitΪtruefitΪtrueΪֵIE67²Żֹ
                tools: [],
                alwaysShowTools: true,
                itemHoverCls: null,//ʾеclass
                onItemToolClick: null,
                hasXScroll: false, //falseʾʡԺűʾ
                scrollWidth: 16, //
                toolMargin:0, //tool֮ļ
                toolDisableCls: 'fs_tool_disabled'
            });
        },
        //չع
        exRebuild:function(config){
            $.extend(true,this.options,config);
            this._init();
        },
        showToolByIndex:function(index){
            this.element.find('td[toolid='+index+']').show();
            this.options.tools[index].invisible = false;
        },
        hideToolByIndex:function(index){
            this.element.find('td[toolid='+index+']').hide();
            this.options.tools[index].invisible = true;
        },
        _init: function () {
            FS.TableTree.superclass._init.apply(this, arguments);
            FR.$defaultImport('/com/fr/web/platform/js/jquery.zTree.js', 'js');
            FR.$defaultImport('/com/fr/fs/web/css/zTreeStyle/zTreeStyle.css', 'css');
            var opts = this.options;
            this.childrenKey = opts.setting.data.key ? opts.setting.data.key.children : "children";
            this.$table = $('<table class="ztree" cellspacing="0" cellpadding="0"/>');
            this.$tbody = $('<tbody/>').attr('id', opts.treeID); //ztreeʽ
            this.$table.append(this.$tbody).appendTo(this.element);
            if (opts.fit === true) {
                var p = this.element.parent();
                opts.width = p.width();
                opts.height = p.height();
            }
            this.element.css({
                width: opts.width,
                height: opts.height,
                overflow: 'auto'
            });
            this._toolsInit();
            this.zTree = $.fn.zTree.init(this.$tbody, opts.setting, opts.Nodes); //

        },
        _getNodeIndex : function(treenode) {
        	var i = 0;
        	var preNode = treenode.getPreNode();
        	while(preNode !== null) {
        		i ++;
        		preNode = preNode.getPreNode();
        	}
        	return i ;
        },
        
        _makeSortableByGroup : function(node, sorthandle) {
        	var self = this;
        	if(!node[this.childrenKey]) {
        		return ;
        	}
        	if(node[this.childrenKey].length < 2) {
    			return;
    		}
        	var trs = [];
        	for(var i = 0; i < node[this.childrenKey].length; i ++) {
        		var childnode = node[this.childrenKey][i];
    			var tr = $("tr[id="+childnode.tId+"]", this.element);
    			trs.push(tr[0]);
    		}
			trs = $(trs);
			var beforeDragNode, afterDragNode, beforeDragIndex, afterDragIndex;
			var isOpen = false;
			var collapseNodes = [];
    		trs.sortable({
    			items:trs,
    			axis:"y",
    			opacity:"0.8",
    			helper:"clone",
    			start:function(event, ui) {
    				//
    				var trid = ui.item.attr("id");
    				var curNode = self.getNodeById(trid);
    				isOpen = curNode.open;
    			
    				//ȰcurrentNodeͬĶЩ	
    				collapseNodes = [];
    				function filter(node) {
					    return (node.level == curNode.level);
					}
					var levelNodes = self.getNodesByFilter(filter);
    				for(var i = 0; i < levelNodes.length; i ++) {
    					if(levelNodes[i].open && levelNodes[i][self.childrenKey]) {
    						//
    						self.expandNode(levelNodes[i], false);
    						collapseNodes.push(levelNodes[i]);
    					}
    				}
//    				self.expandNode(curNode, false);
    				beforeDragNode = curNode;
    				var currentLevel = beforeDragNode.level;
    				var parentNode = beforeDragNode.getParentNode();
    				if(parentNode) {
    					var levelTRs = $("tr." + parentNode.tId+"_ul");
    					beforeDragIndex = levelTRs.index(ui.item);
    				} else {
    					var trsAtLevel = $("tr.level" + currentLevel, self.element);
    					beforeDragIndex = trsAtLevel.index(ui.item);
    				}
    			},
    			stop:function(event, ui) {
    				var beforeLevel = beforeDragNode.level;
    				var nextTR = ui.item.next();
    				if(nextTR.length < 1 || (self.getNodeById(nextTR.attr("id")).level !== beforeLevel)) {
    					//˵ƵײˣafterDragȡһڵ
    					var prevTR = ui.item.prev();
    					afterDragNode = self.getNodeById(prevTR.attr("id"));
    				} else {
    					afterDragNode = self.getNodeById(nextTR.attr("id"));
    				}
    				//ڵƵȷλ
    				
    				for(var m = 0; m < collapseNodes.length; m ++) {
    					var children = self.transformToArray(collapseNodes[m][self.childrenKey]);
	    				var currentTR = $("tr[id="+collapseNodes[m].tId+"]", self.element);
	    				for(var i = 0; i < children.length; i ++) {
	    					var temp = $("tr[id="+children[i].tId+"]", self.element);
	    					currentTR.after(temp);
	    					currentTR = temp;
	    				}
	    				self.expandNode(collapseNodes[m], true);
    				}
    				
    				var currentLevel = beforeDragNode.level;
    				var parentNode = beforeDragNode.getParentNode();
    				if(parentNode) {
    					var levelTRs = $("tr." + parentNode.tId+"_ul");
    					afterDragIndex = levelTRs.index(ui.item);
    				} else {
    					var trsAtLevel = $("tr.level" + currentLevel, self.element);
    					afterDragIndex = trsAtLevel.index(ui.item);
    				}
    				if($.isFunction(sorthandle)) {
    					sorthandle.call(self, beforeDragNode, afterDragNode, beforeDragIndex, afterDragIndex);
    				}
    			}
    		}).disableSelection();
        	
        },
        sortable : function(sorthandle) {
        	var self = this;
        	var nodes = this.transformToArray(this.getNodes());
        	for(var i = 0; i < nodes.length; i ++) {
            	this._makeSortableByGroup(nodes[i], sorthandle);	
        	}
        },
        _toolsInit: function () {
            var self = this;
            var opts = this.options;
            if (!opts.hasXScroll) {
                this.element.css({
                    'overflow-x': 'hidden',
                    'overflow-y': 'auto'
                })
            }
            
            var TreeOnNodeCreated = function (event, treeId, treeNode) {
                var $nodeTr = $('#' + treeNode.tId, self.element);
                
                //toolsͳʼtools
                if (opts.tools && opts.tools.length > 0) {
                	treeNode.toolName =  [];
                	treeNode.toolDiv = [];
                    for (var i = 0; i < opts.tools.length; i++) {
                    	(function(i) {
                    		//tool.rootToolHide ظڵĵǰ
                            if(!treeNode.getParentNode() && opts.tools[i].rootToolHide){
                                $('<td width="20px"/>').html('&nbsp;').appendTo($nodeTr);
                                return ;
                            }
                            var toolItem = opts.tools[i];
                            var toolName = toolItem.name;
                            var $toolDiv = $('<div/>').data('nodeID', treeNode.tId).data('tool', toolItem);//toolnodeID
                            if(self.options.toolMargin) {
                            	$toolDiv.css('margin-right', self.options.toolMargin+'px');
                            }
                            if(opts.tooltype === "check") {
                            	treeNode.toolName.push(toolName);
                            	treeNode.toolDiv.push($toolDiv);
                                if(treeNode.toolDisAbleIndex && treeNode.toolDisAbleIndex == i) {
                                    $toolDiv.addClass(self.options.toolDisableCls);
                                }
                            	$toolDiv.addClass("fs_tool_checkoff");
                                if(opts.toolUnEditAble) {
                                    $toolDiv.addClass("fs_tool_disabled");
                                }
                            	$toolDiv.click(function (e) {
                            		//check͵Ļ˵ǿɸѡtabletree
                            		//checkbox״̬0ûѡ1ȫѡ2ѡ
                                    self.onToolDivClick(i, e, this, treeNode);
                                    if ($.isFunction(opts.onItemToolClick)) {
                                        opts.onItemToolClick.call(this);
                                    }
                            	});
                        	}
                            if (toolItem.iconCls) {
                                $toolDiv.addClass(toolItem.iconCls);
                                //ؼ¼
                                if (toolItem.clickCls) {
                                    $toolDiv.mousedown(function () {
                                        $(this).addClass($(this).data('tool').clickCls);
                                    }).mouseup(function () {
                                            $(this).removeClass($(this).data('tool').clickCls);
                                        });
                                }
                                if(toolItem.onToolClick){
                                    $toolDiv.click(function (e) {
                                        $(this).data('tool').onToolClick.call(this, e);
                                    });
                                }
                                //hover࣬ͨɾʵֽЧ
                                if (toolItem.hoverCls) {
                                    $toolDiv.data('hoverCls', toolItem.hoverCls);
                                    $toolDiv.hover(function () {
                                        $(this).addClass($(this).data('hoverCls'));
                                    }, function () {
                                        $(this).removeClass($(this).data('hoverCls'));
                                    });
                                }
                            }
                            var $tooltd = $('<td/>').attr('toolid',i).appendTo($nodeTr).append($toolDiv);
                            if(toolItem.invisible){
                                $tooltd.hide();
                            }
                    	})(i);
                    }
                    if (!opts.alwaysShowTools) {
                        //attention: tabletreeÿһtrֻtooldivɵģ
                        // дÿdivʱȥжһ
                        $nodeTr.find('div').css({'display': 'none'});
                        //alwaysShowToolsĻôֻڸʱеtoolsŻʾ
                        $nodeTr.hover(function () {
                                $(this).find('div').show();
                            }, function () {
                                $(this).find('div').hide();
                            }
                        );
                    }
                } else {
                    //ӸTD
                    $("<td/>").appendTo($nodeTr);
                }
                if (opts.itemHoverCls) {
                    $nodeTr.hover(function () {
                        $(this).addClass(opts.itemHoverCls);
                    }, function () {
                        $(this).removeClass(opts.itemHoverCls);
                    });
                }
                //ֵĳ
                if (!opts.hasXScroll) {
                    var lineWidth = opts.width ? opts.width : self.element.width();
                    var width = lineWidth - (treeNode.level + 1) * 20;
                    var toolWidth = 0;
                    if (opts.tools && opts.tools.length > 0) {
                        toolWidth = opts.tools.length * (16 + self.options.toolMargin);
                    }
                    var scrollLength = 16;
                    if($.browser.msie) {
                    	scrollLength = 20;
                    }
                    $nodeTr.find('a').css({width: width - toolWidth - self.options.scrollWidth - scrollLength});
                }
            };
            var setting = {
                view: {
                    selectedMulti: false //Ĭϲɶѡ
                },
                callback: {
                    onNodeCreated: TreeOnNodeCreated
                }
            };
            //еzTreeAPIsetting.callback.onNodeCreatedʹ⣬Ḳtabletreeĺķ
            //ԼõsettingȥõsettingںϲzTreesettingȥ
            $.extend(true, setting, opts.setting);
            opts.setting = setting;
        },
        onToolDivClick: function(i, e, toolDiv, treeNode, select) {
            var opts = this.options;
            if(opts.toolUnEditAble || $(toolDiv).hasClass(this.options.toolDisableCls)) {
                return;
            }
            var isSelect = false;
            if(select === true) {
                isSelect = true;
                this.selectNodeWithCascade(treeNode, true, i);
            } else if(select === false) {
                this.cancelSelectedNodeWithCascade(treeNode, i);
            } else {
                if(treeNode[treeNode.toolName[i]] === 1) {
                    //ȡѡ
                    this.cancelSelectedNodeWithCascade(treeNode, i);
                } else {
                    isSelect = true;
                    this.selectNodeWithCascade(treeNode, true, i);
                }
            }
            $(toolDiv).data('tool').onToolClick.call(toolDiv, e, treeNode, isSelect);
        },
        hasNodeSelect: function(index) {
            var opts = this.options;
            if(opts.tooltype !== "check") {
                return false;
            }
            var nodes = this.getNodes();
            for(var i = 0, len = nodes.length; i < len; i ++) {
                var node = nodes[i];
                if(node[node.toolName[index]]) {
                    return true;
                }
            }
            return false;
        },
        selectAll: function(index) {
            var opts = this.options;
            if(opts.tooltype !== "check") {
                return ;
            }
            var nodes = this.getNodes();
            for(var i = 0, len = nodes.length; i < len; i ++) {
                this.onToolDivClick(index, new $.Event(), nodes[i].toolDiv[index], nodes[i], true);
            }
        },
        deSelectAll: function(index) {
            var opts = this.options;
            if(opts.tooltype !== "check") {
                return ;
            }
            var nodes = this.getNodes();
            for(var i = 0, len = nodes.length; i < len; i ++) {
                this.onToolDivClick(index, new $.Event(), nodes[i].toolDiv[index], nodes[i], false);
            }
        },
        //¸ӽڵ״̬
        cascade : function(node, isSelected, m) {
        	var children = node[this.childrenKey];
        	if(!children || children.length === 0) {
        		return ;
        	}
    		for(var i = 0; i < children.length; i ++) {
    			var  child = children[i];
    			if(isSelected) {
        			this.selectNode(child, true, m);	
        		} else {
    				this.cancelSelectedNode(child, m);
    			}
    			this.cascade(children[i], isSelected, m);
    		}
	    },
	    //ϸ¸ڵ״̬
	    bubble : function(node, isSelected, m) {
	    	if(!node) {
	    		return;
	    	}
	    	var parent = node.getParentNode();
	    	if(!parent) {
	    		return ;
	    	}
	    	if(isSelected) {
	    		//ӽڵ㱻ѡУжϸڵǷҪȫѡ
	    		var children = parent[this.childrenKey];
	    		var isAllChoose = true;
	    		for(var i = 0; i < children.length; i ++) {
	    			var child = children[i];
	    			if(child[child.toolName[m]] !== 1) {
	    				//һûȫѡǰѡ״̬
	    				isAllChoose = false;
	    				break ;
	    			}
	    		}
	    		if(!isAllChoose) {
	    			//иҪѡ
	    			while(parent) {
	    				this.selectNode(parent, true, m);
                        parent[parent.toolName[m]] = 2;
	    				parent.toolDiv[m].addClass("fs_tool_checkhalf");
	    				parent = parent.getParentNode();
	    			}
	    		} else {
	    			this.selectNode(parent, true, m);	
	    			this.bubble(parent, true, m);
	    		}
	    	} else {
	    		//ӽڵȡѡУжϸڵǷҪ䲻ѡ
	    		var children = parent[this.childrenKey];
	    		var isAllUnChoose = true;
	    		for(var i = 0; i < children.length; i ++) {
	    			var child = children[i];
	    			if(child[child.toolName[m]]) {
	    				//һǲѡǰѡ״̬
	    				isAllUnChoose = false;
	    				break ;
	    			}
	    		}
	    		if(!isAllUnChoose) {
	    			//иҪѡ
	    			while(parent) {
	    				this.selectNode(parent, true, m);
                        parent[parent.toolName[m]] = 2;
	    				parent.toolDiv[m].addClass("fs_tool_checkhalf");
	    				parent = parent.getParentNode();
	    			}
	    		} else {
	    			this.cancelSelectedNode(parent, m);
	    			this.bubble(parent, false, m);
	    		}
	    	}
	    },
        /**
         * TableTree API
         * */
        //ȡ
        getTreeObj: function () {
            var treeID = this.options.treeID;
            return $.fn.zTree.getZTreeObj(treeID);
        },
        //nodeIDȡڵJSON
        getNodeById: function (nodeID) {
            return this.getTreeObj().getNodeByTId(nodeID);
        },
        //ȡѡеĽڵ ֵΪArray(JSON)
        getSelectedNodes: function () {
            return this.getTreeObj().getSelectedNodes();
        },
        //ѡȫѡ״̬Ľڵ
        getFullSelectedNodes: function () {
            var selectedNodes = this.getSelectedNodes();
            if (this.options.tooltype === "check" && this.options.tools.length === 1) {
                var result = [];
                $.each(selectedNodes, function(idx, node){
                    if (!node.toolDiv[0].hasClass("fs_tool_checkhalf")
                            && node.toolDiv[0].hasClass("fs_tool_checkon")) {
                        result.push(node);
                    }
                });
                return result;
            } else {
                return selectedNodes;
            }
        },
        //nodeIDؽڵ
        getNodeNameById: function (nodeID) {
            return this.getNodeById(nodeID).name;
        },
        //ɾѡнڵ
        removeSelectedNodes: function () {
            var tree = this.getTreeObj();
            var selectedNodes = tree.getSelectedNodes();
            for (var i = 0; i < selectedNodes.length; i++) {
                tree.removeNode(selectedNodes[i], false);
            }
        },
        //ɾڵ
        removeNode : function(node) {
        	var tree = this.getTreeObj();
        	tree.removeNode(node, false);
        },
        //ӽڵ
        addNodes: function (parentNode, nodes, isSilent) {
            var tree = this.getTreeObj();
            var xnodes = FR.isArray(nodes) ? nodes : [nodes];
            return tree.addNodes(parentNode, xnodes, isSilent);
        },
        //wei:ֻһڵ㣬޸ztreeһʾ
        addSingleNode : function(parentNode, node, isSilent) {
        	var xnodes = FR.isArray(node) ? node : [node];
        	if(xnodes.length > 1) {
        		throw("wrong way to use this method,function addSingleNode can only add one node!");
        	}
        	var addedNode = this.addNodes(parentNode, xnodes, isSilent)[0];
        	var addNodeTR = $("tr[id="+addedNode.tId+"]", this.element);
        	var preNode = addedNode.getPreNode();
        	if(preNode && preNode.open && preNode[this.childrenKey] && preNode[this.childrenKey].length > 0) {
        		//ztreeaddNodesǰһڵ֮ǰһһһչӽڵĻµĽڵֱӼpreNodeĺ֮䣬Ӿԡ
        		var currentLevel = preNode.level;
        		var tr = $("tr[id="+addedNode.tId+"]", this.element);
        		//ңһֱҵڵlevelcurrentLevel߲ͬ
        		while(tr.next().length > 0) {
        			tr = tr.next();
        			var nextNode = this.getNodeById(tr.attr("id"));
        			if(nextNode.level <= currentLevel) {
        				//Ҫ嵽trǰ
        				tr.before(addNodeTR);
        				return addedNode;
        			}
        		}
        		//ѾĽ˵addedNodeӦñŵĽβ嵽tr
        		tr.after(addNodeTR);
        	}
        	return addedNode;
        },
        //½ڵ
        updateNode: function (node) {
            var tree = this.getTreeObj();
            tree.updateNode(node);
        },
        //ѡнڵ
        selectNode: function (node, addFlag, i) {
            var tree = this.getTreeObj();
            tree.selectNode(node, addFlag);
            if(this.options.tooltype === "check") {
            	node[node.toolName[i]] = 1;	
    			node.toolDiv[i].removeClass("fs_tool_checkhalf");
    			node.toolDiv[i].addClass("fs_tool_checkon");
            }
        },
        //ѡ
        selectNodeWithCascade: function (node, addFlag, i) {
            this.selectNode(node, addFlag, i);
//            for(var i = 0; i < this.options.tools.length; i ++) {
//            	var toolName = this.options.tools.name;
//            	if(data[toolName])
//            }
    		this.cascade(node, true, i);
    		this.bubble(node, true, i);
        },
        //ѡнڵ
        selectNodesByData : function(data) {
        	var tree = this.getTreeObj();
        	var nodes = tree.transformToArray(tree.getNodes());
        	for(var m = 0; m < data.length; m ++) {
        		for(var i = 0; i < nodes.length; i ++) {
        			if(data[m].id === nodes[i].id) {
        				for(var n = 0; n < this.options.tools.length; n ++) {
        					if(data[m][this.options.tools[n].name] === 1) {
        						this.selectNodeWithCascade(nodes[i], true, n);
        					}
        				}
        				break ;
        			}
        		}
        	}
        },

        getNodeByNodeID : function(id) {
            var tree = this.getTreeObj();
            var nodes = tree.transformToArray(tree.getNodes());
            for(var i = 0; i < nodes.length; i ++) {
                if(id === nodes[i].id) {
                    return nodes[i];
                }
            }
        },

        //Pathѡнڵ
        selectNodesByPath : function(data) {
            var tree = this.getTreeObj();
            var nodes = tree.transformToArray(tree.getNodes());
            for(var m = 0; m < data.length; m ++) {
                for(var i = 0; i < nodes.length; i ++) {
                    if(data[m].path === nodes[i].path) {
                        for(var n = 0; n < this.options.tools.length; n ++) {
                            if(data[m][this.options.tools[n].name] === 1) {
                                this.selectNodeWithCascade(nodes[i], true, n);
                            }
                        }
                        break ;
                    }
                }
            }
        },

        getNodeByPath : function(path) {
            var tree = this.getTreeObj();
            var nodes = tree.transformToArray(tree.getNodes());
            for(var i = 0; i < nodes.length; i ++) {
                if(path == nodes[i].path) {
                    return nodes[i];
                }
            }
        },

        //ȡѡеĽڵ
        cancelSelectedNode: function(node, i) {
        	var tree = this.getTreeObj();
        	var needCancel = true;
        	for(var m = 0; m < this.options.tools.length; m ++) {
        		if(i === m) {
        			continue;
        		}
        		if(node[this.options.tools[m].name]) {
        			needCancel = false;
        		}
        	}
        	if(needCancel) {
        		tree.cancelSelectedNode(node);	
        	}
            if(this.options.tooltype === "check") {
            	//ܻûcreate
            	if(node.toolName) {
            		node[node.toolName[i]] = 0;	
        			node.toolDiv[i].removeClass("fs_tool_checkhalf");
        			node.toolDiv[i].removeClass("fs_tool_checkon");
            	}
            }
        },
        //ȡ
        cancelSelectedNodeWithCascade: function(node, i) {
        	this.cancelSelectedNode(node, i);
        	this.cascade(node, false, i);
    		this.bubble(node, false, i);
        },
        //ȡѡ
        clearState: function() {
        	var nodes = this.getSelectedNodes();
        	for(var i = 0; i < nodes.length; i ++) {
        		for(var m = 0; m < this.options.tools.length; m ++) {
            		this.cancelSelectedNode(nodes[i], m);	
        		}
        	}
        },
        getAllSelectedLeafNodes:function() {
        	var result = [];
        	var nodes = this.getSelectedNodes();
        	for(var i = 0, len = nodes.length; i < len; i ++) {
        		if(!nodes[i].isParent) {
        			result.push(nodes[i]);
        		}
        	}
        	return result;
        },
        //ȡнڵ
        getNodes: function() {
        	var tree = this.getTreeObj();
            return tree.getNodes();
        },
        //childrenתΪ
        transformToArray:function(nodes) {
        	var tree = this.getTreeObj();
            return tree.transformToArray(nodes);
        },
        //չ/ڵ
        expandNode:function(node, expandFlag, sonSign, focus, callbackFlag) {
        	var tree = this.getTreeObj();
        	tree.expandNode(node, expandFlag, sonSign, focus, callbackFlag);
        },
        //ڵ
        getNodesByFilter:function(setting, nodes, filter, isSingle, invokeParam) {
        	var tree = this.getTreeObj();
        	return tree.getNodesByFilter(setting, nodes, filter, isSingle, invokeParam);
        }
    });
    $.shortcut('fstabletree', FS.TableTree);
})(jQuery);
