/**
 * Coder: Sean
 * Date: 14-4-14
 * Time: 6:21
 */
FS.USERMGR = {
    init: function (renderer) {
        var self = this;
        FR.$defaultImport('/com/fr/fs/web/css/manager/fs_usermgr.css', 'css');
        this.preLoadData();
        if(!FS.isGradeAuthorityOpen() || (FS.config.isAdmin == 'true')){
            //ûп༶Ȩ޷ǹԱ¼ʱ,ʹ塣
            this.createSetPane(renderer);
        }
        var items = [
            this.userModule(),
            this.institutionModule()
        ];
        this.mainPane = renderer;
        this.user = new FS.LTabPane({
            width: '100%',
            height: '100%',
            style: 'blue',
            top: 15,
            left: 20,
            marginLeft: 40,
            items: items,
            renderEl: renderer
        })
    },
    /**
     * ûҳԤ
     */
    preLoadData: function(){
        var self = this;
        //ȡû֤ʽ
        this.loginAuthenticateType = FS.Trans.ajax({
            url: FR.servletURL + "?op=fs_load&cmd=loginAuthenticateType",
            returnString: true
        });
        //ȡݼͬݼϢ
        FR.ajax({
            url: FR.servletURL + '?op=fs_manager&cmd=fs_get_syncdatainfo',
            type: 'POST',
            async : false,
            complete : function(res, status) {
                self.syncdata = FR.jsonDecode(res.responseText);
            }
        });
        //Ƿͬݼ 0:hsql,1:ͬݼ
        var state = FS.Trans.getTableDataSyncState();
        this.isSyncOn = (state.type === 1);
    },
    /**
     * жǷLDAP֤
     * @returns {boolean} ǷLDAP֤
     */
    isAuthLdap: function(){
        if(this.loginAuthenticateType == 'ldap'){
            return true;
        }else{
            return false;
        }
    },
    /**
     * жǷƽ̨֤ʽ
     * @returns {boolean}
     */
    isAuthDefault: function(){
        if(this.loginAuthenticateType == 'default'){
            return true;
        }else{
            return false;
        }
    },
    /**
     * 
     * @param anchor ̶dom
     */
    createSetPane: function (anchor) {
        var self = this;
        var $line = $('<div class="fs-usermgr-line"/>');
        var floatPane = FR.createWidget({
            type: 'floatpane',
            anchor: anchor,
            contentHieght: 350,
            isDefaultShow: false,
            contentWidget: {
                type: 'confirm',
                fit: true,
                doSize: true,
                closeAfterAction: false,
                btnsAlignment: 'left',
                needSeparate: 8,
                onOK: function () {
                    var isSaveSuccess = true;
                    //Sean: ȫͬ˳УΪͬݼҪжLDAP
                    //û֤ʽñ
                    var authtype = floatPane.getWidgetByName("authModeRadioGroup").getValue();
                    switch (authtype){
                        case 0: authtype = "default";break;
                        case 1: authtype = "ldap";break;
                        default : authtype = "http";break;
                    }
                    FR.ajax({
                        url : FR.servletURL + "?op=fs_load&cmd=installLoginAuthenticateType",
                        data : { loginAuthenticateType : authtype},
                        async: false,
                        complete: function(res, status){
                            if(status == 'success'){
                                var re = FR.jsonDecode(res.responseText);
                                isSaveSuccess = re.success && isSaveSuccess;
                                if (isSaveSuccess) {
                                    var result = self.saveAuthConfig(authtype, floatPane);
                                    isSaveSuccess = result.success && isSaveSuccess;
                                }
                            }
                        }
                    });
                    //ͬݼñ
                    var syncOn = floatPane.getWidgetByName("syncOpenSwitch").getValue();
                    if(syncOn){
                        var data = self.getDSWidgetData(floatPane);
                        var syncRes = FS.Trans.saveTableDataSync(data);
                        isSaveSuccess = syncRes.success && isSaveSuccess;
                    }else{
                        var result = FS.Trans.closeTableDataSync();
                        isSaveSuccess = result.success && isSaveSuccess;
                    }
                    if(isSaveSuccess){
                        FS.userPane.signOut();
                    }else{
                        FR.Msg.toast(FR.i18nText("Failed"));
                    }
                },
                onCancel: function () {
                    self.popAuthSetData(floatPane);
                    self.popSyncSetData(floatPane);
                    floatPane.doSlide();
                },
                contentWidget: {
                    type: 'tablelayout',
                    scrolly: true,
                    widgetName: 'SETTABLE',
                    columnSize: [20, 110, 450],
                    rowSize: [0, 21, 230, 21, 25, 170, 5],
                    vgap: 15,
                    items: [
                        [
                            null,null,{el:$('<div/>')}
                        ],
                        [
                            //û֤ʽ
                            null,
                            {el: {type: 'llabel', value: FR.i18nText("Authentication")}},
                            {el: {
                                type: 'radiogroup',
                                columnsInRow: 3,
                                widgetName: 'authModeRadioGroup',
                                width: 300,
                                value: 0,
                                items: [
                                    {value: 0, text: FR.i18nText("Platform_Built-in_Authentification")},
                                    {value: 1, text: FR.i18nText("LDAP_Authentification")},
                                    {value: 2, text: FR.i18nText("Http_Authentification")}
                                ],
                                listeners: [
                                    {eventName: FR.Events.AFTEREDIT,
                                        action: function () {
                                            var value = this.getValue();
                                            if (value === 0) {
                                                floatPane.getWidgetByName("SETTABLE").setRowVisible([2, 3], false);
                                            } else if (value === 1) {
                                                floatPane.getWidgetByName("SETTABLE").setRowVisible(2, true);
                                                floatPane.getWidgetByName("SETTABLE").setRowVisible(3, false);
                                            } else if (value === 2){
                                                floatPane.getWidgetByName("SETTABLE").setRowVisible(2, false);
                                                floatPane.getWidgetByName("SETTABLE").setRowVisible(3, true);
                                            }
                                            floatPane.getWidgetByName("SETTABLE").doLayout();
                                        }
                                    }
                                ]
                            }}
                        ],
                        [
                            null,
                            null,
                            {el: {
                                widgetName: 'LDAPSETTABLE',
                                type: 'tablelayout',
                                rowSize: [21, 21, 21, 21, 21, 21, 21, 21],
                                columnSize: [110, 210],
                                vgap: 8,
                                items: [
                                    [
                                        {el: {type: 'llabel', value: '*URL'}},
                                        {el: {type: 'text', widgetName: 'urlCombo', watermark: FR.i18nText("Example") + ':ldap://192.168.106.201:389'}}
                                    ],
                                    [
                                        {el: {type: 'llabel', value: FR.i18nText("Retrieve_Location")}},
                                        {el: {type: 'text', widgetName: 'locationText', watermark: FR.i18nText("Example") + ':DC=finereport'}}
                                    ],
                                    [
                                        {el: {type: 'llabel', value: '*' + FR.i18nText("Authentication")}},
                                        {el: {type: 'combo', widgetName: 'authmodCombo',
                                            items: [
                                                {
                                                    'text': 'simple',
                                                    'value': 1
                                                },
                                                {
                                                    'text': 'strong',
                                                    'value': 2
                                                },
                                                {
                                                    'text': 'none',
                                                    'value': 3
                                                }
                                            ]
                                        }}
                                    ],
                                    [
                                        {el: {type: 'llabel', value: '*' + FR.i18nText("Context")}},
                                        {el: {type: 'combo', widgetName: 'contextCombo', items: [
                                            {
                                                'text': 'com.sun.jndi.ldap.LdapCtxFactory',
                                                'value': 1
                                            },
                                            {
                                                'text': 'com.sun.jndi.ldap.connect.pool',
                                                'value': 2
                                            }
                                        ]
                                        }}
                                    ],
                                    [
                                        {el: {type: 'llabel', value: '*' + FR.i18nText("Referral")}},
                                        {el: {type: 'combo', widgetName: 'ReferralCombo',
                                            items: [
                                                {
                                                    'text': 'follow',
                                                    'value': 1
                                                },
                                                {
                                                    'text': 'ignore',
                                                    'value': 2
                                                },
                                                {
                                                    'text': 'throw',
                                                    'value': 3
                                                }
                                            ]
                                        }}
                                    ],
                                    [
                                        {el: {type: 'llabel', value: FR.i18nText("Username_Suffix")}},
                                        {el: {type: 'text', widgetName: 'suffixText', watermark: FR.i18nText("Example") + ':@finereport.com'}}
                                    ],
                                    [
                                        {el: {type: 'llabel', value: FR.i18nText("Admin_Name")}},
                                        {el: {type: 'text', widgetName: 'adminnameText'}}
                                    ],
                                    [
                                        {el: {type: 'llabel', value: FR.i18nText("Admin_Password")}},
                                        {el: {type: 'text', widgetName: 'adminpwdText', passwordText: true}}
                                    ]
                                ]
                            }}
                        ],
                        [null,null,{el:{type:'text',widgetName:'httpurlText',watermark:'Example: http://localhost/saa'}}],
                        [
                            null,
                            {el: {type: 'llabel', value: FR.i18nText("User_Synchronized_DataSet")}},
                            {el: {
                                type: 'switch',
                                widgetName: 'syncOpenSwitch',
                                onTurnOff: function(){
                                    //رͬݼ
                                    floatPane.getWidgetByName("SETTABLE").setRowVisible(5, false);
                                    floatPane.getWidgetByName("SETTABLE").doLayout();
                                },
                                onTurnOn: function(){
                                    //ͬݼ
                                    floatPane.getWidgetByName("SETTABLE").setRowVisible(5, true);
                                    floatPane.getWidgetByName("SETTABLE").doLayout();
                                }
                            }}
                        ],
                        [
                            null,
                            null,
                            {el:{
                                type: 'border',
                                items: [
                                    {
                                        region: 'west',
                                        width: 240,
                                        el: {
                                            type: 'tablelayout',
                                            widgetName: 'userAuthTablelayout',
                                            columnSize: [100, 110],
                                            rowSize: [21,21,21,21,21,21],
                                            vgap: 8,
                                            items: [
                                                [
                                                    {el: {type: 'llabel', value: FR.i18nText("DS-Server_TableData")}},
                                                    {el: self.getTableDataComboCfg()}
                                                ],
                                                [
                                                    {el: {type: 'llabel', value: FR.i18nText("Username")}},
                                                    {el: {type: 'combo' ,widgetName:'usernameCombo', items:[]}}
                                                ],
                                                [
                                                    {el: {type: 'llabel', value: FR.i18nText("FULLNAME")}},
                                                    {el: {type: 'combo' ,widgetName:'fullnameCombo', items:[]}}
                                                ],
                                                [
                                                    {el: {type: 'llabel', value: FR.i18nText("Password")}},
                                                    {el: {type: 'combo' ,widgetName:'passwordCombo', items:[]}}
                                                ],
                                                [
                                                    {el: {type: 'llabel', value: FR.i18nText("Encryption_Mode")}},
                                                    {el: self.createEncrypComboCfg()}
                                                ],
                                                [
                                                    null,
                                                    {el: {type: 'text' ,widgetName:'customEncrypText'}}
                                                ]
                                            ]
                                        }
                                    },
                                    {
                                        region: 'center',
                                        el: $('<div/>').append($line)
                                    },
                                    {
                                        region: 'east',
                                        width: 180,
                                        el: {
                                            type: 'tablelayout',
                                            columnSize: [60, 110],
                                            rowSize: [21,21,21,21,21],
                                            vgap: 8,
                                            items: [
                                                [
                                                    {el: {type: 'llabel', value: FR.i18nText("Department")}},
                                                    {el: {type: 'combo' ,widgetName:'departmentCombo', items:[]}}
                                                ],
                                                [
                                                    {el: {type: 'llabel', value: FR.i18nText("User_Position")}},
                                                    {el: {type: 'combo' ,widgetName:'positionCombo', items:[]}}
                                                ],
                                                [
                                                    {el: {type: 'llabel', value: FR.i18nText("Role")}},
                                                    {el: {type: 'combo' ,widgetName:'roleCombo', items:[]}}
                                                ],
                                                [
                                                    {el: {type: 'llabel', value: FR.i18nText("email")}},
                                                    {el: {type: 'combo' ,widgetName:'emailCombo', items:[]}}
                                                ],
                                                [
                                                    {el: {type: 'llabel', value: FR.i18nText("MobilePhone")}},
                                                    {el: {type: 'combo' ,widgetName:'mobilephoneCombo', items:[]}}
                                                ]
                                            ]

                                        }
                                    }
                                ]
                            }}
                        ],
                        [null,null,{el: $('<div/>')}]
                    ]
                }
            }
        });
        this.popAuthSetData(floatPane);
        this.popSyncSetData(floatPane);
        floatPane.getWidgetByName("SETTABLE").doLayout();
        floatPane.doHide();
    },

    popAuthSetData: function(pw){
        if(this.isAuthDefault()){
            pw.getWidgetByName('authModeRadioGroup').setValue(0, true);
        }else if(this.isAuthLdap()){
            var ldapAttrs = FR.jsonDecode(FS.Trans.getLdapAttrs());
            pw.getWidgetByName('authModeRadioGroup').setValue(1, true);
            pw.getWidgetByName('urlCombo').setValue(ldapAttrs.ldapUrl);
            pw.getWidgetByName('locationText').setValue(ldapAttrs.ldapSearchBase);
            pw.getWidgetByName('authmodCombo').setValue(ldapAttrs.authentication);
            pw.getWidgetByName('contextCombo').setValue(ldapAttrs.contextFactory);
            pw.getWidgetByName('ReferralCombo').setValue(ldapAttrs.referral);
            pw.getWidgetByName('suffixText').setValue(ldapAttrs.principalSuffix);
            pw.getWidgetByName('adminnameText').setValue(ldapAttrs.ldapSystemName);
            pw.getWidgetByName('adminpwdText').setValue(ldapAttrs.ldapSystemPassword);
        }else{
            pw.getWidgetByName('authModeRadioGroup').setValue(2, true);
            FR.ajax({
                url: FR.servletURL+"?op=fs_set&cmd=sc_http_get",
                complete: function(res, status){
                    if(status == 'success'){
                        var http = FR.jsonDecode(res.responseText);
                        if(http.url){
                            pw.getWidgetByName('httpurlText').setValue(http.url);
                        }
                    }
                }
            });
        }
    },
    /**
     * 
     * @param pw 
     */
    popSyncSetData: function(pw){
        //ͬݼݡ
        var syncdata = this.syncdata;
        pw.getWidgetByName("userAuthTablelayout").setRowVisible(5,false);
        if(this.isSyncOn){
            pw.getWidgetByName("syncOpenSwitch").setValue(true, true);
        }else{
            pw.getWidgetByName("syncOpenSwitch").setValue(false, true);
        }
        if(syncdata.dsName){
            pw.getWidgetByName("tableDataCombo").setValue(syncdata.dsName);
            this.rebuildDSWidgets(syncdata.dsName, pw);
            if (syncdata.userName > -1) {
                pw.getWidgetByName("usernameCombo").setValue(syncdata.userName);
            }
            if (syncdata.password > -1) {
                pw.getWidgetByName("passwordCombo").setValue(syncdata.password);
            }
            if (syncdata.name > -1) {
                pw.getWidgetByName("fullnameCombo").setValue(syncdata.name);
            }
            if (syncdata.department > -1) {
                pw.getWidgetByName("departmentCombo").setValue(syncdata.department);
            }
            if (syncdata.post > -1) {
                pw.getWidgetByName("positionCombo").setValue(syncdata.post);
            }
            if (syncdata.role > -1) {
                pw.getWidgetByName("roleCombo").setValue(syncdata.role);
            }
            if (syncdata.email > -1) {
                pw.getWidgetByName("emailCombo").setValue(syncdata.email);
            }
            if (syncdata.mobile > -1) {
                pw.getWidgetByName("mobilephoneCombo").setValue(syncdata.mobile);
            }
            this.popEncryptSet(pw, syncdata);
        }
    },

    popEncryptSet: function(pw, syncdata){
        if (syncdata.encrypt > -1) {
            pw.getWidgetByName("encryptionCombo").setValue(syncdata.encrypt, true);
        }
        if (syncdata.encrypt === 1) {
            pw.getWidgetByName("customEncrypText").setValue(syncdata.myencrypt);
        }
    },
    /**
     * ֤ʽ
     * @param {String} type û֤ʽ
     * @param {FR.Widget} pw 
     */
    saveAuthConfig: function(type, pw){
        var result = {success: true};
        if(type == "ldap") {
            result = FS.Trans.ajax({
                url : FR.servletURL + "?op=fs_load&cmd=installLdapAttrs",
                data : {
                    loginLdapUrl: pw.getWidgetByName('urlCombo').getValue(),
                    ldapSearchBase: pw.getWidgetByName('locationText').getValue(),
                    referral: pw.getWidgetByName('ReferralCombo').getText(),
                    authentication: pw.getWidgetByName('authmodCombo').getText(),
                    contextFactory: pw.getWidgetByName('contextCombo').getText(),
                    ldapPrincipalSuffix: pw.getWidgetByName('suffixText').getValue(),
                    ldapSystemName: pw.getWidgetByName('adminnameText').getText(),
                    ldapSystemPassword: pw.getWidgetByName('adminpwdText').getText()
                }
            });
        }else if(type == 'http'){
            result = FS.Trans.ajax({
                url : FR.servletURL + "?op=fs_set&cmd=sc_http_set",
                data : {
                    httpurl: pw.getWidgetByName('httpurlText').getValue()
                }
            });
        }
        return result;
    },
    /************û*************/
    userModule: function(){
        var self = this;
        var rowSize = [28, 'auto'];
        var items = [
            self.createHeaderControl(),
            [self.createUserGridCfg(),null,null,null,null,null]
        ];
        var config = {
            title: FR.i18nText("User_Management"),
            content: {
                type: 'panel',
                width: 710,
                height: 400,
                doSize: true,
                contentWidget: {
                    type: 'tablepane',
                    colSize: ['auto',60,60,60,240,214],
                    rowSize: rowSize,
                    vgap: 15,
                    marginLeft: 10,
                    marginRight: 10,
                    items: items
                }
            }
        };
        return config;
    },

    createHeaderControl: function () {
        var self = this;
        var header = [
            {
                type:'search',
                widgetName : 'searchUser',
                onSearch:function() {
                    var value = this.getValue();
                    var usergrid = self.user.getWidgetByName("USERINFOGRID");
                    var data = usergrid.options.async.data;
                    data.startIdx = 0;
                    data.keyword = value;
                    usergrid.activedPage = 1;
                    usergrid.refresh();
                }
            }
        ];
        //δͬݼûӡ롢ɾ
        if (!self.isSyncOn) {
            header.unshift(
                null, {
                    type: 'iconbutton',
                    text: FR.i18nText("add"),
                    baseClass: 'fs-usermgr-add',
                    handler: function () {
                        var addUserDialog = new FR.Dialog({
                            title: FR.i18nText("Add_User"),
                            text4OK: FR.i18nText("OK"),
                            text4Cancel: FR.i18nText("Cancel"),
                            onOK: function () {
                                //ûdialogȷť¼
                                var userTable = self.user.getWidgetByName("USERINFOGRID");
                                var userName = addUserDialog.getWidgetByName("USERNAMETEXT").getValue();
                                var realName = addUserDialog.getWidgetByName("FULLNAMETEXT").getValue();
                                var password = !self.isAuthDefault() ? "123456" : addUserDialog.getWidgetByName("PASSWORDTEXT").getValue();
                                if (!self.checkUserValid(userName, realName, password)) {
                                    return false;
                                }
                                var user = {
                                    username: userName,
                                    realname: realName,
                                    password: password,
                                    email: addUserDialog.getWidgetByName("EMAILTEXT").getValue(),
                                    mobile: addUserDialog.getWidgetByName("PHONETEXT").getValue()
                                };
                                var result = FS.Trans.addUser(user);
                                if (!result.success) {
                                    FR.Msg.alert(FR.Msg.Alert, FR.i18nText("Add_User_Failure"));
                                    return false;
                                }
                                userTable.refresh();
                            },
                            onCancel: function () {
                            },
                            destroyOnClose: true,
                            animate: false,
                            width: 355,
                            height: 250,
                            confirm: true,
                            border: true,
                            closable: true,
                            contentWidget: {
                                type: 'tablelayout',
                                columnSize: [92, 16, 180],
                                rowSize: [0, 21, 21, 21, 21, 21, 21],
                                vgap: 10,
                                items: [
                                    [
                                        {el: $('<div/>')}
                                    ],
                                    [
                                        {el: {type: 'llabel', textalign: 'right', value: FR.i18nText("Username")}},
                                        null,
                                        {el: {type: 'text', widgetName: 'USERNAMETEXT'}}
                                    ],
                                    [
                                        {el: {type: 'llabel', textalign: 'right', value: FR.i18nText("FULLNAME")}},
                                        null,
                                        {el: {type: 'text', widgetName: 'FULLNAMETEXT'}}
                                    ],
                                    !self.isAuthDefault() ? [] :
                                        [
                                            {el: {type: 'llabel', textalign: 'right', value: FR.i18nText("Password")}},
                                            null,
                                            {el: {type: 'text', widgetName: 'PASSWORDTEXT', passwordText: true}}
                                        ],
                                    [
                                        {el: {type: 'llabel', textalign: 'right', value: FR.i18nText("email")}},
                                        null,
                                        {el: {type: 'text', widgetName: 'EMAILTEXT'}}
                                    ],
                                    [
                                        {el: {type: 'llabel', textalign: 'right', value: FR.i18nText("MobilePhone")}},
                                        null,
                                        {el: {type: 'text', widgetName: 'PHONETEXT'}}
                                    ]
                                ]
                            }
                        });
                        addUserDialog.setVisible(true);
                    }
                }, {
                    type: 'iconbutton',
                    text: FR.i18nText("Import2"),
                    baseClass: 'fs-usermgr-import',
                    handler: function () {
                        var dialog = self.createUserImportDialog();
                        dialog.setVisible(true);
                    }
                }, {
                    type: 'iconbutton',
                    text: FR.i18nText("Delete"),
                    baseClass: 'fs-usermgr-delete-blue',
                    handler: function () {
                        FR.Msg.confirm(FR.i18nText("Delete_User"), FR.i18nText("sure_to_delete") + "?", function (result) {
                            if (result) {
                                var usrgrid = self.user.getWidgetByName("USERINFOGRID");
                                var selectedData = usrgrid.getSelectedData();
                                var duserids = [];
                                for (var i = 0, len = selectedData.length; i < len; i++) {
                                    duserids.push(selectedData[i].id);
                                }
                                FS.Trans.removeUser(duserids.join(","));
                                usrgrid.refresh();
                            }
                        });
                    }
                }, {}
            )
        } else {
            header.unshift(
                null, {}, {}, {}, {}
            )
        }
        return header;
    },

    /**
     * ûϢбؼϢ
     * @returns {JSON} Ϣ
     */
    createUserGridCfg: function(){
        var self = this;
        var colcfg = [
            {
                key: 'username',
                value: FR.i18nText("Username"),
                width: 100
            },
            {
                key: 'realname',
                value: FR.i18nText("FULLNAME"),
                width: 100
            },
            {
                key: 'depart',
                value: FR.i18nText("Department_Position"),
                width: 120
            },
            {
                key: 'role',
                value: FR.i18nText("Role"),
                width: 100
            },
            {
                key: 'email',
                value: FR.i18nText("email"),
                width: 95
            },
            {
                key: 'mobile',
                value: FR.i18nText("MobilePhone"),
                width: 95
            }
        ];
        if(!this.isSyncOn){
            colcfg.push({
                width: 24,
                onCellCreate: function (rowIdx, colIdx, item, colCfg) {
                    var usrgrid = this;
                    var editBtn = new FR.IconButton({
                        width: 24,
                        height: 24,
                        imgsrc: 'fs-module-edit-white',
                        handler: function () {
                            var okCallback = function () {
                                //༭ûdialogȷť¼
                                var username = editUserDialog.getWidgetByName("USERNAMETEXT").getValue();
                                var realname = editUserDialog.getWidgetByName("FULLNAMETEXT").getValue();
                                var user = {
                                    username: username,
                                    realname: realname,
                                    email: editUserDialog.getWidgetByName("EMAILTEXT").getValue(),
                                    mobile: editUserDialog.getWidgetByName("PHONETEXT").getValue(),
                                    id: item.id
                                };
                                if (!self.checkUserValid(username, realname, true)) {
                                    return false;
                                }
                                var result = FS.Trans.addUser(user);
                                if (!result.success) {
                                    FR.Msg.toast(FR.i18nText("Failed"));
                                    return false;
                                }
                                usrgrid.refresh();
                            };
                            var editUserDialog = new FR.Dialog({
                                title: FR.i18nText("Edit_User"),
                                text4OK: FR.i18nText("OK"),
                                text4Cancel: FR.i18nText("Cancel"),
                                onOK: function () {
                                    return okCallback.apply(this);
                                },
                                onCancel: function () {
                                },
                                destroyOnClose: true,
                                width: 355,
                                height: 250,
                                confirm: true,
                                border: true,
                                contentWidget: {
                                    type: 'tablelayout',
                                    columnSize: [92, 16, 180],
                                    rowSize: [0, 21, 21, 24, 21, 21, 21],
                                    vgap: 10,
                                    items: [
                                        [
                                            {el: $('<div/>')}
                                        ],
                                        [
                                            {el: {type: 'llabel', textalign: 'right', value: FR.i18nText("Username")}},
                                            null,
                                            {el: {type: 'text', widgetName: 'USERNAMETEXT'}}
                                        ],
                                        [
                                            {el: {type: 'llabel', textalign: 'right', value: FR.i18nText("FULLNAME")}},
                                            null,
                                            {el: {type: 'text', widgetName: 'FULLNAMETEXT'}}
                                        ],
                                        !self.isAuthDefault() ? [] :
                                            [
                                                {el: {type: 'llabel', textalign: 'right', value: FR.i18nText("Reset_Password")}},
                                                null,
                                                {el: {type: 'iconbutton',
                                                    widgetName: 'PASSWORDRESET',
                                                    text: FR.i18nText("User_Reset_Password"),
                                                    imgsrc: 'fs-usermgr-pwd',
                                                    handler: function () {
                                                        //밴ť¼
                                                        item.password = "123456";
                                                        var result = FS.Trans.addUser(item);
                                                        if(!result.success){
                                                            FR.Msg.toast(FR.i18nText("Failed"));
                                                            return false;
                                                        }
                                                        this.setEnable(false);
                                                        this.element.addClass('fs-usermgr-pwd-done').text(FR.i18nText("User_Password_Reseted"));
                                                    }
                                                }}
                                            ],
                                        [
                                            {el: {type: 'llabel', textalign: 'right', value: FR.i18nText("email")}},
                                            null,
                                            {el: {type: 'text', widgetName: 'EMAILTEXT'}}
                                        ],
                                        [
                                            {el: {type: 'llabel', textalign: 'right', value: FR.i18nText("MobilePhone")}},
                                            null,
                                            {el: {type: 'text', widgetName: 'PHONETEXT'}}
                                        ]
                                    ]
                                }
                            });
                            editUserDialog.setVisible(true);
                            editUserDialog.getWidgetByName("USERNAMETEXT").setValue(item.username);
                            editUserDialog.getWidgetByName("FULLNAMETEXT").setValue(item.realname);
                            editUserDialog.getWidgetByName("EMAILTEXT").setValue(item.email);
                            editUserDialog.getWidgetByName("PHONETEXT").setValue(item.mobile);
                        }
                    });
                    return editBtn.element;
                }
            });
            colcfg.push({
                width: 24,
                onCellCreate: function (rowIdx, colIdx, item, colCfg) {
                    var delBtn = new FR.IconButton({
                        width: 24,
                        height: 24,
                        imgsrc: 'fs-module-delete-white',
                        handler: function () {
                            var userTable = self.user.getWidgetByName("USERINFOGRID");
                            //ɾû
                            FR.Msg.confirm(FR.i18nText("Delete_User"), FR.i18nText("sure_to_delete") + "?", function (result) {
                                if (result) {
                                    FS.Trans.removeUser(item.id);
                                    userTable.refresh();
                                }
                            });
                        }
                    });
                    return delBtn.element;
                }
            });
        }
        var cfg = {
            type: 'quickgrid',
            page: true,
            autoPage: false,
            pageCount: 10,
            multiSelect: !self.isSyncOn,
            intervalColor: true,
            marginLeft: 10,
            marginRight: 10,
            widgetName: 'USERINFOGRID',
            async: {
                url: FR.servletURL + "?op=fs_set&cmd=auth_getalluserinfo",
                data: {
                    startIdx: 0,
                    count: 10
                }
            },
            onPageTurn: function(active, count, nav){
                var async = this.options.async;
                async.data.startIdx = (active-1) * count;
                this.refresh();
            },
            onAsyncSuccess: function (res, status) {
                var result = FR.jsonDecode(res);
                this.options.items = result.users;
                this.totalpages = Math.ceil(result.total/10);
            },
            columnsConfig: colcfg
        };
        return cfg;
    },
    /**
     * û룬ͬݼúûݱֶѡ
     * ֻƽ̨֤ʱûֻûźְλͬʱѡͬʱѡ
     * @param username ûֶ
     * @param realname ֶ
     * @param password ֶ
     * @param depart ֶ
     * @param post ְλֶ
     * @returns {boolean} Ƿ
     */
    checkUserValid :function(username, realname, password, depart, post) {
        if(FR.isEmpty(username)) {
            FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("Privilege-User_Can_Not_Be_Null"));
            return false;
        }
        if(FR.isEmpty(realname)){
            FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("Name_Can_Not_Be_Null"));
            return false;
        }
        if(this.isAuthDefault() && FR.isEmpty(password)){
            FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("Privilege-Password_Can_Not_Be_Null"));
            return false;
        }
        if(FR.isEmpty(post)&& !FR.isEmpty(depart) || !FR.isEmpty(post)&& FR.isEmpty(depart)){
            FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("Depart_Post_Together"));
            return false;
        }
        return true;
    },

    /**
     * ûԻ
     */
    createUserImportDialog : function(){
        var self = this;
        var encryptCfg = FS.Trans.ajax({
            url: FR.servletURL+"?op=fs_manager&cmd=gethsqlpv"
        });
        var importDialog = new FR.Dialog({
            title: FR.i18nText("Import2","User"),
            width: 350,
            height: 430,
            confirm: true,
            border: true,
            closable: true,
            contentWidget: self.getUserImportConfig(),
            closeAfterAction: false,
            destroyOnClose: true,
            onOK: function () {
                var data = self.getDSWidgetData(importDialog);
                if(!data){
                    return false;
                }
                self.doImportUsers({res: data});
                importDialog.doClose();
            },
            onCancel: function(){
                this.doClose();
            }
        });
        this.popEncryptSet(importDialog, encryptCfg);
        importDialog.getWidgetByName("userAuthTablelayout").doLayout();
        return importDialog;
    },

    /**
     * ܷʽǷı(û)
     * @param oldEncrypt ɼܷʽ
     * @param newEncrypt ¼ܷʽ
     * @returns {boolean} ؼܷʽǷı
     */
    hasEncryptChanged: function(oldEncrypt, newEncrypt){
        if(oldEncrypt.encrypt != newEncrypt.encrypt){
            return true;
        }else if(newEncrypt.encrypt === 1 && oldEncrypt.myencrypt != newEncrypt.myencrypt){
            return true;
        }
        return false;
    },

    doImportUsers: function(data){
        var self = this,
            usergrid = this.user.getWidgetByName("USERINFOGRID")
        var $loading = this._createLoading();
        $loading.appendTo(this.mainPane);
        FR.ajax({
            url : FR.servletURL + "?op=fs_manager&cmd=importUser",
            data : data,
            complete: function(res, status){
                if(status == 'success'){
                    var importres = FR.jsonDecode(res.responseText);
                    if(importres.query){
                        FR.Msg.confirm(FR.i18nText("Warning"), importres.query + '?',
                            function(result){
                                if(result){
                                    data.clearall = true;
                                    self.doImportUsers(data);
                                }
                                $loading.remove();
                        });
                        return;
                    }
                    if(importres.hasDuplicated){
                        FR.Msg.confirm(FR.i18nText("Warning"), importres.warnings + '?',
                            function (result) {
                                if (result) {
                                    self.addDuplicatedUsers($loading);
                                }else{
                                    usergrid.refresh();
                                    $loading.remove();
                                }
                            });
                    }else{
                        usergrid.refresh();
                        $loading.remove();
                    }
                }else{
                    $loading.remove();
                }
            }
        });
    },

    _createLoading: function(){
        var $loading = $('<div class="fs-usermgr-loading"/>');
        return $loading;
    },
    /**
     * û
     * @returns {*}
     */
    getUserImportConfig : function(){
        var self = this;
        //ʾϢ
        var $tip = $('<div class="fs-usermgr-tip-icon"></div>').click(
            function(){
                var $tipContext = $('<div class="fs-usermgr-tip-context">'+
                    FR.i18nText("Sync_Dataset_Config_Tip")+
                    '</div>');
                var left = $(this).offset().left + $(this).width();
                var top = $(this).offset().top + $(this).height();
                $tipContext.appendTo($('body')).css({
                    position : 'absolute',
                    left : left,
                    top : top,
                    'z-index': FR.widget.opts.zIndex++
                });
                $(document).bind('mousedown.tip', $tipContext, function(e){
                    var target = e.target;
                    if(!$(target).isChildAndSelfOf('div.fs-usermgr-tip-context')){
                        $tipContext.remove();
                        $(document).unbind('mousedown.tip');
                    }
                });
            }
        );
        var dialogConfig = {
            type: 'tablelayout',
            top: 10,
            widgetName: 'userAuthTablelayout',
            columnSize: [110, 10, 150, 6 ],
            rowSize: [21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21],
            vgap: 11,
            items: [
                [
                    {el: {type: 'llabel', value: '*'+FR.i18nText("DS-Server_TableData"), textalign: 'right'}},null,
                    {el: self.getTableDataComboCfg()},null,
                    {el: $('<div/>').append($tip)}
                ],
                [
                    {el: {type: 'llabel', value: '*'+FR.i18nText("Username"), textalign: 'right'}},null,
                    {el: {type: 'combo' ,widgetName:'usernameCombo', items:[]}}
                ],
                [
                    {el: {type: 'llabel', value: '*'+FR.i18nText("FULLNAME"), textalign: 'right'}},null,
                    {el: {type: 'combo' ,widgetName:'fullnameCombo', items:[]}}
                ],
                [
                    {el: {type: 'llabel', value: '*'+FR.i18nText("Password"), textalign: 'right'}},null,
                    {el: {type: 'combo' ,widgetName:'passwordCombo', items:[]}}
                ],
                [
                    {el: {type: 'llabel', value: FR.i18nText("Encryption_Mode"), textalign: 'right'}},null,
                    {el: self.createEncrypComboCfg()}
                ],
                [
                    null,null,{el: {type: 'text' ,widgetName:'customEncrypText'}}
                ],
                [
                    {el: {type: 'llabel', value: FR.i18nText("Department"), textalign: 'right'}},null,
                    {el: {type: 'combo' ,widgetName:'departmentCombo', items:[]}}
                ],
                [
                    {el: {type: 'llabel', value: FR.i18nText("User_Position"), textalign: 'right'}},null,
                    {el: {type: 'combo' ,widgetName:'positionCombo', items:[]}}
                ],
                [
                    {el: {type: 'llabel', value: FR.i18nText("Role"), textalign: 'right'}},null,
                    {el: {type: 'combo', widgetName: 'roleCombo', items:[]}}
                ],
                [
                    {el: {type: 'llabel', value: FR.i18nText("email"), textalign: 'right'}},null,
                    {el: {type: 'combo' ,widgetName:'emailCombo', items:[]}}
                ],
                [
                    {el: {type: 'llabel', value: FR.i18nText("MobilePhone"), textalign: 'right'}},null,
                    {el: {type: 'combo' ,widgetName:'mobilephoneCombo', items:[]}}
                ]
            ]
        };
        return dialogConfig;
    },
    /**
     * ɷݼϢ
     * @returns {*}
     */
    getTableDataComboCfg: function(){
        var self = this;
        return {
            type: 'combo' ,
            widgetName:'tableDataCombo',
            widgetUrl:FR.servletURL+"?op=fs_manager&cmd=fs_get_servertabledata",
            listeners: [
                {
                    eventName: FR.Events.AFTEREDIT,
                    action: function () {
                        var ds = this.getValue();
                        self.rebuildDSWidgets(ds, this);
                    }
                }
            ]
        }
    },

    /**
     * ȡݼпؼֵ
     * @param pw 
     * @returns {*}
     */
    getDSWidgetData: function(pw){
        var self = this;
        var username = pw.getWidgetByName("usernameCombo").getValue(),
            name = pw.getWidgetByName("fullnameCombo").getValue(),
            password = pw.getWidgetByName("passwordCombo").getValue(),
            department = pw.getWidgetByName("departmentCombo").getValue(),
            post = pw.getWidgetByName("positionCombo").getValue(),
            role = pw.getWidgetByName("roleCombo").getValue(),
            mobile = pw.getWidgetByName("mobilephoneCombo").getValue(),
            email = pw.getWidgetByName("emailCombo").getValue();
        if(!this.checkUserValid(username, name, password, department, post)){
            return false;
        }
        var res = {
            dsName: pw.getWidgetByName("tableDataCombo").getValue(),
            userName: FR.isEmpty(username) ? -1 : username,
            name: FR.isEmpty(name) ? -1 : name,
            password: FR.isEmpty(password) ? -1 : password,
            department: FR.isEmpty(department) ? -1 : department,
            post: FR.isEmpty(post) ? -1 : post,
            role: FR.isEmpty(role) ? -1 : role,
            mobile: FR.isEmpty(mobile) ? -1 : mobile,
            email: FR.isEmpty(email) ? -1 : email,
            encrypt: pw.getWidgetByName("encryptionCombo").getValue()
        };
        if(res.encrypt === 1) {
            res.myencrypt = pw.getWidgetByName("customEncrypText").getValue();
        }
        if(!res.encrypt) {
            res.encrypt = 0;
        }
        return res;
    },
    /**
     * ÷ݼֶѡؼ
     * @param ds ݼ
     * @param pw 
     */
    rebuildDSWidgets: function(ds, pw){
        var cols = [];
        if(!FR.isEmpty(ds)){
            cols = FS.Tools.getColsByTableDataName(ds);
        }
        var widgetNames= ["usernameCombo", "passwordCombo", "fullnameCombo","departmentCombo",
            "positionCombo", "emailCombo", "mobilephoneCombo", "roleCombo"];
        for(var i= 0;i<8;i++){
            var widget = pw.getWidgetByName(widgetNames[i]);
            widget.options.renderEl = widget.element;
            widget.rebuild(cols);
        }
    },

    /**
     * ɼϢ
     * @returns {*}
     */
    createEncrypComboCfg: function(){
        return {
            type: 'combo',
            widgetName: 'encryptionCombo',
            allowBlank: true,
            value: 0,
            items: [
                {text: FR.i18nText("NoEncryption"), value: 0},
                {text: FR.i18nText("CustomEncryption"), value: 1},
                {text: FR.i18nText("MD5Encryption"), value: 2}
            ],
            listeners: [
                {
                    eventName: FR.Events.AFTEREDIT,
                    action: function () {
                        var val = this.getValue();
                        var table = this.getWidgetByName("userAuthTablelayout");
                        if (val === 1) {
                            table.setRowVisible(5, true);
                        } else {
                            table.setRowVisible(5, false);
                        }
                        table.doLayout();
                    }
                }
            ]
        }
    },
    /**
     * ǵû
     */
    addDuplicatedUsers : function($loading){
        var self = this;
        FR.ajax({
            url : FR.servletURL+"?op=fs_manager&cmd=importUser",
            data: {
                override: true
            },
            complete: function(res, status){
                if(status == 'success'){
                    if(res.success){
                        //ɹ
                        self.user.getWidgetByName("USERINFOGRID").refresh();
                    }
                }
                $loading.remove();
            }
        });
    },
    /************Ź*************/
    institutionModule: function(){
        var self = this, isSyncOn = this.isSyncOn;
        var filter = function(parentNode, node, newNodes, result, open) {
            if (!newNodes) {
                return null;
            }
            if(!result) {
                result = [];
            }
            for (var i = 0, l = newNodes.length; i < l; i++) {
                var item = newNodes[i];
                var zItem = {};
                zItem.name = item.text;
                if(item.ChildNodes && item.ChildNodes.length > 0) {
                    filter(item, node, item.ChildNodes, result, false);
                }
                zItem.id = item.id;
                zItem.pId = item.parentID || item.parentId;
                zItem.type = item.type;
                zItem.description = item.description;
                zItem.open = (open === false ? open : true);
                if(self._alreadyExists(zItem.id, result)) {
                    continue;
                }
                result.push(zItem);
            }
            return result;
        };
        var paneWidth = 230, paneHeight = 375,
            dpadd = null, dpedit = null,
            postedit = null, postdel = null,
            useredit = null, userdel = null;
        if(!isSyncOn){
            dpadd = this._createDpmgrTool();
            dpedit = this._createDptreeTool();
            postedit = this._createPostTool();
            useredit = this._createUserTool();
        }
        var config = {
            title: FR.i18nText("Institution"),
            content: {
                type: 'panel',
                width: 800,
                height: 510,
                doSize: true,
                contentWidget: {
                    type: 'absolute',
                    widgetName: 'INSTITUTLAYOUT',
                    items: [
                        //Ź
                        {el:{
                            type : "panel",
                            width: paneWidth,
                            height: paneHeight,
                            title: FR.i18nText("Department_Management"),
                            border: true,
                            doSize: true,
                            tools: dpadd,
                            contentWidget: {
                                type: 'fstabletree',
                                widgetName: 'DEPARTMENTTABLETREE',
                                treeID: 'fsUserDepartmentTableTree',
                                height: '100%',
                                width : '100%',
                                alwaysShowTools: false,
                                toolMargin: 0,
                                itemHoverCls: 'fs-usermgr-tabletree-item-hover',
                                setting: {
                                    view: {
                                        showIcon: false  //ʾÿڵǰICON
                                    },
                                    data : {
                                        simpleData : {
                                            enable : true,
                                            idKey : "id",
                                            pidKey : "pId",
                                            rootPId : "-2"
                                        }
                                    },
                                    async: {
                                        enable: true,
                                        url: FR.servletURL + "?op=fs_set&cmd=auth_getspecialdepart",
                                        dataFilter: filter
                                    },
                                    callback : {
                                        onClick : function(e, treeId, treeNode) {
                                            //ѡʾµְλб
                                            var nodeid = treeNode.id,
                                                postlist = self.user.getWidgetByName("POSTLIST"),
                                                userlist = self.user.getWidgetByName("USERLIST");
                                            userlist.clear();
                                            postlist.refresh({
                                                async:{
                                                    url: FR.servletURL + "?op=fs_set&cmd=auth_getjrole_post",
                                                    data: {departid: nodeid}
                                                }
                                            });
                                        }
                                    }
                                },
                                tools: dpedit
                            }
                        }, x:0,y:0},
                        //ְλ
                        {el:{
                            type : "panel",
                            title: FR.i18nText("Post_Management"),
                            border: true,
                            width: paneWidth,
                            height: paneHeight,
                            tools: postedit,
                            contentWidget: {
                                type: 'quicklist',
                                widgetName: "POSTLIST",
                                height: '100%',
                                alwaysShowTools: false,
                                itemCanBeSelect: true,
                                showField: 'postName',
                                valueField: 'postId',
                                tools: isSyncOn?null:[
                                    {
                                        iconCls: 'fs-module-delete-white',
                                        iconCls4Hover: 'fs-module-delete-white-hover'
                                    }
                                ],
                                onItemToolClick: function (toolindex, index) {
                                    //ɾְλ
                                    var depart = self.user.getWidgetByName("DEPARTMENTTABLETREE").getSelectedNodes()[0];
                                    var postlist = self.user.getWidgetByName("POSTLIST");
                                    var userlist = self.user.getWidgetByName("USERLIST");
                                    if(!depart){
                                        return;
                                    }
                                    FR.Msg.confirm(FR.i18nText("Delete_Data"), FR.i18nText("sure_to_delete")+"?", function(result) {
                                        if(result) {
                                            FR.ajax({
                                                url: FR.servletURL + "?op=fs_set&cmd=auth_removejrole_post",
                                                data: {
                                                    departid: depart.id,
                                                    postid: postlist.getValueAtIndex(index)
                                                },
                                                type: 'POST',
                                                complete: function(res, status){
                                                    if(status == 'success'){
                                                        var re = FR.jsonDecode(res.responseText);
                                                        if(re.success){
                                                            userlist.clear();
                                                            userlist.element.data('users', null);
                                                            postlist.remove(index);
                                                        }
                                                    }
                                                }
                                            });
                                        }
                                    });
                                },
                                onItemSelect: function(){
                                    var data = self._getPostAndDepart();
                                    var userlist = self.user.getWidgetByName("USERLIST");
                                    if(!data){
                                        return;
                                    }
                                    userlist.refresh({
                                        async: {
                                            url: FR.servletURL + "?op=fs_set&cmd=auth_getallemployee",
                                            data: data
                                        }
                                    });
                                }

                            }
                        }, x:270 ,y:0},
                        //Ա
                        {el:{
                            type : "panel",
                            width: paneWidth,
                            height: paneHeight,
                            title: FR.i18nText("Personnel_Management"),
                            border: true,
                            tools: useredit,
                            contentWidget: {
                                type: 'quicklist',
                                widgetName: 'USERLIST',
                                scrollLoading: true,
                                height: '100%',
                                alwaysShowTools: false,
                                itemCanBeSelect: true,
                                onAsyncSuccess: function(items){
                                    this.element.data("users", items);
                                },
                                dataFilter: function(item){
                                    return {
                                        text: (item.realname||"")+'('+item.username+')',
                                        value: item.userid
                                    }
                                },
                                tools: isSyncOn?null:[
                                    {
                                        iconCls: 'fs-module-delete-white',
                                        iconCls4Hover: 'fs-module-delete-white-hover'
                                    }
                                ],
                                onItemToolClick: function(toolindex, index){
                                    var userlist = self.user.getWidgetByName("USERLIST");
                                    //ɾԱ
                                    FR.Msg.confirm(FR.i18nText("Delete_Data"), FR.i18nText("sure_to_delete")+"?", function(result) {
                                        if(result) {
                                            var users = userlist.element.data("users");
                                            var uid = users[index].id;
                                            var data = self._getPostAndDepart();
                                            FR.ajax({
                                                data : {
                                                    userid: uid,
                                                    departid: data.departid,
                                                    postid: data.postid
                                                },
                                                url : FR.servletURL + "?op=fs_set&cmd=auth_removeemployee",
                                                type: 'POST',
                                                complete: function(res, status){
                                                    if(status == 'success'){
                                                        var re = FR.jsonDecode(res.responseText);
                                                        if(re.success){
                                                            userlist.remove(index);
                                                            users.splice(index, 1);
                                                            userlist.element.data("users", users);
                                                        }
                                                    }
                                                }
                                            });
                                        }
                                    });
                                }
                            }
                        }, x:540, y:0}
                    ]
                }
            }
        };
        return config;
    },
    /**
     * ŹPanelӰť
     */
    _createDpmgrTool: function(){
        var self = this;
        var cfg = [
            {
                iconCls: 'fs-module-add-white',
                width: 24,
                height: 24,
                handler: function(){
                    //Ӳ
                    var selecteDepart = self.user.getWidgetByName("DEPARTMENTTABLETREE").getSelectedNodes()[0];
                    if(!selecteDepart) {
                        FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("DoSelectDepartment"));
                        return;
                    }
                    FR.Msg.prompt(FR.i18nText("Add_Department"), FR.i18nText("Department_Name"), "",
                        function (value) {
                            if (value) {
                                var departid = selecteDepart.id;
                                var result = FS.Trans.addDepart({parentID : departid, text : value});
                                if (result.success) {
                                    var node = {
                                        id: result.id,
                                        name: value,
                                        pId: departid,
                                        open: true
                                    };
                                    self.user.getWidgetByName("DEPARTMENTTABLETREE").addNodes(selecteDepart, node, true);
                                } else {
                                    FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("FS-User_Same_Department"));
                                    return false;
                                }
                            }
                        },
                        225
                    );
                }
            }
        ];
        return cfg;
    },

    /**
     * ŹTabletree༭ɾ
     * @private
     */
    _createDptreeTool: function(){
        var self = this;
        var cfg = [
            {
                rootToolHide: true,
                iconCls: 'fs-module-edit-white',
                hoverCls: 'fs-module-edit-white-over',
                //༭ť¼
                onToolClick: function (e) {
                    var nodeID = $(this).data('nodeID');
                    var departTT = self.user.getWidgetByName("DEPARTMENTTABLETREE");
                    var preDeleteNode = departTT.getNodeById(nodeID);
                    departTT.selectNode(preDeleteNode);
                    FR.Msg.prompt(FR.i18nText("EditDepartment"),
                        FR.i18nText("Department_Name"),
                        preDeleteNode.name,
                        function (value) {
                            if (value) {
                                var selecteDepart = departTT.getSelectedNodes()[0];
                                var departid = selecteDepart.id;
                                var result = FS.Trans.addDepart({id : departid, text : value});
                                if (result.success) {
                                    selecteDepart.name = value;
                                    departTT.updateNode(selecteDepart);
                                } else {
                                    FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("FS-User_Same_Department"));
                                }
                            }
                        },
                        225);
                    e.stopEvent();
                }
            },
            {
                rootToolHide: true,
                iconCls: 'fs-module-delete-white',
                hoverCls: 'fs-module-delete-white-hover',
                //ɾť¼
                onToolClick: function (e) {
                    var nodeID = $(this).data('nodeID');
                    var departTT = self.user.getWidgetByName("DEPARTMENTTABLETREE");
                    var preDeleteNode = departTT.getNodeById(nodeID);
                    departTT.selectNode(preDeleteNode);
                    FR.Msg.confirm(FR.i18nText("Delete_Data"), FR.i18nText("sure_to_delete") + '?', function (result) {
                        if (result) {
                            //̨ɾݣɹwebɾ
                            var departmentId = departTT.getSelectedNodes()[0].id;
                            FS.Trans.removeDepart(departmentId);
                            departTT.removeSelectedNodes();
                        }
                    });
                    e.stopEvent();
                }
            }
        ];
        return cfg;
    },

    /**
     * ְλб༭ť
     * @private
     */
    _createPostTool: function(){
        var self = this;
        var cfg = [
            {
                iconCls: 'fs-module-edit-white',
                width: 24,
                height: 24,
                handler: function(){
                    self._createPostEditDialog();
                }
            }
        ];
        return cfg;
    },

    /**
     * Աб༭ť
     * @private
     */
    _createUserTool: function(){
        var self = this;
        var cfg = [
            {
                iconCls: 'fs-module-edit-white',
                width: 24,
                height: 24,
                handler: function(){
                    var dp = self._getPostAndDepart();
                    //û
                    self._createUserDialog(dp);
                }
            }
        ];
        return cfg;
    },
    /**
     * Ӻͱ༭ְλĶԻ
     * @private
     */
    _createPostEditDialog: function(){
        var self = this;
        var depart = this.user.getWidgetByName("DEPARTMENTTABLETREE").getSelectedNodes()[0];
        if(!depart){
            return;
        }
        var departid = depart.id;
        var postlist = this.user.getWidgetByName("POSTLIST");
        var toAddList = [], toDelList = [];
        var dialog = new FR.Dialog({
            confirm: true,
            needSeparate: 8,
            height: 450,
            width: 300,
            title: FR.i18nText("Post_Management"),
            destroyOnClose: true,
            onOK: function(){
                var delResult = true, addResult = true;
                if(toDelList.length){
                    var re = FS.Trans.removePostsFromDepart({
                        departid: departid,
                        postid: toDelList.join(',')
                    });
                    delResult = re.success;
                }
                if(toAddList.length){
                    var re = FS.Trans.addPostsToDepart({
                        departid: departid,
                        postid: toAddList.join(',')
                    });
                    addResult = re.success;
                }
                if(addResult && delResult){
                    postlist.refresh();
                }else{
                    FR.Msg.toast(FR.i18nText("Failed"));
                }
            },
            contentWidget: {
                type:'border',
                items: [
                    {
                        region: 'north',
                        height: 1,
                        el: $('<div/>')
                    },
                    {
                        region: 'center',
                        el: {
                            type:'search',
                            autoSearch: true,
                            widgetName: 'POSTNAMETEXT',
                            onKeyup: function(e){
                                var val = this.getValue(), data = {departid: depart.id};
                                if(val){
                                    data.keyword = val;
                                }
                                var allpost = dialog.getWidgetByName('ALLPOSTLIST');
                                if (!FR.isNavKeyPress(e)) {
                                    setTimeout(function () {
                                        allpost.clear();
                                        allpost.refresh({
                                            async: {
                                                url: FR.servletURL + "?op=fs_set&cmd=auth_getfilterposts",
                                                data: data
                                            }
                                        });
                                    }, 100);
                                }
                            }
                        }
                    },
                    {
                        region: 'west',
                        width: 1,
                        el: $('<div/>')
                    },
                    {
                        region: 'east',
                        width: 24,
                        el:{
                            type:'iconbutton',
                            widgetName: 'POSTADDBTN',
                            imgsrc: 'fs-usermgr-add-blue',
                            handler: function(){
                                //ְλбְλ
                                var newpost = dialog.getWidgetByName("POSTNAMETEXT").getValue();
                                if(!newpost) {
                                    FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("Position_Can_Not_Be_Null"));
                                    return ;
                                }
                                var id = FS.Trans.addPost({postname : newpost});
                                if(id > 0) {
                                    dialog.getWidgetByName("ALLPOSTLIST").addItem({
                                        text: newpost,
                                        id: id
                                    });
                                } else {
                                    FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("Add_Position_Failure"));
                                }
                            }
                        }
                    },
                    {
                        region: 'south',
                        height: 342,
                        el:{
                            type: 'quicklist',
                            widgetName:'ALLPOSTLIST',
                            alwaysShowTools: false,
                            itemCanBeSelect: true,
                            paddingLeft: 0,
                            valueField: 'id',
                            async: {
                                url:  FR.servletURL + "?op=fs_set&cmd=auth_getfilterposts",
                                data: {departid: departid}
                            },
                            tools: [
                                {
                                    iconCls: 'fs-module-delete-white',
                                    iconCls4Hover: 'fs-module-delete-white-hover'
                                }
                            ],
                            onBeforeItemCreate: function(element, options){
                                var $check = new FR.CheckBox({
                                    renderEl: element,
                                    height: this.options.height,
                                    value: options.inDepart ? true : false,
                                    listeners:[{
                                        eventName: FR.Events.STATECHANGE,
                                        action: function(){
                                            var id = options.id;
                                            if(this.getValue()){
                                                if(toDelList.length === toDelList.remove(id).length){
                                                    toAddList.push(id);
                                                }
                                            }else{
                                                if(toAddList.length === toAddList.remove(id).length){
                                                    toDelList.push(id);
                                                }
                                            }
                                        }
                                    }]
                                });
                            },
                            onItemToolClick: function (toolindex, index) {
                                var allpostlist = dialog.getWidgetByName('ALLPOSTLIST');
                                var selpost = allpostlist.getValueAtIndex(index);
                                if(!selpost){
                                    return;
                                }
                                //ɾְλ
                                FR.Msg.confirm(FR.i18nText("Delete_Data"), FR.i18nText("sure_to_delete")+"?", function(result) {
                                    if(result) {
                                        FR.ajax({
                                            url: FR.servletURL + "?op=fs_set&cmd=auth_removepost",
                                            data: {
                                                id: selpost
                                            },
                                            type: 'POST',
                                            complete: function(res, status){
                                                if(status == 'success'){
                                                    var re = FR.jsonDecode(res.responseText);
                                                    if(re.success){
                                                        allpostlist.remove(index);
                                                    }
                                                }
                                            }
                                        });
                                    }
                                });
                            }
                        }
                    }
                ]
            }
        });
        dialog.setVisible(true);
    },

    /**
     * ӺɾûĶԻ
     * @param data ʼ
     * @private
     */
    _createUserDialog: function(data){
        var self = this;
        var $userOptPane = FS.Tools.createUserOptPane(data),
            userlist = this.user.getWidgetByName('USERLIST');
        var userDialog = new FR.Dialog({
            confirm: true,
            title: FR.i18nText("Personnel_Management"),
            width: 550,
            height: 445,
            doSize: true,
            destroyOnClose: true,
            contentWidget: {
                type: 'absolute',
                widgetName: 'USERABSOLUTE',
                items: [
                    {el: {
                        type: 'label',
                        widgetName: 'POSTNAME',
                        wrap: false,
                        fontsize: 14,
                        color: '#676767',
                        width: 220,
                        value: data.departname + '-' + data.postname,
                        title: data.departname + '-' + data.postname,
                        height: 21
                    },x:15,y:12},
                    {el: {
                        type: 'search',
                        width: 230,
                        autoSearch: true,
                        onKeyup: function(e){
                            if (self.filerid != null) {
                                clearTimeout(self.filerid);
                                self.filerid = null;
                            }
                            if (!FR.isNavKeyPress(e)) {
                                var val = this.getValue();
                                var dp = {
                                    departid: data.departid,
                                    postid: data.postid
                                };
                                if(val){
                                    dp.keyword = val;
                                }
                                self.filerid = setTimeout(function () {
                                    $userOptPane.refresh(dp, $userOptPane.seluser, $userOptPane.alluser, function() {
                                        $userOptPane.seluser.empty();
                                        $userOptPane.alluser.empty();
                                    });
                                }, 200);
                            }
                        }
                    },x:300,y:10},
                    {el: $userOptPane,x:15,y:50}
                ]
            },
            onOK: function(){
                var addids = $userOptPane.getAddlist, delids = $userOptPane.getDellist;
                //Ա
                if(addids.length){
                    FS.Trans.addEmployee({
                        userid: addids.join(','),
                        departid: data.departid,
                        postid: data.postid
                    })
                }
                //ɾԱ
                if(delids.length){
                    FS.Trans.removeEmployee({
                        userid: delids.join(','),
                        departid: data.departid,
                        postid: data.postid
                    });
                }
                userlist.refresh({
                    async: {
                        url: FR.servletURL+"?op=fs_set&cmd=auth_getallemployee",
                        data: data
                    }
                });
            }
        });
        userDialog.setVisible(true);
    },

    /**
     * ȡѡеĲźְλ
     * @returns {*}
     * @private
     */
    _getPostAndDepart: function(){
        var depart = this.user.getWidgetByName("DEPARTMENTTABLETREE").getSelectedNodes()[0],
            post = this.user.getWidgetByName("POSTLIST");
        if(depart && post){
            return {
                departname: depart.name,
                departid: depart.id,
                postid: post.getValue(),
                postname: post.getText()
            }
        }else{
            return null
        }
    },

    _alreadyExists : function(id, result) {
        for(var i = 0; i < result.length; i ++) {
            if(result[i].id === id) {
                return true;
            }
        }
        return false;
    }
};
