/**
 * ϵͳϢ
 * Coder: Sean
 * Date: 14-5-2
 * Time: 5:42
 */
FS.SYSMSG={
    /**
     * ʼϵͳϢҳ
     */
    init: function (renderer) {
        var self = this;
        this.sysmsg = new FR.AbsoluteLayout({
            renderEl: renderer,
            scrollable: true,
            items: [
                {el: {
                    type: 'quickgrid',
                    widgetName: 'MSGGRID',
                    footAlign: 'top',
                    page: true,
                    pageCount: 15,
                    multiSelect: true,
                    intervalColor: false,
                    hasHoverCls: false,
                    isHeadShow: false,
                    async: {
                        url: FR.servletURL + "?op=fs_main&cmd=check_toast",
                        type: 'POST'
                    },
                    onAsyncSuccess: function (res, status) {
                        this.options.items = [];
                        var result = FR.jsonDecode(res);
                        if (result && result.toasted) {
                            this.options.items = result.toasted;
                        }
                    },
                    columnsConfig: [
                        {
                            key: 'message',
                            value: 'message',
                            width: 600
                        },
                        {
                            key: 'check',
                            value: 'check',
                            width: 60,
                            onCellCreate: function (rowIdx, colIdx, item, colCfg) {
                                var grid = this;
                                var btn = new FR.IconButton({
                                    text: FR.i18nText("Deal"),
                                    imgsrc: 'fs-sysmsg-deal',
                                    width: 60,
                                    height: 25,
                                    handler: function () {
                                        self.dealSysMsg(item);
                                        grid.refresh();
                                    }
                                });
                                return btn.element;
                            }
                        }
                    ]
                }, x: 15, y: 25},
                {el: {
                    type: 'iconbutton',
                    text: FR.i18nText("Delete"),
                    baseClass: 'fs_sysmsg_delete_blue',
                    height: 28,
                    width: 60,
                    handler: function () {
                        FR.Msg.confirm(FR.i18nText("Delete_User"), FR.i18nText("sure_to_delete") + "?", function (result) {
                            if (result) {
                                var msggrid = self.sysmsg.getWidgetByName("MSGGRID");
                                var selectedData = msggrid.getSelectedData();
                                self.ignoreMsgs(selectedData, true, function () {
                                    msggrid.refresh();
                                });
                            }
                        });
                    }
                }, x: 25, y: 25}
            ]
        });
        this.sysmsg.doLayout();
    },

    /**
     * ϵͳϢӡһʱ̨ȡ
     * @param {Number} interval ʱ()
     */
    sendSysMsgConn: function(interval) {
        var self = this;
        var fn = function() {
            FR.ajax({
                url: FR.servletURL+"?op=fs_main&cmd=check_toast",
                type: 'POST',
                async: true,
                complete: function(res, status) {
                    if (status == 'success') {
                        var result = FR.jsonDecode(res.responseText);
                        if (result && result.fresh && result.toasted) {
                            // Ϣ
                            var fresh = result.fresh;
                            self.toastMsg(fresh);

                            // ϢĿ䶯
                            var toasted = result.toasted;
                            self.refreshMsgBox(toasted);
                        }
                    } else {
                        clearInterval(self.SysMsgConn);
                    }
                }
            });
        };
        this.SysMsgConn = setInterval(fn, interval);
        setTimeout(fn, 2000);
    },

    /**
     * ϵͳϢ
     * @param {Array} msgs Ϣ
     */
    toastMsg: function(msgs){
        var self = this;
        var len = msgs.length;
        if(len < 1){
            return;
        }
        var curidx = 1;
        if(this.toastPane){
            return;
        }
        this.toastPane = new FR.Panel({
            renderEl: $('<div class="fs_sysmsg_toastpane"/>').appendTo(FS.tabPane.element),
            width: 220,
            height: 120,
            title: FR.i18nText("New_Message"),
            closable: true,
            border: true,
            animate: false,
            onClose: function(){
                self.ignoreMsgs(msgs);
                clearTimeout(panetime);
            },
            contentWidget: {
                type: 'border',
                widgetBackground:{
                    background: '#ffffff'
                },
                items: [
                    {
                        region: 'north',
                        height: 10,
                        el: $('<div/>')
                    },{
                        region: 'east',
                        width: 5,
                        el: $('<div/>')
                    },{
                        region: 'west',
                        width: 5,
                        el: $('<div/>')
                    },{
                        region: 'center',
                        el: {
                            type: 'label',
                            widgetName: 'MSGINFO',
                            fontfamily: 'SimSun',
                            fontsize: 12,
                            value: FS.getShowText(msgs[0].message, 800, 12, 'SimSun'),
                            listeners:[
                                {
                                    eventName: FR.Events.CLICK,
                                    action: function(){
                                        self.dealSysMsg(msgs[curidx]);
                                        self.ignoreMsgs(msgs);
                                        self.toastPane.destroy();
                                        self.toastPane = null;
                                    }
                                }
                            ]
                        }
                    },{
                        region: 'south',
                        height: 30,
                        el: {
                            type: 'horizontal',
                            items: [
                                {el:{
                                    type: 'iconbutton',
                                    imgsrc: 'fs_sysmsg_prev',
                                    handler: function(){
                                        clearTimeout(panetime);
                                        if(curidx <= 1){
                                            return;
                                        }
                                        curidx--;
                                        self.jumpToastMsg(curidx, len, msgs);
                                    }
                                }, width:20},
                                {el:{
                                    type: 'label',
                                    widgetName: 'PAGELABEL',
                                    value: curidx+'/'+len,
                                    verticalcenter: true,
                                    color: '#707070',
                                    fontsize: 11,
                                    textalign: 'center'
                                }, width:20},
                                {el:{
                                    type: 'iconbutton',
                                    imgsrc: 'fs_sysmsg_next',
                                    handler: function(){
                                        clearTimeout(panetime);
                                        if(curidx >= len){
                                            return;
                                        }
                                        curidx++;
                                        self.jumpToastMsg(curidx, len, msgs);
                                    }
                                }, width:20},
                                {el:$('<div/>'), width:80},
                                {el:{
                                    type: 'iconbutton',
                                    imgsrc: 'fs_sysmsg_viewmsg',
                                    text: FR.i18nText("View_All")+"&nbsp;&raquo;",
                                    handler: function(){
                                        clearTimeout(panetime);
                                        self.dealAllMsg(msgs);
                                        self.toastPane.destroy();
                                        self.toastPane = null;
                                    }
                                }, width: 70}
                            ]
                        }
                    }
                ]
            }
        });
        var panetime = setTimeout(function(){
            if(self.toastPane){
                self.ignoreMsgs(msgs);
                self.toastPane.destroy();
                self.toastPane = null;
            }
        }, 10000);
    },

    /**
     * תָĵϵͳϢ
     * @param {Number} curidx תλ
     * @param {Number} len 
     * @param {Array} msgs Ϣ
     */
    jumpToastMsg: function(curidx, len, msgs){
        var pane = this.toastPane;
        pane.getWidgetByName("MSGINFO")
            .setValue(FS.getShowText(msgs[curidx - 1].message, 800, 12, 'SimSun'));
        pane.getWidgetByName("PAGELABEL").setValue(curidx+'/'+len);
    },
    /**
     * ϵͳϢ
     */
    goSysMsgCenter: function(){
        var $container = $("<div/>").addClass('fs_design_container');
        FS.tabPane.addItem({
            title: FR.i18nText("RP_System_Message"),
            contentEl: $container
        });
        this.init($container);
    },

    /**
     * (ɾ)Ϣ
     * @param {Array} msgs ҪԵϢ
     * @param {Boolean} needDelete ǷҪݿɾϢ
     * @param {Function} callback ص
     */
    ignoreMsgs: function(msgs, needDelete, callback){
        var self = this;
        FR.ajax({
            url: FR.servletURL+"?op=fs_main&cmd=click_toast",
            type: 'POST',
            async: true,
            data: {
                msgs: msgs,
                clicked: !!needDelete
            },
            complete: function (res, status) {
                if (status == 'success') {
                    var result = FR.jsonDecode(res.responseText);
                    if (result.error) {
                        FR.Msg.toast(result.error);
                    }else{
                        callback.apply(self, arguments);
                    }
                }
            }
        });
    },

    /**
     * ȫϢ,Ϣ,ϵͳϢġ
     * @param {Array} msgs Ϣ
     */
    dealAllMsg: function(msgs){
        var self = this;
        this.ignoreMsgs(msgs, false, function(){
            self.goSysMsgCenter();
        });

    },


    /**
     * ˢϢ
     * @param {Array} msgs Ϣ
     */
    refreshMsgBox: function(msgs){
        var pane = FS.userPane;
        var text = FS.config.hasnavigation?FR.i18nText("New_Message"):"";
        if(msgs){
            var length = msgs.length;
            if(length > 0){
                text += "("+length+")";
            }
        }
        if (pane.sysmsgText) {
            pane.sysmsgText.find('a').text(text);
        }
        pane.msgbox = msgs || [];
    },

    /**
     * ʾϢеб
     * @param x ʾλx
     * @param y ʾλy
     * @returns {*|jQuery}
     */
    showSysMsgComboAt: function(x, y){
        var self = this, msgbox = FS.userPane.msgbox;
        msgbox = msgbox || [];//ʼϢ
        //б
        var $combo = $('<div class="fs_sysmsg_combo"/>').hide();
        var $ul = $('<ul/>');
        for(var i= 0,len = msgbox.length;i<len;i++){
            if(i > 4){
                break; //Ϣʾ5Ϣ
            }
            var item = msgbox[i];
            var $li = $('<li class="fs_sysmsg_combo_item"/>');
            var text = item.message;
            $('<div class="fs_sysmsg_combo_text"/>')
                .attr('title', text)
                .text(FS.getShowText(text, 270, 12, 'SimSun')).appendTo($li);
            $li.click(function(){
                //ָһϵͳϢ, ˢϢ.
                var index = $(this).data('index');
                self.dealSysMsg(msgbox[index]);
                msgbox.splice(index, 1);
                self.refreshMsgBox(msgbox);
                $(this).remove();
            }).appendTo($ul).data('index', i);
        }
        //бչ
        $combo.append($ul).css({
            position: 'absolute',
            left: x,
            top: y,
            width: 180
        }).appendTo($('body')).slideDown('fast');
        //ȫť
        var $more = $('<div class="fs_sysmsg_combo_more"/>').appendTo($combo);
        $('<div/>').text(FR.i18nText("View_All")).appendTo($more)
            .click(function(){
                //ȫ,ϵͳϢ
                self.dealAllMsg(msgbox);
            });
        return $combo;
    },

    /**
     * һϢ
     * @param {Object} msg һϢ
     */
    dealSysMsg: function(msg){
        FR.ajax({
            url: FR.servletURL+"?op=fs_main&cmd=click_toast",
            type: 'POST',
            async: false,
            data: {
                msgs: [msg],
                clicked: true
            },
            complete: function (res, status) {
                if (status == 'success') {
                    var result = FR.jsonDecode(res.responseText);
                    if (result.error) {
                        FR.Msg.toast(result.error);
                    } else {
                        FS.tabPane.addItem({
                            title: FR.i18nText("RP_MyTask"),
//                            src: FR.buildServletUrl({
//                                reportlet: msg.url,
//                                op: 'write',
//                                '__processtaskid__': msg.taskId
//                            })
                            src: FR.servletURL + "?reportlet=" + FR.cjkEncode(msg.url) + "&op=write&__processtaskid__=" + msg.taskId + "&__allprocesstaskid__=" + msg.alltaskId
                        });
                    }
                }
            }
        });
    },

    /**
     * رϵͳϢ
     */
    closeSysMsgConn: function(){
        if(this.SysMsgConn){
            clearInterval(this.SysMsgConn);
        }
    }
};