/**
 * wei : ƽ̨
 */
FS.CONFIGSETTING = {
	
	NAVIGATIONIMGS : [],
		
	init : function(renderer) {
		FR.$defaultImport('/com/fr/fs/web/css/manager/fs_configsetting.css', 'css');
		var columnSize = [40, 131, 'fill'];
		var rowSize = [10, 21, 52, 25, 150, 21, 21, 21, 125, 145, 21, 150, 0];
		var self = this;
		this.fsTitleText = FR.createWidget({type: 'text', widgetName: 'fstitle', width: 186, height: 21});
		this.homepageURLText = FR.createWidget({type: 'text', widgetName: 'homepageurl', width: 186, height: 21});
		var tablelayout = {
			type : 'tablelayout',	
			columnSize : columnSize,
            scrollable: true,
			rowSize : rowSize,
			vgap : 20,
			widgetName : 'tablelayout',
			items : [
				[
					{
						el : $('<div/>')
					}
				],
				[
					{
					 	el : $('<div/>')
					},
					{
					 	el : {
					 		type : 'llabel',
					 		value : FR.i18nText("FS-Look_And_Feel_Customize_Login")
					 	}
					},
					{
					 	el: {
                            type:'absolute',
                            widgetName:'loginPageAbsolute',
                            items:[
                                {
                                    type: 'radiogroup',
                                    width: 270,
                                    height: 21,
                                    items: [
                                        {
                                            text: FR.i18nText("FS-Look_And_Feel_Login_Background"),
                                            value: 1,
                                            width: 135
                                        },
                                        {
                                            text: FR.i18nText("FS-Look_And_Feel_Login_URL"),
                                            value: 2,
                                            width: 135
                                        }
                                    ],
                                    listeners: [
                                        {
                                            eventName: "afteredit",
                                            action: function () {
                                                var widget = self.panel.getWidgetByName('loginpagetype');
                                                if (widget && widget.getValue() === 1) {
                                                    self._showLoginPageImg();
                                                } else {
                                                    self._showLoginPageURL();
                                                }
                                            }
                                        }
                                    ],
                                    columnsInRow: 2,
                                    widgetName: 'loginpagetype',
                                    x: 0,
                                    y: 0
                                }
                            ]
						}
					}
				],
				[
					{
						el : $('<div/>')
					},
                    {
                        el : $('<div/>')
                    },
                    {
                        el: {
                            type: 'absolute',
                            widgetName: 'pageUrlAbsolute',
                            items: [
                                {
                                    height: 21,
                                    width: 122,
                                    type: 'llabel',
                                    value: FR.i18nText("FS-Look_And_Feel_Login_URL_Detail"),
                                    x: 0,
                                    y: 0
                                },
                                {
                                    type: 'text',
                                    widgetName: 'urladdress',
                                    width: 322,
                                    height: 21,
                                    y: 31,
                                    x: 0
                                }
                            ]
                        }
                    }
				],
				[
					{
						el : $('<div/>')
					},
					{
						el : $('<div/>')
					},
					{
						el : {
					 		type : 'multifile',
					 		widgetName : 'loginimgupload',
					 		maxlength : 1,
					 		accept : '.png.jpg.gif',
							hideFileList : true,
							height:32,
							width:32,
							tooltipText:FR.i18nText("FS-Look_And_Feel_BG_Upload_ToolTip"),
							listeners : [
					  		    {
					  		    	eventName : "afteredit",
					  		    	action : function() {
					  		    		var widget = self.panel.getWidgetByName('loginimgupload');
					  		    		if(widget) {
					  		    			var attachid = widget.getValue().attach_id;
					  		    			var url = FR.servletURL + ('?op=fr_attach&cmd=ah_image&id=' + attachid + '&isAdjust=false');
				  		    				$('.fs_csview_loginimg').attr('src', url);
				  		    				$('td', widget.element).remove();
					  		    		}
					  		    	}
					  		    }
					  		]
						}
					}
				],
				[
					{
						el : $('<div/>')
					},
					{
					 	el : $('<div/>')
					},
					{
						el : $('<img/>').addClass('fs_csview_loginimg')
					}
				],
				[
					{
						el : $('<div/>')
					},
					{
				 	el : {
				 			type : 'llabel',
				 			value : FR.i18nText("FS-Look_And_Feel_Title")
				 		}
					 },
					 {
					 	el : $('<div/>').append(this.fsTitleText.element)
					 }
				],
				[
				 	{
				 		el : $('<div/>')
				 	},
				 	{
	                 	el : {
	                 		type : 'llabel',
	                 		value : FR.i18nText("HomepageURL")
	                 	}
				 	},
				 	{
	                 	el : $('<div/>').append(this.homepageURLText.element)
	                }
				],
				[
				 	{
				 		el : $('<div/>')
				 	},
				 	{
	                 	el : {
	                 		type : 'llabel',
	                 		value : FR.i18nText("FS-Look_And_Feel_Top_Navigation")
	                 	}
				 	},
				 	{
	                 	el : {
	                 		type : 'switch',
	                 		widgetName : 'hasNavigation',
	                 		onTurnOff : function() {
	                 			self._hideNavigationImgs();
	                 			$('.fs_csview_loginimg').width(213).height(147);
	                 			$('.fs_csview_background').width(213).height(147);
	                 		},
	                 		onTurnOn : function() {
	                 			self._showNavigationImgs();
	                 			$('.fs_csview_loginimg').width(213).height(147);
	                 			$('.fs_csview_background').width(213).height(147);
	                 		}
	                 	}
	                }
				],
				[
				 	{
				 		el : $('<div/>')
				 	},
				 	{
	                 	el : $('<div/>')
				 	},
				 	{
	                 	el : $('<div/>').append($('<div/>').attr("id", "fs_csview_navicustompane"))
	                }
				],
				[
				 	{
				 		el : $('<div/>')
				 	},
				 	{
				 		el : {
					 		type : 'llabel',
	                 		value : FR.i18nText("StyleChoice"),
	                 		verticalcenter: false
					 	}
				 	},
				 	{
				 		el : $('<div/>').attr("id", 'fs_csview_style')
				 	}
				],
				[
				 	{
				 		el : $('<div/>')
				 	},
				 	{
				 		el : {
					 		type : 'llabel',
	                 		value : FR.i18nText("BackgroundImg")
					 	}
				 	},
				 	{
				 		el : {
				 			type : 'multifile',
				 			maxlength : 1,
				 			widgetName : 'backgroundimgupload',
				 			accept : '.png.jpg.gif',
				 			height:32,
							width:32,
							tooltipText:FR.i18nText("FS-Look_And_Feel_BG_Upload_ToolTip"),
							hideFileList : true,
							listeners : [
					  		    {
					  		    	eventName : "afteredit",
					  		    	action : function() {
					  		    		var widget = self.panel.getWidgetByName('backgroundimgupload');
					  		    		if(widget) {
					  		    			var attachid = widget.getValue().attach_id;
					  		    			var url = FR.servletURL + ('?op=fr_attach&cmd=ah_image&id=' + attachid + '&isAdjust=false');
				  		    				$('.fs_csview_background').attr('src', url);
				  		    				$('td', widget.element).remove();
					  		    		}
					  		    	}
					  		    }
					  		]
				 		}
				 	}
				],
				[
				 	{
				 		el : $('<div/>')
				 	},
				 	{
				 		el : {
					 		type : 'llabel',
	                 		value : FR.i18nText("Preview"),
	                 		verticalcenter: false
					 	}
				 	},
				 	{
				 		el : $('<img/>').addClass('fs_csview_background')
				 	}
				],
                [
                    {
                        el : $('<div/>')
                    }
                ]
			]
		}
		this.panel = FR.createWidget({
			renderEl : $('<div>').appendTo(renderer),
            widgetName: 'confSetConfirmPane',
            type: 'confirm',
            firstBtnMargin: 40,
            needSeparate : 8,
            btnsAlignment: 'left',
            closeAfterAction: false,
            width:renderer.width(),
            height:renderer.height(),
            onOK : function() {
            	self.saveData();
            },
            doSize: true,
            text4Cancel:null,
            text4OK:FR.i18nText("Save_With_Whitespace"),
            contentWidget: tablelayout
        });
		this.customNavigationPane = FR.createWidget({
			renderEl : $("#fs_csview_navicustompane"),
     		type : 'panel',
     		title : FR.i18nText("CustomIcon"),
     		width : 560,
     		height :90,
            doSize:true,
     		border : true,
     		contentWidget : {
     			type : 'absolute',
     			widgetName : 'naviAbsolute',
                scrollable: true,
     			items : self.createNavigationItems()
     		}
     	});
        this.customNavigationPane.element.find('.fs_navigation_text').css('color','#000000');
        this.panel.getWidgetByName("tablelayout").doLayout();
        this.panel.getWidgetByName("loginPageAbsolute").doLayout();
        this.panel.getWidgetByName("pageUrlAbsolute").doLayout();
        this.loginUrlText = this.panel.getWidgetByName("urladdress");
		this.customNavigationPane.getWidgetByName("naviAbsolute").doLayout();
        this.panel.getWidgetByName("tablelayout").element.css('overflow-x','hidden');
		$('.fr-fileupload-image', this.panel.element).css('left', 0);
		this._createStylePane();
		renderer.css("overflow", "hidden");
		renderer.data("onResize", function(width, height) {
			self.panel.doResize({
				width:width,
				height:height
			});
            $('.fs_csview_loginimg').width(213).height(147);
            $('.fs_csview_background').width(213).height(147);
		});
		this.popData();
	},
	
	_createStylePane : function() {
		var wrap = $("#fs_csview_style");
		var cls = "fs_csview_style";
		var styleItems = [];
		var blackStyle = $("<div/>").addClass(cls).addClass(cls+"_black")
			.data("style", "black").appendTo(wrap);
		var darkBlueStyle = $("<div/>").addClass(cls).addClass(cls+"_darkblue")
			.data("style", "darkblue").appendTo(wrap);
		var lightBlueStyle = $("<div/>").addClass(cls).addClass(cls+"_lightblue")
			.data("style", "lightblue").appendTo(wrap);
		this.styleItems = [blackStyle, darkBlueStyle, lightBlueStyle];
		this._makeImgGrouped(this.styleItems, true);
	},
	
	_showNavigationImgs : function() {
		this.panel.getWidgetByName('tablelayout').setRowVisible(8, true);
		this.panel.getWidgetByName('tablelayout').doLayout();
	},
	
	_hideNavigationImgs : function() {
		this.panel.getWidgetByName('tablelayout').setRowVisible(8, false);
		this.panel.getWidgetByName('tablelayout').doLayout();
	},
	
	_showLoginPageURL : function() {
		this.panel.getWidgetByName('tablelayout').setRowVisible(2, true);
		this.panel.getWidgetByName('tablelayout').setRowVisible(3, false);
		this.panel.getWidgetByName('tablelayout').setRowVisible(4, false);
		this.panel.getWidgetByName('tablelayout').doLayout();
		$('.fs_csview_background').width(213).height(147);
	},
	
	_showLoginPageImg : function() {
		this.panel.getWidgetByName('tablelayout').setRowVisible(2, false);
		this.panel.getWidgetByName('tablelayout').setRowVisible(3, true);
		this.panel.getWidgetByName('tablelayout').setRowVisible(4, true);
		var url = FR.servletURL + ((this.data.loginimg && this.data.loginimg != 'null') 
			?('?op=fr_attach&cmd=ah_image&id=' + this.data.loginimg + '&isAdjust=false') :'?op=resource&resource=/com/fr/base/images/oem/signin.png');
		$('.fs_csview_loginimg').attr('src', url);
		$('.fs_csview_loginimg')[0].onload = function() {
			$('.fs_csview_loginimg').width(213).height(147);
		}
		this.panel.getWidgetByName('tablelayout').doLayout();
		$('.fs_csview_background').width(213).height(147);
		$('.fs_csview_loginimg').width(213).height(147);
	},
	
	_createSimpleItems : function(items) {
		var wrap = $("<div/>").addClass("fs_csview_simplenavi");
		var top = $("<div/>").addClass("fs_csview_simplenavi_top").appendTo(wrap);
		var bottom = $("<div/>").addClass("fs_csview_simplenavi_bottom").appendTo(wrap);
		var naviimgcls = "fs_csview_naviimgs";
		for(var i = 1; i <= 5; i ++) {
			items.push($("<div/>").addClass(naviimgcls).addClass(naviimgcls + i)
					.data("navicls", naviimgcls + i).appendTo(top));
		}
		for(var i = 6; i <= 10; i ++) {
			items.push($("<div/>").addClass(naviimgcls).addClass(naviimgcls + i)
					.data("navicls", naviimgcls + i).appendTo(bottom));
		}
		return wrap;
	},
	
	_createColorfulItems : function(items) {
		var wrap = $("<div/>").addClass("fs_csview_colorfulnavi");
		var top = $("<div/>").addClass("fs_csview_simplenavi_top").appendTo(wrap);
		var bottom = $("<div/>").addClass("fs_csview_simplenavi_bottom").appendTo(wrap);
		var naviimgcls = "fs_csview_naviimgc";
		for(var i = 1; i <= 5; i ++) {
			items.push($("<div/>").addClass(naviimgcls).addClass(naviimgcls + i)
					.data("navicls", naviimgcls + i).appendTo(top));
		}
		for(var i = 6; i <= 10; i ++) {
			items.push($("<div/>").addClass(naviimgcls).addClass(naviimgcls + i)
					.data("navicls", naviimgcls + i).appendTo(bottom));
		}
		return wrap;
	},
	
	_createCustomImgUpload : function() {
		var self = this;
		var wrap = $("<div/>");
		var upload = $("<div/>").addClass("fs_csview_navi_customimg_upload").appendTo(wrap);
		var fileupload = FR.createWidget({
			renderEl : upload,
			type : 'multifile',
	 		maxlength : 1,
	 		accept : '.png.jpg.gif',
	 		height:32,
			width:32,
			tooltipText:FR.i18nText("FSNaviUploadToolTip"),
			hideFileList : true,
	 		widgetName : 'naviupload'
		});
		fileupload.on(FR.Events.AFTEREDIT, function(e){
			var ids = this.getValue();
			var id = ids.attach_id;
            var url =FR.servletURL
                + (id && id != 'null' ?('?op=fr_attach&cmd=ah_image&id='+id+'&isAdjust=false') :'');
            img.attr("src", url);
            self._makeItemInGroup(imgshow);
    		self.navimgItems.push(imgshow);
    		self._selectItem(imgshow);
    		imgshow.data("naviid", id);
            $('td', this.element).remove();
		});
		var emptyImgsrc = FR.servletURL + '?op=resource&resource=/com/fr/web/core/js/jquerytree/images/s.gif';
		var imgshow = $("<div/>").addClass("fs_csview_navi_customimg_show").appendTo(wrap);
		var img = $("<img/>").attr("src", emptyImgsrc).addClass("fs_csview_navi_customimg").appendTo(imgshow);
		return wrap;
	},
	
	_checkDataExist : function(item, naviItem) {
		var type = item.treefolderid;
		if(item.bi === true) {
			type = "bi"; 
		} else if(item.managersystem === true) {
			type = "manager";
		}
		
		for(var i = 0, len = this.NAVIGATIONIMGS.length; i < len; i ++) {
			if(this.NAVIGATIONIMGS[i].type === type) {
				//ҵ
				this._addItemClsOrId(this.NAVIGATIONIMGS[i], naviItem);
				return true;
			}
		}
		//ûҵĬϵ
		var addItem = {};
		addItem.type = type;
		this._addItemClsOrId(addItem, naviItem);
		
		this.NAVIGATIONIMGS.push(addItem);
	},
	
	_addItemClsOrId : function(item, naviItem) {
		if(this.selectNaviImg.data("navicls")) {
			item.cls = this.selectNaviImg.data("navicls");
			item.id = "";
			naviItem.icon.switchClass(this.selectNaviImg.data("navicls"));
			naviItem.icon.addClass("fs_navigation_icon");
		} else if(this.selectNaviImg.data("naviid")) {
			item.cls = "";
			item.id = this.selectNaviImg.data("naviid");
			var url = FR.servletURL + '?op=fr_attach&cmd=ah_image&id='+this.selectNaviImg.data("naviid")+'&isAdjust=false';
			naviItem.icon.attr("src", url);
			naviItem.icon.removeClass();
			naviItem.icon.addClass("fs_navigation_icon");
		}
	},
	
	createToogleText : function(text, index, isHidden) {
		var self = this;
		var iconFoldCls = "fs_togglelist_foldicon";
		var iconUnFoldCls = "fs_togglelist_unfoldicon";
		var title = $("<div/>").addClass("fs_togglelist_title")
			.click(function() {
				var tableLayout = self.customNavdialog.getWidgetByName('toggletablelayout');
				if(tableLayout.isRowVisible(index+1)) {
					//
					tableLayout.setRowVisible(index+1, false);
					var icon = $('.'+iconUnFoldCls, title);
					icon.addClass(iconFoldCls);
					icon.removeClass(iconUnFoldCls);
				} else {
					//ʾ
					tableLayout.setRowVisible(index+1, true);
					var icon = $('.'+iconFoldCls, title);
					icon.addClass(iconUnFoldCls);
					icon.removeClass(iconFoldCls);
				}
				tableLayout.doLayout();
			});
		var text = $("<div/>").addClass("fs_togglelist_text").text(text)
			.appendTo(title);
		var icon = $("<div/>").addClass((isHidden === true) ? iconFoldCls : iconUnFoldCls)
			.appendTo(title);
			return title;
	},
	
	createNavigationItems : function() {
		var self = this;
		this.navimgItems = [];
		var navigationItems = FS.navigationItems;
		var items = [];
		for(var i = 0, len = navigationItems.length; i < len; i ++) {
			(function(index) {
				var item = {
					x : index * 70,
					y : 0,
					canEdit : true,
					clickFun : function() {
						var naviItem = this;
						self.customNavdialog = new FR.Dialog({
							title : FR.i18nText("EditIcon"),
							width : 315,
							confirm : true,
							height : 320,
							firstBtnMargin: 40,
                            closable: false,
							needSeparate : 8,
							onCancel : function() {
								if(naviItem.editIcon) {
									naviItem.eidtOverLayer.removeClass(naviItem.options.itemCanEditClickCls);
									naviItem.eidtOverLayer.removeClass(naviItem.options.itemCanEditOverCls);
									naviItem.editIcon.removeClass(naviItem.options.editIconCls);
								}
							},
							onOK : function() {
								if(naviItem.editIcon) {
									naviItem.eidtOverLayer.removeClass(naviItem.options.itemCanEditClickCls);
									naviItem.eidtOverLayer.removeClass(naviItem.options.itemCanEditOverCls);
									naviItem.editIcon.removeClass(naviItem.options.editIconCls);
								}
								if(!self.selectNaviImg) {
									return ;
								}
								self._checkDataExist(item, naviItem);
							},
							contentWidget : {
								type:'tablelayout',
								columnSize : [8, 281, 6],
					            scrollable: true,
								rowSize : [30, 110, 30, 110, 30, 110],
								widgetName : 'toggletablelayout',
								items:[
									[{
										el:$('<div/>')
									}, {
										el:self.createToogleText(FR.i18nText("Simple_FS"), 0)
									}, {
										el:$('<div/>')
									}],
									[{
										el:$('<div/>')
									}, {
										el:self._createSimpleItems(self.navimgItems)
									}, {
										el:$('<div/>')
									}],
									[{
										el:$('<div/>')
									}, {
										el:self.createToogleText(FR.i18nText("Colorful_FS"), 2, true)
									}, {
										el:$('<div/>')
									}],
									[{
										el:$('<div/>')
									}, {
										el:self._createColorfulItems(self.navimgItems)
									}, {
										el:$('<div/>')
									}],
									[{
										el:$('<div/>')
									}, {
										el:self.createToogleText(FR.i18nText("User-defined"), 4, true)
									}, {
										el:$('<div/>')
									}],
									[{
										el:$('<div/>')
									}, {
										el:self._createCustomImgUpload()
									}, {
										el:$('<div/>')
									}]
								]
							}
						});
						var tableLayout = self.customNavdialog.getWidgetByName('toggletablelayout'); 
						tableLayout.element.css('overflow-x', 'hidden');
						self.customNavdialog.setVisible(true);
						tableLayout.setRowVisible(3, false);
						tableLayout.setRowVisible(5, false);
						tableLayout.doLayout();
						self._makeImgGrouped(self.navimgItems);
						$('.fr-fileupload-image', self.customNavdialog.element).css('left', 0);
					}
				};
				$.extend(item, navigationItems[index]);
				items.push(item);
			})(i);
		}
		return items;
	},
	
	_showBackgroundImg : function() {
		var url = FR.servletURL + ((this.data.backgroundimg && this.data.backgroundimg != 'null') 
				?('?op=fr_attach&cmd=ah_image&id=' + this.data.backgroundimg + '&isAdjust=false') :'?op=resource&resource=/com/fr/fs/web/images/fsbg.jpg');
		$('.fs_csview_background').attr('src', url);
		$('.fs_csview_background')[0].onload = function() {
			$('.fs_csview_background').width(213).height(147);
		}
	},
	
	_makeItemInGroup : function(item, isStyle) {
		var self = this;
		item.css('position', 'relative');
		item.mouseover(function() {
			if(!item.selectIcon) {
				item.overLayer = $("<div/>").addClass("fs_csview_imgoverlayer").appendTo(item);
				item.selectIcon = $("<div/>").addClass("fs_csview_selecticon").appendTo(item);
                item.overLayer.width(item.width()).height(item.height());
			}
			item.selectIcon.addClass("fs_csview_selecticon");
			item.overLayer.addClass("fs_csview_imgoverlayer");
		}).mouseout(function() {
			if(item.selectIcon) {
				item.selectIcon.removeClass("fs_csview_selecticon");
				item.overLayer.removeClass("fs_csview_imgoverlayer");
			}
		}).click(function() {
			if(isStyle) {
				self._selectItem(item, true);
			} else {
				self._selectItem(item);
			}
		});
	},
	
	_removeSelect : function(item) {
		item.selectIcon.removeClass();
		item.overLayer.removeClass();
	},
	
	_selectItem : function(item, isStyle) {
		if(isStyle === true) {
			if(this.selectStyle) {
				this._removeSelect(this.selectStyle);
			}
			this.selectStyle = item;
		} else {
			if(this.selectNaviImg) {
				this._removeSelect(this.selectNaviImg);
			}
			this.selectNaviImg = item;
		}
		if(!item.selectIcon) {
			item.overLayer = $("<div/>").addClass("fs_csview_imgoverlayer").appendTo(item);
			item.selectIcon = $("<div/>").addClass("fs_csview_selecticon").appendTo(item);
            item.overLayer.width(item.width()).height(item.height());
		}
		item.selectIcon.addClass("fs_csview_selection_click");
		item.overLayer.addClass("fs_csview_imgoverlayer_click");
		
	},
	
	//2飬navigationһStyleһ
	_makeImgGrouped : function(items, isStyle) {
		var self = this;
		for(var i = 0, len = items.length; i < len; i ++) {
			(function(index) {
				var item = items[index];
				self._makeItemInGroup(item, isStyle);
			})(i);
		}
	},
	
	_showStyle : function(style) {
		for(var i = 0, len = this.styleItems.length; i < len;i ++) {
			if(this.styleItems[i].data("style") === style) {
				this._selectItem(this.styleItems[i], true);
			}
		}
	},
	
	popData : function() {
		var self = this;
		FR.ajax({
			url: FR.servletURL + '?op=fs_manager&cmd=fs_get_titleinfo',
			type: 'POST',
			complete : function(res, status) {
				self.data = FR.jsonDecode(res.responseText);
				if(self.data.isloginimg === true) {
					self.panel.getWidgetByName('loginpagetype').setValue(1, true);
				} else {
					self.panel.getWidgetByName('loginpagetype').setValue(2, true);
                    self.loginUrlText.setValue(self.data.loginurl);
                }
				self.fsTitleText.setValue(self.data.logintitle);
				self.homepageURLText.setValue(self.data.homepageurl);
				self.panel.getWidgetByName('hasNavigation').setValue(self.data.hasnavigation, true);
				self._showStyle(self.data.style);
				self._showBackgroundImg();
			}
		});
		this.NAVIGATIONIMGS = FR.jsonDecode(FS.config.navigationimgs);
	},
	
	saveData : function() {
		var jo = {};
		var isLoginImg = (this.panel.getWidgetByName('loginpagetype').getValue() === 1);
		jo.isLoginImg = isLoginImg;
		if(isLoginImg) {
			var attach = this.panel.getWidgetByName('loginimgupload').getValue();
			if(attach && attach.attach_id) {
				jo.loginImgId = attach.attach_id;
			}
		} else {
			var loginurl = this.loginUrlText.getValue();
			if(loginurl) {
				jo.loginUrl = loginurl;
			}
		}
		var loginTitle = this.fsTitleText.getValue();
		if(loginTitle) {
			jo.loginTitle = loginTitle;
		}
		var homepageURL = this.homepageURLText.getValue();
		if(homepageURL) {
			jo.homepageURL = homepageURL;
		}
		jo.hasNavigation = this.panel.getWidgetByName('hasNavigation').getValue();
		if(jo.hasNavigation && this.NAVIGATIONIMGS.length > 0) {
			jo.navigationImages4FS = this.NAVIGATIONIMGS;
		}
		jo.style = this.selectStyle ? this.selectStyle.data("style") : "darkblue";
		var attach = this.panel.getWidgetByName('backgroundimgupload').getValue();
		if(attach && attach.attach_id) {
			jo.backgroundImg = attach.attach_id;
		}
		FR.ajax({
			url: FR.servletURL + '?op=fs_manager&cmd=fs_set_titleinfo',
			type: 'POST',
			data: jo,
			complete : function(res, status) {
				if (status === 'success') {
					FR.Msg.toast(FR.i18nText("Successfully"));
				} 
			}
		});
	}
}