/*
 * Copyright (c) 2001-2014,FineReport Inc, All Rights Reserved.
 */

/**
 * Coder: Sean
 * Date: 14-7-10
 * Time: 1:08
 */
$(function() {
    //ɰ
    var $mask = $('<div class="fs-login-errmask"/>');
    //û
    var $username = $('input.fs-login-username').attr("placeholder", FR.i18nText('Username')).attr('title',FR.i18nText('Username'));
    //
    var $password = $('input.fs-login-password').attr("placeholder", FR.i18nText('Password')).attr('title',FR.i18nText('Password'));
    $('input').focus(function(){
        $(this).parent().addClass('fs-login-input-focus');
        $mask.hide();
    }).blur(function(){
        $(this).parent().removeClass('fs-login-input-focus');
    });
    //Ƿ񱣳ֵ¼״̬
    var $keep = $('span.fs-login-remember').text(FR.i18nText('Privilege-Keep_Login_State')).click(
        function(){
            $(this).toggleClass('fs-login-remember-selected');
        }
    );
    //¼ť
    $('a').text(FR.i18nText('Sign_In')).click(
        function(){
            signIN();
        }
    );
    //󶨻س
    $(document).keydown(function(e){
        if(e.keyCode===13){
            signIN();
        }
    });
    /**
     * ʼFSĵ¼ͼƬ
     */
    var initBackgroundImage = function () {
        var self = this;
        var ran = new Date().getTime() + "" + (Math.random() * 1000);
        FR.ajax({
            url: FR.servletURL + "?op=fs_load&cmd=getLoginImageInfo&_ran=" + ran,
            complete: function (res, status) {
                if (status == 'success') {
                    var loginInfo = FR.jsonDecode(res.responseText);
                    self.loginImgID = loginInfo.id;
                    self.loginImgWidth = parseInt(loginInfo.width);
                    self.loginImgHeight = parseInt(loginInfo.height);
                    self.locale = loginInfo.locale;

                    calcBackgroundScale();

                    var url = FR.servletURL
                        + ((self.loginImgID && self.loginImgID != 'null') ? ('?op=fr_attach&cmd=ah_image&id=' + self.loginImgID + '&isAdjust=false') : '?op=resource&resource=' + createDifferentLoginImageByLocale(self.locale));
                    if ($('body').length > 0) {
                        var loginImg = $('img.fs-login-img');
                        loginImg.attr("src", url);
                        loginImg.css({
                            "margin-left": "-" + self.imgOffsetX + "px",
                            "margin-top": "-" + self.imgOffsetY + "px",
                            width: self.loginImgWidth * self.scale + "px",
                            height: self.loginImgHeight * self.scale + "px"
                        });

                        var offset = $('#fs-login-scalebg').offset();
                        var loginScaleBgImg = $('img.fs-login-scalebg-img');
                        loginScaleBgImg.attr("src", url);
                        loginScaleBgImg.css({
                            "margin-left": "-" + (self.imgOffsetX + offset.left) + "px",
                            "margin-top": "-" + (self.imgOffsetY + offset.top) + "px",
                            width: self.loginImgWidth * self.scale + "px",
                            height: self.loginImgHeight * self.scale + "px"
                        });
                    }
                }
            }
        })
    };

    var createDifferentLoginImageByLocale = function(locale) {
        if (locale == 'en_US') {
            return "/com/fr/base/images/oem/signin_en_us.png";
        } else {
            return "/com/fr/base/images/oem/signin.png";
        }
    };

    var calcBackgroundScale = function () {
        var self = this;
        self.windowWidth = document.body.clientWidth;
        self.windowHeight = document.body.clientHeight;

        if (self.windowWidth / self.windowHeight >= self.loginImgWidth / self.loginImgHeight) {
            self.scale = self.windowWidth / self.loginImgWidth;
            self.imgOffsetX = 0;
            self.imgOffsetY = (self.loginImgHeight * self.scale - self.windowHeight) / 2;
        } else {
            self.scale = self.windowHeight / self.loginImgHeight;
            self.imgOffsetX = (self.loginImgWidth * self.scale - self.windowWidth) / 2;
            self.imgOffsetY = 0;
        }
    };

    var showErrorMsg = function($pos, msg){
        $mask.hide().insertAfter($pos).text(msg);
        $mask.click(function(){
            $(this).fadeOut();
            $pos.select();
        }).fadeIn();
    };

    var signIN = function(){
        $mask.hide();
        var user = $username.val();
        var pw = $password.val();
        //ûΪ
        if(FR.isEmpty(user)){
            showErrorMsg($username,FR.i18nText('Privilege-User_Can_Not_Be_Null'));
            return;
        }
        //Ϊ
        if(FR.isEmpty(pw)){
            showErrorMsg($password,FR.i18nText('Privilege-Password_Can_Not_Be_Null'));
            return;
        }
        FR.ajax({
            url : FR.servletURL + '?op=fs_load&cmd=login',
            data : FR.cjkEncodeDO({
                fsusername : encodeURIComponent(user),
                fspassword : encodeURIComponent(pw),
                fsremember : $keep.hasClass('fs-login-remember-selected')
            }),
            type : 'POST',
            async : false,
            error : function() {
                FR.Msg.toast("Error!");
            },
            complete : function(res, status) {
                if (res.responseText == "") {
                    showErrorMsg($username,FR.i18nText('Privilege-Authentication_failed'));
                    return;
                }
                var signResult = FR.jsonDecode(res.responseText);
                if (signResult.fail) {
                    //û벻ƥ
                    showErrorMsg($username,FR.i18nText('Privilege-Name_Not_Match_Password'));
                } else if (signResult.url) {
                    window.location.href = signResult.url;
                }
            }
        });
    };
    initBackgroundImage();
    $username.focus();
    $(window).resize(function(){
        calcBackgroundScale();
        $('img.fs-login-img').css({
            "margin-left": "-" + self.imgOffsetX +"px",
            "margin-top": "-" + self.imgOffsetY +"px",
            width: self.loginImgWidth * self.scale + "px",
            height: self.loginImgHeight * self.scale + "px"
        });
        var offset = $('#fs-login-scalebg').offset();
        $('img.fs-login-scalebg-img').css({
            "margin-left": "-" + (self.imgOffsetX + offset.left) + "px",
            "margin-top": "-" + (self.imgOffsetY + offset.top) + "px",
            width: self.loginImgWidth * self.scale + "px",
            height: self.loginImgHeight * self.scale + "px"
        });
    });
});
