/*
 * Decompiled with CFR 0.152.
 */
package com.fr.write.config;

import com.fr.cache.list.IntList;
import com.fr.data.core.DataCoreUtils;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dml.Select;
import com.fr.data.core.db.dml.Where;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.PropertiesUtils;
import com.fr.script.Calculator;
import com.fr.stable.FormulaProvider;
import com.fr.stable.StableUtils;
import com.fr.write.config.ColumnConfig;
import com.fr.write.config.DMLConfig;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class InsertConfig
extends DMLConfig {
    protected Map pstmtMap = new HashMap();

    public int dmlSubmit(Connection connection, Calculator calculator, Object[] objectArray, Map map) throws SQLException {
        int n2 = this.insert(connection, calculator, objectArray);
        if (this.getDialect(connection).isSupportQueryWhileInsert(n2)) {
            this.putSelfInCreaseColumn2Map(this, map, connection);
        }
        return n2;
    }

    public void simpleSubmit(Connection connection, Object[] objectArray) throws SQLException {
        this.insert(connection, null, objectArray);
    }

    private void putSelfInCreaseColumn2Map(DMLConfig dMLConfig, Map map, Connection connection) {
        if (map != null) {
            String string = null;
            string = this.findSelfIncreaseKey(dMLConfig);
            if (string != null) {
                Object object;
                int n2 = 0;
                int n3 = this.getColumnConfigCount();
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (!ComparatorUtils.equals(this.getColumnName(i2), string)) continue;
                    n2 = this.getColumnType(this.getColumnName(i2), connection);
                    break;
                }
                if ((object = this.findRecordInsertedBySelfIncreaseKey(string, n2, this.getDialect(connection), connection)) != null) {
                    map.putAll(this.findRecordByKeyAndValue(string, object, connection, this.getDialect(connection)));
                }
            }
        }
    }

    private String findSelfIncreaseKey(DMLConfig dMLConfig) {
        String string = null;
        string = this.findSelfIncreaseKeyByConfig();
        if (string == null) {
            string = this.findSelfIncreaseKeyByDefault(dMLConfig);
        }
        return string;
    }

    private String findSelfIncreaseKeyByConfig() {
        PropertiesUtils.initSequenceProperties();
        return PropertiesUtils.getSequenceProperties().getProperty(this.table.getName() + ".increaseKey");
    }

    private String findSelfIncreaseKeyByDefault(DMLConfig dMLConfig) {
        int n2 = dMLConfig.getColumnConfigCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            ColumnConfig columnConfig = dMLConfig.getColumnConfig(i2);
            if (!columnConfig.isKey()) continue;
            return columnConfig.getColumnName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map findRecordByKeyAndValue(String string, Object object, Connection connection, Dialect dialect) {
        PreparedStatement preparedStatement;
        ResultSet resultSet;
        HashMap<String, Object> hashMap;
        block6: {
            hashMap = new HashMap<String, Object>();
            String[] stringArray = DBUtils.checkInColumnNames(connection, DataCoreUtils.createSelectSQL(this.getTable(), null, dialect));
            if (stringArray.length == 0) {
                return hashMap;
            }
            Where where = new Where();
            where.addColumn(string, object);
            Select select = new Select(this.getTable(), where, dialect);
            resultSet = null;
            preparedStatement = null;
            try {
                preparedStatement = select.createPreparedStatement(connection);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block6;
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    hashMap.put(stringArray[i2], resultSet.getObject(stringArray[i2]));
                }
            }
            catch (SQLException sQLException) {
                try {
                    FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
                }
                catch (Throwable throwable) {
                    DBUtils.closeResultSet(resultSet);
                    DBUtils.closeStatement(preparedStatement);
                    throw throwable;
                }
                DBUtils.closeResultSet(resultSet);
                DBUtils.closeStatement(preparedStatement);
            }
        }
        DBUtils.closeResultSet(resultSet);
        DBUtils.closeStatement(preparedStatement);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Object findRecordInsertedBySelfIncreaseKey(String string, int n2, Dialect dialect, Connection connection) {
        Object object = null;
        PreparedStatement preparedStatement = null;
        try {
            String string2 = dialect.getIdentitySelectString(dialect.table2SQL(this.getTable()), string, n2);
            preparedStatement = connection.prepareStatement(string2);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            object = resultSet.getObject(1);
        }
        catch (Exception exception) {
            DBUtils.closeStatement(preparedStatement);
            catch (Throwable throwable) {
                DBUtils.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        DBUtils.closeStatement(preparedStatement);
        return object;
    }

    protected void closeStatement(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = (PreparedStatement)this.pstmtMap.get(connection);
        if (preparedStatement != null) {
            preparedStatement.executeBatch();
            preparedStatement.close();
            this.pstmtMap.remove(connection);
        }
    }

    private PreparedStatement getInsertedPreparedStatement(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = (PreparedStatement)this.pstmtMap.get(connection);
        if (preparedStatement == null) {
            preparedStatement = this.createInsertedPreparedStatement(connection);
            this.pstmtMap.put(connection, preparedStatement);
        }
        return preparedStatement;
    }

    public PreparedStatement createInsertedPreparedStatement(Connection connection) throws SQLException {
        IntList intList = new IntList();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Dialect dialect = this.getDialect(connection);
        int n2 = this.getColumnConfigCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.isIgnoreColumn(i2)) continue;
            arrayList.add(dialect.column2SQL(this.getColumnConfig(i2).getColumnName()));
            arrayList2.add("?");
            intList.add(i2);
        }
        if (arrayList2.isEmpty()) {
            return null;
        }
        String string = "INSERT INTO " + this.getTable().toStatementSQLString(dialect) + " (" + StableUtils.join(arrayList, ",") + ")" + " VALUES (" + StableUtils.join(arrayList2, ",") + ")";
        if (FRLogger.getLogger().isLoggable(Level.CONFIG)) {
            FRLogger.getLogger().info(string);
        }
        PreparedStatement preparedStatement = connection.prepareStatement(string.toString());
        return preparedStatement;
    }

    private boolean isIgnoreByEmptyFormula(int n2) {
        return this.isEmptyFormula(this.getColumnConfig(n2).getColumnValue());
    }

    private boolean isIgnoreColumn(int n2) {
        if (this.isIgnoreByEmptyFormula(n2)) {
            return true;
        }
        return this.isIgnoreInConfig(this.getColumnName(n2));
    }

    private boolean isIgnoreInConfig(String string) {
        if (string == null) {
            return false;
        }
        Properties properties = PropertiesUtils.getProperties("insertIgnoreColumn");
        String string2 = null;
        try {
            string2 = properties.getProperty(new String(this.table.getName().getBytes(), "ISO8859-1") + ".ignoreColumns");
            if (string2 != null) {
                string2 = new String(string2.getBytes("ISO8859-1"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
        if (string2 == null) {
            return false;
        }
        String[] stringArray = string2.split(",");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!ComparatorUtils.equals(string.compareToIgnoreCase(stringArray[i2].trim()), 0)) continue;
            return true;
        }
        return false;
    }

    private boolean isEmptyFormula(Object object) {
        if (!(object instanceof FormulaProvider)) {
            return false;
        }
        FormulaProvider formulaProvider = (FormulaProvider)object;
        return ComparatorUtils.equals("", formulaProvider.getPureContent());
    }

    private void fillInsertedPreparedStatement(PreparedStatement preparedStatement, Connection connection, Calculator calculator, Object[] objectArray) throws SQLException {
        int n2 = 0;
        for (int i2 = 0; i2 < this.getColumnConfigCount(); ++i2) {
            if (this.isIgnoreColumn(i2)) continue;
            DBUtils.applyColumnTypeValue(this.getDialect(connection), connection, this.getTable(calculator), this.getColumnName(i2), preparedStatement, n2 + 1, this.getColumnType(this.getColumnName(i2), connection), objectArray[i2]);
            ++n2;
        }
    }

    private int insert(Connection connection, Calculator calculator, Object[] objectArray) throws SQLException {
        PreparedStatement preparedStatement = this.getInsertedPreparedStatement(connection);
        this.fillInsertedPreparedStatement(preparedStatement, connection, calculator, objectArray);
        return preparedStatement.executeUpdate();
    }

    public String toString() {
        return "insert into " + this.table.toString() + " " + super.toString();
    }

    protected boolean isIgnoreUpdate(Calculator calculator) {
        return false;
    }
}

