/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.weblet;

import com.fr.base.FRContext;
import com.fr.general.GeneralUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.web.Weblet;
import com.fr.stable.web.WebletCreator;
import com.fr.web.utils.WebUtils;
import com.fr.web.weblet.EmbeddedTplFormlet;
import com.fr.web.weblet.Formlet;
import com.fr.web.weblet.TemplateFormlet;
import com.fr.web.weblet.WebClassFormlet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FormletCreator
implements WebletCreator {
    private static FormletCreator instance = null;
    private static final String[] CHECKPARAMPATH = new String[]{"formlet"};

    public static FormletCreator getInstance() {
        if (instance == null) {
            instance = new FormletCreator();
        }
        return instance;
    }

    private FormletCreator() {
    }

    public Weblet createWebletByRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "formlet");
        if (StringUtils.isEmpty(string)) {
            return null;
        }
        if (string.endsWith(".frm") || string.endsWith(".form")) {
            return new TemplateFormlet(string);
        }
        try {
            Object t2 = GeneralUtils.classForName(string).newInstance();
            if (t2 instanceof Formlet) {
                return new WebClassFormlet(string, (Formlet)t2);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(this.getClass().getName() + ":" + exception.getMessage());
        }
        return null;
    }

    public Weblet createEmbeddedWeblet(String string, Map map) throws Exception {
        if (string == null || !string.endsWith(".frm")) {
            return null;
        }
        return new EmbeddedTplFormlet(string, map);
    }

    public String[] getCheckParamPath() {
        return CHECKPARAMPATH;
    }
}

