/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.platform.dataModel;

import com.fr.base.FRContext;
import com.fr.privilege.PrivilegeManager;
import com.fr.privilege.providers.AuthenticationProvider;
import com.fr.privilege.providers.ldap.LDAPAuthenticationProvider;
import com.fr.web.platform.dataModel.PlatFormData;
import com.fr.web.platform.dataModel.ProviderDataModel;

public class ProviderLdapDataModel
extends ProviderDataModel {
    protected void loadProviderData(PlatFormData platFormData, AuthenticationProvider authenticationProvider) {
        LDAPAuthenticationProvider lDAPAuthenticationProvider = null;
        if (authenticationProvider instanceof LDAPAuthenticationProvider) {
            lDAPAuthenticationProvider = (LDAPAuthenticationProvider)authenticationProvider;
        }
        platFormData.put("url", lDAPAuthenticationProvider == null ? null : lDAPAuthenticationProvider.getUrl());
        platFormData.put("searchBase", lDAPAuthenticationProvider == null ? null : lDAPAuthenticationProvider.getSearchBase());
        platFormData.put("suffix", lDAPAuthenticationProvider == null ? null : lDAPAuthenticationProvider.getPrincipalSuffix());
        platFormData.put("sysName", lDAPAuthenticationProvider == null ? null : lDAPAuthenticationProvider.getSystemUsername());
        platFormData.put("sysPassword", lDAPAuthenticationProvider == null ? null : lDAPAuthenticationProvider.getSystemPassword());
        platFormData.put("authen", lDAPAuthenticationProvider == null ? null : lDAPAuthenticationProvider.getRoleAttribute());
        platFormData.put("context", lDAPAuthenticationProvider == null ? null : lDAPAuthenticationProvider.getContextFactory());
        platFormData.put("referral", lDAPAuthenticationProvider == null ? null : lDAPAuthenticationProvider.getReferral());
    }

    protected void store(PlatFormData platFormData) throws Exception {
        PrivilegeManager privilegeManager = PrivilegeManager.getInstance();
        LDAPAuthenticationProvider lDAPAuthenticationProvider = new LDAPAuthenticationProvider();
        lDAPAuthenticationProvider.setUrl(platFormData.getString("url"));
        lDAPAuthenticationProvider.setSearchBase(platFormData.getString("searchBase"));
        lDAPAuthenticationProvider.setPrincipalSuffix(platFormData.getString("suffix"));
        lDAPAuthenticationProvider.setSystemUsername(platFormData.getString("sysName"));
        lDAPAuthenticationProvider.setSystemPassword(platFormData.getString("sysPassword"));
        lDAPAuthenticationProvider.setRoleAttribute(platFormData.getString("authen"));
        lDAPAuthenticationProvider.setContextFactory(platFormData.getString("context"));
        lDAPAuthenticationProvider.setReferral(platFormData.getString("referral"));
        privilegeManager.setAuthenticationProvider(lDAPAuthenticationProvider);
        FRContext.getCurrentEnv().writeResource(PrivilegeManager.getInstance());
    }
}

