/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.factory;

import com.fr.base.FRContext;
import com.fr.general.FRLogger;
import com.fr.privilege.base.PrivilegeFilterRegister;
import com.fr.privilege.base.PrivilegeVote;
import com.fr.privilege.filter.PrivilegeFilterManager;
import com.fr.stable.StringUtils;
import com.fr.stable.web.Weblet;
import com.fr.stable.web.WebletCreator;
import com.fr.web.NoPrivilegeException;
import com.fr.web.utils.WebUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebletFactory {
    private static List<WebletCreator> webletCreatorList = new ArrayList<WebletCreator>();

    private WebletFactory() {
    }

    public static void registerWebletCreator(WebletCreator webletCreator) {
        if (webletCreatorList.contains(webletCreator)) {
            return;
        }
        webletCreatorList.add(webletCreator);
    }

    public static Weblet createWebletByRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Weblet weblet = null;
        for (WebletCreator object : webletCreatorList) {
            try {
                weblet = object.createWebletByRequest(httpServletRequest, httpServletResponse);
                if (weblet == null) continue;
                break;
            }
            catch (Exception string) {
                FRContext.getLogger().error(WebletFactory.class.getName() + "@" + string.getMessage());
            }
        }
        if (weblet != null) {
            PrivilegeVote privilegeVote = PrivilegeFilterRegister.doPrivilegeFilter(httpServletRequest);
            if (privilegeVote != null && !privilegeVote.isPermitted()) {
                String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "fr_check_url");
                String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "id");
                if (string2 != null) {
                    FRLogger.getLogger().setThreadLocal(string2);
                }
                if (StringUtils.isNotEmpty(string)) {
                    if (httpServletRequest.getSession().getAttribute(string) != null) {
                        httpServletRequest.getSession().removeAttribute(string);
                        return weblet;
                    }
                    if (PrivilegeFilterManager.remoteWebPreview.get(string) != null) {
                        PrivilegeFilterManager.remoteWebPreview.remove(string);
                        return weblet;
                    }
                }
                privilegeVote.action(httpServletRequest, httpServletResponse);
                throw new NoPrivilegeException();
            }
            return weblet;
        }
        return null;
    }

    public static Weblet createEmbeddedWeblet(String string) {
        return WebletFactory.createEmbeddedWeblet(string, new HashMap());
    }

    public static Weblet createEmbeddedWeblet(String string, Map map) {
        Weblet weblet = null;
        try {
            int n2 = webletCreatorList.size();
            for (int i2 = 0; i2 < n2 && (weblet = webletCreatorList.get(i2).createEmbeddedWeblet(string, map)) == null; ++i2) {
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(WebletFactory.class.getName() + ":" + exception.getMessage());
        }
        return weblet;
    }
}

