/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.upload;

import com.fr.base.ConfigManager;
import com.fr.base.FRContext;
import com.fr.web.core.upload.MemByteArrayBuffer;
import com.fr.web.core.upload.SmartFile;
import com.fr.web.core.upload.SmartFiles;
import com.fr.web.core.upload.SmartRequest;
import com.fr.web.core.upload.SmartUploadException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SmartUpload {
    protected byte[] m_binArray;
    protected HttpServletRequest m_request;
    protected HttpServletResponse m_response;
    protected ServletContext m_application;
    private int m_totalBytes = 0;
    private int m_currentIndex = 0;
    private int m_startData = 0;
    private int m_endData = 0;
    private String m_boundary = "";
    private long m_totalMaxFileSize = 0L;
    private long m_maxFileSize = 0L;
    private Vector m_deniedFilesList = new Vector();
    private Vector m_allowedFilesList = new Vector();
    private boolean m_denyPhysicalPath = false;
    private String m_contentDisposition = "";
    public static final int SAVE_AUTO = 0;
    public static final int SAVE_VIRTUAL = 1;
    public static final int SAVE_PHYSICAL = 2;
    private SmartFiles m_files = new SmartFiles();
    private SmartRequest m_formRequest = new SmartRequest();
    private static final int UPLOAD_BUF_SIZE = 0x400000;
    private String[] FileNames;

    public final void init(ServletConfig servletConfig) throws ServletException {
        this.m_application = servletConfig.getServletContext();
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.m_request = httpServletRequest;
        this.m_response = httpServletResponse;
    }

    public final void initialize(ServletConfig servletConfig, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        this.m_application = servletConfig.getServletContext();
        this.m_request = httpServletRequest;
        this.m_response = httpServletResponse;
    }

    public final void initialize(ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        this.m_application = servletContext;
        this.m_request = httpServletRequest;
        this.m_response = httpServletResponse;
    }

    public void upload() throws ServletException, IOException, SmartUploadException {
        int n2;
        boolean bl = false;
        long l2 = 0L;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        this.m_totalBytes = this.m_request.getContentLength();
        if (this.m_totalBytes < 0) {
            return;
        }
        byte[] byArray = new byte[0x400000];
        MemByteArrayBuffer memByteArrayBuffer = new MemByteArrayBuffer(0x400000);
        for (int i2 = 0; i2 < this.m_totalBytes; i2 += n2) {
            try {
                this.m_request.getInputStream();
                n2 = this.m_request.getInputStream().read(byArray);
                if (n2 <= 0) {
                    throw new SmartUploadException("Unable to upload.");
                }
                memByteArrayBuffer.append(byArray, 0, n2);
                continue;
            }
            catch (Exception exception) {
                throw new SmartUploadException("Unable to upload.");
            }
        }
        this.m_binArray = memByteArrayBuffer.getByteArray();
        while (!bl && this.m_currentIndex < this.m_totalBytes) {
            if (this.m_binArray[this.m_currentIndex] == 13) {
                bl = true;
            } else {
                this.m_boundary = this.m_boundary + (char)this.m_binArray[this.m_currentIndex];
            }
            ++this.m_currentIndex;
        }
        if (this.m_currentIndex == 1) {
            return;
        }
        ++this.m_currentIndex;
        while (this.m_currentIndex < this.m_totalBytes) {
            Object object;
            String string8 = this.getDataHeader();
            this.m_currentIndex += 2;
            boolean bl2 = string8.indexOf("filename") > 0;
            String string9 = this.getDataFieldValue(string8, "name");
            if (bl2) {
                string3 = this.getDataFieldValue(string8, "filename");
                string = this.getFileName(string3);
                string2 = this.getFileExt(string);
                string4 = this.getContentType(string8);
                string5 = this.getContentDisp(string8);
                string6 = this.getTypeMIME(string4);
                string7 = this.getSubTypeMIME(string4);
            }
            this.getDataSection();
            if (bl2 && string.length() > 0) {
                if (this.m_deniedFilesList.contains(string2)) {
                    throw new SecurityException("The extension of the file is denied to be uploaded (1015).");
                }
                if (!this.m_allowedFilesList.isEmpty() && !this.m_allowedFilesList.contains(string2)) {
                    throw new SecurityException("The extension of the file is not allowed to be uploaded (1010).");
                }
                if (this.m_maxFileSize > 0L && (long)(this.m_endData - this.m_startData + 1) > this.m_maxFileSize) {
                    throw new SecurityException("Size exceeded for this file : " + string + " (1105).");
                }
                if (this.m_totalMaxFileSize > 0L && (l2 += (long)(this.m_endData - this.m_startData + 1)) > this.m_totalMaxFileSize) {
                    throw new SecurityException("Total File Size exceeded (1110).");
                }
            }
            if (bl2) {
                object = new SmartFile();
                ((SmartFile)object).setParent(this);
                ((SmartFile)object).setFieldName(string9);
                ((SmartFile)object).setFileName(string);
                ((SmartFile)object).setFileExt(string2);
                ((SmartFile)object).setFilePathName(string3);
                ((SmartFile)object).setIsMissing(string3.length() == 0);
                ((SmartFile)object).setContentType(string4);
                ((SmartFile)object).setContentDisp(string5);
                ((SmartFile)object).setTypeMIME(string6);
                ((SmartFile)object).setSubTypeMIME(string7);
                if (string4.indexOf("application/x-macbinary") > 0) {
                    this.m_startData += 128;
                }
                ((SmartFile)object).setSize(this.m_endData - this.m_startData + 1);
                ((SmartFile)object).setStartData(this.m_startData);
                ((SmartFile)object).setEndData(this.m_endData);
                this.m_files.addFile((SmartFile)object);
            } else {
                object = new String(this.m_binArray, this.m_startData, this.m_endData - this.m_startData + 1);
                this.m_formRequest.putParameter(string9, (String)object);
            }
            if ((char)this.m_binArray[this.m_currentIndex + 1] == '-') break;
            this.m_currentIndex += 2;
        }
    }

    public int save(String string) throws ServletException, IOException, SmartUploadException {
        return this.save(string, 0);
    }

    public int save(String string, int n2) throws ServletException, IOException, SmartUploadException {
        int n3 = 0;
        if (string == null) {
            string = this.m_application.getRealPath("/");
        }
        if (string.indexOf("/") != -1) {
            if (string.charAt(string.length() - 1) != '/') {
                string = string + "/";
            }
        } else if (string.charAt(string.length() - 1) != '\\') {
            string = string + "\\";
        }
        this.FileNames = new String[this.m_files.getCount()];
        for (int i2 = 0; i2 < this.m_files.getCount(); ++i2) {
            if (this.m_files.getFile(i2).isMissing()) continue;
            this.m_files.getFile(i2).saveAs(string + this.m_files.getFile(i2).getFileName(), n2);
            this.FileNames[n3] = string + this.m_files.getFile(i2).getFileName();
            ++n3;
        }
        return n3;
    }

    public String[] getFileNames() {
        String[] stringArray = new String[this.FileNames.length];
        System.arraycopy(this.FileNames, 0, stringArray, 0, this.FileNames.length);
        return stringArray;
    }

    public int getSize() {
        return this.m_totalBytes;
    }

    public byte getBinaryData(int n2) {
        byte by;
        try {
            by = this.m_binArray[n2];
        }
        catch (Exception exception) {
            throw new ArrayIndexOutOfBoundsException("Index out of range (1005).");
        }
        return by;
    }

    public SmartFiles getFiles() {
        return this.m_files;
    }

    public SmartRequest getRequest() {
        return this.m_formRequest;
    }

    public void downloadFile(String string) throws ServletException, IOException, SmartUploadException {
        this.downloadFile(string, null, null);
    }

    public void downloadFile(String string, String string2) throws ServletException, IOException, SmartUploadException, SmartUploadException {
        this.downloadFile(string, string2, null);
    }

    public void downloadFile(String string, String string2, String string3) throws ServletException, IOException, SmartUploadException {
        this.downloadFile(string, string2, string3, 65000);
    }

    public void downloadFile(String string, String string2, String string3, int n2) throws ServletException, IOException, SmartUploadException {
        if (string == null) {
            throw new IllegalArgumentException("File '" + string + "' not found (1040).");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("File '" + string + "' not found (1040).");
        }
        if (!this.isVirtual(string) && this.m_denyPhysicalPath) {
            throw new SecurityException("Physical path is denied (1035).");
        }
        if (this.isVirtual(string)) {
            string = this.m_application.getRealPath(string);
        }
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        long l2 = file.length();
        int n3 = 0;
        byte[] byArray = new byte[n2];
        if (string2 == null) {
            this.m_response.setContentType("application/x-msdownload");
        } else if (string2.length() == 0) {
            this.m_response.setContentType("application/x-msdownload");
        } else {
            this.m_response.setContentType(string2);
        }
        this.m_response.setContentLength((int)l2);
        String string4 = this.m_contentDisposition = this.m_contentDisposition != null ? this.m_contentDisposition : "attachment;";
        if (string3 == null) {
            this.m_response.setHeader("Content-Disposition", this.m_contentDisposition + " filename=" + this.getFileName(string));
        } else if (string3.length() == 0) {
            this.m_response.setHeader("Content-Disposition", this.m_contentDisposition);
        } else {
            this.m_response.setHeader("Content-Disposition", this.m_contentDisposition + " filename=" + string3);
        }
        while ((long)n3 < l2) {
            int n4 = fileInputStream.read(byArray, 0, n2);
            n3 += n4;
            this.m_response.getOutputStream().write(byArray, 0, n4);
        }
        fileInputStream.close();
    }

    public void downloadField(ResultSet resultSet, String string, String string2, String string3) throws ServletException, IOException, SQLException {
        if (resultSet == null) {
            throw new IllegalArgumentException("The RecordSet cannot be null (1045).");
        }
        if (string == null) {
            throw new IllegalArgumentException("The columnName cannot be null (1050).");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("The columnName cannot be empty (1055).");
        }
        byte[] byArray = resultSet.getBytes(string);
        if (string2 == null) {
            this.m_response.setContentType("application/x-msdownload");
        } else if (string2.length() == 0) {
            this.m_response.setContentType("application/x-msdownload");
        } else {
            this.m_response.setContentType(string2);
        }
        this.m_response.setContentLength(byArray.length);
        if (string3 == null) {
            this.m_response.setHeader("Content-Disposition", "attachment;");
        } else if (string3.length() == 0) {
            this.m_response.setHeader("Content-Disposition", "attachment;");
        } else {
            this.m_response.setHeader("Content-Disposition", "attachment; filename=" + string3);
        }
        this.m_response.getOutputStream().write(byArray, 0, byArray.length);
    }

    public void fieldToFile(ResultSet resultSet, String string, String string2) throws ServletException, IOException, SmartUploadException, SQLException {
        try {
            int n2;
            if (this.m_application.getRealPath(string2) != null) {
                string2 = this.m_application.getRealPath(string2);
            }
            InputStream inputStream = resultSet.getBinaryStream(string);
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            while ((n2 = inputStream.read()) != -1) {
                fileOutputStream.write(n2);
            }
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new SmartUploadException("Unable to save file from the DataBase (1020).");
        }
    }

    private String getDataFieldValue(String string, String string2) {
        String string3 = "";
        String string4 = "";
        int n2 = 0;
        string3 = string2 + "=" + '\"';
        n2 = string.indexOf(string3);
        if (n2 > 0) {
            int n3;
            int n4 = n3 = n2 + string3.length();
            string3 = "\"";
            int n5 = string.indexOf(string3, n3);
            if (n4 > 0 && n5 > 0) {
                string4 = string.substring(n4, n5);
            }
        }
        return string4;
    }

    private String getFileExt(String string) {
        int n2 = 0;
        int n3 = 0;
        if (string == null) {
            return null;
        }
        n2 = string.lastIndexOf(46) + 1;
        n3 = string.length();
        String string2 = string.substring(n2, n3);
        if (string.lastIndexOf(46) > 0) {
            return string2;
        }
        return "";
    }

    private String getContentType(String string) {
        String string2 = "";
        String string3 = "";
        int n2 = 0;
        string2 = "Content-Type:";
        n2 = string.indexOf(string2) + string2.length();
        if (n2 != -1) {
            int n3 = string.length();
            string3 = string.substring(n2, n3);
        }
        return string3;
    }

    private String getTypeMIME(String string) {
        int n2 = 0;
        n2 = string.indexOf("/");
        if (n2 != -1) {
            return string.substring(1, n2);
        }
        return string;
    }

    private String getSubTypeMIME(String string) {
        int n2 = 0;
        n2 = string.indexOf("/") + 1;
        if (n2 != -1) {
            int n3 = string.length();
            return string.substring(n2, n3);
        }
        return string;
    }

    private String getContentDisp(String string) {
        String string2 = "";
        int n2 = 0;
        int n3 = 0;
        n2 = string.indexOf(":") + 1;
        n3 = string.indexOf(";");
        string2 = string.substring(n2, n3);
        return string2;
    }

    private void getDataSection() {
        int n2 = this.m_currentIndex;
        int n3 = 0;
        int n4 = this.m_boundary.length();
        this.m_startData = this.m_currentIndex;
        this.m_endData = 0;
        while (n2 < this.m_totalBytes) {
            if (this.m_binArray[n2] == (byte)this.m_boundary.charAt(n3)) {
                if (n3 == n4 - 1) {
                    this.m_endData = n2 - n4 + 1 - 3;
                    break;
                }
                ++n2;
                ++n3;
                continue;
            }
            ++n2;
            n3 = 0;
        }
        this.m_currentIndex = this.m_endData + n4 + 3;
    }

    private String getDataHeader() {
        int n2 = this.m_currentIndex;
        int n3 = 0;
        boolean bl = false;
        while (!bl) {
            if (this.m_binArray[this.m_currentIndex] == 13 && this.m_binArray[this.m_currentIndex + 2] == 13) {
                bl = true;
                n3 = this.m_currentIndex - 1;
                this.m_currentIndex += 2;
                continue;
            }
            ++this.m_currentIndex;
        }
        String string = "";
        try {
            string = new String(this.m_binArray, n2, n3 - n2 + 1, ConfigManager.getInstance().getServerCharset());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FRContext.getLogger().error(unsupportedEncodingException.getMessage());
        }
        return string;
    }

    private String getFileName(String string) {
        int n2 = 0;
        n2 = string.lastIndexOf(47);
        if (n2 != -1) {
            return string.substring(n2 + 1, string.length());
        }
        n2 = string.lastIndexOf(92);
        if (n2 != -1) {
            return string.substring(n2 + 1, string.length());
        }
        return string;
    }

    public void setDeniedFilesList(String string) throws ServletException, IOException, SQLException {
        if (string != null) {
            String string2 = "";
            for (int i2 = 0; i2 < string.length(); ++i2) {
                if (string.charAt(i2) == ',') {
                    if (!this.m_deniedFilesList.contains(string2)) {
                        this.m_deniedFilesList.addElement(string2);
                    }
                    string2 = "";
                    continue;
                }
                string2 = string2 + string.charAt(i2);
            }
            if (!"".equals(string2)) {
                this.m_deniedFilesList.addElement(string2);
            }
        } else {
            this.m_deniedFilesList = null;
        }
    }

    public void setAllowedFilesList(String string) {
        if (string != null) {
            String string2 = "";
            for (int i2 = 0; i2 < string.length(); ++i2) {
                if (string.charAt(i2) == ',') {
                    if (!this.m_allowedFilesList.contains(string2)) {
                        this.m_allowedFilesList.addElement(string2);
                    }
                    string2 = "";
                    continue;
                }
                string2 = string2 + string.charAt(i2);
            }
            if (!string2.equals("")) {
                this.m_allowedFilesList.addElement(string2);
            }
        } else {
            this.m_allowedFilesList = null;
        }
    }

    public void setDenyPhysicalPath(boolean bl) {
        this.m_denyPhysicalPath = bl;
    }

    public void setForcePhysicalPath(boolean bl) {
    }

    public void setContentDisposition(String string) {
        this.m_contentDisposition = string;
    }

    public void setTotalMaxFileSize(long l2) {
        this.m_totalMaxFileSize = l2;
    }

    public void setMaxFileSize(long l2) {
        this.m_maxFileSize = l2;
    }

    protected String getPhysicalPath(String string, int n2) throws IOException {
        File file;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        boolean bl = false;
        string4 = System.getProperty("file.separator");
        if (string == null) {
            throw new IllegalArgumentException("There is no specified destination file (1140).");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("There is no specified destination file (1140).");
        }
        if (string.lastIndexOf("\\") >= 0) {
            string2 = string.substring(0, string.lastIndexOf("\\"));
            string3 = string.substring(string.lastIndexOf("\\") + 1);
        }
        if (string.lastIndexOf("/") >= 0) {
            string2 = string.substring(0, string.lastIndexOf("/"));
            string3 = string.substring(string.lastIndexOf("/") + 1);
        }
        if ((file = new File(string2 = string2.length() != 0 ? string2 : "/")).exists()) {
            bl = true;
        }
        if (n2 == 0) {
            if (this.isVirtual(string2)) {
                string2 = (string2 = this.m_application.getRealPath(string2)).endsWith(string4) ? string2 + string3 : string2 + string4 + string3;
                return string2;
            }
            if (bl) {
                if (this.m_denyPhysicalPath) {
                    throw new IllegalArgumentException("Physical path is denied (1125).");
                }
                return string;
            }
            throw new IllegalArgumentException("This path does not exist (1135).");
        }
        if (n2 == 1) {
            if (this.isVirtual(string2)) {
                string2 = (string2 = this.m_application.getRealPath(string2)).endsWith(string4) ? string2 + string3 : string2 + string4 + string3;
                return string2;
            }
            if (bl) {
                throw new IllegalArgumentException("The path is not a virtual path.");
            }
            throw new IllegalArgumentException("This path does not exist (1135).");
        }
        if (n2 == 2) {
            if (bl) {
                if (this.m_denyPhysicalPath) {
                    throw new IllegalArgumentException("Physical path is denied (1125).");
                }
                return string;
            }
            if (this.isVirtual(string2)) {
                throw new IllegalArgumentException("The path is not a physical path.");
            }
            throw new IllegalArgumentException("This path does not exist (1135).");
        }
        return null;
    }

    public void uploadInFile(String string) throws IOException, SmartUploadException {
        int n2;
        int n3 = 0;
        if (string == null) {
            throw new IllegalArgumentException("There is no specified destination file (1025).");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("There is no specified destination file (1025).");
        }
        if (!this.isVirtual(string) && this.m_denyPhysicalPath) {
            throw new SecurityException("Physical path is denied (1035).");
        }
        n3 = this.m_request.getContentLength();
        this.m_binArray = new byte[n3];
        for (int i2 = 0; i2 < n3; i2 += n2) {
            try {
                n2 = this.m_request.getInputStream().read(this.m_binArray, i2, n3 - i2);
                continue;
            }
            catch (Exception exception) {
                throw new SmartUploadException("Unable to upload.");
            }
        }
        if (this.isVirtual(string)) {
            string = this.m_application.getRealPath(string);
        }
        try {
            File file = new File(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(this.m_binArray);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new SmartUploadException("The Form cannot be saved in the specified file (1030).");
        }
    }

    private boolean isVirtual(String string) {
        if (this.m_application.getRealPath(string) != null) {
            File file = new File(this.m_application.getRealPath(string));
            return file.exists();
        }
        return false;
    }
}

