/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.process.reportprocess;

import com.fr.base.FRContext;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.data.dao.CommonFieldColumnMapper;
import com.fr.data.dao.FieldColumnMapper;
import com.fr.data.dao.ObjectTableMapper;
import com.fr.data.dao.PrimaryKeyFCMapper;
import com.fr.general.DateUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.ArrayUtils;
import com.fr.web.core.process.ProcessUtils;
import com.fr.web.core.process.reportprocess.ProcessElement;
import com.fr.web.core.process.reportprocess.ProcessNode;
import com.fr.web.core.process.reportprocess.ProcessTask;
import com.fr.web.core.process.reportprocess.dao.ProcessNodeDAO;
import com.fr.web.core.process.reportprocess.dao.ProcessTaskDAO;
import com.fr.web.core.process.reportprocess.dao.ReportProcessDAO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class ReportProcess
implements ProcessElement {
    public static final String NODES_ID = "nodesId";
    private long id = -1L;
    private String name;
    private long creatorId;
    private Date createTime;
    private String describe;
    private List nodes = null;
    private String nodesId;
    public static final ObjectTableMapper TABLE_MAPPER = new ObjectTableMapper(ReportProcess.class, new Table("FR_REPORT_PROCESS"), new FieldColumnMapper[]{new PrimaryKeyFCMapper("id", -5, new ColumnSize(8)), new CommonFieldColumnMapper("name", 12, new ColumnSize(50), false), new CommonFieldColumnMapper("creatorId", -5, new ColumnSize(8), false), new CommonFieldColumnMapper("nodesId", 12, new ColumnSize(255), false), new CommonFieldColumnMapper("createTime", 93, new ColumnSize(10), false), new CommonFieldColumnMapper("describe", 12, new ColumnSize(1024), true)}, (String[][])new String[][]{{"id"}}, null);

    public ReportProcess() {
    }

    public ReportProcess(String string, long l2, String string2, String string3) {
        this.name = string;
        this.creatorId = l2;
        this.nodesId = string2;
        this.describe = string3;
        this.createTime = new Date();
    }

    public ReportProcess(JSONObject jSONObject) {
        this.parseJSON(jSONObject);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long l2) {
        this.id = l2;
    }

    public long getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(long l2) {
        this.creatorId = l2;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date date) {
        this.createTime = date;
    }

    public String getDescribe() {
        return this.describe;
    }

    public void setDescribe(String string) {
        this.describe = string;
    }

    public String getNodesId() {
        return this.nodesId;
    }

    public void setNodesId(String string) {
        this.nodesId = string;
    }

    public String[] getNodesArr() {
        if (this.nodesId == null) {
            return new String[0];
        }
        return this.nodesId.split("##");
    }

    public int getNodeCount() {
        return this.getNodesArr().length;
    }

    public ProcessNode getNode(int n2) {
        if (n2 < 0) {
            return null;
        }
        if (this.nodes == null) {
            String[] stringArray = this.getNodesArr();
            if (n2 >= stringArray.length) {
                return null;
            }
            long l2 = ProcessUtils.getIdFromStr(stringArray[n2]);
            try {
                return ProcessNodeDAO.getInstance().findByID(l2);
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (n2 < this.nodes.size()) {
            return (ProcessNode)this.nodes.get(n2);
        }
        return null;
    }

    public JSONObject createJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("id", this.id);
        jSONObject.put("name", this.name);
        jSONObject.put("creatorName", ProcessUtils.getUserName(this.creatorId));
        jSONObject.put("department", ProcessUtils.getUserDepartmentName(this.creatorId));
        jSONObject.put("creatorId", this.creatorId);
        if (this.createTime != null) {
            jSONObject.put("createTime", DateUtils.getDate2Str("yyyy-MM-dd HH:mm:ss", this.createTime));
        }
        jSONObject.put("describe", this.describe);
        return jSONObject;
    }

    public JSONObject createDetailedJSONObject() throws Exception {
        JSONObject jSONObject = this.createJSONObject();
        JSONArray jSONArray = new JSONArray();
        if (this.nodes == null || this.nodes.isEmpty()) {
            this.initNodes();
        }
        for (int i2 = 0; i2 < this.nodes.size(); ++i2) {
            ProcessNode processNode = (ProcessNode)this.nodes.get(i2);
            jSONArray.put(processNode.createJSONObject());
        }
        jSONObject.put("nodes", jSONArray);
        return jSONObject;
    }

    public void parseJSON(JSONObject jSONObject) {
        if (jSONObject.has("name")) {
            this.name = jSONObject.optString("name");
        }
        if (jSONObject.has("describe")) {
            this.describe = jSONObject.optString("describe");
        }
        if (jSONObject.has(NODES_ID)) {
            this.nodesId = jSONObject.optString(NODES_ID);
        }
    }

    public long[] getAllRelatedUsers() {
        String[] stringArray = this.getNodesArr();
        long[] lArray = new long[]{};
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                long l2 = ProcessUtils.getIdFromStr(stringArray[i2]);
                ProcessNode processNode = ProcessNodeDAO.getInstance().findByID(l2);
                lArray = ArrayUtils.addAll(lArray, processNode.getAllRelatedUsers());
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        return lArray;
    }

    private void initNodes() {
        this.nodes = new ArrayList();
        try {
            String[] stringArray = this.getNodesArr();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                long l2 = ProcessUtils.getIdFromStr(stringArray[i2]);
                this.nodes.add(ProcessNodeDAO.getInstance().findByID(l2));
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
    }

    public void clear() {
        try {
            ReportProcessDAO.getInstance().deleteByID(this.id);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        String[] stringArray = this.getNodesArr();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            long l2 = ProcessUtils.getIdFromStr(stringArray[i2]);
            try {
                ProcessNodeDAO.getInstance().deleteByID(l2);
                continue;
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage());
            }
        }
        try {
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            hashMap.put("processId", this.id);
            List<ProcessTask> list = ProcessTaskDAO.getInstance().listByFieldValue("processId", this.id);
            for (ProcessTask processTask : list) {
                processTask.clear();
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return null;
    }
}

