/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.chwriter;

import com.fr.base.BaseUtils;
import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.ResultFormula;
import com.fr.base.Style;
import com.fr.base.TextFormat;
import com.fr.form.ui.MultiFileEditor;
import com.fr.form.ui.Widget;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.report.cell.CellElement;
import com.fr.report.core.A.J;
import com.fr.report.worksheet.CalculatableReport;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.ColumnRow;
import com.fr.stable.html.Tag;
import com.fr.stable.web.Repository;
import com.fr.web.RepositoryHelper;
import com.fr.web.core.chwriter.CellHtmlWriter;
import com.fr.web.core.chwriter.HtmlWriteCellBox;
import com.fr.web.utils.WebUtils;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;

public class EditableCellWriter
extends CellHtmlWriter {
    private CalculatableReport report;

    public EditableCellWriter(Repository repository, int n2, CalculatableReport calculatableReport) {
        super(repository, n2, calculatableReport.getReportSettings());
        this.report = calculatableReport;
    }

    protected ColumnRow getColumnRowOfBox(HtmlWriteCellBox htmlWriteCellBox) {
        Object[] objectArray = htmlWriteCellBox.getHtmlID();
        if (!ArrayUtils.isEmpty(objectArray) && htmlWriteCellBox.isBoxUSELESS()) {
            return null;
        }
        objectArray = EditableCellWriter.retriveCellElementPositions(htmlWriteCellBox.getCell());
        return objectArray[0];
    }

    protected void columnRowPosition(ColumnRow columnRow) {
        super.columnRowPosition(columnRow);
        this.resTag.attr("row", "" + columnRow.getRow()).attr("col", "" + columnRow.getColumn());
    }

    protected boolean shouldDrawContent(Object object, CellElement cellElement, Calculator calculator, Tag tag) {
        return !(this.getWidgetOfCell(cellElement) instanceof MultiFileEditor);
    }

    protected Widget getWidgetOfCell(CellElement cellElement) {
        return null;
    }

    protected boolean isVisible(HtmlWriteCellBox htmlWriteCellBox) {
        return !htmlWriteCellBox.isBoxUSELESS();
    }

    protected boolean shouldDrawBackground(HtmlWriteCellBox htmlWriteCellBox) {
        return this.cellHeight > 0 && this.cellWidth > 0;
    }

    protected void processFormula(CellElement cellElement, Formula formula) {
        if (formula instanceof ResultFormula) {
            this.writeFMInfo(cellElement, (ResultFormula)formula);
        }
    }

    protected void writeLocationID(ColumnRow columnRow) {
        super.writeLocationID(columnRow);
        this.resTag.attr("row", columnRow.getRow() + "").attr("col", columnRow.getColumn() + "");
    }

    protected void writeFMInfo(CellElement cellElement, ResultFormula resultFormula) {
        this.resTag.attr("fm", resultFormula.getTransferContent().substring(1));
    }

    protected void processUnwrappedRawValue(CellElement cellElement, Object object) {
        Style style = cellElement.getStyle();
        Format format = style.getFormat();
        if (object instanceof Date && format == null) {
            format = FRContext.getDefaultValues().getDateTimeFormat();
        } else if (format == null && object instanceof String && ((String)object).toString().length() > 0) {
            format = TextFormat.getInstance();
        }
        if (format instanceof SimpleDateFormat) {
            this.resTag.attr("fmt", (style.getFormat() == null ? "DT" : "D") + ((SimpleDateFormat)format).toPattern().trim());
        } else if (format instanceof DecimalFormat) {
            this.resTag.attr("fmt", ((DecimalFormat)format).toPattern().trim());
        } else if (format == TextFormat.getInstance()) {
            this.resTag.attr("fmt", "T");
        }
        J j2 = this.report.getFormulaRelation(ColumnRow.valueOf(cellElement.getColumn(), cellElement.getRow()));
        if (j2 != null && j2.D() != null) {
            this.resTag.attr("frs", "0");
        }
        try {
            Object object2 = WebUtils.object2JSONable(object, this.cellWidth, this.cellHeight);
            if (object2 != null) {
                if (object2 instanceof JSONObject && ((JSONObject)object2).has("attach_id")) {
                    RepositoryHelper.getSessionIDInfor(this.repo).addImageID((String)((JSONObject)object2).get("attach_id"));
                }
                this.resTag.attr("cv", BaseUtils.jsonEncode(object2));
            }
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage(), jSONException);
        }
    }

    protected void processOtherAttributes(HtmlWriteCellBox htmlWriteCellBox) {
        if (!this.cellGUIAttr.isPreviewContent()) {
            this.resTag.cls("cehide");
        }
    }
}

