/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.chwriter;

import com.fr.base.BaseUtils;
import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.GraphHelper;
import com.fr.base.Painter;
import com.fr.base.Style;
import com.fr.base.Utils;
import com.fr.base.background.ColorBackground;
import com.fr.cache.Attachment;
import com.fr.data.DataUtils;
import com.fr.form.ui.DateEditor;
import com.fr.form.ui.DependProvider;
import com.fr.form.ui.MultiFileEditor;
import com.fr.form.ui.Widget;
import com.fr.general.DateUtils;
import com.fr.general.FArray;
import com.fr.general.FRFont;
import com.fr.js.NameJavaScriptGroup;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.page.ReportSettingsProvider;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.ResultCellElement;
import com.fr.report.cell.cellattr.CellGUIAttr;
import com.fr.report.core.PaintUtils;
import com.fr.report.stable.PolyBlockAttr;
import com.fr.script.Calculator;
import com.fr.stable.CodeUtils;
import com.fr.stable.ColumnRow;
import com.fr.stable.StringUtils;
import com.fr.stable.html.Html;
import com.fr.stable.html.Tag;
import com.fr.stable.html.TextHtml;
import com.fr.stable.unit.PT;
import com.fr.stable.web.Repository;
import com.fr.web.RepositoryHelper;
import com.fr.web.core.chwriter.HtmlWriteCellBox;
import com.fr.web.core.reportcase.WebReportCase;
import com.fr.web.core.utils.ReportHTMLWriterUtils;
import com.fr.web.core.utils.StyleWithSize;
import java.awt.Image;
import java.awt.Rectangle;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class CellHtmlWriter {
    protected Repository repo;
    protected Tag resTag;
    protected int cellWidth;
    protected int cellHeight;
    protected CellGUIAttr cellGUIAttr;
    protected boolean heavy = false;
    private boolean isQuickModel = false;
    protected int reportIndex;
    protected int tableID = 0;
    protected ReportSettingsProvider reportSettings;

    public CellHtmlWriter(Repository repository, int n2, ReportSettingsProvider reportSettingsProvider) {
        this.repo = repository;
        this.reportIndex = n2;
        this.reportSettings = reportSettingsProvider;
    }

    public static ColumnRow[] retriveCellElementPositions(CellElement cellElement) {
        if (cellElement.getColumnSpan() <= 1 && cellElement.getRowSpan() <= 1) {
            return new ColumnRow[]{ColumnRow.valueOf(cellElement.getColumn(), cellElement.getRow())};
        }
        int n2 = cellElement.getRow();
        int n3 = cellElement.getColumn();
        int n4 = cellElement.getRowSpan();
        int n5 = cellElement.getColumnSpan();
        ArrayList<ColumnRow> arrayList = new ArrayList<ColumnRow>();
        for (int i2 = n2; i2 < n2 + n4; ++i2) {
            for (int i3 = n3; i3 < n3 + n5; ++i3) {
                arrayList.add(ColumnRow.valueOf(i3, i2));
            }
        }
        return arrayList.toArray(new ColumnRow[arrayList.size()]);
    }

    public Tag cell2Tag(HtmlWriteCellBox htmlWriteCellBox, WebReportCase webReportCase, Rectangle rectangle, Rectangle rectangle2, Calculator calculator) throws JSONException {
        ResultCellElement resultCellElement = htmlWriteCellBox.getCell();
        this.initCellTagAndFillColumnRowSpan(rectangle);
        this.hideCellWhenNeed(webReportCase.getColumnPixWidth(resultCellElement.getColumn()));
        this.calculateCellWidthAndHeight(webReportCase, rectangle2);
        this.makeSureCellGUIAtrrNotEmpty(resultCellElement);
        Tag tag = this.dealWithHyperlinkGroup(resultCellElement, this.resTag);
        ColumnRow columnRow = this.createAndMarkColumnRow(htmlWriteCellBox);
        this.calculateTooltip(calculator, webReportCase);
        Object object = this.calculateRawValue(resultCellElement, calculator);
        if (this.shouldDrawBackground(htmlWriteCellBox)) {
            ArrayList arrayList = new ArrayList();
            ReportHTMLWriterUtils.style2Css4Background(new StyleWithSize(resultCellElement.getStyle(), this.cellWidth, this.cellHeight), this.resTag, this.cellGUIAttr, this.repo, object, arrayList);
        }
        if (this.shouldDrawContent(object, resultCellElement, calculator, tag)) {
            this.dealBeforeDrawContent(htmlWriteCellBox);
            this.drawContent(htmlWriteCellBox, object, tag);
        }
        this.dealWidgetWhenNotEmpty(resultCellElement, columnRow, object, calculator);
        this.processOtherAttributes(htmlWriteCellBox);
        this.anyElse(htmlWriteCellBox);
        calculator.remove("$$$");
        return this.resTag;
    }

    public int getReportIndex() {
        return this.reportIndex;
    }

    private int getMode() {
        if (this.cellGUIAttr == null || this.cellGUIAttr.getAdjustMode() == 3) {
            return this.reportSettings.getShrinkToFitMode();
        }
        return this.cellGUIAttr.getAdjustMode();
    }

    private void initCellTagAndFillColumnRowSpan(Rectangle rectangle) {
        this.resTag = new Tag("td");
        if (rectangle.width > 1) {
            this.resTag.attr("colSpan", rectangle.width + "");
        }
        if (rectangle.height > 1) {
            this.resTag.attr("rowSpan", rectangle.height + "");
        }
    }

    private void hideCellWhenNeed(int n2) {
        if (n2 == 0) {
            this.resTag.css("display", "none");
        }
    }

    private void calculateCellWidthAndHeight(WebReportCase webReportCase, Rectangle rectangle) {
        int n2;
        this.cellHeight = 0;
        int n3 = rectangle.y;
        for (n2 = 0; n2 < rectangle.height; ++n2) {
            this.cellHeight += webReportCase.getRowPixHeight(n3);
            ++n3;
        }
        this.cellWidth = 0;
        n3 = rectangle.x;
        for (n2 = 0; n2 < rectangle.width; ++n2) {
            this.cellWidth += webReportCase.getColumnPixWidth(n3);
            ++n3;
        }
        if (this.repo.getBrowser().isUseTDWidthInTable()) {
            this.resTag.attr("width", this.cellWidth + "");
        }
    }

    private void makeSureCellGUIAtrrNotEmpty(CellElement cellElement) {
        this.cellGUIAttr = cellElement.getCellGUIAttr();
        if (this.cellGUIAttr == null) {
            this.cellGUIAttr = CellGUIAttr.DEFAULT_CELLGUIATTR;
        }
    }

    private ColumnRow createAndMarkColumnRow(HtmlWriteCellBox htmlWriteCellBox) {
        ColumnRow columnRow = this.getColumnRowOfBox(htmlWriteCellBox);
        if (columnRow != null) {
            this.writeLocationID(columnRow);
            this.columnRowPosition(columnRow);
        }
        return columnRow;
    }

    public Object calculateRawValue(CellElement cellElement, Calculator calculator) {
        Object object = this.getRawValue(cellElement);
        if (object instanceof Formula) {
            this.processFormula(cellElement, (Formula)object);
            object = this.dealWithValue4Formula((Formula)object);
        }
        object = this.unwrapLobs(cellElement, object);
        this.processUnwrappedRawValue(cellElement, object);
        calculator.set("$$$", object);
        return object;
    }

    private void calculateTooltip(Calculator calculator, WebReportCase webReportCase) {
        String string = this.cellGUIAttr.getTooltipText();
        if (string != null) {
            this.resTag.attr("title", string);
        }
    }

    public boolean showUseHeavy(CellElement cellElement) {
        int n2 = cellElement.getCellGUIAttr() == null || cellElement.getCellGUIAttr().getAdjustMode() == 3 ? this.reportSettings.getShrinkToFitMode() : cellElement.getCellGUIAttr().getAdjustMode();
        return n2 != 1 && n2 != 2 || this.isHeavy();
    }

    protected void drawContent(HtmlWriteCellBox htmlWriteCellBox, Object object, Tag tag) {
        ResultCellElement resultCellElement = htmlWriteCellBox.getCell();
        Style style = resultCellElement.getStyle();
        Object object2 = this.unwrapLobs(resultCellElement, this.getDisplayValue(resultCellElement, object));
        int n2 = Math.max(this.getHeightOfValueWrapper(htmlWriteCellBox), 0) - 1;
        Tag tag2 = this.getValueWrapper(tag, style, resultCellElement, n2);
        if (object2 instanceof Formula) {
            this.processFormula(resultCellElement, (Formula)object2);
            object2 = this.dealWithValue4Formula((Formula)object2);
        }
        if (this.shouldBeDisplayAsVerticalText(style, object2)) {
            this.displayVerticalText(style, object2, tag2, n2);
        } else if (object2 != null) {
            if (style.getRotation() != 0) {
                this.displayVerticalText(style, object2, tag2, n2);
            } else {
                this.displayNormalText(resultCellElement, object2, tag2, n2);
            }
        }
    }

    protected boolean shouldBeDisplayAsVerticalText(Style style, Object object) {
        FRFont fRFont = style.getFRFont();
        int n2 = GraphHelper.getLineStyleSize(fRFont.getUnderline());
        return style.getVerticalText() == 1 || style.getTextStyle() == 3 || style.getTextStyle() == 2 || BaseUtils.getAlignment4Horizontal(style) == 6 || object instanceof Painter || object instanceof Image || object instanceof Attachment || this.cellGUIAttr.isShowAsImage() || this.cellGUIAttr.isShowAsDownload() || n2 > 1;
    }

    protected void displayVerticalText(Style style, Object object, Tag tag, int n2) {
        if (object instanceof String && this.cellGUIAttr.isShowAsHTML()) {
            object = PaintUtils.createHTMLContentBufferedImage((String)object, new Rectangle(this.cellWidth, this.cellHeight), 0, 0);
        }
        if (this.painterAsImage()) {
            ReportHTMLWriterUtils.value2PaintableTag4Print(object, new StyleWithSize(style, this.cellWidth, n2), tag, this.repo);
        } else {
            ReportHTMLWriterUtils.value2PaintableTag(object, new StyleWithSize(style, this.cellWidth, n2), tag, this.repo);
        }
        style = style.derivePadding(0, 0);
    }

    protected void displayNormalText(CellElement cellElement, Object object, Tag tag, int n2) {
        Html html = this.getHtmlValue(cellElement, object, tag, n2);
        if (html != null) {
            tag.sub(html);
        }
    }

    private Html getHtmlValue(CellElement cellElement, Object object, Tag tag, int n2) {
        Object object2;
        Style style = cellElement.getStyle();
        String string = null;
        Widget widget = this.getWidgetOfCell(cellElement);
        if (this.cellGUIAttr.isShowAsHTML()) {
            tag.attr("showAsHtml", "true");
            if (widget == null || widget.isEditor()) {
                object2 = Utils.objectToString(object);
                Pattern pattern = Pattern.compile("<script[^>]*>[\\d\\D]*?</script>", 2);
                Matcher matcher = pattern.matcher((CharSequence)object2);
                string = matcher.replaceAll("");
            }
        } else if (widget == null || widget.isEditor()) {
            object2 = Style.valueToText(object, cellElement.getStyle().getFormat());
            style = Style.modCellStyleString(this.cellWidth, n2, (String)object2, style, this.repo.getResolution());
            string = CodeUtils.htmlEncode((CharSequence)object2);
        }
        object2 = null;
        if (StringUtils.isNotBlank(string)) {
            object2 = new TextHtml(string);
            if (style.getFRFont().isSubscript()) {
                object2 = new Tag("sub").sub((Html)object2);
            } else if (style.getFRFont().isSuperscript()) {
                object2 = new Tag("sup").sub((Html)object2);
            }
        }
        return object2;
    }

    private void dealWidgetWhenNotEmpty(CellElement cellElement, ColumnRow columnRow, Object object, Calculator calculator) {
        Widget widget = this.getWidgetOfCell(cellElement);
        if (widget != null) {
            this.processWidget(cellElement, widget, object, columnRow, calculator);
        }
    }

    protected boolean painterAsImage() {
        return false;
    }

    protected void columnRowPosition(ColumnRow columnRow) {
        this.resTag.attr("id", columnRow + "-" + this.reportIndex + "-" + this.tableID);
    }

    protected void writeLocationID(ColumnRow columnRow) {
        this.resTag.attr("id", columnRow + "-" + this.reportIndex + "-" + this.tableID);
    }

    protected abstract ColumnRow getColumnRowOfBox(HtmlWriteCellBox var1);

    protected abstract boolean isVisible(HtmlWriteCellBox var1);

    protected boolean shouldDrawBackground(HtmlWriteCellBox htmlWriteCellBox) {
        return this.isVisible(htmlWriteCellBox);
    }

    protected abstract boolean shouldDrawContent(Object var1, CellElement var2, Calculator var3, Tag var4);

    public int getHeightOfValueWrapper(HtmlWriteCellBox htmlWriteCellBox) {
        return this.cellHeight;
    }

    private Tag getValueWrapper(Tag tag, Style style, CellElement cellElement, int n2) {
        Tag tag2 = tag;
        boolean bl = this.showUseHeavy(cellElement);
        if (bl) {
            Tag tag3 = new Tag("div").cls("fx").css("height", n2 + "px");
            if (!this.skipValueWrapper(cellElement)) {
                tag.sub(tag3);
            }
            double d2 = PT.pt2pix(style.getPaddingLeft() + style.getPaddingRight() == 2 ? 0 : style.getPaddingRight(), this.repo.getResolution());
            d2 += (double)((style.getBorderLeftWidth() + style.getBorderRightWidth()) / 2);
            tag2 = new Tag("td").attr("hv", "true").css("height", n2 + "px").css("width", (double)this.cellWidth - (d2 += 2.0) + "px");
            String string = style.getContentClsCss(cellElement.getValue()).replaceAll("pl", "").replaceAll("pr", "");
            tag2.attr("class", string);
            Map map = style.getContentStyleCssMap();
            map.remove("padding-left");
            map.remove("padding-right");
            tag2.css(map);
            tag3.sub(new Tag("table").css("width", (double)this.cellWidth - d2 + "px").sub(new Tag("tbody").sub(new Tag("tr").sub(tag2))));
        }
        return tag2;
    }

    public boolean skipValueWrapper(CellElement cellElement) {
        return false;
    }

    protected Object getRawValue(CellElement cellElement) {
        return cellElement.getValue();
    }

    protected void processFormula(CellElement cellElement, Formula formula) {
    }

    protected void processUnwrappedRawValue(CellElement cellElement, Object object) {
    }

    protected Object getDisplayValue(CellElement cellElement, Object object) {
        return object;
    }

    protected abstract Widget getWidgetOfCell(CellElement var1);

    protected void processWidget(CellElement cellElement, Widget widget, Object object, ColumnRow columnRow, Calculator calculator) {
    }

    protected void processOtherAttributes(HtmlWriteCellBox htmlWriteCellBox) {
    }

    protected void anyElse(HtmlWriteCellBox htmlWriteCellBox) {
    }

    protected void dealBeforeDrawContent(HtmlWriteCellBox htmlWriteCellBox) {
    }

    protected Tag dealWithHyperlinkGroup(CellElement cellElement, Tag tag) throws JSONException {
        NameJavaScriptGroup nameJavaScriptGroup = cellElement.getNameHyperlinkGroup();
        if (nameJavaScriptGroup != null && nameJavaScriptGroup.size() > 0) {
            Style style = cellElement.getStyle();
            Tag tag2 = tag;
            if (style.getBackground() == null || style.getBackground() instanceof ColorBackground) {
                tag2 = new Tag("span");
                tag.sub(tag2);
            }
            tag2.css("cursor", "pointer");
            tag2.attr("onclick", "FR.doHyperlink(event||window.event, " + BaseUtils.writeJSLinkContent(nameJavaScriptGroup, this.repo) + ", true)");
            tag.cls("celink");
            tag2.cls("linkspan");
            return tag2;
        }
        return tag;
    }

    public void dealWithEmptyHeight(Tag tag) {
        tag.css("display", "none");
    }

    protected JSONObject widget2ConfigWithJSONStyle(Widget widget, Object object, ColumnRow columnRow, CellElement cellElement, int n2, String string, Calculator calculator) throws JSONException {
        Map map;
        Object object2;
        if (widget instanceof DateEditor && object != null && !(object instanceof Timestamp)) {
            object2 = object.toString();
            if (StringUtils.isNotBlank((String)object2)) {
                try {
                    if (object instanceof Date) {
                        object = DateUtils.DATEFORMAT1.format((Date)object);
                    }
                }
                catch (Throwable throwable) {
                    object = object2;
                    FRContext.getLogger().error(throwable.getMessage());
                }
            } else {
                object = object2;
            }
        }
        object2 = widget.createJSONConfig(this.repo, calculator);
        ((JSONObject)object2).put("value", widget.value2Config(object, this.repo.getCalculator()));
        ((JSONObject)object2).put("widgetUrl", this.repo.checkoutObject(new JSONObject().put("reportIndex", n2).put("column", columnRow.getColumn()).put("row", columnRow.getRow()), string));
        ((JSONObject)object2).put("sessionID", RepositoryHelper.getSessionIDInfor(this.repo).getSessionID());
        ((JSONObject)object2).put("location", ColumnRow.valueOf(columnRow.getColumn(), columnRow.getRow()));
        ((JSONObject)object2).put("reportIndex", n2);
        if (widget instanceof DependProvider && (map = ((DependProvider)((Object)widget)).getDependenceMap()) != null) {
            ((JSONObject)object2).put("dependenceMap", map);
        }
        if (widget instanceof MultiFileEditor && (object instanceof FArray || object instanceof Attachment || object instanceof Image)) {
            ((JSONObject)object2).put("attachment", true);
        }
        ((JSONObject)object2).put("fontSize", cellElement.getStyle().getFRFont().getSize());
        return object2;
    }

    protected String widget2Config(Widget widget, Object object, ColumnRow columnRow, CellElement cellElement, int n2, String string, Calculator calculator) throws JSONException {
        return this.widget2ConfigWithJSONStyle(widget, object, columnRow, cellElement, n2, string, calculator).toString();
    }

    protected Object dealWithValue4Formula(Formula formula) {
        return formula.getResult();
    }

    protected Object unwrapLobs(CellElement cellElement, Object object) {
        Object object2 = DataUtils.resolveOtherValue(object, this.cellGUIAttr.isShowAsImage(), this.cellGUIAttr.isShowAsDownload(), this.cellGUIAttr.getFileName(), true);
        if (object2 instanceof Attachment) {
            String string = ((Attachment)object2).getID();
            RepositoryHelper.getSessionIDInfor(this.repo).addImageID(string);
        }
        return object2;
    }

    public void setHeavy(boolean bl) {
        this.heavy = bl;
    }

    public boolean isHeavy() {
        return this.heavy;
    }

    public void setTableID(int n2) {
        this.tableID = n2;
    }

    public int getTableID() {
        return this.tableID;
    }

    public Tag getTitleTag(PolyBlockAttr polyBlockAttr) {
        return null;
    }

    public void setQuickModel(boolean bl) {
        this.isQuickModel = bl;
    }

    public boolean isQuickModel() {
        return this.isQuickModel;
    }

    public boolean mayHideTailRows() {
        return false;
    }

    public void setTablePosition(Tag tag) {
    }
}

