/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core;

import com.fr.base.FRContext;
import com.fr.base.Utils;
import com.fr.dav.LocalEnv;
import com.fr.stable.Consts;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.web.utils.WebUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import javax.servlet.ServletContext;

public class ServerEnv
extends LocalEnv {
    private ServletContext servletContext = null;
    private boolean packDeploy = false;

    public ServerEnv(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.setPath();
    }

    public boolean isTemplateExist(String string) throws Exception {
        if (string == null) {
            return false;
        }
        InputStream inputStream = this.servletContext.getResourceAsStream(StableUtils.pathJoin(new String[]{"/", "WEB-INF", "reportlets", string}));
        return inputStream != null;
    }

    public InputStream readBean(String string, String string2) throws Exception {
        if (this.isPackDeploy() && StringUtils.isNotEmpty(string2) && string2.endsWith(".xml") && string2.indexOf("resources") != -1) {
            return this.readResource(string, string2);
        }
        return this.readFromWar(string, string2);
    }

    private InputStream readFromWar(String string, String string2) {
        return this.servletContext.getResourceAsStream(StableUtils.pathJoin(new String[]{"/", "WEB-INF", string2, string}));
    }

    public InputStream readResource(String string) throws Exception {
        return this.readResource(string, "resources");
    }

    public InputStream readResource(String string, String string2) throws Exception {
        if (!this.isPackDeploy()) {
            return super.readBean(string, string2);
        }
        return new FileInputStream(this.makeSureXMLExist(string, string2));
    }

    private File makeSureXMLExist(String string, String string2) {
        String string3 = StableUtils.pathJoin(new String[]{this.getPath(), string2});
        String string4 = StableUtils.pathJoin(new String[]{string3, string});
        try {
            File file = new File(string4);
            if (!file.exists()) {
                InputStream inputStream = this.readFromWar(string, string2);
                Utils.copy(inputStream, string, new File(string3));
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        return new File(string4);
    }

    public OutputStream writeBean(String string, String string2) throws Exception {
        if (!this.isPackDeploy()) {
            return super.writeBean(string, string2);
        }
        return new FileOutputStream(this.makeSureXMLExist(string, string2));
    }

    public boolean isPackDeploy() {
        return this.packDeploy;
    }

    public String getAppName() {
        return this.isPackDeploy() ? Consts.WEB_APP_NAME : super.getAppName();
    }

    private void setPath() {
        this.path = WebUtils.getWebINFPath(this.servletContext);
        if (StringUtils.isNotEmpty(this.path)) {
            return;
        }
        this.packDeploy = true;
        String string = "WebReport";
        try {
            InputStream inputStream = this.readFromWar("warpath.xml", "resources");
            if (inputStream != null) {
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                string = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        this.path = StableUtils.pathJoin(new String[]{Consts.getEnvHome(), string});
    }
}

