/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core;

import com.fr.base.ChartPreStyleServerManager;
import com.fr.base.ConfigManager;
import com.fr.base.FRContext;
import com.fr.base.Parameter;
import com.fr.base.TemplateUtils;
import com.fr.base.Utils;
import com.fr.file.filetree.FileNode;
import com.fr.file.filetree.FileNodeFilter;
import com.fr.file.filetree.IOFileNodeFilter;
import com.fr.form.ui.ToolBar;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.main.FineBook;
import com.fr.main.TemplateWorkBook;
import com.fr.page.PaperSettingProvider;
import com.fr.page.ReportPageAttrProvider;
import com.fr.page.ReportSettingsProvider;
import com.fr.report.core.ReportUtils;
import com.fr.report.report.ECReport;
import com.fr.report.report.Report;
import com.fr.report.web.ToolBarManager;
import com.fr.report.web.button.page.First;
import com.fr.report.web.button.page.Last;
import com.fr.report.web.button.page.Next;
import com.fr.report.web.button.page.PageNavi;
import com.fr.report.web.button.page.Previous;
import com.fr.report.web.button.write.Submit;
import com.fr.report.web.button.write.SubmitForcibly;
import com.fr.script.Calculator;
import com.fr.script.CalculatorMap;
import com.fr.stable.Actor;
import com.fr.stable.ParameterProvider;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.web.Repository;
import com.fr.web.BaseHTMLWriterUtils;
import com.fr.web.Browser;
import com.fr.web.RepositoryHelper;
import com.fr.web.core.A.V;
import com.fr.web.core.IdGenerator;
import com.fr.web.core.ReportRepositoryDeal;
import com.fr.web.core.ReportSession;
import com.fr.web.core.ReportSessionIDInfor;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.utils.WebUtils;
import com.fr.write.ProcessProvider;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportWebUtils {
    private static final FileNodeFilter CPTFILTER = new IOFileNodeFilter(new String[]{".cpt"});
    private static final FileNodeFilter FRMFILTER = new IOFileNodeFilter(new String[]{".frm", ".form"});

    private ReportWebUtils() {
    }

    public static Map context4PageTpl(HttpServletRequest httpServletRequest, ReportSession reportSession) {
        return ReportWebUtils.context4PolicyPaneTpl(httpServletRequest, reportSession, null);
    }

    public static Map context4EditTpl(HttpServletRequest httpServletRequest, ReportSessionIDInfor reportSessionIDInfor) {
        Map map = ReportWebUtils.context4CommonPaneTpl(httpServletRequest, reportSessionIDInfor);
        ReportRepositoryDeal reportRepositoryDeal = new ReportRepositoryDeal(httpServletRequest, reportSessionIDInfor, 96);
        try {
            int n2 = reportSessionIDInfor.getReportCount();
            JSONArray jSONArray = new JSONArray();
            for (int i2 = 0; i2 < n2; ++i2) {
                jSONArray.put(new JSONObject().put("title", reportSessionIDInfor.getReportName(i2)));
            }
            map.put("sheets", jSONArray);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
        }
        try {
            map.put("param", V.A(reportRepositoryDeal, ReportWebUtils.isShowParameterPanel(reportRepositoryDeal)));
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage(), jSONException);
        }
        map.put("browserbg", BaseHTMLWriterUtils.jsonBackground(ReportUtils.getBrowserBackgroundFromWorkBook(reportSessionIDInfor.getContextBook()), reportRepositoryDeal));
        return map;
    }

    public static Map context4CommonPaneTpl(HttpServletRequest httpServletRequest, ReportSession reportSession) {
        if (reportSession == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("charset", ConfigManager.getInstance().getServerCharset());
        hashMap.put("sessionID", reportSession.getSessionID());
        hashMap.put("reportlet_title", reportSession.getWebTitle());
        hashMap.put("reportlet_paperwidth", ReportWebUtils.getReportWidthPixI(reportSession) + "");
        hashMap.put("reportlet_paperheight", ReportWebUtils.getReportHeightPixI(reportSession) + "");
        hashMap.put("csslink", reportSession.getCssLinks(hashMap));
        hashMap.put("jslink", reportSession.getJsLinks(hashMap));
        hashMap.put("Baidu", ChartPreStyleServerManager.getInstance().getBaiduSource());
        hashMap.put("Google", ChartPreStyleServerManager.getInstance().getGoogleSource());
        return hashMap;
    }

    private static double getReportHeightPixI(ReportSession reportSession) {
        if (reportSession.getContextBook().getReportCount() == 0) {
            return 0.0;
        }
        PaperSettingProvider paperSettingProvider = reportSession.getContextBook().getReport(0).getReportSettings().getPaperSetting();
        return paperSettingProvider.getPaperSize().getHeight().toPixI(96);
    }

    private static double getReportWidthPixI(ReportSession reportSession) {
        if (reportSession.getContextBook().getReportCount() == 0) {
            return 0.0;
        }
        PaperSettingProvider paperSettingProvider = reportSession.getContextBook().getReport(0).getReportSettings().getPaperSetting();
        return paperSettingProvider.getPaperSize().getWidth().toPixI(96);
    }

    public static Map context4PolicyPaneTpl(HttpServletRequest httpServletRequest, ReportSession reportSession, Actor actor) {
        return ReportWebUtils.context4PolicyPaneTpl(httpServletRequest, reportSession, actor, null);
    }

    public static Map context4PolicyPaneTpl(HttpServletRequest httpServletRequest, ReportSession reportSession, Actor actor, Map map) {
        Map map2 = ReportWebUtils.context4CommonPaneTpl(httpServletRequest, reportSession);
        Calculator calculator = Calculator.createCalculator();
        calculator.setAttribute(Report.class, reportSession.getContextBook());
        actor = actor == null ? reportSession.getActor() : actor;
        try {
            ReportRepositoryDeal reportRepositoryDeal = new ReportRepositoryDeal(httpServletRequest, (SessionIDInfor)((Object)reportSession), 96);
            map2.putAll(ReportWebUtils.policyMap4Tpl(reportRepositoryDeal, actor, calculator, httpServletRequest));
            if (map != null) {
                map2.putAll(map);
            }
            if (Browser.resolve(httpServletRequest).isMobile()) {
                ReportWebUtils.dealMobile(httpServletRequest, actor, reportRepositoryDeal, map2, reportSession);
            } else if (ReportWebUtils.isNeedToolbar(reportRepositoryDeal)) {
                map2.put("script", TemplateUtils.renderTemplate("/com/fr/web/core/tpl/tpl_script.js", map2));
            } else {
                map2.put("script", TemplateUtils.renderTemplate("/com/fr/web/core/tpl/tpl_script_without_toolbar.js", map2));
            }
        }
        catch (IOException iOException) {
            FRContext.getLogger().error(iOException.getMessage(), iOException);
        }
        return map2;
    }

    private static void dealMobile(HttpServletRequest httpServletRequest, Actor actor, Repository repository, Map map, ReportSession reportSession) throws IOException {
        if (WebUtils.isMobileAPPRequest(httpServletRequest)) {
            if (actor != null && actor.panelType() == "write" && ReportWebUtils.isNeedToolbar(repository)) {
                ToolBarManager[] toolBarManagerArray = actor.toolbarManagers(repository);
                map.put("has_msubmit", Boolean.FALSE);
                block0: for (int i2 = 0; toolBarManagerArray != null && i2 < toolBarManagerArray.length; ++i2) {
                    ToolBar toolBar = toolBarManagerArray[i2].getToolBar();
                    for (int i3 = 0; i3 < toolBar.getWidgetSize(); ++i3) {
                        if (toolBar.getWidget(i3) instanceof Submit) {
                            Submit submit = (Submit)toolBar.getWidget(i3);
                            map.put("has_msubmit", Boolean.TRUE);
                            map.put("msubmit_fun", submit.clickAction(repository).getContent());
                            break block0;
                        }
                        if (!(toolBar.getWidget(i3) instanceof SubmitForcibly)) continue;
                        SubmitForcibly submitForcibly = (SubmitForcibly)toolBar.getWidget(i3);
                        map.put("has_msubmit", Boolean.TRUE);
                        map.put("msubmit_fun", submitForcibly.clickAction(repository).getContent());
                        break block0;
                    }
                }
            }
            if (ReportWebUtils.checkFrozenState(actor, reportSession)) {
                map.put("script", TemplateUtils.renderTemplate("/com/fr/web/mobile/core/js/tpl_script_mobile_without_toolbar_nozoom.js", map));
            } else {
                map.put("script", TemplateUtils.renderTemplate("/com/fr/web/mobile/core/js/tpl_script_mobile_without_toolbar.js", map));
            }
        } else {
            ReportWebUtils.formMobileBrowser(httpServletRequest, actor, repository, map, reportSession);
        }
    }

    private static boolean notPageAndPriview(Actor actor) {
        return actor != null && actor.panelType() != "page" && actor.panelType() != "preview";
    }

    private static boolean isViewOrFrozen(Actor actor, ReportPageAttrProvider reportPageAttrProvider, ReportSettingsProvider reportSettingsProvider) {
        return (actor.panelType() == "view" || actor.panelType() == "page") && reportPageAttrProvider != null && reportPageAttrProvider.getFreezeColumnRow() != null || actor.panelType() == "write" && reportSettingsProvider != null && reportSettingsProvider.getWriteFrozenColumnRow() != null;
    }

    private static boolean checkFrozenState(Actor actor, ReportSession reportSession) {
        FineBook fineBook = reportSession.getContextBook();
        for (int i2 = 0; i2 < fineBook.getReportCount(); ++i2) {
            ReportSettingsProvider reportSettingsProvider;
            ECReport eCReport;
            ReportPageAttrProvider reportPageAttrProvider;
            Report report = fineBook.getReport(i2);
            if (!report.isElementCaseReport() || !ReportWebUtils.isViewOrFrozen(actor, reportPageAttrProvider = (eCReport = (ECReport)report).getReportPageAttr(), reportSettingsProvider = eCReport.getReportSettings())) continue;
            return true;
        }
        return false;
    }

    private static boolean checkNoZoomState(Actor actor, ReportSession reportSession) {
        FineBook fineBook = reportSession.getContextBook();
        boolean bl = false;
        if (fineBook.getReportCount() > 1) {
            if (ReportWebUtils.notPageAndPriview(actor)) {
                bl = true;
            } else if (actor.panelType() == "page") {
                for (int i2 = 0; i2 < fineBook.getReportCount(); ++i2) {
                    ECReport eCReport;
                    ReportPageAttrProvider reportPageAttrProvider;
                    Report report = fineBook.getReport(i2);
                    if (!report.isElementCaseReport() || (reportPageAttrProvider = (eCReport = (ECReport)report).getReportPageAttr()) == null || reportPageAttrProvider.getFreezeColumnRow() == null) continue;
                    return true;
                }
            }
        } else if (fineBook.getReportCount() == 1) {
            Report report = fineBook.getReport(0);
            if (report.isElementCaseReport()) {
                ReportSettingsProvider reportSettingsProvider;
                ECReport eCReport = (ECReport)report;
                ReportPageAttrProvider reportPageAttrProvider = eCReport.getReportPageAttr();
                if (ReportWebUtils.isViewOrFrozen(actor, reportPageAttrProvider, reportSettingsProvider = eCReport.getReportSettings())) {
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    private static void formMobileBrowser(HttpServletRequest httpServletRequest, Actor actor, Repository repository, Map map, ReportSession reportSession) throws IOException {
        if (ReportWebUtils.checkNoZoomState(actor, reportSession)) {
            if (ReportWebUtils.isNeedToolbar(repository)) {
                map.put("script", TemplateUtils.renderTemplate("/com/fr/web/core/tpl/tpl_script.js", map));
            } else {
                map.put("script", TemplateUtils.renderTemplate("/com/fr/web/core/tpl/tpl_script_without_toolbar.js", map));
            }
        } else if (ReportWebUtils.isNeedToolbar(repository)) {
            map.put("script", TemplateUtils.renderTemplate("/com/fr/web/mobile/core/js/tpl_script_mobile_browseronly.js", map));
        } else {
            map.put("script", TemplateUtils.renderTemplate("/com/fr/web/mobile/core/js/tpl_script_mobile_browseronly_without_toolbar.js", map));
        }
    }

    private static boolean isNeedToolbar(Repository repository) {
        return !"false".equalsIgnoreCase(WebUtils.getHTTPRequestParameter(repository.getHttpServletReques(), "__showtoolbar__")) || ReportWebUtils.isReportProcess(repository.getHttpServletReques());
    }

    public static Map policyMap4Tpl(Repository repository, Actor actor, Calculator calculator, HttpServletRequest httpServletRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        SessionIDInfor sessionIDInfor = RepositoryHelper.getSessionIDInfor(repository);
        boolean bl = sessionIDInfor.getParameterValue("__isdebug__") != null;
        String string = Utils.objectToString(sessionIDInfor.getParameterValue("__cutpage__"));
        hashMap.put("__cutpage__", string);
        if (actor == null) {
            return hashMap;
        }
        JSONObject jSONObject = null;
        try {
            jSONObject = actor.panelConfig(repository);
            jSONObject.put("type", actor.panelType());
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage());
        }
        String string2 = null;
        try {
            string2 = bl ? jSONObject.toString(4) : jSONObject.toString();
        }
        catch (JSONException jSONException) {
            string2 = jSONObject.toString();
        }
        hashMap.put("panel_config", string2);
        hashMap.put("__pi__", String.valueOf(ReportWebUtils.isShowParameterPanel(repository)));
        StringWriter stringWriter = new StringWriter();
        try {
            V.A(repository, new PrintWriter(stringWriter), actor, ReportWebUtils.isShowParameterPanel(repository));
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
        }
        hashMap.put("loading", stringWriter.getBuffer().toString());
        ReportWebUtils.dealWithToolbar(repository, actor, httpServletRequest, calculator, hashMap, bl);
        return hashMap;
    }

    private static void dealWithToolbar(Repository repository, Actor actor, HttpServletRequest httpServletRequest, Calculator calculator, Map map, boolean bl) {
        if (ReportWebUtils.isNeedToolbar(repository)) {
            ToolBarManager[] toolBarManagerArray = ReportWebUtils.makeToolbarManager(repository, actor, httpServletRequest);
            JSONArray jSONArray = new JSONArray();
            for (int i2 = 0; toolBarManagerArray != null && i2 < toolBarManagerArray.length; ++i2) {
                jSONArray.put(toolBarManagerArray[i2].toJSONConfig(repository, calculator));
            }
            String string = null;
            try {
                string = bl ? jSONArray.toString(4) : jSONArray.toString();
            }
            catch (JSONException jSONException) {
                string = jSONArray.toString();
            }
            map.put("toolbar_conf", string);
        }
    }

    private static ToolBarManager[] makeToolbarManager(Repository repository, Actor actor, HttpServletRequest httpServletRequest) {
        ToolBarManager[] toolBarManagerArray = actor.toolbarManagers(repository);
        try {
            ArrayList<ToolBarManager> arrayList = new ArrayList<ToolBarManager>();
            boolean bl = ReportWebUtils.isWriteByPage(httpServletRequest);
            boolean bl2 = ReportWebUtils.isReportProcess(httpServletRequest);
            ProcessProvider processProvider = (ProcessProvider)StableFactory.createNewObject("processBridge");
            if (toolBarManagerArray != null) {
                Collections.addAll(arrayList, toolBarManagerArray);
            }
            if (bl2 && processProvider != null) {
                long l2 = Long.parseLong(WebUtils.getHTTPRequestParameter(httpServletRequest, "__processtaskid__"));
                long l3 = Long.parseLong(WebUtils.getHTTPRequestParameter(httpServletRequest, "__allprocesstaskid__"));
                String string = processProvider.getTaskAuthority(l2);
                if (toolBarManagerArray == null) {
                    return new ToolBarManager[]{processProvider.createDefaultReportProcessToolbar(string, l2)};
                }
                ReportWebUtils.dealReportProcessToolbar(repository, toolBarManagerArray, arrayList, processProvider, string, l2, l3);
                ReportWebUtils.dealProcessStashData(repository, l2, processProvider);
            }
            if (bl && !arrayList.isEmpty()) {
                ToolBarManager toolBarManager = (ToolBarManager)((ToolBarManager)arrayList.get(0)).clone();
                ReportWebUtils.modifyWriteByPageToolbar(toolBarManager);
                arrayList.set(0, toolBarManager);
            }
            return arrayList.toArray(new ToolBarManager[arrayList.size()]);
        }
        catch (Exception exception) {
            return toolBarManagerArray;
        }
    }

    private static boolean isReportProcess(HttpServletRequest httpServletRequest) {
        ProcessProvider processProvider = (ProcessProvider)StableFactory.createNewObject("processBridge");
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "__processtaskid__");
        return string != null && processProvider != null && processProvider.isValidTaskUser(httpServletRequest, Long.parseLong(string));
    }

    private static boolean isWriteByPage(HttpServletRequest httpServletRequest) {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "__cutpage__");
        if (string == null) {
            return false;
        }
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "op");
        return (ComparatorUtils.equals(string2, "write") || ComparatorUtils.equals(string2, "fs_main") && ComparatorUtils.equals(WebUtils.getHTTPRequestParameter(httpServletRequest, "cmd"), "entry_report")) && ComparatorUtils.equals(Utils.objectToString(string), "v");
    }

    private static void dealReportProcessToolbar(Repository repository, ToolBarManager[] toolBarManagerArray, List<ToolBarManager> list, ProcessProvider processProvider, String string, long l2, long l3) {
        try {
            boolean bl = processProvider.modifyToolbar(toolBarManagerArray, list, string, l2);
            if (!bl) {
                list.add(processProvider.createDefaultReportProcessToolbar(string, l2));
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("fr_task_id", l3);
            hashMap.put("fr_task_state", processProvider.getTaskState(l2));
            hashMap.put("fr_task_name", processProvider.getTaskName(l2));
            hashMap.put("fr_task_sender", processProvider.getTaskSender(l2));
            Parameter[] parameterArray = processProvider.getTaskParameters(l2, repository);
            for (int i2 = 0; i2 < parameterArray.length; ++i2) {
                hashMap.put(parameterArray[i2].getName(), parameterArray[i2].getValue());
            }
            ((ReportSessionIDInfor)RepositoryHelper.getSessionIDInfor(repository)).apply4Parameters(hashMap);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
    }

    private static void dealProcessStashData(Repository repository, long l2, ProcessProvider processProvider) throws Exception {
        String string = processProvider.getStashData(repository, l2);
        if (string == null) {
            return;
        }
        ReportSessionIDInfor reportSessionIDInfor = (ReportSessionIDInfor)RepositoryHelper.getSessionIDInfor(repository);
        reportSessionIDInfor.setAttribute("stash_data", string);
    }

    public static void dealReportProcessToolbar(Repository repository, ToolBarManager[] toolBarManagerArray, List<ToolBarManager> list, long l2, long l3) {
        ProcessProvider processProvider = (ProcessProvider)StableFactory.createNewObject("processBridge");
        ReportWebUtils.dealReportProcessToolbar(repository, toolBarManagerArray, list, processProvider, processProvider.getTaskAuthority(l2), l2, l3);
    }

    private static void modifyWriteByPageToolbar(ToolBarManager toolBarManager) {
        ToolBar toolBar = toolBarManager.getToolBar();
        toolBar.addWidgetAhead(new Last());
        toolBar.addWidgetAhead(new Next());
        toolBar.addWidgetAhead(new PageNavi());
        toolBar.addWidgetAhead(new Previous());
        toolBar.addWidgetAhead(new First());
    }

    public static Map dealWithReportParameters(TemplateWorkBook templateWorkBook, Map map) {
        CalculatorMap calculatorMap;
        ParameterProvider[] parameterProviderArray;
        ParameterProvider[] parameterProviderArray2 = parameterProviderArray = templateWorkBook == null ? null : templateWorkBook.getParameters();
        if (map == null) {
            if (parameterProviderArray == null || parameterProviderArray.length == 0) {
                return Collections.EMPTY_MAP;
            }
            calculatorMap = CalculatorMap.create(parameterProviderArray);
        } else {
            calculatorMap = parameterProviderArray == null || parameterProviderArray.length == 0 ? new CalculatorMap() : CalculatorMap.create(parameterProviderArray);
            calculatorMap.putAll(map);
        }
        return calculatorMap;
    }

    private static boolean isShowParameterPanel(Repository repository) {
        return !ComparatorUtils.equals(WebUtils.getHTTPRequestParameter(repository.getHttpServletReques(), "__pi__"), "false");
    }

    public static FileNode[] filterAndSortFile(FileNode[] fileNodeArray, String string) {
        ArrayList<FileNode> arrayList = new ArrayList<FileNode>();
        boolean bl = string.indexOf("cpt") > -1;
        boolean bl2 = string.indexOf("frm") > -1;
        for (int i2 = 0; i2 < fileNodeArray.length; ++i2) {
            if (!ReportWebUtils.needToAddNode(bl, bl2, fileNodeArray, i2)) continue;
            arrayList.add(fileNodeArray[i2]);
        }
        FileNode[] fileNodeArray2 = new FileNode[arrayList.size()];
        Iterator iterator = arrayList.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            fileNodeArray2[n2] = (FileNode)iterator.next();
            ++n2;
        }
        Arrays.sort(fileNodeArray2, new Comparator(){

            public int compare(Object object, Object object2) {
                if (!(object instanceof FileNode) || !(object instanceof FileNode)) {
                    return -1;
                }
                FileNode fileNode = (FileNode)object;
                FileNode fileNode2 = (FileNode)object2;
                int n2 = fileNode.isDirectory() ? (fileNode2.isDirectory() ? fileNode.getName().toLowerCase().compareTo(fileNode2.getName().toLowerCase()) : -1) : (fileNode2.isDirectory() ? 1 : fileNode.getName().toLowerCase().compareTo(fileNode2.getName().toLowerCase()));
                return n2;
            }
        });
        return fileNodeArray2;
    }

    private static boolean needToAddNode(boolean bl, boolean bl2, FileNode[] fileNodeArray, int n2) {
        return fileNodeArray[n2].isDirectory() || bl && CPTFILTER.accept(fileNodeArray[n2]) || bl2 && FRMFILTER.accept(fileNodeArray[n2]);
    }

    public static JSONArray getAllReportletsOfCurrentEnv(String string, IdGenerator idGenerator, String string2) {
        return ReportWebUtils.getReportletsOfCurrentEnv(string, idGenerator, string2);
    }

    public static JSONArray getReportletsOfCurrentEnv(String string, IdGenerator idGenerator, String string2) {
        JSONArray jSONArray = new JSONArray();
        FileNode[] fileNodeArray = null;
        try {
            fileNodeArray = FRContext.getCurrentEnv().listFile(string);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
        }
        if (fileNodeArray == null || fileNodeArray.length == 0) {
            return jSONArray;
        }
        return ReportWebUtils.getReportletsOfCurrentEnv(fileNodeArray, idGenerator, string2);
    }

    public static JSONArray getReportletsOfCurrentEnv(FileNode[] fileNodeArray, IdGenerator idGenerator, String string) {
        JSONArray jSONArray = new JSONArray();
        fileNodeArray = ReportWebUtils.filterAndSortFile(fileNodeArray, string);
        for (int i2 = 0; i2 < fileNodeArray.length; ++i2) {
            FileNode fileNode = fileNodeArray[i2];
            String string2 = fileNode.getEnvPath().substring("reportlets".length() + 1);
            JSONObject jSONObject = new JSONObject();
            jSONArray.put(jSONObject);
            try {
                jSONObject.put("id", idGenerator.generateId());
                jSONObject.put("text", fileNode.getName());
                jSONObject.put("value", fileNode.getName());
                jSONObject.put("path", string2);
                jSONObject.put("complete", true);
                jSONObject.put("isexpand", false);
                jSONObject.put("page", 1);
                jSONObject.put("write", 1);
                jSONObject.put("design", 1);
                if (!fileNode.isDirectory()) continue;
                jSONObject.put("hasChildren", true);
                jSONObject.put("ChildNodes", ReportWebUtils.getReportletsOfCurrentEnv(fileNode.getEnvPath(), idGenerator, string));
                continue;
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().error(jSONException.getMessage(), jSONException);
            }
        }
        return jSONArray;
    }
}

