/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core;

import com.fr.base.ConfigManager;
import com.fr.base.Env;
import com.fr.base.FRContext;
import com.fr.base.TemplateUtils;
import com.fr.stable.CodeUtils;
import com.fr.stable.Consts;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.web.core.ErrorHandler;
import com.fr.web.utils.WebUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultErrorHandler
implements ErrorHandler {
    public void error(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Throwable throwable) {
        this.error(httpServletRequest, httpServletResponse, throwable.getMessage(), throwable);
    }

    public void error(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        this.error(httpServletRequest, httpServletResponse, string, null);
    }

    public void error(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Throwable throwable) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string == null) {
            string = "";
        }
        hashMap.put("message", CodeUtils.htmlEncode(CodeUtils.cjkEncode(string)));
        hashMap.put("duration", Consts.HISTORY);
        hashMap.put("companyname", Consts.COMPANY_NAME);
        try {
            Object object;
            if (httpServletRequest.getParameter("frload") != null) {
                PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
                printWriter.println(new StringBuffer().append("alert(\"").append(string.replaceAll("\"", "\\\\\"")).append("\")"));
                printWriter.flush();
                printWriter.close();
                return;
            }
            if (throwable != null) {
                object = new StringWriter();
                PrintWriter printWriter = new PrintWriter((Writer)object);
                throwable.printStackTrace(printWriter);
                hashMap.put("exception", CodeUtils.htmlEncode(CodeUtils.cjkEncode(((StringWriter)object).toString())));
                printWriter.flush();
                printWriter.close();
            }
            hashMap.put("charset", CodeUtils.htmlEncode(ConfigManager.getInstance().getServerCharset()));
            object = "/com/fr/web/core/errorIframe.html";
            if (StringUtils.isNotEmpty(ConfigManager.getInstance().getErrorTemplate())) {
                try {
                    DefaultErrorHandler.userDefineHandler(httpServletRequest, httpServletResponse, hashMap);
                }
                catch (Exception exception) {
                    WebUtils.writeOutTemplate((String)object, httpServletResponse, hashMap);
                    FRContext.getLogger().error(exception.getMessage());
                }
            } else {
                WebUtils.writeOutTemplate((String)object, httpServletResponse, hashMap);
            }
        }
        catch (IOException iOException) {
            FRContext.getLogger().errorWithServerLevel(iOException.getMessage(), iOException);
        }
    }

    private static void userDefineHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map map) throws Exception {
        Env env = FRContext.getCurrentEnv();
        if (env == null) {
            throw new IllegalStateException("Env is null..");
        }
        String string = ConfigManager.getInstance().getErrorTemplate();
        if (StringUtils.isNotEmpty(string) && !string.endsWith(".html")) {
            if (string.length() > 0 && string.charAt(0) == '/') {
                string = httpServletRequest.getContextPath() + string;
            }
            map.put("redirectURL", string);
            WebUtils.writeOutTemplate("/com/fr/web/core/errorPostRedirect.html", httpServletResponse, map);
        } else {
            String string2 = env.getPath();
            File file = new File(StableUtils.pathJoin(new String[]{new File(string2).getParent(), string}));
            PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
            TemplateUtils.dealWithTemplate(new FileInputStream(file), "GBK", printWriter, map);
            printWriter.flush();
            printWriter.close();
        }
    }
}

