/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.cache;

import com.fr.base.FRContext;
import com.fr.file.CacheManager;
import com.fr.general.VT4FR;
import com.fr.io.TemplateWorkBookIO;
import com.fr.main.TemplateWorkBook;
import com.fr.stable.StableUtils;
import com.fr.web.cache.ReportCache;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ReportEntry {
    public static final int MAX_CACHE_SIZE = 1000;
    private static boolean shareAvailable = true;
    private String bookPath;
    private long lastmodifiedtime;
    private Map reportCacheMap = new HashMap(16);
    private SoftReference reference;

    public ReportEntry(String string) {
        this.bookPath = string;
    }

    public synchronized TemplateWorkBook getWorkBookTemplate() {
        TemplateWorkBook templateWorkBook = null;
        long l2 = 0L;
        if (!shareAvailable || CacheManager.getInstance().isAlwaysReloadTpl() || (l2 = TemplateWorkBookIO.getLastModifiedTime(FRContext.getCurrentEnv(), this.bookPath)) != this.lastmodifiedtime || this.reference == null || (templateWorkBook = (TemplateWorkBook)this.reference.get()) == null) {
            try {
                templateWorkBook = TemplateWorkBookIO.readTemplateWorkBook(FRContext.getCurrentEnv(), this.bookPath);
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), exception);
                throw new RuntimeException(exception.getMessage());
            }
            if (templateWorkBook != null) {
                this.reference = new SoftReference<TemplateWorkBook>(templateWorkBook);
                this.lastmodifiedtime = l2;
            }
        }
        return templateWorkBook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReportCache getReportCache(Map map, long l2, boolean bl) {
        ReportCache reportCache = null;
        Map map2 = this.reportCacheMap;
        synchronized (map2) {
            long l3 = System.currentTimeMillis();
            Iterator iterator = this.reportCacheMap.values().iterator();
            while (shareAvailable && iterator.hasNext()) {
                ReportCache reportCache2 = (ReportCache)iterator.next();
                long l4 = reportCache2.createTime();
                if (l4 < 0L) {
                    if (!reportCache2.accept(map)) continue;
                    reportCache = reportCache2;
                    break;
                }
                if (!reportCache2.accept(map)) continue;
                if (bl || l2 != 0L && (l2 < 0L || l3 - l4 < l2)) {
                    reportCache = reportCache2;
                    break;
                }
                iterator.remove();
                break;
            }
            if (reportCache == null) {
                reportCache = new ReportCache(this, map);
                if (shareAvailable) {
                    if (this.reportCacheMap.size() > 1000) {
                        this.reportCacheMap.clear();
                    }
                    this.reportCacheMap.put(reportCache.getId(), reportCache);
                }
            }
        }
        return reportCache;
    }

    public String getBookPath() {
        return this.bookPath;
    }

    static {
        shareAvailable = VT4FR.isLicAvailable(StableUtils.getBytes()) && VT4FR.PERFORMCE_OPTIMISE.support();
    }
}

