/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.cache;

import com.fr.general.DeclareRecordType;
import com.fr.general.FRLogManager;
import com.fr.general.FRLogger;
import com.fr.log.LogUtils;
import com.fr.main.TemplateWorkBook;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.stable.ActorFactory;
import com.fr.web.cache.ReportCacheIdGenerator;
import com.fr.web.cache.ReportEntry;
import com.fr.web.core.MatchMapContainer;
import java.lang.ref.SoftReference;
import java.util.Map;

public class ReportCache
extends MatchMapContainer {
    private String id;
    private ReportEntry reportEntry;
    private SoftReference reference;
    private long createTime = -1L;

    public ReportCache(ReportEntry reportEntry, Map map) {
        super(map);
        this.reportEntry = reportEntry;
        this.id = ReportCacheIdGenerator.getId();
    }

    public long createTime() {
        return this.createTime;
    }

    public synchronized ResultWorkBook getResultWorkBook(TemplateWorkBook templateWorkBook) {
        ResultWorkBook resultWorkBook;
        if (this.reference == null || (resultWorkBook = (ResultWorkBook)this.reference.get()) == null) {
            resultWorkBook = LogUtils.executeAndLogRecord(templateWorkBook, this.reportEntry.getBookPath(), this.paraMap, ActorFactory.getActor("page"));
            this.reference = new SoftReference<ResultWorkBook>(resultWorkBook);
            this.createTime = System.currentTimeMillis();
            return resultWorkBook;
        }
        LogUtils.recordAccessNoExecuteInfo(this.reportEntry.getBookPath(), DeclareRecordType.EXECUTE_TYPE_PAGE, FRLogger.createParamString(this.paraMap), FRLogManager.getDeclareSQLContent());
        return resultWorkBook;
    }

    public String getId() {
        return this.id;
    }
}

