/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.attr;

import com.fr.base.BaseXMLUtils;
import com.fr.base.background.ColorBackground;
import com.fr.general.Background;
import com.fr.report.web.Printer;
import com.fr.report.web.ToolBarManager;
import com.fr.report.web.WebPage;
import com.fr.report.web.WebView;
import com.fr.report.web.WebWrite;
import com.fr.stable.ColumnRow;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLWriter;
import com.fr.stable.xml.XMLableReader;
import com.fr.xml.SynchronizedFrozenColumnRow;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ReportWebAttr
implements XMLWriter,
XMLReadable,
Cloneable,
Serializable {
    private String title = null;
    private Printer printer;
    private WebPage page = null;
    private WebWrite write = null;
    private WebView view = null;
    private List jsImportList = null;
    private List cssImportList = null;
    private Background background = null;
    private long cacheValidateTime = 0L;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setCacheValidateTime(long l2) {
        this.cacheValidateTime = l2;
    }

    public long getCacheValidateTime() {
        return this.cacheValidateTime;
    }

    public WebPage getWebPage() {
        return this.page;
    }

    public void setWebPage(WebPage webPage) {
        this.page = webPage;
    }

    public WebView getWebView() {
        return this.view;
    }

    public void setWebView(WebView webView) {
        this.view = webView;
    }

    public WebWrite getWebWrite() {
        return this.write;
    }

    public void setWebWrite(WebWrite webWrite) {
        this.write = webWrite;
    }

    public Printer getPrinter() {
        return this.printer;
    }

    public void setPrinter(Printer printer) {
        this.printer = printer;
    }

    public Background getBackground() {
        return this.background;
    }

    public void setBackground(Background background) {
        this.background = background;
    }

    public int getJSImportCount() {
        return this.jsImportList == null ? 0 : this.jsImportList.size();
    }

    public String getJSImport(int n2) {
        return this.jsImportList == null ? null : (String)this.jsImportList.get(n2);
    }

    public void clearJSImportList() {
        if (this.jsImportList != null) {
            this.jsImportList.clear();
        }
    }

    public void addJSImport(String string) {
        if (this.jsImportList == null) {
            this.jsImportList = new ArrayList();
        }
        this.jsImportList.add(string);
    }

    public int getCSSImportCount() {
        return this.cssImportList == null ? 0 : this.cssImportList.size();
    }

    public String getCSSImport(int n2) {
        return this.cssImportList == null ? null : (String)this.cssImportList.get(n2);
    }

    public void clearCSSImportList() {
        if (this.cssImportList != null) {
            this.cssImportList.clear();
        }
    }

    public void addCSSImport(String string) {
        if (this.cssImportList == null) {
            this.cssImportList = new ArrayList();
        }
        this.cssImportList.add(string);
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if (string2.equals("Title")) {
                String string3 = xMLableReader.getElementValue();
                if (StringUtils.isNotBlank(string3)) {
                    this.setTitle(string3);
                }
            } else if (string2.equals("ServerPrinter")) {
                this.printer = new Printer();
                xMLableReader.readXMLObject(this.printer);
            } else if (string2.equals("Background")) {
                this.setBackground(BaseXMLUtils.readBackground(xMLableReader));
            } else if (string2.equals("CSSImport")) {
                String string4 = xMLableReader.getElementValue();
                if (string4 != null) {
                    this.addCSSImport(string4);
                }
            } else if (string2.equals("WriteCSSImport")) {
                String string5 = xMLableReader.getElementValue();
                if (string5 != null) {
                    this.addCSSImport(string5);
                }
            } else if (string2.equals("WidgetCSSImport")) {
                String string6 = xMLableReader.getElementValue();
                if (string6 != null) {
                    this.addCSSImport(string6);
                }
            } else if (string2.equals("JSImport")) {
                String string7 = xMLableReader.getElementValue();
                if (string7 != null) {
                    this.addJSImport(string7);
                }
            } else if (string2.equals("WebPageContent")) {
                this.page = new WebPage();
                xMLableReader.readXMLObject(this.page);
            } else if (string2.equals("WebViewContent")) {
                this.view = new WebView();
                xMLableReader.readXMLObject(this.view);
            } else if (string2.equals("WebWriteContent")) {
                this.write = new WebWrite();
                xMLableReader.readXMLObject(this.write);
            } else if ("CacheValidateTime".equals(string2)) {
                String string8 = xMLableReader.getElementValue();
                this.setCacheValidateTime(string8 == null ? 0L : Long.parseLong(string8));
            } else if (string2.equals("ToolbarManager")) {
                ToolBarManager toolBarManager = new ToolBarManager();
                xMLableReader.readXMLObject(toolBarManager);
                if (this.page == null) {
                    this.page = new WebPage();
                }
                this.page.setToolBarManagers(new ToolBarManager[]{toolBarManager});
            } else if (string2.equals("FrozenColumnRow") && ((string = xMLableReader.getAttrAsString("FrozenColumnRow", null)) != null || (string = xMLableReader.getAttrAsString("frozenColumnRow", null)) != null)) {
                ColumnRow columnRow = ColumnRow.valueOf(string);
                if (this.write == null) {
                    this.write = new WebWrite();
                }
                SynchronizedFrozenColumnRow.putSynchronizedFrozenColumnRow(columnRow);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        int n2;
        xMLPrintWriter.startTAG("ReportWebAttr");
        if (StringUtils.isNotBlank(this.getTitle())) {
            xMLPrintWriter.startTAG("Title").textNode(this.getTitle()).end();
        }
        if (this.printer != null) {
            this.printer.writeXML(xMLPrintWriter);
        }
        if (this.page != null) {
            xMLPrintWriter.startTAG("WebPageContent");
            this.page.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.view != null) {
            xMLPrintWriter.startTAG("WebViewContent");
            this.view.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.write != null) {
            xMLPrintWriter.startTAG("WebWriteContent");
            this.write.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        Background background = this.getBackground();
        if (!ColorBackground.getInstance(Color.white).equals(background) && background != null) {
            BaseXMLUtils.writeBackground(xMLPrintWriter, background);
        }
        int n3 = this.getCSSImportCount();
        for (n2 = 0; n2 < n3; ++n2) {
            xMLPrintWriter.startTAG("CSSImport").textNode(this.getCSSImport(n2)).end();
        }
        n3 = this.getJSImportCount();
        for (n2 = 0; n2 < n3; ++n2) {
            xMLPrintWriter.startTAG("JSImport").textNode(this.getJSImport(n2)).end();
        }
        if (this.cacheValidateTime != 0L) {
            xMLPrintWriter.startTAG("CacheValidateTime").textNode(String.valueOf(this.cacheValidateTime)).end();
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        ReportWebAttr reportWebAttr = (ReportWebAttr)super.clone();
        if (this.background != null) {
            reportWebAttr.background = (Background)this.background.clone();
        }
        if (this.printer != null) {
            reportWebAttr.printer = (Printer)this.printer.clone();
        }
        if (this.page != null) {
            reportWebAttr.page = (WebPage)this.page.clone();
        }
        if (this.view != null) {
            reportWebAttr.view = (WebView)this.view.clone();
        }
        if (this.write != null) {
            reportWebAttr.write = (WebWrite)this.write.clone();
        }
        if (this.cssImportList != null) {
            reportWebAttr.cssImportList = new ArrayList();
            reportWebAttr.cssImportList.addAll(this.cssImportList);
        }
        if (this.jsImportList != null) {
            reportWebAttr.jsImportList = new ArrayList();
            reportWebAttr.jsImportList.addAll(this.jsImportList);
        }
        return reportWebAttr;
    }
}

