/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web;

import com.fr.base.ConfigManager;
import com.fr.base.FRContext;
import com.fr.base.IconManager;
import com.fr.base.ModuleContext;
import com.fr.general.RegistEditionException;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.record.DBRecordManager;
import com.fr.script.Calculator;
import com.fr.stable.Consts;
import com.fr.web.Browser;
import com.fr.web.J2EEContainer;
import com.fr.web.core.A.l;
import com.fr.web.core.ErrorHandlerHelper;
import com.fr.web.core.ReportDispatcher;
import com.fr.web.core.ServerEnv;
import com.fr.web.core.gzip.GZIPResponseWrapper;
import com.fr.web.utils.WebUtils;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseServlet
extends HttpServlet {
    private static final long serialVersionUID = 2204797189775876731L;
    private static String reportName;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        J2EEContainer.init(servletConfig);
        ServletContext servletContext = this.getServletContext();
        try {
            if (FRContext.getCurrentEnv() == null) {
                FRContext.setCurrentEnv(new ServerEnv(servletContext));
            }
            FRContext.getLogger().initRecord(new DBRecordManager());
            FRContext.getLogger().setLogLevel(ConfigManager.getInstance().getServerLogLevel());
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        servletContext.setAttribute(((Object)((Object)this)).getClass().getName(), (Object)this);
        ModuleContext.startModule(this.moduleToStart());
    }

    public abstract String moduleToStart();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse object) throws IOException, ServletException {
        if (Consts.WEB_APP_NAME == null && (Consts.WEB_APP_NAME = httpServletRequest.getContextPath()).startsWith("/")) {
            Consts.WEB_APP_NAME = Consts.WEB_APP_NAME.substring(1);
        }
        BaseServlet.saveRequestContext(httpServletRequest);
        GZIPResponseWrapper gZIPResponseWrapper = null;
        try {
            String string = httpServletRequest.getHeader("accept-encoding");
            if (ConfigManager.getInstance().isSupportGzip() && !"false".equals(httpServletRequest.getParameter("gzip")) && string != null && string.indexOf("gzip") != -1 && Browser.resolve(httpServletRequest).supportGzip()) {
                gZIPResponseWrapper = new GZIPResponseWrapper((HttpServletResponse)object);
            }
            if (gZIPResponseWrapper != null) {
                object = gZIPResponseWrapper;
            }
            object.addHeader("P3P", "CP=CAO PSA OUR");
            ReportDispatcher.dealWithRequest(httpServletRequest, object);
        }
        catch (RegistEditionException registEditionException) {
            if (registEditionException.isAjax()) {
                PrintWriter printWriter = WebUtils.createPrintWriter(object);
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("exception", "FAILPASS");
                    if (registEditionException.getFUNC() != null) {
                        jSONObject.put("func", registEditionException.getFUNC().toString());
                    }
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                printWriter.write(jSONObject.toString());
                printWriter.flush();
                printWriter.close();
                return;
            }
            FRContext.getLogger().errorWithServerLevel(registEditionException.getMessage(), registEditionException);
            ErrorHandlerHelper.getErrorHandler().error(httpServletRequest, (HttpServletResponse)object, registEditionException);
        }
        catch (Exception exception) {
            FRContext.getLogger().errorWithServerLevel(exception.getMessage(), exception);
            ErrorHandlerHelper.getErrorHandler().error(httpServletRequest, (HttpServletResponse)object, exception);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            FRContext.getLogger().errorWithServerLevel(outOfMemoryError.getMessage(), outOfMemoryError);
            ErrorHandlerHelper.getErrorHandler().error(httpServletRequest, (HttpServletResponse)object, outOfMemoryError);
            System.gc();
        }
        finally {
            if (gZIPResponseWrapper != null) {
                gZIPResponseWrapper.finishResponse();
            }
            Calculator.clearThreadSavedParameter();
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    public static void saveRequestContext(HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(httpServletRequest.getScheme());
        stringBuffer.append("://");
        stringBuffer.append(httpServletRequest.getServerName());
        stringBuffer.append(':');
        stringBuffer.append(httpServletRequest.getServerPort());
        Calculator.setThreadSavedParameter("servletURL", WebUtils.createServletURL(httpServletRequest));
        Calculator.setThreadSavedParameter("session_heart_beat", Boolean.toString(ConfigManager.getInstance().isSendHeartBeat()));
        Calculator.setThreadSavedParameter("serverURL", stringBuffer);
        Calculator.setThreadSavedParameter("serverSchema", httpServletRequest.getScheme());
        Calculator.setThreadSavedParameter("serverName", httpServletRequest.getServerName());
        Calculator.setThreadSavedParameter("serverPort", Integer.toString(httpServletRequest.getServerPort()));
        Calculator.setThreadSavedParameter("contextPath", httpServletRequest.getContextPath());
        String string = WebUtils.getReportTitleFromRequest(httpServletRequest);
        reportName = string == null ? reportName : string;
        Calculator.setThreadSavedParameter("reportName", reportName);
    }

    public long getLastModified(HttpServletRequest httpServletRequest) {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "resource");
        if (string != null) {
            return l.E().A(string);
        }
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "op");
        if ("toolbar_icon".equalsIgnoreCase(string2)) {
            return IconManager.getLastModified();
        }
        return -1L;
    }
}

