/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable;

import com.fr.stable.InterpreterError;
import com.fr.stable.Primitive;
import com.fr.stable.UtilEvalError;
import java.math.BigDecimal;

public class OperationUtils {
    public static final Double POSITIVE_INFINITY = new Double(Double.POSITIVE_INFINITY);
    public static final Double NEGATIVE_INFINITY = new Double(Double.NEGATIVE_INFINITY);
    private static final String BOOL = "!";
    private static final String PLUS = "+";
    private static final String MINUS = "-";
    public static final Integer ZERO = new Integer(0);
    public static final BigDecimal BZERO = new BigDecimal(0);

    private OperationUtils() {
    }

    public static boolean isFalse(Object object) {
        return object == null || object == Primitive.NULL || Boolean.FALSE.equals(object) || new Integer(0).equals(object) || "".equals(object);
    }

    public static boolean booleanUnaryOperation(Boolean bl, String string) throws UtilEvalError {
        boolean bl2 = bl;
        if (BOOL.equals(string)) {
            return !bl2;
        }
        throw new UtilEvalError("Operator inappropriate for boolean:\n" + string + bl);
    }

    public static int intUnaryOperation(Integer n2, String string) {
        int n3 = n2;
        if (PLUS.equals(string)) {
            return n3;
        }
        if (MINUS.equals(string)) {
            return -n3;
        }
        throw new InterpreterError("bad integer unaryOperation:\n" + string + n2);
    }

    public static long longUnaryOperation(Long l2, String string) {
        long l3 = l2;
        if (PLUS.equals(string)) {
            return l3;
        }
        if (MINUS.equals(string)) {
            return -l3;
        }
        throw new InterpreterError("bad long unaryOperation:\n" + string + l2);
    }

    public static float floatUnaryOperation(Float f2, String string) {
        float f3 = f2.floatValue();
        if (PLUS.equals(string)) {
            return f3;
        }
        if (MINUS.equals(string)) {
            return -f3;
        }
        throw new InterpreterError("bad float unaryOperation:\n" + string + f2);
    }

    public static double doubleUnaryOperation(Double d2, String string) {
        double d3 = d2;
        if (PLUS.equals(string)) {
            return d3;
        }
        if (MINUS.equals(string)) {
            return -d3;
        }
        throw new InterpreterError("bad double unaryOperation:\n" + string + d2);
    }

    public static BigDecimal bigDecimalUnaryOperation(BigDecimal bigDecimal, String string) {
        if (PLUS.equals(string)) {
            return bigDecimal;
        }
        if (MINUS.equals(string)) {
            return bigDecimal.negate();
        }
        throw new InterpreterError("bad bigDecimal unaryOperation:\n" + string + bigDecimal);
    }

    public static Object promoteCharByteShort(Object object) {
        if (object instanceof Character) {
            return object.toString();
        }
        if (object instanceof Byte || object instanceof Short) {
            return new Integer(((Number)object).intValue());
        }
        return object;
    }
}

