/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import javax.swing.ImageIcon;

public class CoreGraphHelper {
    private static final MediaTracker MEDIA_TRACKER = new MediaTracker(null);

    private CoreGraphHelper() {
    }

    public static void waitForImage(Image image) {
        MEDIA_TRACKER.addImage(image, 0);
        try {
            MEDIA_TRACKER.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        MEDIA_TRACKER.removeImage(image);
    }

    public static BufferedImage createBufferedImage(int n2, int n3) {
        return CoreGraphHelper.createBufferedImage(n2, n3, 2);
    }

    public static BufferedImage createBufferedImage(int n2, int n3, int n4) {
        if (n2 <= 0) {
            n2 = 1;
        }
        if (n3 <= 0) {
            n3 = 1;
        }
        return new BufferedImage(n2, n3, n4);
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean bl = CoreGraphHelper.hasAlpha(image);
        BufferedImage bufferedImage = null;
        ImageObserver imageObserver = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int n2 = 1;
            if (bl) {
                n2 = 2;
            }
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            bufferedImage = graphicsConfiguration.createCompatibleImage(image.getWidth(imageObserver), image.getHeight(imageObserver), n2);
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        if (bufferedImage == null) {
            int n3 = 1;
            if (bl) {
                n3 = 2;
            }
            bufferedImage = CoreGraphHelper.createBufferedImage(image.getWidth(imageObserver), image.getHeight(imageObserver), n3);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, imageObserver);
        graphics2D.dispose();
        return bufferedImage;
    }

    private static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            return bufferedImage.getColorModel().hasAlpha();
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel colorModel = pixelGrabber.getColorModel();
        return colorModel.hasAlpha();
    }

    public static int changeImageLayout4Draw(Image image, int n2, int n3, int n4) {
        if (image != null && n2 == 1 && (image.getWidth(null) > n3 || image.getHeight(null) > n4)) {
            n2 = 0;
        }
        return n2;
    }
}

