/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable;

import com.fr.stable.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CodeUtils {
    public static int ENCODE_LEN = 4;
    public static int HEX = 16;
    public static double coefficient = 1.5;
    public static int ascCodeA = 65;
    public static int ascCodeZ = 90;
    public static int ascCodea = 97;
    public static int ascCodez = 122;
    public static int ascCode0 = 48;
    public static int ascCode9 = 57;
    public static int ascCodeDel = 127;
    public static int ascCodeLeftBracket = 91;
    public static int ascCodeRightBracket = 93;
    private static final String[] HEXDIGITS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    private static int EIGHTTIMES2 = 256;
    private static Pattern bracketPattern = Pattern.compile("\\[[^\\]]*\\]");
    private static Pattern textPattern = Pattern.compile("[0-9a-f]{2,4}", 2);
    private static Pattern blankPattern = Pattern.compile("\\s+");
    private static final int[] PASSWORD_MASK_ARRAY = new int[]{19, 78, 10, 15, 100, 213, 43, 23};

    private CodeUtils() {
    }

    public static String javascriptEncode(String string) {
        if (StringUtils.isEmpty(string)) {
            return "";
        }
        char c2 = '\u0000';
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        block9: for (int i2 = 0; i2 < n2; ++i2) {
            char c3 = c2;
            c2 = string.charAt(i2);
            switch (c2) {
                case '\"': 
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append(c2);
                    continue block9;
                }
                case '/': {
                    if (c3 == '<') {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c2);
                    continue block9;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block9;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block9;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block9;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block9;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block9;
                }
                default: {
                    if (CodeUtils.isCopyRightSymbol(c2)) {
                        String string2 = "000" + Integer.toHexString(c2);
                        stringBuffer.append("\\u" + string2.substring(string2.length() - ENCODE_LEN));
                        continue block9;
                    }
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer.toString();
    }

    private static boolean isCopyRightSymbol(char c2) {
        return c2 < ' ' || c2 >= '\u0080' && c2 < '\u00a0' || c2 >= '\u2000' && c2 < '\u2100' || c2 == '\u00a9' || c2 == '\u00ae';
    }

    public static String javascriptDecode(String string) {
        return CodeUtils.encodeString(string, new String[][]{{"\\", "'", "\""}, {"\\\\", "\\'", "\\\""}});
    }

    public static String encodeString(String string, String[][] stringArray) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        block0: for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            for (int i3 = 0; i3 < stringArray[1].length; ++i3) {
                if (c2 != stringArray[1][i3].charAt(0)) continue;
                stringBuffer.append(stringArray[0][i3]);
                continue block0;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static String encodeURIComponent(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return CodeUtils.encodeString(string, new String[][]{{"%20", "%23", "%24", "%26", "%2B", "%2C", "%2F", "%3A", "%3B", "%3D", "%3F", "%40", "%25"}, {" ", "#", "$", "&", "+", ",", "/", ":", ";", "=", "?", "@", "%"}});
        }
    }

    public static String attributeHtmlEncode(CharSequence charSequence) {
        if (charSequence == null) {
            return "";
        }
        int n2 = charSequence.length();
        StringBuffer stringBuffer = new StringBuffer((int)((double)n2 * coefficient));
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (CodeUtils.isLetterOrNumber(c2)) {
                stringBuffer.append(c2);
                continue;
            }
            stringBuffer.append("&#").append((int)c2).append(';');
        }
        return stringBuffer.toString();
    }

    public static String attributeHtmlDecode(CharSequence charSequence) {
        if (charSequence == null) {
            return "";
        }
        int n2 = charSequence.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            char c2 = charSequence.charAt(i2);
            boolean bl = false;
            if (c2 == '&' && i2 + 1 < n2 && charSequence.charAt(i2 + 1) == '#' && (n3 = ((Object)charSequence).toString().indexOf(";", i2 + 1)) != -1 && n3 < i2 + 3 + 3) {
                String string = ((Object)charSequence.subSequence(i2 + 2, n3)).toString();
                char c3 = (char)Integer.parseInt(string);
                stringBuffer.append(c3);
                i2 = n3;
                bl = true;
            }
            if (bl) continue;
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    private static boolean isLetterOrNumber(char c2) {
        return c2 >= ascCodea && c2 <= ascCodez || c2 >= ascCodeA && c2 <= ascCodeZ || c2 >= ascCode0 && c2 <= ascCode9;
    }

    public static String htmlEncode(CharSequence charSequence) {
        if (charSequence == null) {
            return "";
        }
        int n2 = charSequence.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = charSequence.charAt(i2);
            i2 = CodeUtils.dealWithChar(c2, stringBuffer, n2, i2, charSequence);
        }
        String string = CodeUtils.replaceBlankToHtmlBlank(stringBuffer.toString());
        return string;
    }

    private static int dealWithChar(char c2, StringBuffer stringBuffer, int n2, int n3, CharSequence charSequence) {
        switch (c2) {
            case '<': {
                stringBuffer.append("&lt;");
                break;
            }
            case '>': {
                stringBuffer.append("&gt;");
                break;
            }
            case '&': {
                stringBuffer.append("&amp;");
                break;
            }
            case '\"': {
                stringBuffer.append("&quot;");
                break;
            }
            case '\r': {
                if (n3 + 1 < n2 && charSequence.charAt(n3 + 1) == '\n') {
                    ++n3;
                }
                stringBuffer.append("<br>");
                break;
            }
            case '\\': {
                if (n3 + 1 < n2 && charSequence.charAt(n3 + 1) == 'n') {
                    ++n3;
                    stringBuffer.append("<br>");
                    break;
                }
                if (n3 + 1 < n2 && charSequence.charAt(n3 + 1) == '\\') {
                    ++n3;
                }
                stringBuffer.append(c2);
                break;
            }
            case '\n': {
                stringBuffer.append("<br>");
                break;
            }
            default: {
                stringBuffer.append(c2);
            }
        }
        return n3;
    }

    private static String replaceBlankToHtmlBlank(String string) {
        Matcher matcher = blankPattern.matcher(string);
        int n2 = 0;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        while (matcher.find()) {
            n3 = matcher.start();
            stringBuffer.append(string.substring(n2, n3));
            n2 = matcher.end();
            String string2 = matcher.group();
            stringBuffer.append(" ");
            int n4 = string2.length();
            if (n4 <= 1) continue;
            for (int i2 = n4; i2 > 1; --i2) {
                stringBuffer.append("&nbsp;");
            }
            stringBuffer.append(" ");
        }
        if (n2 == 0) {
            return string;
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    public static String cjkEncode(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (CodeUtils.needToEncode(c2)) {
                stringBuffer.append('[');
                stringBuffer.append(Integer.toString(c2, 16));
                stringBuffer.append(']');
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    private static boolean needToEncode(char c2) {
        return c2 > ascCodeDel || c2 == ascCodeLeftBracket || c2 == ascCodeRightBracket;
    }

    public static String cjkDecode(String string) throws Exception {
        if (string == null) {
            return "";
        }
        if (!CodeUtils.isCJKEncoded(string)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            int n2;
            char c2 = string.charAt(i2);
            if (c2 == '[' && (n2 = string.indexOf(93, i2 + 1)) > i2 + 1) {
                String string2 = string.substring(i2 + 1, n2);
                if (string2.length() > 0) {
                    c2 = (char)Integer.parseInt(string2, 16);
                }
                i2 = n2;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static boolean isCJKEncoded(String string) {
        boolean bl = false;
        if (string == null) {
            return bl;
        }
        Matcher matcher = bracketPattern.matcher(string);
        while (matcher.find()) {
            int n2;
            bl = true;
            int n3 = matcher.start();
            String string2 = string.substring(n3 + 1, (n2 = matcher.end()) - 1);
            if (textPattern.matcher(string2).matches()) continue;
            return false;
        }
        return bl;
    }

    public static String passwordEncode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("___");
        if (string == null) {
            return stringBuffer.toString();
        }
        int n2 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (n2 == PASSWORD_MASK_ARRAY.length) {
                n2 = 0;
            }
            int n3 = string.charAt(i2) ^ PASSWORD_MASK_ARRAY[n2];
            String string2 = Integer.toHexString(n3);
            int n4 = string2.length();
            for (int i3 = 0; i3 < ENCODE_LEN - n4; ++i3) {
                string2 = "0" + string2;
            }
            stringBuffer.append(string2);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String passwordDecode(String string) {
        if (string != null && string.startsWith("___")) {
            string = string.substring(3);
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            for (int i2 = 0; i2 <= string.length() - ENCODE_LEN; i2 += ENCODE_LEN) {
                if (n2 == PASSWORD_MASK_ARRAY.length) {
                    n2 = 0;
                }
                String string2 = string.substring(i2, i2 + ENCODE_LEN);
                int n3 = Integer.parseInt(string2, HEX) ^ PASSWORD_MASK_ARRAY[n2];
                stringBuffer.append((char)n3);
                ++n2;
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public static String decodeText(String string) {
        if (string == null) {
            return string;
        }
        if (CodeUtils.isCJKEncoded(string)) {
            try {
                return CodeUtils.cjkDecode(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public static String md5Encode(String string, Object object, String string2) {
        String string3 = null;
        try {
            String string4;
            MessageDigest messageDigest = MessageDigest.getInstance(string2);
            String string5 = string4 = string == null ? "" : string;
            if (object != null && StringUtils.isNotEmpty(object.toString())) {
                string4 = string4 + "{" + object.toString() + "}";
            }
            byte[] byArray = messageDigest.digest(string4.getBytes("UTF-8"));
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                stringBuffer.append(CodeUtils.byteToHexString(byArray[i2]));
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return string3;
        }
    }

    public static String byteToHexString(byte n2) {
        int n3 = n2;
        if (n3 < 0) {
            n3 = EIGHTTIMES2 + n3;
        }
        int n4 = n3 / HEX;
        int n5 = n3 % HEX;
        return HEXDIGITS[n4] + HEXDIGITS[n5];
    }
}

