/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule.task;

import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.data.dao.CommonFieldColumnMapper;
import com.fr.data.dao.FieldColumnMapper;
import com.fr.data.dao.ObjectTableMapper;
import com.fr.fs.schedule.ScheduleContext;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.schedule.task.ItriggerTask;
import com.fr.schedule.task.ScheduleTask;
import com.fr.schedule.util.ScheduleLogUtils;
import com.fr.schedule.util.TaskConfig;
import com.fr.third.org.quartz.Scheduler;
import com.fr.third.org.quartz.SchedulerException;
import com.fr.third.org.quartz.Trigger;

public class SAPSynTask
extends ItriggerTask {
    private static final long serialVersionUID = 1L;
    public static final String TABLE_NAME = "fr_schedule_sapsyn_task";
    private static FRLogger log = FRLogger.getLogger();
    private String transfers;
    public static final ObjectTableMapper OBJECT_MAPPER = new ObjectTableMapper(SAPSynTask.class, new Table("fr_schedule_sapsyn_task"), new FieldColumnMapper[]{ID, NAME, DES, REPEATTIME, REPEATTIMES, COUNTS, ITRIGGER, TASKPARAMETERS, new CommonFieldColumnMapper("transfers", 12, new ColumnSize(511))}, 0);

    public SAPSynTask() {
    }

    public SAPSynTask(TaskConfig taskConfig) {
        super(taskConfig);
        this.transfers = taskConfig.getTransfer();
    }

    public String getTransfers() {
        return this.transfers;
    }

    public String[] getTransferNames() {
        if (this.transfers != null) {
            try {
                JSONArray jSONArray = new JSONArray(this.transfers);
                String[] stringArray = new String[jSONArray.length()];
                for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                    stringArray[i2] = jSONArray.getString(i2);
                }
                return stringArray;
            }
            catch (JSONException jSONException) {
                ScheduleLogUtils.error(jSONException);
                return null;
            }
        }
        return null;
    }

    public void setTransfers(String string) {
        this.transfers = string;
    }

    public JSONObject createJSONConfig() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        super.createJSONConfig(jSONObject);
        jSONObject.put("transfers", new JSONArray(this.transfers));
        return jSONObject;
    }

    protected void setTriggerState(JSONObject jSONObject) throws JSONException {
        try {
            Scheduler scheduler = ScheduleContext.getScheduler();
            Trigger[] triggerArray = scheduler.getTriggersOfJob(this.getName(), "SAPSyn");
            if (triggerArray.length > 0) {
                Trigger trigger = triggerArray[0];
                int n2 = scheduler.getTriggerState(trigger.getName(), trigger.getGroup());
                jSONObject.put("state", n2);
            }
        }
        catch (SchedulerException schedulerException) {
            ScheduleLogUtils.error(schedulerException);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof ScheduleTask)) {
            return false;
        }
        SAPSynTask sAPSynTask = (SAPSynTask)object;
        return super.equals(object) && ComparatorUtils.equals(this.transfers, sAPSynTask.transfers);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

