/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule.entry;

import com.fr.fs.schedule.ScheduleContext;
import com.fr.fs.schedule.job.SAPSynJob;
import com.fr.fs.schedule.trigger.ITrigger;
import com.fr.fs.schedule.trigger.OnceITrigger;
import com.fr.general.FRLogger;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.schedule.entry.EntryManager;
import com.fr.schedule.task.SAPSynTask;
import com.fr.schedule.util.ScheduleLogUtils;
import com.fr.schedule.util.TaskConfig;
import com.fr.third.org.quartz.JobDetail;
import com.fr.third.org.quartz.Scheduler;
import com.fr.third.org.quartz.SchedulerException;
import com.fr.third.org.quartz.Trigger;
import com.fr.web.platform.TransmitParameters;
import java.util.Date;
import java.util.List;

public class SAPSynManager {
    public static final String SAPSYN_GROUP_NAME = "SAPSyn";
    private static FRLogger log = FRLogger.getLogger();

    public static JSONArray getAllTasks() {
        JSONArray jSONArray = new JSONArray();
        List list = ScheduleContext.createDAOSession().list(SAPSynTask.class);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            SAPSynTask sAPSynTask = (SAPSynTask)list.get(i2);
            try {
                JSONObject jSONObject = sAPSynTask.createJSONConfig();
                jSONArray.put(jSONObject);
                continue;
            }
            catch (JSONException jSONException) {
                ScheduleLogUtils.error(jSONException);
            }
        }
        return jSONArray;
    }

    public static void addOrUpdateTask(JSONObject jSONObject) {
        try {
            String string = jSONObject.getString("name");
            String string2 = "";
            String string3 = jSONObject.getString("repeatTime");
            String string4 = jSONObject.getString("repeatTimes");
            ITrigger iTrigger = EntryManager.parseITrigger(jSONObject.getJSONObject("iTrigger"));
            JSONArray jSONArray = jSONObject.getJSONArray("transmitParameters");
            TransmitParameters transmitParameters = TransmitParameters.parseJSON(jSONArray);
            JSONArray jSONArray2 = jSONObject.getJSONArray("transfers");
            SAPSynTask sAPSynTask = null;
            ITrigger iTrigger2 = null;
            if (jSONObject.has("id")) {
                sAPSynTask = (SAPSynTask)ScheduleContext.createDAOSession().load(SAPSynTask.class, jSONObject.getLong("id"));
                iTrigger2 = sAPSynTask.getITrigger();
                sAPSynTask.setName(string);
                sAPSynTask.setDescription(string2);
                sAPSynTask.setITrigger(iTrigger);
                sAPSynTask.setCounts(0);
                sAPSynTask.setTaskParameters(transmitParameters);
                sAPSynTask.setRepeatTime(string3);
                sAPSynTask.setRepeatTimes(string4);
                sAPSynTask.setTransfers(jSONArray2.toString());
            } else {
                TaskConfig taskConfig = new TaskConfig();
                taskConfig.setName(string);
                taskConfig.setDescription(string2);
                taskConfig.setiTrigger(iTrigger);
                taskConfig.setTaskParameters(transmitParameters);
                taskConfig.setRepeatTime(string3);
                taskConfig.setRepeatTimes(string4);
                taskConfig.setTransfer(jSONArray2.toString());
                sAPSynTask = new SAPSynTask(taskConfig);
            }
            ScheduleContext.createDAOSession().saveOrUpdate(sAPSynTask);
            SAPSynManager.scheduleTask(sAPSynTask, false, iTrigger2);
        }
        catch (JSONException jSONException) {
            ScheduleLogUtils.error(jSONException);
        }
    }

    public static void scheduleTask(SAPSynTask sAPSynTask, boolean bl, ITrigger iTrigger) {
        JobDetail jobDetail = new JobDetail(sAPSynTask.getName(), SAPSYN_GROUP_NAME, SAPSynJob.class);
        if (bl) {
            jobDetail.setName(jobDetail.getName() + Math.random() * 10000.0);
        }
        jobDetail.setDescription(sAPSynTask.getDescription());
        jobDetail.getJobDataMap().put("__task__", sAPSynTask.getId());
        if (bl) {
            jobDetail.getJobDataMap().put((Object)"__restarttask__", (Object)sAPSynTask);
        }
        ITrigger iTrigger2 = sAPSynTask.getITrigger();
        Trigger trigger = iTrigger2.createTrigger();
        if (bl) {
            trigger.setName(trigger.getName() + "_Restart_" + Math.random());
        }
        trigger.setJobName(jobDetail.getName());
        trigger.setJobGroup(jobDetail.getGroup());
        Scheduler scheduler = ScheduleContext.getScheduler();
        try {
            Trigger[] triggerArray = scheduler.getTriggersOfJob(jobDetail.getName(), jobDetail.getGroup());
            if (triggerArray.length > 0 && iTrigger != null) {
                scheduler.rescheduleJob(iTrigger.createTrigger().getName(), iTrigger.createTrigger().getGroup(), trigger);
            } else {
                scheduler.scheduleJob(jobDetail, trigger);
            }
        }
        catch (SchedulerException schedulerException) {
            ScheduleLogUtils.error(schedulerException);
        }
    }

    public static void delTasks(String string) {
        String[] stringArray = string.split(",");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            long l2 = Long.parseLong(stringArray[i2]);
            Object object = ScheduleContext.createDAOSession().load(SAPSynTask.class, l2);
            SAPSynManager.deleteTask((SAPSynTask)object);
        }
    }

    private static void deleteTask(SAPSynTask sAPSynTask) {
        Scheduler scheduler = ScheduleContext.getScheduler();
        try {
            scheduler.deleteJob(sAPSynTask.getName(), SAPSYN_GROUP_NAME);
        }
        catch (SchedulerException schedulerException) {
            ScheduleLogUtils.error(schedulerException);
        }
        ScheduleContext.createDAOSession().delete(sAPSynTask);
    }

    public static void reStartTask(SAPSynTask sAPSynTask, long l2) {
        sAPSynTask.setCounts(sAPSynTask.getCounts() + 1);
        SAPSynTask sAPSynTask2 = null;
        try {
            sAPSynTask2 = (SAPSynTask)sAPSynTask.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            log.error(cloneNotSupportedException.getMessage());
        }
        if (sAPSynTask2.getCounts() > Integer.parseInt(sAPSynTask.getRepeatTimes()) || Integer.parseInt(sAPSynTask.getRepeatTimes()) == 0) {
            return;
        }
        OnceITrigger onceITrigger = new OnceITrigger();
        onceITrigger.setStartType(2L);
        onceITrigger.setId(sAPSynTask.getITrigger().getId());
        onceITrigger.setStartTime(new Date(new Date().getTime() + l2));
        sAPSynTask2.setITrigger(onceITrigger);
        SAPSynManager.scheduleTask(sAPSynTask2, true, onceITrigger);
    }

    public static int stateJob(long l2) {
        int n2 = -1;
        Scheduler scheduler = ScheduleContext.getScheduler();
        SAPSynTask sAPSynTask = (SAPSynTask)ScheduleContext.createDAOSession().load(SAPSynTask.class, l2);
        if (sAPSynTask.getITrigger().getStartTime() != null && sAPSynTask.getITrigger().getStartTime().getTime() > System.currentTimeMillis()) {
            return ITrigger.WAITSTATE;
        }
        try {
            Trigger[] triggerArray = scheduler.getTriggersOfJob(sAPSynTask.getName(), SAPSYN_GROUP_NAME);
            if (triggerArray.length > 0) {
                Trigger trigger = triggerArray[0];
                n2 = scheduler.getTriggerState(trigger.getName(), trigger.getGroup());
                if (n2 == 0) {
                    scheduler.pauseJob(trigger.getJobName(), trigger.getJobGroup());
                } else {
                    scheduler.resumeJob(trigger.getJobName(), trigger.getJobGroup());
                }
                n2 = scheduler.getTriggerState(trigger.getName(), trigger.getGroup());
            }
        }
        catch (SchedulerException schedulerException) {
            ScheduleLogUtils.error(schedulerException);
        }
        return n2;
    }
}

