/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web.button;

import com.fr.base.IconManager;
import com.fr.base.TemplateUtils;
import com.fr.form.ui.Button;
import com.fr.form.ui.ToolBarMenuButton;
import com.fr.report.web.button.Excel;
import com.fr.report.web.button.Image;
import com.fr.report.web.button.PDF;
import com.fr.report.web.button.Word;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;

public final class Export
extends ToolBarMenuButton {
    private boolean pdfAvailable = true;
    private boolean excelPAvailable = true;
    private boolean excelOAvailable = true;
    private boolean excelSAvailable = true;
    private boolean wordAvailable = true;
    private boolean imageAvailable = true;
    private boolean htmlAvailabel = true;

    public Export() {
        super(TemplateUtils.i18nTpl("Export"), IconManager.EXPORT.getName());
    }

    public boolean isPdfAvailable() {
        return this.pdfAvailable;
    }

    public void setPdfAvailable(boolean bl) {
        this.pdfAvailable = bl;
    }

    public boolean isWordAvailable() {
        return this.wordAvailable;
    }

    public void setWordAvailable(boolean bl) {
        this.wordAvailable = bl;
    }

    public boolean isExcelPAvailable() {
        return this.excelPAvailable;
    }

    public void setExcelPAvailable(boolean bl) {
        this.excelPAvailable = bl;
    }

    public boolean isExcelOAvailable() {
        return this.excelOAvailable;
    }

    public void setExcelOAvailable(boolean bl) {
        this.excelOAvailable = bl;
    }

    public boolean isExcelSAvailable() {
        return this.excelSAvailable;
    }

    public void setExcelSAvailable(boolean bl) {
        this.excelSAvailable = bl;
    }

    public boolean isExcelAvailable() {
        return this.excelPAvailable || this.excelOAvailable || this.excelSAvailable;
    }

    public void setImageAvailable(boolean bl) {
        this.imageAvailable = bl;
    }

    public boolean isImageAvailable() {
        return this.imageAvailable;
    }

    public boolean isHtmlAvailabel() {
        return this.htmlAvailabel;
    }

    public void setHtmlAvailabel(boolean bl) {
        this.htmlAvailabel = bl;
    }

    public boolean supportMobile() {
        return false;
    }

    public Button[] createMenuItems() {
        ArrayList<Button> arrayList = new ArrayList<Button>();
        if (this.pdfAvailable) {
            arrayList.add(new PDF());
        }
        if (this.isExcelAvailable()) {
            arrayList.add(new Excel(this.excelPAvailable, this.excelOAvailable, this.excelSAvailable));
        }
        if (this.wordAvailable) {
            arrayList.add(new Word());
        }
        if (this.imageAvailable) {
            arrayList.add(new Image());
        }
        return arrayList.toArray(new Button[arrayList.size()]);
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("Buttons")) {
            this.setPdfAvailable(xMLableReader.getAttrAsBoolean("pdf", true));
            this.setWordAvailable(xMLableReader.getAttrAsBoolean("word", true));
            this.setExcelPAvailable(xMLableReader.getAttrAsBoolean("excelP", true));
            this.setExcelOAvailable(xMLableReader.getAttrAsBoolean("excelO", true));
            this.setExcelSAvailable(xMLableReader.getAttrAsBoolean("excelS", true));
            this.setImageAvailable(xMLableReader.getAttrAsBoolean("image", true));
            this.setHtmlAvailabel(xMLableReader.getAttrAsBoolean("html", true));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Buttons").attr("pdf", this.pdfAvailable).attr("excelP", this.excelPAvailable).attr("excelO", this.excelOAvailable).attr("excelS", this.excelSAvailable).attr("word", this.wordAvailable).attr("image", this.imageAvailable).attr("html", this.htmlAvailabel).end();
    }

    public boolean equals(Object object) {
        return object instanceof Export && super.equals(object) && ((Export)object).excelPAvailable == this.excelPAvailable && ((Export)object).excelOAvailable == this.excelOAvailable && ((Export)object).excelSAvailable == this.excelSAvailable && ((Export)object).imageAvailable == this.imageAvailable && ((Export)object).pdfAvailable == this.pdfAvailable && ((Export)object).wordAvailable == this.wordAvailable && ((Export)object).htmlAvailabel == this.htmlAvailabel;
    }
}

