/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.stable;

import com.fr.base.BaseXMLUtils;
import com.fr.base.Margin;
import com.fr.base.PaperSize;
import com.fr.base.background.ColorBackground;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.page.PaperSettingProvider;
import com.fr.page.ReportSettingsProvider;
import com.fr.stable.ColumnRow;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.unit.FU;
import com.fr.stable.unit.UNIT;
import com.fr.stable.unit.UnitUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.io.Serializable;

public class ReportSettings
implements XMLable,
Cloneable,
Serializable,
ReportSettingsProvider {
    public static final ReportSettings DEFAULTSETTINGS = new ReportSettings();
    private static final long serialVersionUID = -3314213013399129839L;
    public static final String XML_TAG = "ReportSettings";
    private PaperSettingProvider paperSetting = (PaperSettingProvider)StableFactory.createNewObject("PaperSetting");
    private int pageOrder = 0;
    private boolean isHorizontalCenterOnPage = false;
    private boolean isVerticalCenterOnPage = false;
    private int firstPageNumber = 1;
    private Background background = ColorBackground.getInstance(Color.white);
    private boolean isPreviewBackground = true;
    private boolean isPrintBackground = true;
    private ColumnRow writeFrozenColumnRow;
    private UNIT headerHeight = UNIT.ZERO;
    private UNIT footerHeight = UNIT.ZERO;
    private int shrinkToFitMode = 1;
    private static final long DHFH = 1938528L;

    public ColumnRow getWriteFrozenColumnRow() {
        return this.writeFrozenColumnRow;
    }

    public void setWriteFrozenColumnRow(ColumnRow columnRow) {
        this.writeFrozenColumnRow = columnRow;
    }

    public void setPaperSetting(PaperSettingProvider paperSettingProvider) {
        this.paperSetting = paperSettingProvider;
    }

    public PaperSettingProvider getPaperSetting() {
        return this.paperSetting;
    }

    public int getPageOrder() {
        return this.pageOrder;
    }

    public void setPageOrder(int n2) {
        this.pageOrder = n2;
    }

    public int getShrinkToFitMode() {
        return this.shrinkToFitMode;
    }

    public void setShrinkToFitMode(int n2) {
        this.shrinkToFitMode = n2;
    }

    public boolean isHorizontalCenterOnPage() {
        return this.isHorizontalCenterOnPage;
    }

    public void setHorizontalCenterOnPage(boolean bl) {
        this.isHorizontalCenterOnPage = bl;
    }

    public boolean isVerticalCenterOnPage() {
        return this.isVerticalCenterOnPage;
    }

    public void setVerticalCenterOnPage(boolean bl) {
        this.isVerticalCenterOnPage = bl;
    }

    public int getFirstPageNumber() {
        return this.firstPageNumber;
    }

    public void setFirstPageNumber(int n2) {
        this.firstPageNumber = n2;
    }

    public Background getBackground() {
        return this.background;
    }

    public void setBackground(Background background) {
        this.background = background;
    }

    public boolean isPreviewBackground() {
        return this.isPreviewBackground;
    }

    public void setPreviewBackground(boolean bl) {
        this.isPreviewBackground = bl;
    }

    public boolean isPrintBackground() {
        return this.isPrintBackground;
    }

    public void setPrintBackground(boolean bl) {
        this.isPrintBackground = bl;
    }

    public UNIT getHeaderHeight() {
        return this.headerHeight;
    }

    public void setHeaderHeight(UNIT uNIT) {
        this.headerHeight = uNIT;
    }

    public UNIT getFooterHeight() {
        return this.footerHeight;
    }

    public void setFooterHeight(UNIT uNIT) {
        this.footerHeight = uNIT;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.readAttr(xMLableReader);
        } else if (xMLableReader.isChildNode()) {
            this.readChildNode(xMLableReader);
        }
    }

    private void readAttr(XMLableReader xMLableReader) {
        this.setFirstPageNumber(xMLableReader.getAttrAsInt("firstPageNumber", 1));
        this.setPageOrder(xMLableReader.getAttrAsInt("pageOrder", 0));
        String string = xMLableReader.getAttrAsString("shrinkToFit", null);
        if (string != null) {
            this.setShrinkToFitMode(Boolean.valueOf(string) != false ? 1 : 0);
        }
        this.setShrinkToFitMode(xMLableReader.getAttrAsInt("shrinkToFitMode", 1));
        this.setHorizontalCenterOnPage(xMLableReader.getAttrAsBoolean("isHorizontalCenterOnPage", false));
        this.setVerticalCenterOnPage(xMLableReader.getAttrAsBoolean("isVerticalCenterOnPage", false));
        this.setFirstPageNumber(xMLableReader.getAttrAsInt("firstPageNumber", 1));
        if (!xMLableReader.getXMLVersion().isAfterREPORT_REFECT_FOR65_4_XML_VERSION()) {
            this.setHeaderHeight(UnitUtils.unit4CompatibleInchDV(xMLableReader.getAttrAsString("headerHeight", "0")));
            this.setFooterHeight(UnitUtils.unit4CompatibleInchDV(xMLableReader.getAttrAsString("footerHeight", "0")));
        } else if (!xMLableReader.getXMLVersion().isAfterUNIT_REFECT_XML_VERSION()) {
            this.setHeaderHeight(UnitUtils.unit4CompatibleMMDV(xMLableReader.getAttrAsString("headerHeight", "0")));
            this.setFooterHeight(UnitUtils.unit4CompatibleMMDV(xMLableReader.getAttrAsString("footerHeight", "0")));
        } else {
            this.setHeaderHeight(FU.getInstance(xMLableReader.getAttrAsLong("headerHeight", 0L)));
            this.setFooterHeight(FU.getInstance(xMLableReader.getAttrAsLong("footerHeight", 0L)));
        }
        this.setPreviewBackground(xMLableReader.getAttrAsBoolean("previewBackground", true));
        this.setPrintBackground(xMLableReader.getAttrAsBoolean("printBackground", true));
        this.getPaperSetting().setOrientation(xMLableReader.getAttrAsInt("orientation", 0));
    }

    private void readChildNode(XMLableReader xMLableReader) {
        String string = xMLableReader.getTagName();
        if ("PaperSetting".equals(string)) {
            PaperSettingProvider paperSettingProvider = this.getPaperSetting();
            xMLableReader.readXMLObject(paperSettingProvider);
        } else if (string.equals("Background")) {
            this.setBackground(BaseXMLUtils.readBackground(xMLableReader));
        } else if (xMLableReader.getTagName().equals("FrozenColumnRow")) {
            ColumnRow columnRow;
            String string2 = xMLableReader.getAttrAsString("columnrow", null);
            if (string2 != null && ColumnRow.validate(columnRow = ColumnRow.valueOf(string2))) {
                this.setWriteFrozenColumnRow(columnRow);
            }
        } else if (string.equals("PaperSize")) {
            PaperSize paperSize = new PaperSize();
            this.getPaperSetting().setPaperSize(paperSize);
            paperSize.setWidth(UnitUtils.unit4CompatibleInchDV(xMLableReader.getAttrAsString("width", "0")));
            paperSize.setHeight(UnitUtils.unit4CompatibleInchDV(xMLableReader.getAttrAsString("height", "0")));
        } else if (string.equals("Margin")) {
            Margin margin = new Margin();
            this.getPaperSetting().setMargin(margin);
            margin.setTop(UnitUtils.unit4CompatibleInchDV(xMLableReader.getAttrAsString("top", "0")));
            margin.setLeft(UnitUtils.unit4CompatibleInchDV(xMLableReader.getAttrAsString("left", "0")));
            margin.setBottom(UnitUtils.unit4CompatibleInchDV(xMLableReader.getAttrAsString("bottom", "0")));
            margin.setRight(UnitUtils.unit4CompatibleInchDV(xMLableReader.getAttrAsString("right", "0")));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        PaperSettingProvider paperSettingProvider;
        xMLPrintWriter.startTAG(XML_TAG);
        if (this.getFirstPageNumber() != 1) {
            xMLPrintWriter.attr("firstPageNumber", this.getFirstPageNumber());
        }
        if (this.getPageOrder() != 0) {
            xMLPrintWriter.attr("pageOrder", this.getPageOrder());
        }
        if (this.shrinkToFitMode != 1) {
            xMLPrintWriter.attr("shrinkToFitMode", this.getShrinkToFitMode());
        }
        if (this.isHorizontalCenterOnPage()) {
            xMLPrintWriter.attr("isHorizontalCenterOnPage", this.isHorizontalCenterOnPage());
        }
        if (this.isVerticalCenterOnPage()) {
            xMLPrintWriter.attr("isVerticalCenterOnPage", this.isVerticalCenterOnPage());
        }
        if (this.getHeaderHeight().toFU() != 1938528L) {
            xMLPrintWriter.attr("headerHeight", this.getHeaderHeight().toFU());
        }
        if (this.getFooterHeight().toFU() != 1938528L) {
            xMLPrintWriter.attr("footerHeight", this.getFooterHeight().toFU());
        }
        if (!this.isPrintBackground()) {
            xMLPrintWriter.attr("printBackground", this.isPrintBackground());
        }
        if (ColumnRow.validate(this.writeFrozenColumnRow)) {
            xMLPrintWriter.startTAG("FrozenColumnRow").attr("columnrow", this.writeFrozenColumnRow.toString()).end();
        }
        if ((paperSettingProvider = this.getPaperSetting()) != null) {
            paperSettingProvider.writeXML(xMLPrintWriter);
        }
        Background background = this.getBackground();
        if (!ColorBackground.getInstance(Color.white).equals(background)) {
            BaseXMLUtils.writeBackground(xMLPrintWriter, background);
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        ReportSettings reportSettings = (ReportSettings)super.clone();
        if (this.writeFrozenColumnRow != null) {
            reportSettings.setWriteFrozenColumnRow((ColumnRow)this.writeFrozenColumnRow.clone());
        }
        if (this.getBackground() != null) {
            reportSettings.setBackground((Background)this.getBackground().clone());
        } else {
            reportSettings.setBackground(null);
        }
        return reportSettings;
    }

    public boolean equals(Object object) {
        return object instanceof ReportSettings && this.isHorizontalCenterOnPage == ((ReportSettings)object).isHorizontalCenterOnPage && this.isPreviewBackground == ((ReportSettings)object).isPreviewBackground && this.isPrintBackground == ((ReportSettings)object).isPrintBackground && this.isVerticalCenterOnPage == ((ReportSettings)object).isVerticalCenterOnPage && this.firstPageNumber == ((ReportSettings)object).firstPageNumber && this.pageOrder == ((ReportSettings)object).pageOrder && this.shrinkToFitMode == ((ReportSettings)object).shrinkToFitMode && ComparatorUtils.equals(this.headerHeight, ((ReportSettings)object).headerHeight) && ComparatorUtils.equals(this.footerHeight, ((ReportSettings)object).footerHeight) && ComparatorUtils.equals(this.paperSetting, ((ReportSettings)object).paperSetting) && ComparatorUtils.equals(this.background, ((ReportSettings)object).background) && ComparatorUtils.equals(this.writeFrozenColumnRow, ((ReportSettings)object).writeFrozenColumnRow);
    }
}

