/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.core.sheet;

import com.fr.cache.list.IntList;
import com.fr.main.impl.WorkBook;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.parser.SheetIntervalLiteral;
import com.fr.privilege.PrivilegeManager;
import com.fr.report.core.A.H;
import com.fr.report.core.sheet.SequenceExecuter;
import com.fr.report.core.sheet.SheetExecuter;
import com.fr.report.core.sheet.WorkBookExecuter;
import com.fr.report.elementcase.ResultElementCase;
import com.fr.report.elementcase.TemplateElementCase;
import com.fr.report.report.ResultReport;
import com.fr.report.report.TemplateReport;
import com.fr.report.worksheet.WorkSheet;
import com.fr.script.Calculator;
import com.fr.stable.Actor;
import com.fr.stable.ListMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SheetSequenceExecuter
extends SequenceExecuter {
    private WorkBook workbook;
    private WorkBookExecuter bookExecuter;

    public SheetSequenceExecuter(WorkBook workBook, Map map) {
        if (workBook != null) {
            int n2 = workBook.getReportCount();
            this.nameListMap = new ListMap(n2);
            this.executed_mark = new IntList(n2);
            this.executer_list = new ArrayList(n2);
            this.exe_info_list = new ArrayList(n2);
            this.exe_start_time_list = new ArrayList(workBook.getReportCount());
            for (int i2 = 0; i2 < n2; ++i2) {
                TemplateReport templateReport = workBook.getTemplateReport(i2);
                this.nameListMap.put(workBook.getReportName(i2), templateReport);
                this.executed_mark.add(0);
                this.executer_list.add(null);
                this.exe_info_list.add(new int[n2]);
                this.exe_start_time_list.add(null);
            }
        }
        this.workbook = workBook;
        this.parameterMap = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultWorkBook execute(Actor actor) {
        if (this.workbook == null) {
            return null;
        }
        this.bookExecuter = actor.createWorkBookExecuter(this.workbook, this.parameterMap);
        this._execute();
        try {
            ResultWorkBook resultWorkBook = this.bookExecuter.result();
            return resultWorkBook;
        }
        finally {
            this.bookExecuter = null;
        }
    }

    private void _execute() {
        int n2 = this.nameListMap.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            TemplateReport templateReport = (TemplateReport)this.nameListMap.getByIndex(i2);
            this.current_index = i2;
            ResultReport resultReport = null;
            if (!templateReport.isElementCaseReport()) {
                String[] stringArray = PrivilegeManager.getRoleFromCalculator(Calculator.createCalculator());
                if (templateReport.getWorkSheetPrivilegeControl().checkInvisible(stringArray)) {
                    this.executed_mark.set(this.current_index, 1);
                } else {
                    resultReport = this.bookExecuter.execute(this.current_index, templateReport);
                }
            } else {
                this.stuffExecuter(this.bookExecuter.getExeType(), templateReport);
            }
            if (null == resultReport) continue;
            this.executed_mark.set(this.current_index, 1);
        }
        while (this.next()) {
            SheetExecuter sheetExecuter = this.getExecuter();
            this.execute(sheetExecuter);
        }
    }

    protected long execute4Expand(SheetExecuter sheetExecuter) {
        return sheetExecuter == null ? 0L : sheetExecuter.execute4Expand(this.bookExecuter.getExeType());
    }

    protected void addExecute4Result(SheetExecuter sheetExecuter, long l2) {
        this.bookExecuter.addResult(this.current_index, sheetExecuter.execute4ECReport(this.bookExecuter.getExeType(), l2));
    }

    protected void addExcute4Result(int n2) {
        this.bookExecuter.addResult(n2, ((SheetExecuter)this.executer_list.get(n2)).execute4ECReport(this.bookExecuter.getExeType(), (Long)this.exe_start_time_list.get(n2)));
    }

    protected String getLiteralName(List list, int n2) {
        SheetIntervalLiteral sheetIntervalLiteral = (SheetIntervalLiteral)list.get(n2);
        return sheetIntervalLiteral.getSheetName();
    }

    public TemplateElementCase getTemplateByIndex(int n2) {
        TemplateReport templateReport = (TemplateReport)this.nameListMap.getByIndex(n2);
        if (templateReport.isElementCaseReport()) {
            return (TemplateElementCase)((Object)templateReport);
        }
        return null;
    }

    public ResultElementCase getResultByIndex(int n2) {
        if (this.bookExecuter != null) {
            return this.bookExecuter.getResultByIndex(n2);
        }
        return null;
    }

    private void stuffExecuter(Actor actor, TemplateReport templateReport) {
        try {
            templateReport = (WorkSheet)templateReport.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
        if (this.parameterMap == null) {
            this.parameterMap = Collections.EMPTY_MAP;
        }
        if (!actor.canCalculateOnDemand() || ((WorkSheet)templateReport).getLayerReportAttr() == null) {
            H h2 = new H((WorkSheet)templateReport, this.parameterMap, this, templateReport.getTableDataSource());
            this.executer_list.set(this.current_index, h2);
        }
    }
}

