/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cell.painter.barcode.output;

import com.fr.report.cell.painter.barcode.layout.LabelLayout;
import com.fr.report.cell.painter.barcode.output.AbstractOutput;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;

public class GraphicsOutput
extends AbstractOutput {
    public static final int BARS_TEXT_VGAP = 4;
    private final Graphics2D g;

    public GraphicsOutput(Graphics2D graphics2D, Font font, double d2, double d3, boolean bl, Color color, Color color2) {
        super(font, d2, d3, bl, 1.0, color, color2);
        this.g = graphics2D;
    }

    public void beginDraw(double d2, double d3) {
    }

    public void endDraw() {
    }

    public void drawBar(int n2, int n3, int n4, int n5, boolean bl) {
        if (this.painting) {
            if (bl) {
                this.g.setColor(this.foregroundColour);
            } else {
                this.g.setColor(this.backgroundColour);
            }
            this.g.fillRect((int)(this.scalar * (double)n2), (int)(this.scalar * (double)n3), (int)(this.scalar * (double)n4), (int)(this.scalar * (double)n5));
        }
    }

    public double drawText(String string, double d2, double d3, double d4) {
        if (this.font == null) {
            return 0.0;
        }
        Font font = new Font("Times Roman", 0, 12);
        TextLayout textLayout = new TextLayout(string, font, this.g.getFontRenderContext());
        double d5 = (float)(d3 + textLayout.getBounds().getHeight() + 4.0);
        int n2 = (int)(d5 - d3 + 1.0);
        if (this.painting) {
            this.g.setColor(this.backgroundColour);
            this.g.fillRect((int)d2, (int)d3, (int)(d4 - d2), n2);
            this.g.setColor(this.foregroundColour);
            double d6 = (d4 - d2) / (double)string.length();
            for (int i2 = 0; i2 < string.length(); ++i2) {
                this.g.drawString("" + string.charAt(i2), (int)(d2 + d6 * (double)i2 + d6 / 2.0), (int)d5);
            }
        }
        return n2;
    }

    public void drawText(String string, LabelLayout labelLayout) {
        if (this.font == null) {
            return;
        }
        this.font = new Font("SimSun", 0, 12);
        TextLayout textLayout = new TextLayout(string, this.font, this.g.getFontRenderContext());
        labelLayout.setTextLayout(textLayout);
        if (this.painting) {
            this.g.setColor(this.backgroundColour);
            this.g.fillRect(labelLayout.getBackgroundX(), labelLayout.getBackgroundY(), labelLayout.getBackgroundWidth(), labelLayout.getBackgroundHeight());
            this.g.setColor(this.foregroundColour);
            textLayout.draw(this.g, labelLayout.getTextX(), labelLayout.getTextY());
        }
    }
}

