/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cell.painter.barcode.line.code128;

import com.fr.report.cell.painter.barcode.BarcodeException;
import com.fr.report.cell.painter.barcode.BarcodeImpl;
import com.fr.report.cell.painter.barcode.BlankModule;
import com.fr.report.cell.painter.barcode.CompositeModule;
import com.fr.report.cell.painter.barcode.Module;
import com.fr.report.cell.painter.barcode.line.code128.Accumulator;
import com.fr.report.cell.painter.barcode.line.code128.CharBuffer;
import com.fr.report.cell.painter.barcode.line.code128.CodeChangeModule;
import com.fr.report.cell.painter.barcode.line.code128.ModuleFactory;
import com.fr.report.cell.painter.barcode.line.code128.ShiftModule;
import com.fr.report.cell.painter.barcode.output.AbstractOutput;
import com.fr.report.cell.painter.barcode.output.GraphicsOutput;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class Code128Barcode
extends BarcodeImpl {
    public static final int A = 0;
    public static final int B = 1;
    public static final int C = 2;
    public static final int O = 3;
    public static final String SHIFT = "\u00c6";
    public static final String CHANGE_TO_A = "\u00c9";
    public static final String CHANGE_TO_B = "\u00c8";
    public static final String CHANGE_TO_C = "\u00c7";
    public static final String FNC_1 = "\u00ca";
    protected static final Module START_A = new Module(new int[]{2, 1, 1, 4, 1, 2});
    protected static final Module START_B = new Module(new int[]{2, 1, 1, 2, 1, 4});
    protected static final Module START_C = new Module(new int[]{2, 1, 1, 2, 3, 2});
    protected static final Module STOP = new Module(new int[]{2, 3, 3, 1, 1, 1, 2});
    protected static final Module QUIET_SECTION = new BlankModule(10);
    private static final Module[] START = new Module[]{START_A, START_B, START_C};
    protected static final int[] START_INDICES = new int[]{103, 104, 105};
    protected static final int[] BUF_SIZES = new int[]{1, 1, 2};
    protected int startIndex;
    protected int mode;
    private int startingMode;
    private boolean shiftNext;
    private boolean shifted;
    private CharBuffer buf;
    private Module checkDigit;
    private boolean optimising;
    private Accumulator sum;
    private Accumulator index;

    public Code128Barcode(String string) throws BarcodeException {
        this(string, 3);
    }

    public Code128Barcode(String string, int n2) throws BarcodeException {
        super(string);
        if (n2 == 3) {
            this.optimising = true;
            this.mode = 1;
        } else {
            this.optimising = false;
            this.mode = n2;
        }
        this.startingMode = this.mode;
        this.shiftNext = false;
        this.shifted = false;
        this.startIndex = START_INDICES[this.mode];
    }

    public int getCharacterSet() {
        return this.startingMode;
    }

    protected String getLabel() {
        return this.data;
    }

    protected double getBarcodeWidth(int n2) {
        return this.getQuietZoneWidth() * 2.0 + this.getSymbolWidth(n2);
    }

    protected double getSymbolWidth(int n2) {
        double d2 = this.convertToMillimetres(this.barWidth, n2);
        double d3 = 11.0;
        if (this.startingMode == 2) {
            d3 = 5.5;
        }
        return (d3 * (double)this.data.length() + 35.0) * d2;
    }

    protected double calculateMinimumBarHeight(int n2) {
        double d2 = (double)n2 * 0.25;
        return Math.max(0.15 * this.getSymbolWidth(n2), d2);
    }

    protected Module[] encodeData() {
        this.sum = new Accumulator(this.startIndex);
        ArrayList arrayList = new ArrayList();
        this.buf = new CharBuffer(BUF_SIZES[this.mode]);
        this.index = new Accumulator(1);
        this.padDataToEvenLength();
        for (int i2 = 0; i2 < this.data.length(); ++i2) {
            char c2 = this.data.charAt(i2);
            if (this.optimising && this.startingMode == 1) {
                if (i2 + 1 < this.data.length() && this.isControl(c2) && this.mode != 0) {
                    if (this.mode == 1) {
                        this.encode(arrayList, SHIFT);
                    } else {
                        this.encode(arrayList, CHANGE_TO_A);
                    }
                } else if (i2 + 3 < this.data.length() && this.digitGroupIsNext(i2, this.data) && this.mode != 2) {
                    this.encode(arrayList, CHANGE_TO_C);
                } else if (i2 + 1 <= this.data.length() && this.digitGroupEndIsNext(i2, this.data) && this.mode == 2 && this.buf.size() != 1) {
                    this.encode(arrayList, CHANGE_TO_B);
                }
            }
            if (this.isShiftOrCode(c2)) {
                this.encode(arrayList, String.valueOf(c2));
                this.buf.clear();
                continue;
            }
            this.buf.addChar(c2);
            if (!this.buf.isFull()) continue;
            this.encode(arrayList, this.buf.toString());
            this.buf.clear();
        }
        this.checkDigit = ModuleFactory.getModuleForIndex(this.sum.getValue() % 103, this.mode);
        this.mode = this.startingMode;
        return arrayList.toArray(new Module[0]);
    }

    private boolean isShiftOrCode(char c2) {
        String string = String.valueOf(c2);
        return string.equals(SHIFT) || string.equals(CHANGE_TO_A) || string.equals(CHANGE_TO_B) || string.equals(CHANGE_TO_C) || string.equals(FNC_1);
    }

    protected Module calculateChecksum() {
        if (this.checkDigit == null) {
            this.encodeData();
        }
        return this.checkDigit;
    }

    protected Module getPreAmble() {
        CompositeModule compositeModule = new CompositeModule();
        compositeModule.add(QUIET_SECTION);
        compositeModule.add(START[this.mode]);
        return compositeModule;
    }

    protected Module getPostAmble() {
        CompositeModule compositeModule = new CompositeModule();
        compositeModule.add(STOP);
        compositeModule.add(QUIET_SECTION);
        return compositeModule;
    }

    protected double getQuietZoneWidth() {
        return 10.0 * this.barWidth;
    }

    private boolean isControl(char c2) {
        return Character.isISOControl(c2);
    }

    private boolean digitGroupIsNext(int n2, String string) {
        char c2 = string.charAt(n2);
        char c3 = string.charAt(n2 + 1);
        char c4 = string.charAt(n2 + 2);
        char c5 = string.charAt(n2 + 3);
        return Character.isDigit(c2) && Character.isDigit(c3) && Character.isDigit(c4) && Character.isDigit(c5);
    }

    private boolean digitGroupEndIsNext(int n2, String string) {
        if (n2 == string.length() - 1) {
            return true;
        }
        char c2 = string.charAt(n2);
        char c3 = string.charAt(n2 + 1);
        return Character.isDigit(c2) && !Character.isDigit(c3) || !Character.isDigit(c2);
    }

    private void padDataToEvenLength() {
        if (this.startingMode == 2 && this.data.length() % 2 != 0 && !this.containsShiftOrChange(this.data)) {
            this.data = '0' + this.data;
        }
    }

    private boolean containsShiftOrChange(String string) {
        return string.indexOf(CHANGE_TO_A) >= 0 || string.indexOf(CHANGE_TO_B) >= 0 || string.indexOf(CHANGE_TO_C) >= 0 || string.indexOf(SHIFT) >= 0;
    }

    private void clearShift() {
        if (this.shifted) {
            this.shifted = false;
            this.shiftNext = false;
            this.mode = this.shiftMode();
        }
    }

    private void checkShift(Module module) {
        if (module instanceof ShiftModule) {
            this.mode = this.shiftMode();
            this.shiftNext = true;
        } else if (this.shiftNext) {
            this.shifted = true;
        }
    }

    private int shiftMode() {
        if (this.mode == 0) {
            return 1;
        }
        return 0;
    }

    private void checkCodeChange(Module module) {
        if (module instanceof CodeChangeModule) {
            this.mode = ((CodeChangeModule)module).getCode();
            this.buf = new CharBuffer(BUF_SIZES[this.mode]);
        }
    }

    private void encode(List list, String string) {
        Module module = ModuleFactory.getModule(string, this.mode);
        this.updateCheckSum(string);
        this.checkShift(module);
        this.checkCodeChange(module);
        list.add(module);
        this.clearShift();
    }

    private void updateCheckSum(String string) {
        int n2 = ModuleFactory.getIndex(string, this.mode);
        this.sum.add(n2 * this.index.getValue());
        this.index.increment();
    }

    private double convertToMillimetres(double d2, int n2) {
        double d3 = (double)n2 / 25.4;
        return d2 / d3;
    }

    protected Dimension draw(GraphicsOutput graphicsOutput, int n2, int n3, double d2, double d3) {
        return null;
    }

    protected Dimension draw(AbstractOutput abstractOutput, int n2, int n3, double d2, double d3) {
        return null;
    }
}

