/*
 * Decompiled with CFR 0.152.
 */
package com.fr.record;

import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.HSQLDialect;
import com.fr.data.core.db.dml.Insert;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.dml.Update;
import com.fr.data.core.db.dml.Where;
import com.fr.data.impl.JDBCDatabaseConnection;
import com.fr.general.DeclareRecordType;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.general.RecordManager;
import com.fr.record.ErrorRecord;
import com.fr.record.ExecuteRecord;
import com.fr.record.ExportRecord;
import com.fr.record.JdbcTemplate;
import com.fr.record.PrintRecord;
import com.fr.record.RecordTables;
import com.fr.record.ScheduleRecord;
import com.fr.stable.EnvChangedListener;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class DBRecordManager
implements RecordManager {
    public static Timer DB_RECORD_MANAGER_TIMER = null;
    private static JDBCDatabaseConnection databaseConnection;
    private JdbcTemplate jdbcTemplate;
    private static final int STATE_ERROR = -2;
    private static final int STATE_OFF = -1;
    private static final int STATE_ON = 1;
    private int state = 1;
    private boolean inited = false;
    private int dayofweek = 7;
    private int dayofmouth = 30;
    private int hourofday = 24;
    private int secondofhour = 3600;
    private int thousand = 1000;

    private void init() throws Exception {
        this.inited = true;
        this.state = -1;
        Connection connection = null;
        try {
            connection = DBRecordManager.getDB().createConnection();
            RecordTables recordTables = new RecordTables();
            recordTables.generatorModuleTables(connection);
            recordTables.generateIndexs(connection);
            this.jdbcTemplate = new JdbcTemplate(DBRecordManager.getDB());
            this.initDelTraceTimer();
        }
        catch (Exception exception) {
            this.state = -2;
            throw exception;
        }
        finally {
            DBUtils.closeConnection(connection);
        }
        this.state = 1;
    }

    public synchronized boolean isOK() {
        return this.state != -2;
    }

    public static synchronized JDBCDatabaseConnection getDB() {
        if (databaseConnection == null) {
            databaseConnection = DBUtils.getEmbeddedDB("logdb", 5);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Class<DBRecordManager> clazz = DBRecordManager.class;
                    synchronized (DBRecordManager.class) {
                        if (databaseConnection != null) {
                            try {
                                databaseConnection.createConnection().createStatement().execute("shutdown");
                            }
                            finally {
                                databaseConnection = null;
                            }
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                {
                    return;
                }
            }
        });
        return databaseConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void shutdownDB() throws Exception {
        if (databaseConnection != null) {
            try {
                databaseConnection.createConnection().createStatement().execute("shutdown");
            }
            finally {
                databaseConnection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void recordErrorInfo(String string, short s2, String string2, String string3, String string4, String string5) throws Exception {
        if (this.state <= -1) {
            return;
        }
        if (!this.inited) {
            this.init();
        }
        this.state = -1;
        try {
            Insert insert = ErrorRecord.getInstance().createInsert(string, s2, string2, string3, string4, new Date(), string5);
            this.executeInsert(insert);
        }
        finally {
            this.state = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void recordScheduleInfo(String string, short s2, String string2, String string3, String string4, String string5, String string6) throws Exception {
        if (this.state <= -1) {
            return;
        }
        if (!this.inited) {
            this.init();
        }
        this.state = -1;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-DD HH:mm:ss");
            Insert insert = ScheduleRecord.getInstance().createInsert(string, s2, string2, string3, string4, simpleDateFormat.parse(simpleDateFormat.format(new Date())), string5);
            this.executeInsert(insert);
        }
        finally {
            this.state = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void recordExecuteInfo(String string, DeclareRecordType declareRecordType, String string2, long l2, String string3) throws Exception {
        if (this.state <= -1) {
            return;
        }
        if (!this.inited) {
            this.init();
        }
        this.state = -1;
        try {
            Insert insert = ExecuteRecord.getInstance().createInsert(string, declareRecordType.getTypeMark(), string2, l2, new Date(), string3);
            this.executeInsert(insert);
        }
        finally {
            this.state = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordAccessNoExecuteInfo(String string, DeclareRecordType declareRecordType, String string2, String string3) throws Exception {
        if (this.state <= -1) {
            return;
        }
        if (!this.inited) {
            this.init();
        }
        this.state = -1;
        try {
            Insert insert = ExecuteRecord.getInstance().createInsert(string, declareRecordType.getTypeMark(), string2, new Date(), string3);
            this.executeInsert(insert);
        }
        finally {
            this.state = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void recordExportInfo(String string, String string2, DeclareRecordType declareRecordType, long l2, String string3) throws Exception {
        if (this.state <= -1) {
            return;
        }
        if (!this.inited) {
            this.init();
        }
        this.state = -1;
        try {
            Insert insert = ExportRecord.getInstance().createInsert(string, declareRecordType.getTypeMark(), string2, l2, new Date(), string3);
            this.executeInsert(insert);
        }
        finally {
            this.state = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void recordPrintInfo(String string, String string2, DeclareRecordType declareRecordType, String string3) throws Exception {
        if (this.state <= -1) {
            return;
        }
        if (!this.inited) {
            this.init();
        }
        this.state = -1;
        try {
            Insert insert = PrintRecord.getInstance().createInsert(string, declareRecordType.getTypeMark(), string2, new Date(), string3);
            this.executeInsert(insert);
        }
        finally {
            this.state = 1;
        }
    }

    private void executeInsert(Insert insert) throws Exception {
        if (insert != null) {
            this.jdbcTemplate.execute(insert);
        }
    }

    private void initDelTraceTimer() {
        DB_RECORD_MANAGER_TIMER = new Timer();
        long l2 = System.currentTimeMillis();
        long l3 = (long)this.dayofweek * (long)this.hourofday * (long)this.secondofhour * (long)this.thousand;
        long l4 = (l2 / l3 + 1L) * l3;
        DB_RECORD_MANAGER_TIMER.schedule((TimerTask)new DelTimerTask(), new Date(l4), l3);
    }

    static {
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                databaseConnection = null;
            }
        });
    }

    private class DelTimerTask
    extends TimerTask {
        private DelTimerTask() {
        }

        public void run() {
            Where where = new Where();
            Date date = new Date(System.currentTimeMillis() - (long)DBRecordManager.this.dayofweek * (long)DBRecordManager.this.hourofday * (long)DBRecordManager.this.secondofhour * (long)DBRecordManager.this.thousand);
            Date date2 = new Date(System.currentTimeMillis() - (long)DBRecordManager.this.dayofmouth * (long)DBRecordManager.this.hourofday * (long)DBRecordManager.this.secondofhour * (long)DBRecordManager.this.thousand);
            where.addColumn("logtime", 93, 4, date);
            where.addColumn("logtime", 93, 2, date2);
            where.addColumn("trace", -1, 1, "");
            Update update = new Update(new Table("fr_errrecord"), where, new HSQLDialect());
            update.addColumn("trace", -1, null);
            try {
                DBRecordManager.this.jdbcTemplate.execute(update);
            }
            catch (Exception exception) {
                FRLogger.getLogger().error("Log_DelTimerTask action failed! : " + exception.getMessage(), exception);
            }
        }
    }
}

