/*
 * Decompiled with CFR 0.152.
 */
package com.fr.process.web.services;

import com.fr.base.FRContext;
import com.fr.base.MultiFieldParameter;
import com.fr.base.Parameter;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dml.Insert;
import com.fr.data.core.db.dml.Select;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.dml.Update;
import com.fr.data.core.db.dml.Where;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.process.dao.ProcessExecutorCache;
import com.fr.process.engine.processexecutor.ProcessExecutor;
import com.fr.process.engine.processservice.ProceedInfo;
import com.fr.process.pdl.processdefine.ProcessOB;
import com.fr.process.pdl.processdefine.SystemOfProcesses;
import com.fr.process.pdl.task.AbstractTask;
import com.fr.process.pdl.task.EndTask;
import com.fr.process.pdl.task.FormTask;
import com.fr.process.pdl.task.SubProTask;
import com.fr.process.pdl.task.Task;
import com.fr.process.pdl.task.Task4Database;
import com.fr.process.web.services.ProcessServiceUtils;
import com.fr.stable.StringUtils;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.core.db.PlatformDB;
import com.fr.web.utils.WebUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ProcessExecuteContinueAction
extends ActionNoSessionCMD {
    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        FormTask formTask;
        long l2 = Long.valueOf(WebUtils.getHTTPRequestParameter(httpServletRequest, "id"));
        long l3 = ServiceUtils.getCurrentUserID(httpServletRequest);
        ProcessExecutor processExecutor = ProcessExecutorCache.getInstance().getProcessExecutorByID(l2);
        if (processExecutor == null) {
            ProcessServiceUtils.writeBack(httpServletResponse, "close");
            return;
        }
        this.saveOrUpdate(processExecutor, httpServletRequest);
        String string = processExecutor.getCurrentTaskName();
        if (string == null) {
            string = WebUtils.getHTTPRequestParameter(httpServletRequest, "taskname");
        }
        if ((formTask = (FormTask)processExecutor.getTask(string)) == null) {
            return;
        }
        formTask.continueTask(processExecutor, l3, ProceedInfo.createProceedInfoWithID(httpServletRequest));
        ProcessServiceUtils.writeBack(httpServletResponse, "success");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void saveOrUpdate(ProcessExecutor processExecutor, HttpServletRequest httpServletRequest) throws Exception {
        Object object;
        SystemOfProcesses systemOfProcesses = processExecutor.getProcessDefine().getSystem();
        String string = "FR_T_" + systemOfProcesses.getSystemName().toUpperCase();
        ProceedInfo proceedInfo = ProceedInfo.createProceedInfoWithID(httpServletRequest);
        Connection connection = ProcessExecuteContinueAction.getConnection();
        if (WebUtils.getHTTPRequestParameter(httpServletRequest, "id") != null) {
            object = WebUtils.getHTTPRequestParameter(httpServletRequest, "id");
        } else {
            object = systemOfProcesses.getAutoIncreasePara().getValue();
            systemOfProcesses.getAutoIncreasePara().setValue(new Integer(Integer.parseInt(object.toString()) + 1));
        }
        try {
            try {
                AbstractTask abstractTask = (AbstractTask)processExecutor.getTask(WebUtils.getHTTPRequestParameter(httpServletRequest, "taskname"));
                String string2 = "";
                if (StringUtils.isEmpty(proceedInfo.getTransitionName(0))) {
                    System.out.println("\u4e0d\u8df3\u8f6c\u53ea\u5165\u5e93");
                } else {
                    System.out.println("\u8df3\u8f6c : " + proceedInfo.getTransitionName(0));
                    string2 = this.getReportNameFromTran(processExecutor, proceedInfo.getTransitionName(0), abstractTask);
                }
                if (this.executeQuery(object, string, connection)) {
                    this.executeUpdate(object, string, proceedInfo, connection, string2, processExecutor.getProcessDefine());
                }
                this.executeInsert(proceedInfo, string, connection, string2, processExecutor.getProcessDefine());
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                connection.rollback();
                Object var11_12 = null;
                DBUtils.closeConnection(connection);
                return;
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            DBUtils.closeConnection(connection);
            throw throwable;
        }
        DBUtils.closeConnection(connection);
    }

    private static Connection getConnection() throws Exception {
        return PlatformDB.getDB().createConnection();
    }

    private boolean executeQuery(Object object, String string, Connection connection) throws SQLException {
        Dialect dialect = DialectFactory.generateDialect(connection);
        Table table = new Table(string);
        Select select = new Select(table, dialect);
        Where where = new Where();
        try {
            where.addColumn("FR_SYSTEM_ID", new Integer(Integer.parseInt(object.toString())));
        }
        catch (Exception exception) {
            where.addColumn("FR_SYSTEM_ID", new Integer(-1));
        }
        select.setWhere(where);
        PreparedStatement preparedStatement = select.createPreparedStatement(connection);
        ResultSet resultSet = preparedStatement.executeQuery();
        boolean bl = resultSet.next();
        DBUtils.closeResultSet(resultSet);
        DBUtils.closeStatement(preparedStatement);
        return bl;
    }

    private void executeInsert(ProceedInfo proceedInfo, String string, Connection connection, String string2, ProcessOB processOB) throws SQLException, JSONException {
        Parameter parameter;
        Dialect dialect = DialectFactory.generateDialect(connection);
        Table table = new Table(string);
        Insert insert = new Insert(table, dialect);
        Set set = processOB.getAllMultiFieldParaName();
        Set set2 = processOB.getParaNames();
        HashSet<String> hashSet = new HashSet<String>();
        int n2 = proceedInfo.getParaLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            parameter = proceedInfo.getPara(i2);
            if (!set2.contains(parameter.getName()) && !ComparatorUtils.equals(parameter.getName(), "FR_SYSTEM_ID")) {
                for (String string3 : set) {
                    MultiFieldParameter multiFieldParameter = (MultiFieldParameter)processOB.getParameterByName(string3);
                    if (!multiFieldParameter.getAllFiledName().contains(parameter.getName())) continue;
                    multiFieldParameter.setSingleParaValue(parameter.getName(), parameter.getValue());
                    hashSet.add(multiFieldParameter.getName());
                }
                continue;
            }
            insert.addColumn(parameter.getName(), this.checkTypeForSql(parameter.getValue()), parameter.getValue());
        }
        for (String string4 : hashSet) {
            parameter = (MultiFieldParameter)processOB.getParameterByName(string4);
            JSONArray jSONArray = new JSONArray();
            jSONArray.put(((MultiFieldParameter)parameter).getJSONObjectValue());
            insert.addColumn(string4, 12, jSONArray.toString());
        }
        if (StringUtils.isNotBlank(string2)) {
            insert.addColumn("nextTask", 12, string2);
        }
        insert.execute(connection);
    }

    private void executeUpdate(Object object, String string, ProceedInfo proceedInfo, Connection connection, String string2, ProcessOB processOB) throws SQLException, JSONException {
        Object object2;
        Parameter parameter;
        Dialect dialect = DialectFactory.generateDialect(connection);
        Table table = new Table(string);
        Update update = new Update(table, dialect);
        Set set = processOB.getAllMultiFieldParaName();
        Set set2 = processOB.getParaNames();
        HashSet<String> hashSet = new HashSet<String>();
        int n2 = proceedInfo.getParaLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            parameter = proceedInfo.getPara(i2);
            if (ComparatorUtils.equals(parameter.getName(), "FR_SYSTEM_ID")) continue;
            if (!set2.contains(parameter.getName())) {
                for (Object object3 : set) {
                    object2 = (MultiFieldParameter)processOB.getParameterByName((String)object3);
                    if (!((MultiFieldParameter)object2).getAllFiledName().contains(parameter.getName())) continue;
                    ((MultiFieldParameter)object2).setSingleParaValue(parameter.getName(), parameter.getValue());
                    hashSet.add(((Parameter)object2).getName());
                }
                continue;
            }
            update.addColumn(parameter.getName(), this.checkTypeForSql(parameter.getValue()), parameter.getValue());
        }
        for (String string3 : hashSet) {
            Object object3;
            parameter = (MultiFieldParameter)processOB.getParameterByName(string3);
            Select select = new Select(table, dialect);
            select.addColumnName(string3);
            object3 = new Where();
            ((Where)object3).addColumn("FR_SYSTEM_ID", object.toString());
            select.setWhere((Where)object3);
            object2 = select.createPreparedStatement(connection);
            ResultSet resultSet = object2.executeQuery();
            if (resultSet.next()) {
                JSONArray jSONArray = new JSONArray();
                try {
                    String string4 = resultSet.getString(string3);
                    jSONArray = new JSONArray(string4.replaceAll("\n", "<br/>"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                jSONArray.put(((MultiFieldParameter)parameter).getJSONObjectValue());
                update.addColumn(string3, 12, jSONArray.toString());
            }
            DBUtils.closeResultSet(resultSet);
            DBUtils.closeStatement((Statement)object2);
        }
        if (StringUtils.isNotBlank(string2)) {
            update.addColumn("nextTask", 12, string2);
        }
        Where where = new Where();
        try {
            where.addColumn("FR_SYSTEM_ID", new Integer(Integer.parseInt(object.toString())));
        }
        catch (Exception exception) {
            where.addColumn("FR_SYSTEM_ID", new Integer(-1));
        }
        update.setWhere(where);
        update.execute(connection);
    }

    private String getReportNameFromTran(ProcessExecutor processExecutor, String string, AbstractTask abstractTask) throws Exception {
        String string2;
        ProcessOB processOB = processExecutor.getProcessDefine();
        Task task = processOB.getTask(string2 = processOB.getToTaskName(string));
        if (task instanceof FormTask) {
            return ((FormTask)task).getReportName();
        }
        if (task instanceof SubProTask) {
            return ((SubProTask)task).getReportName();
        }
        if (task instanceof EndTask) {
            System.out.println("\u8fd9\u662f\u4e2a\u7ed3\u675f\u8282\u70b9");
            if (processExecutor.getParentTaskLength() > 0) {
                System.out.println("\u5728\u5b50\u6d41\u7a0b\u91cc");
                Iterator iterator = processExecutor.getTaskIterator();
                while (iterator.hasNext()) {
                    Long l2 = new Long((String)iterator.next());
                    List list = Task4Database.getDaoAccess().findByKey("id", l2);
                    AbstractTask abstractTask2 = null;
                    if (list.size() > 0) {
                        Task4Database task4Database = (Task4Database)list.get(0);
                        abstractTask2 = (AbstractTask)processExecutor.getTask(task4Database.getName());
                    }
                    if (!(abstractTask2 instanceof SubProTask) || !ComparatorUtils.equals(((SubProTask)abstractTask2).getSubname(), processExecutor.getProcessname())) continue;
                    System.out.println("\u627e\u5230\u5b50\u8282\u70b9");
                    return ((EndTask)task).getReportName((SubProTask)abstractTask2, abstractTask, processExecutor);
                }
            }
            return ((EndTask)task).getReportName(null, abstractTask, processExecutor);
        }
        return null;
    }

    private int checkTypeForSql(Object object) {
        if (object instanceof Integer) {
            return 4;
        }
        if (object instanceof Double) {
            return 4;
        }
        if (object instanceof Date) {
            return 91;
        }
        if (object instanceof Boolean) {
            return 16;
        }
        return 12;
    }

    public String getCMD() {
        return "continue";
    }
}

