/*
 * Decompiled with CFR 0.152.
 */
package com.fr.process.pdl.transition;

import com.fr.base.FRContext;
import com.fr.fs.schedule.ScheduleContext;
import com.fr.fs.schedule.trigger.OnceITrigger;
import com.fr.general.FRLogger;
import com.fr.json.JSONObject;
import com.fr.process.pdl.transition.TransitionJob;
import com.fr.process.pdl.transition.TriggerTransition;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import com.fr.third.org.quartz.JobDetail;
import com.fr.third.org.quartz.Scheduler;
import com.fr.third.org.quartz.SchedulerException;
import com.fr.third.org.quartz.Trigger;
import java.util.Date;

public class LimitDayTransition
extends TriggerTransition {
    public static String typeName = "limitday";
    private int days;
    private int secondofday = 1440000;

    public boolean executeValue(Object object) {
        return new Integer(object.toString()) == this.days;
    }

    public String getType() {
        return "days";
    }

    public int getDays() {
        return this.days;
    }

    public void setDays(int n2) {
        this.days = n2;
    }

    public void createScheduleTask(long l2) {
        if (this.getTransition() == null || this.days < 1) {
            return;
        }
        JobDetail jobDetail = new JobDetail(this.getTransition(), this.getTransition(), TransitionJob.class);
        jobDetail.getJobDataMap().put(TransitionJob.NAME, this.getTransition());
        jobDetail.getJobDataMap().put(TransitionJob.PROCESSEXECUTORID, l2);
        OnceITrigger onceITrigger = new OnceITrigger();
        onceITrigger.setStartTime(new Date(System.currentTimeMillis() + (long)(this.days * this.secondofday)));
        Trigger trigger = onceITrigger.createTrigger();
        trigger.setJobName(jobDetail.getName());
        trigger.setJobGroup(jobDetail.getGroup());
        try {
            Scheduler scheduler = ScheduleContext.getScheduler();
            Trigger[] triggerArray = scheduler.getTriggersOfJob(jobDetail.getName(), jobDetail.getGroup());
            if (triggerArray.length > 0) {
                scheduler.rescheduleJob(jobDetail.getName(), jobDetail.getGroup(), trigger);
            } else {
                scheduler.scheduleJob(jobDetail, trigger);
            }
        }
        catch (SchedulerException schedulerException) {
            FRContext.getLogger().error(schedulerException.getMessage(), schedulerException);
        }
    }

    public void removeScheduleTask() {
        Scheduler scheduler = ScheduleContext.getScheduler();
        try {
            scheduler.deleteJob(this.getTransition(), this.getTransition());
        }
        catch (SchedulerException schedulerException) {
            FRLogger.getLogger().error(schedulerException.getMessage());
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("TriggerTransition").attr("class", this.getClass().toString());
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("LimitDays").textNode(new StringBuffer(this.getDays()).toString()).end();
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("LimitDays")) {
            this.setDays(new Integer(xMLableReader.getContent()));
        }
    }

    public void parseJSON(JSONObject jSONObject) {
    }

    public JSONObject createJSON() {
        return null;
    }
}

