/*
 * Decompiled with CFR 0.152.
 */
package com.fr.process.engine.processexecutor;

import com.fr.base.FRContext;
import com.fr.base.Parameter;
import com.fr.data.dao.ObjectTableMapper;
import com.fr.fs.FSConfig;
import com.fr.fs.control.UserControl;
import com.fr.fs.dao.DaoAccess;
import com.fr.fs.dao.DaoObject;
import com.fr.fs.dao.TaskInfo;
import com.fr.fs.dao.TaskInfoUser;
import com.fr.process.dao.ProcessAccess;
import com.fr.process.dao.ProcessExecutorCache;
import com.fr.process.engine.processexecutor.ProcessDefineCache;
import com.fr.process.engine.processexecutor.ProcessExecutorTableMapper;
import com.fr.process.pdl.processdefine.ProcessOB;
import com.fr.process.pdl.task.AbstractTask;
import com.fr.process.pdl.task.SubProTask;
import com.fr.process.pdl.task.Task;
import com.fr.process.pdl.task.Task4Database;
import com.fr.process.pdl.transition.TransitionImpl;
import com.fr.web.platform.TransmitParameters;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

public class ProcessExecutor
extends DaoObject {
    public static final String PROCESSNAME = "processname";
    public static final String TASKIDS = "taskids";
    public static final String PARAMETERS = "parameters";
    public static final String PARENTID = "parentid";
    private static DaoAccess daoAccess = null;
    private static ObjectTableMapper tableMapper = null;
    private TransmitParameters parameters = new TransmitParameters();
    private String processname;
    private LinkedList parentid = new LinkedList();
    private Set childrenids = new HashSet();
    private Set taskids = new HashSet();
    private LinkedHashSet activetasks = new LinkedHashSet();

    public ProcessExecutor() {
    }

    public ProcessExecutor(String string) {
        this.processname = string;
    }

    public static DaoAccess getDaoAccess() {
        if (daoAccess == null) {
            daoAccess = new ProcessAccess();
        }
        return daoAccess;
    }

    public static ObjectTableMapper getObjectTableMapper() {
        if (tableMapper == null) {
            tableMapper = new ProcessExecutorTableMapper();
        }
        return tableMapper;
    }

    public void addParentTaskId(long l2) {
        this.parentid.add(new Long(l2));
    }

    public int getParentTaskLength() {
        return this.parentid.size();
    }

    public ProcessOB getProcessDefine() {
        try {
            return ProcessDefineCache.getInstance().getProcess(this.processname);
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage());
            return null;
        }
    }

    public String getProcessname() {
        return this.processname;
    }

    public void setProcessname(String string) {
        this.processname = string;
    }

    public Parameter[] getNoUserParameters() {
        Set set = this.getProcessDefine().getUserParameterNames();
        HashSet<Parameter> hashSet = new HashSet<Parameter>();
        int n2 = this.parameters.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = this.parameters.get(i2).getName();
            if (set.contains(string) || string.equals("processStarter")) continue;
            hashSet.add(this.parameters.get(i2));
        }
        return hashSet.toArray(new Parameter[hashSet.size()]);
    }

    public void start() throws Exception {
        this.userStart(-1L);
    }

    public void userStart(long l2) throws Exception {
        this.initScope(l2);
        Task task = (Task)this.getProcessDefine().getStart().clone4Exe();
        if (this.getParentTaskLength() > 0) {
            this.addChildren(this.getId());
        }
        this.save();
        this.performTask(task, null);
    }

    private void initScope(long l2) {
        if (l2 < 0L && l2 != UserControl.getInstance().getSuperManagerID()) {
            return;
        }
        if (this.getVariableValue("processStarter") == null) {
            this.addVariable("processStarter", new Long(l2));
        }
        int n2 = this.getProcessDefine().getParametersLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            Parameter parameter = this.getProcessDefine().getParameter(i2);
            if (this.getVariableValue(parameter.getName()) != null) continue;
            this.addVariable(parameter.getName(), parameter.getValue());
        }
    }

    public void addVariable(String string, Object object) {
        boolean bl = false;
        int n2 = this.parameters.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Parameter parameter = this.parameters.get(i2);
            if (!parameter.getName().equals(string)) continue;
            bl = true;
            parameter.setValue(object);
        }
        if (!bl) {
            this.parameters.add(new Parameter(string, object));
        }
    }

    public Object getVariableValue(String string) {
        int n2 = this.parameters.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!this.parameters.get(i2).getName().equals(string)) continue;
            return this.parameters.get(i2).getValue();
        }
        return null;
    }

    public Iterator getVariableNames() {
        HashSet<String> hashSet = new HashSet<String>();
        int n2 = this.parameters.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            hashSet.add(this.parameters.get(i2).getName());
        }
        return hashSet.iterator();
    }

    public Parameter[] getParameters() {
        return this.parameters.toArray();
    }

    public void end() {
        DaoObject daoObject2;
        Object object2;
        for (Object object2 : this.activetasks) {
            ((AbstractTask)object2).remove();
        }
        object2 = TaskInfo.getDaoAccess().findByKey("processexecutorid", new Long(this.getId()));
        int n2 = object2.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            daoObject2 = (TaskInfo)object2.get(i2);
            if (daoObject2.getEndTime() != null) {
                daoObject2.setProcessexecutorid(-1L);
                daoObject2.update();
                continue;
            }
            List list = FSConfig.getInstance().getControl().getTaskInfoUserDAO().findByTaskId(new Long(daoObject2.getId()));
            int n3 = list.size();
            for (int i3 = 0; i3 < n3; ++i3) {
                ((TaskInfoUser)list.get(i3)).remove();
            }
            daoObject2.remove();
        }
        if (this.getParentTaskLength() > 0) {
            LinkedHashSet<TaskInfo> linkedHashSet = new LinkedHashSet<TaskInfo>();
            for (DaoObject daoObject2 : this.activetasks) {
                if (!(daoObject2 instanceof SubProTask)) continue;
                linkedHashSet.add((TaskInfo)daoObject2);
            }
            this.activetasks = linkedHashSet;
            this.parentid.removeLast();
            this.activeSubProTask(this.processname, this.parameters.toArray());
            this.removeChildren(this.getId());
        } else {
            this.activetasks.clear();
            this.remove();
        }
        if (this.childrenids.size() > 0) {
            for (Long l2 : this.childrenids) {
                daoObject2 = ProcessExecutorCache.getInstance().getProcessExecutorByID(l2);
                if (daoObject2 == null) continue;
                ((ProcessExecutor)daoObject2).remove();
            }
        }
    }

    public void activeSubProTask(String string, Parameter[] parameterArray) {
        for (Object e2 : this.activetasks) {
            if (!(e2 instanceof SubProTask) || !((SubProTask)e2).getSubname().equals(string)) continue;
            this.setProcessname(((SubProTask)e2).getParentname());
            ((SubProTask)e2).continueTask(this, parameterArray);
            break;
        }
    }

    public Iterator getTaskIterator() {
        return this.taskids.iterator();
    }

    public void performTask(Task task, TransitionImpl transitionImpl) {
        task.behavior(this, transitionImpl);
    }

    public void executeTransition(TransitionImpl transitionImpl) {
        String string = transitionImpl.getToTaskName();
        Task task = this.getTask(string);
        this.performTask(task, transitionImpl);
    }

    public void addChildren(long l2) {
        if (l2 < 0L) {
            return;
        }
        this.childrenids.add(new Long(l2));
    }

    public void removeChildren(long l2) {
        if (l2 < 0L) {
            return;
        }
        this.childrenids.remove(new Long(l2));
    }

    public boolean checkTaskUser(TransitionImpl transitionImpl) {
        String string = transitionImpl.getToTaskName();
        Task task = this.getTask(string);
        return task.checkUser(this);
    }

    public void addTask(Task task) {
        try {
            if (!this.activetasks.contains(task)) {
                this.activetasks.add(task.clone4Exe());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRContext.getLogger().log(Level.WARNING, cloneNotSupportedException.getMessage());
        }
        this.taskids.add(((AbstractTask)task).getID());
        this.update();
    }

    public Task getTask(String string) {
        Task task = this.getActiveTask(string);
        try {
            if (task != null) {
                return task;
            }
            Task task2 = this.getProcessDefine().getTask(string);
            if (task2 != null) {
                ((AbstractTask)task2).setExecuted(false);
                return (Task)task2.clone4Exe();
            }
            for (int i2 = this.parentid.size() - 1; i2 >= 0; --i2) {
                String string2 = this.parentid.get(i2).toString();
                task2 = ProcessDefineCache.getInstance().getProcessByID(Long.parseLong(string2)).getTask(string);
                if (task2 != null) break;
            }
            ((AbstractTask)task2).setExecuted(false);
            return (Task)task2.clone4Exe();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isActive(String string) {
        return this.getActiveTask(string) != null;
    }

    public Task getActiveTask(String string) {
        for (Task task : this.activetasks) {
            if (!task.getName().equals(string)) continue;
            return task;
        }
        return null;
    }

    public int getActiveTaskNum() {
        return this.activetasks.size();
    }

    public void removeTask(Task task) {
        this.activetasks.remove(task);
        this.taskids.remove(((AbstractTask)task).getID());
        this.update();
    }

    public void execute() {
        if (this.taskids.size() < 1) {
            return;
        }
        if (this.activetasks.size() > 0) {
            return;
        }
        if (this.getParentTaskLength() > 1) {
            this.addChildren(this.getId());
        }
        Iterator iterator = this.taskids.iterator();
        while (iterator.hasNext()) {
            Object object = new Long((String)iterator.next());
            List list = Task4Database.getDaoAccess().findByKey("id", object);
            if (list.size() <= 0) continue;
            Task4Database task4Database = (Task4Database)list.get(0);
            this.activetasks.add(this.toRealTask(task4Database));
        }
        for (Object object : this.activetasks) {
            this.performTask((Task)object, null);
        }
    }

    public void save() {
        ProcessExecutorCache.getInstance().addProcessExecutor(this);
    }

    public void update() {
        ProcessExecutorCache.getInstance().addProcessExecutor(this);
    }

    public void remove() {
        ProcessExecutorCache.getInstance().removeProcessExecutor(this);
    }

    protected int hashCode4Properties() {
        return 0;
    }

    public boolean equals4Properties(Object object) {
        return false;
    }

    public String getCurrentTaskName() {
        Iterator iterator = this.taskids.iterator();
        long l2 = 0L;
        while (iterator.hasNext()) {
            long l3 = Long.parseLong((String)iterator.next());
            if (l3 <= l2) continue;
            l2 = l3;
        }
        List list = Task4Database.getDaoAccess().findByKey("id", l2 + "");
        if (list.size() > 0) {
            return ((Task4Database)list.get(0)).getName();
        }
        return null;
    }

    public Task toRealTask(Task4Database task4Database) {
        AbstractTask abstractTask = (AbstractTask)this.getTask(task4Database.getName());
        abstractTask.setTask4Database(task4Database);
        abstractTask.setExecuted(task4Database.isExecuted());
        Iterator iterator = task4Database.getExecutedInTransitions().iterator();
        while (iterator.hasNext()) {
            abstractTask.addExecutedInTransition((String)iterator.next());
        }
        iterator = task4Database.getExecutedOutTransitions().iterator();
        while (iterator.hasNext()) {
            abstractTask.addExecutedOutTransition((String)iterator.next());
        }
        return abstractTask;
    }
}

