/*
 * Decompiled with CFR 0.152.
 */
package com.fr.process.dao;

import com.fr.base.FRContext;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralContext;
import com.fr.process.dao.ProcessAccess;
import com.fr.process.engine.processexecutor.ProcessExecutor;
import com.fr.stable.EnvChangedListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class ProcessExecutorCache {
    private static ProcessExecutorCache pec;
    private HashMap map = new HashMap();
    private ProcessAccess processAccess = (ProcessAccess)ProcessExecutor.getDaoAccess();

    public static ProcessExecutorCache getInstance() {
        if (pec == null) {
            pec = new ProcessExecutorCache();
            pec.readAll();
        }
        return pec;
    }

    public static void clearCache() {
        pec = null;
    }

    public long addProcessExecutor(ProcessExecutor processExecutor) {
        if (processExecutor.getId() > -1L) {
            this.map.put(new Long(processExecutor.getId()), processExecutor);
            this.processAccess.update(processExecutor);
            return processExecutor.getId();
        }
        if (ComparatorUtils.equals(processExecutor, this.map.get(new Long(processExecutor.getId())))) {
            return processExecutor.getId();
        }
        processExecutor.setId(this.processAccess.save(processExecutor));
        this.map.put(new Long(processExecutor.getId()), processExecutor);
        return processExecutor.getId();
    }

    public void removeProcessExecutor(ProcessExecutor processExecutor) {
        if (processExecutor.getId() < 0L) {
            return;
        }
        if (this.processAccess.removeByID(processExecutor.getId())) {
            this.map.remove(new Long(processExecutor.getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAll() {
        ProcessExecutorCache processExecutorCache = this;
        synchronized (processExecutorCache) {
            if (!this.map.isEmpty()) {
                return;
            }
            List list = this.processAccess.findAll();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.map.put(new Long(((ProcessExecutor)list.get(i2)).getId()), list.get(i2));
            }
        }
    }

    private void refresh() {
        this.map.clear();
    }

    private void endAll() {
        Iterator iterator = this.map.values().iterator();
        while (iterator.hasNext()) {
            ((ProcessExecutor)iterator.next()).end();
        }
    }

    public boolean hasProcessExecutorInstance(String string) {
        for (ProcessExecutor processExecutor : this.map.values()) {
            if (!ComparatorUtils.equals(processExecutor.getProcessname(), string)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessExecutor getProcessExecutorByID(long l2) {
        ProcessExecutorCache processExecutorCache = this;
        synchronized (processExecutorCache) {
            if (l2 < 0L) {
                return null;
            }
            return this.map.get(new Long(l2)) == null ? null : (ProcessExecutor)this.map.get(new Long(l2));
        }
    }

    public List getProcessExecutorByName(String string) {
        Iterator iterator = this.map.values().iterator();
        ArrayList<ProcessExecutor> arrayList = new ArrayList<ProcessExecutor>();
        while (iterator.hasNext()) {
            ProcessExecutor processExecutor = (ProcessExecutor)iterator.next();
            if (!ComparatorUtils.equals(processExecutor.getProcessname(), string)) continue;
            arrayList.add(processExecutor);
        }
        return arrayList;
    }

    static {
        ProcessExecutorCache.getInstance().readAll();
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                try {
                    ProcessExecutorCache.clearCache();
                }
                catch (Exception exception) {
                    FRContext.getLogger().log(Level.WARNING, exception.getMessage());
                }
            }
        });
    }
}

