/*
 * Decompiled with CFR 0.152.
 */
package com.fr.print;

import com.fr.base.FRContext;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.page.BaseSinglePagePrintable;
import com.fr.page.BaseSingleReportCache;
import com.fr.page.PageXmlProvider;
import com.fr.page.PaperSettingProvider;
import com.fr.print.PrintUtils;
import com.fr.print.SinglePageSet;
import com.fr.stable.StringUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.xml.ReportXMLUtils;
import java.awt.print.PrinterException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class PrintApplet
extends JApplet {
    private BaseSinglePagePrintable[] pages;
    private static String OUT_OF_RANGE = "\u9875\u7801\u8303\u56f4\u8d85\u51fa\u603b\u9875\u6570\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165";
    private static boolean initial = false;

    public void init() {
        if (initial) {
            return;
        }
        try {
            URL uRL = new URL(this.getParameter("url"));
            boolean bl = new Boolean(this.getParameter("loadJVM"));
            if (bl) {
                URL uRL2 = new URL(uRL.toString().replaceAll("op=fr_applet&cmd=print", "op=fr_applet&cmd=printover&printvalue=true"));
                uRL2.openStream();
                return;
            }
            this.initModule();
            initial = this.getParameter("isIE9").equals("9.0");
            int n2 = this.getCopy();
            boolean bl2 = new Boolean(this.getParameter("isShowDialog"));
            boolean bl3 = new Boolean(this.getParameter("isSingleSheet"));
            String string = this.getParameter("printerName");
            String string2 = this.getParameter("index");
            InputStream inputStream = uRL.openStream();
            PageXmlProvider pageXmlProvider = (PageXmlProvider)StableFactory.createNewObject("PageXmlOperator");
            BaseSinglePagePrintable[] baseSinglePagePrintableArray = pageXmlProvider.deXmlizable4SinglePage(inputStream);
            BaseSingleReportCache baseSingleReportCache = (BaseSingleReportCache)StableFactory.createNewObject("SingleReportCache");
            URL uRL3 = new URL(uRL.toString().replaceAll("op=fr_applet&cmd=print", "op=fr_applet&cmd=printover&printvalue=false"));
            uRL3.openStream();
            this.validIndex(string2, baseSinglePagePrintableArray, uRL, baseSingleReportCache);
            this.setUpCopies(n2);
            this.cachePaperSetting(bl3);
            this.print(bl2, string);
            baseSingleReportCache.clearReportPageCache();
            URL uRL4 = new URL(uRL.toString().replaceAll("op=fr_applet&cmd=print", "op=fr_applet&cmd=printover&printvalue=true"));
            uRL4.openStream();
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
            JOptionPane.showMessageDialog(null, " e=" + exception.getMessage());
        }
    }

    private int getCopy() {
        String string = this.getParameter("copies");
        return this.isInteger(string) ? Integer.valueOf(string) : 1;
    }

    private void initModule() throws Exception {
        UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        GeneralXMLTools.Object_Tokenizer = new ReportXMLUtils.ReportObjectTokenizer();
        GeneralXMLTools.Object_XML_Writer_Finder = new ReportXMLUtils.ReportObjectXMLWriterFinder();
        this.startModule("com.fr.page.module.PageModule");
        this.startModule("com.fr.chart.module.ChartModule");
    }

    private void validIndex(String string, BaseSinglePagePrintable[] baseSinglePagePrintableArray, URL uRL, BaseSingleReportCache baseSingleReportCache) {
        if (string != null && string.indexOf("-") != -1) {
            Pattern pattern = Pattern.compile("-");
            String[] stringArray = pattern.split(string);
            int n2 = Integer.parseInt(stringArray[0]) - 1;
            int n3 = Integer.parseInt(stringArray[1]) - 1;
            if (n2 > baseSinglePagePrintableArray.length - 1 || n3 > baseSinglePagePrintableArray.length - 1) {
                JOptionPane.showMessageDialog(null, OUT_OF_RANGE);
                return;
            }
            if (n2 >= 0 && n3 >= n2) {
                int n4 = n3 - n2 + 1;
                this.initIndexedPages(n4, n2, baseSinglePagePrintableArray, uRL, baseSingleReportCache);
            }
        } else if (this.isInteger(string)) {
            int n5 = Integer.parseInt(string) - 1;
            if (n5 > baseSinglePagePrintableArray.length - 1) {
                JOptionPane.showMessageDialog(null, OUT_OF_RANGE);
                return;
            }
            this.initIndexedPages(1, n5, baseSinglePagePrintableArray, uRL, baseSingleReportCache);
        } else {
            this.initIndexedPages(baseSinglePagePrintableArray.length, 0, baseSinglePagePrintableArray, uRL, baseSingleReportCache);
        }
    }

    private void setUpCopies(int n2) {
        if (n2 <= 1) {
            return;
        }
        ArrayList<BaseSinglePagePrintable> arrayList = new ArrayList<BaseSinglePagePrintable>();
        List<BaseSinglePagePrintable> list = Arrays.asList(this.pages);
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.addAll(list);
        }
        this.pages = arrayList.toArray(new BaseSinglePagePrintable[arrayList.size()]);
    }

    private void cachePaperSetting(boolean bl) {
        if (this.pages.length > 0 && bl) {
            for (int i2 = 0; i2 < this.pages.length; ++i2) {
                if (i2 == 0) continue;
                this.pages[i2].setReadreportsettings(false);
            }
        }
    }

    private void initIndexedPages(int n2, int n3, BaseSinglePagePrintable[] baseSinglePagePrintableArray, URL uRL, BaseSingleReportCache baseSingleReportCache) {
        this.pages = new BaseSinglePagePrintable[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            PaperSettingProvider paperSettingProvider = baseSinglePagePrintableArray[n3 + i2].getPaperSetting();
            HashMap<String, Class> hashMap = new HashMap<String, Class>();
            hashMap.put("1", PaperSettingProvider.class);
            hashMap.put("3", BaseSingleReportCache.class);
            Object[] objectArray = new Object[]{uRL, paperSettingProvider, n3 + i2, baseSingleReportCache};
            this.pages[i2] = (BaseSinglePagePrintable)StableFactory.createNewObject("SinglePagePrintable", objectArray, hashMap);
        }
    }

    private void startModule(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            Method method = clazz.getMethod("init", null);
            method.invoke(clazz.newInstance(), new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isInteger(String string) {
        if (StringUtils.isEmpty(string)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^[1-9]\\d*$");
        return pattern.matcher(string).matches();
    }

    public void print(boolean bl) {
        this.print(bl, null);
    }

    public void print(boolean bl, String string) {
        if (this.pages != null) {
            try {
                PrintUtils.print(new SinglePageSet(this.pages), bl, string);
            }
            catch (PrinterException printerException) {
                FRContext.getLogger().error(printerException.getMessage(), printerException);
                JOptionPane.showMessageDialog(null, printerException.getMessage());
            }
            catch (SecurityException securityException) {
                if (!"checkPrintJobAccess".equals(securityException.getMessage())) {
                    throw securityException;
                }
                System.out.println("User cancel.");
            }
        }
    }
}

