/*
 * Decompiled with CFR 0.152.
 */
package com.fr.main.impl;

import com.fr.base.ConfigManager;
import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.Parameter;
import com.fr.base.ParameterHelper;
import com.fr.base.ParameterMapNameSpace;
import com.fr.base.TableData;
import com.fr.base.Utils;
import com.fr.base.chart.BaseChart;
import com.fr.base.chart.BaseChartCollection;
import com.fr.base.chartdata.BaseTableDefinition;
import com.fr.base.io.XMLReadHelper;
import com.fr.base.parameter.ParameterUI;
import com.fr.base.present.DictPresent;
import com.fr.base.present.Present;
import com.fr.data.SimpleDSColumn;
import com.fr.data.TableDataSource;
import com.fr.data.condition.CommonCondition;
import com.fr.data.condition.JoinCondition;
import com.fr.data.condition.ListCondition;
import com.fr.data.core.Compare;
import com.fr.data.impl.NameTableData;
import com.fr.data.impl.TableDataDictionary;
import com.fr.form.ui.ComboBox;
import com.fr.form.ui.ToolBar;
import com.fr.form.ui.Widget;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.Inter;
import com.fr.general.data.Condition;
import com.fr.main.AbstractTemplateWorkBook;
import com.fr.main.SynchronizedReportSettings;
import com.fr.main.parameter.ReportParameterAttr;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.page.ReportSettingsProvider;
import com.fr.privilege.PrivilegeEditedRoleProvider;
import com.fr.privilege.finegrain.AbstractPrivilegeControl;
import com.fr.privilege.finegrain.CellPrivilegeControl;
import com.fr.privilege.finegrain.ColumnRowPrivilegeControl;
import com.fr.privilege.finegrain.FloatPrivilegeControl;
import com.fr.privilege.finegrain.WidgetPrivilegeControl;
import com.fr.report.cell.AbstractWidgetCellElement;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.FloatElement;
import com.fr.report.cell.TemplateCellElement;
import com.fr.report.cell.cellattr.core.group.DSColumn;
import com.fr.report.core.ReportUtils;
import com.fr.report.core.sheet.SheetSequenceExecuter;
import com.fr.report.core.utils.ScriptUtils;
import com.fr.report.elementcase.ElementCase;
import com.fr.report.report.Report;
import com.fr.report.report.TemplateReport;
import com.fr.report.stable.ReportSettings;
import com.fr.report.web.ToolBarManager;
import com.fr.report.worksheet.WorkSheet;
import com.fr.script.Calculator;
import com.fr.stable.Actor;
import com.fr.stable.ColumnRow;
import com.fr.stable.ListMap;
import com.fr.stable.ParameterProvider;
import com.fr.stable.script.NameSpace;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import com.fr.xml.ReportXMLUtils;
import com.fr.xml.SynchronizedFrozenColumnRow;
import java.awt.Dimension;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkBook
extends AbstractTemplateWorkBook
implements PrivilegeEditedRoleProvider {
    public static final String XML_TAG = "WorkBook";
    public static final String STRING_TO_FORMULA = "string2Formula";

    public WorkBook() {
    }

    public WorkBook(TemplateReport templateReport) {
        this.addReport(templateReport);
    }

    public void addReport(int n2, TemplateReport templateReport) {
        super.addReport(n2, null, templateReport);
    }

    public void addReport(int n2, String string, TemplateReport templateReport) {
        super.addReport(n2, string, templateReport);
    }

    @Override
    public ResultWorkBook execute(Map map, Actor actor) {
        ResultWorkBook resultWorkBook;
        this.apply4Parameters(map);
        if (!actor.getBookFUNC().support() && this.getReportCount() > 1) {
            resultWorkBook = actor.createResultBook(map);
        } else if (this.getReportCount() > 1 && !ReportUtils.hasLayerReport4Template(this)) {
            SheetSequenceExecuter sheetSequenceExecuter = new SheetSequenceExecuter(this, map);
            resultWorkBook = sheetSequenceExecuter.execute(actor);
        } else {
            resultWorkBook = actor.createWorkBookExecuter(this, map).execute();
        }
        return resultWorkBook;
    }

    @Override
    public Parameter[] getParameters() {
        HashSet<ParameterProvider> hashSet = new HashSet<ParameterProvider>();
        Calculator calculator = Calculator.createCalculator();
        calculator.setAttribute(TableDataSource.class, this);
        ParameterHelper.addGlobal_ParameterToSet(hashSet);
        ReportParameterAttr reportParameterAttr = this.getReportParameterAttr();
        if (reportParameterAttr != null && reportParameterAttr.getParameters() != null) {
            hashSet.addAll(Arrays.asList(reportParameterAttr.getParameters()));
        }
        try {
            int n2 = this.tableDataList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                TableData tableData = (TableData)this.tableDataList.get(i2);
                ParameterProvider[] parameterProviderArray = FRContext.getCurrentEnv().getTableDataParameters(tableData);
                if (tableData == null || parameterProviderArray == null) continue;
                hashSet.addAll(Arrays.asList(parameterProviderArray));
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
        return hashSet.toArray(new Parameter[hashSet.size()]);
    }

    @Override
    public void apply4Parameters(Map map) {
        Object object;
        Parameter[] parameterArray;
        Object object2;
        Object object3;
        ReportParameterAttr reportParameterAttr = this.getReportParameterAttr();
        Calculator calculator = Calculator.createCalculator();
        if (reportParameterAttr != null) {
            object3 = new ListMap();
            object2 = new ListMap();
            parameterArray = reportParameterAttr.getParameters();
            for (int i2 = 0; i2 < parameterArray.length; ++i2) {
                if (map.get(parameterArray[i2].getName()) == null || this.shouldExecuteParameter(parameterArray[i2])) {
                    ((ListMap)object3).put(parameterArray[i2].getName(), parameterArray[i2].getValue());
                    continue;
                }
                ((ListMap)object2).put(parameterArray[i2].getName(), map.get(parameterArray[i2].getName()));
            }
            ParameterMapNameSpace parameterMapNameSpace = ParameterMapNameSpace.create((Map)object2);
            calculator.pushNameSpace(parameterMapNameSpace);
            object = ((ListMap)object3).keySet().iterator();
            while (object.hasNext()) {
                ParameterMapNameSpace parameterMapNameSpace2 = ParameterMapNameSpace.create(map);
                calculator.pushNameSpace(parameterMapNameSpace2);
                String string = (String)object.next();
                Object object4 = ((ListMap)object3).get(string);
                Object object5 = object4 instanceof Formula ? ScriptUtils.executeNormalFormula(calculator, (Formula)object4) : object4;
                map.put(string, object5);
            }
            calculator.removeNameSpace(parameterMapNameSpace);
        }
        if ((object2 = ((ConfigManager)(object3 = ConfigManager.getInstance())).getGlobal_Parameters()) != null) {
            parameterArray = ParameterMapNameSpace.create(map);
            calculator.pushNameSpace((NameSpace)parameterArray);
            for (int i3 = 0; i3 < ((Parameter[])object2).length; ++i3) {
                if (map.get(object2[i3].getName()) != null) continue;
                object = object2[i3].getValue();
                if (object instanceof Formula) {
                    object = ScriptUtils.executeNormalFormula(calculator, (Formula)object);
                }
                map.put(object2[i3].getName(), object);
            }
            calculator.removeNameSpace((NameSpace)parameterArray);
        }
    }

    private boolean shouldExecuteParameter(Parameter parameter) {
        Object object = parameter.getValue();
        if (!(object instanceof Formula)) {
            return false;
        }
        String string = Utils.objectToString(object);
        return object != null && string.startsWith("=") && string.indexOf(36) != -1;
    }

    @Override
    public String[] getAllEditedRoleSet() {
        HashSet<String> hashSet = new HashSet<String>();
        this.dealWithToolBar(ReportUtils.getToolBarFromWorkBook(this, 0), hashSet);
        this.dealWithToolBar(ReportUtils.getToolBarFromWorkBook(this, 1), hashSet);
        this.dealWithToolBar(ReportUtils.getToolBarFromWorkBook(this, 3), hashSet);
        this.iteratorParameterUI(hashSet);
        this.iteratorReport(hashSet);
        return new ArrayList<String>(hashSet).toArray(new String[hashSet.size()]);
    }

    private void iteratorParameterUI(HashSet<String> hashSet) {
        Widget[] widgetArray;
        ParameterUI parameterUI;
        ReportParameterAttr reportParameterAttr = this.getReportParameterAttr();
        if (reportParameterAttr != null && (parameterUI = reportParameterAttr.getParameterUI()) != null && (widgetArray = parameterUI.getAllWidgets()) != null) {
            for (int i2 = 0; i2 < widgetArray.length; ++i2) {
                this.dealWithWidget(widgetArray[i2], hashSet);
            }
        }
    }

    private void iteratorReport(HashSet<String> hashSet) {
        for (int i2 = 0; i2 < this.getReportCount(); ++i2) {
            Object object;
            Report report = this.getReport(i2);
            if (report == null) continue;
            if (report instanceof TemplateReport) {
                object = ((TemplateReport)report).getWorkSheetPrivilegeControl();
                hashSet.addAll(Arrays.asList(((AbstractPrivilegeControl)object).getAllEditedRoles()));
            }
            object = report.iteratorOfElementCase();
            while (object.hasNext()) {
                ElementCase elementCase = (ElementCase)object.next();
                this.iteratorElementCase(hashSet, elementCase);
                Iterator iterator = elementCase.cellIterator();
                while (iterator.hasNext()) {
                    CellElement cellElement = (CellElement)iterator.next();
                    CellPrivilegeControl cellPrivilegeControl = cellElement.getCellPrivilegeControl();
                    hashSet.addAll(Arrays.asList(cellPrivilegeControl.getAllEditedRoles()));
                    if (!(cellElement instanceof AbstractWidgetCellElement)) continue;
                    Widget widget = ((AbstractWidgetCellElement)cellElement).getWidget();
                    this.dealWithWidget(widget, hashSet);
                }
            }
        }
    }

    private void iteratorElementCase(HashSet<String> hashSet, ElementCase elementCase) {
        ColumnRowPrivilegeControl columnRowPrivilegeControl;
        int n2;
        int n3 = elementCase.getRowCount();
        int n4 = elementCase.getColumnCount();
        for (n2 = 0; n2 < n3; ++n2) {
            columnRowPrivilegeControl = elementCase.getRowPrivilegeControl(n2);
            hashSet.addAll(Arrays.asList(columnRowPrivilegeControl.getAllEditedRoles()));
        }
        for (n2 = 0; n2 < n4; ++n2) {
            columnRowPrivilegeControl = elementCase.getColumnPrivilegeControl(n2);
            hashSet.addAll(Arrays.asList(columnRowPrivilegeControl.getAllEditedRoles()));
        }
        Iterator iterator = elementCase.floatIterator();
        while (iterator.hasNext()) {
            FloatElement floatElement = (FloatElement)iterator.next();
            FloatPrivilegeControl floatPrivilegeControl = floatElement.getFloatPrivilegeControl();
            hashSet.addAll(Arrays.asList(floatPrivilegeControl.getAllEditedRoles()));
        }
    }

    private void dealWithToolBar(ToolBarManager[] toolBarManagerArray, HashSet<String> hashSet) {
        if (toolBarManagerArray == null) {
            return;
        }
        for (int i2 = 0; i2 < toolBarManagerArray.length; ++i2) {
            ToolBar toolBar = toolBarManagerArray[i2].getToolBar();
            for (int i3 = 0; i3 < toolBar.getWidgetSize(); ++i3) {
                Widget widget = toolBar.getWidget(i3);
                this.dealWithWidget(widget, hashSet);
            }
        }
    }

    private void dealWithWidget(Widget widget, HashSet<String> hashSet) {
        if (widget == null) {
            return;
        }
        WidgetPrivilegeControl widgetPrivilegeControl = widget.getWidgetPrivilegeControl();
        hashSet.addAll(Arrays.asList(widgetPrivilegeControl.getAllEditedRoles()));
    }

    @Override
    public boolean renameTableData(String string, String string2) {
        if (super.renameTableData(string, string2)) {
            if (this.getTableData(string) == null) {
                for (int i2 = 0; i2 < this.getReportCount(); ++i2) {
                    Report report = this.getReport(i2);
                    if (report == null) continue;
                    Iterator iterator = report.iteratorOfElementCase();
                    while (iterator.hasNext()) {
                        ElementCase elementCase = (ElementCase)iterator.next();
                        this.iteratorFloatCell(elementCase, string2, string);
                        this.iteratorNormalCell(elementCase, string2, string);
                    }
                }
            }
            return true;
        }
        return false;
    }

    private void iteratorFloatCell(ElementCase elementCase, String string, String string2) {
        Iterator iterator = elementCase.floatIterator();
        while (iterator.hasNext()) {
            FloatElement floatElement = (FloatElement)iterator.next();
            Object object = floatElement.getValue();
            if (!(object instanceof BaseChartCollection)) continue;
            this.setChartTableData(object, string, string2);
        }
    }

    private void iteratorNormalCell(ElementCase elementCase, String string, String string2) {
        Iterator iterator = elementCase.cellIterator();
        while (iterator.hasNext()) {
            CellElement cellElement = (CellElement)iterator.next();
            this.setPresentAndDictionary(cellElement, string, string2);
            Object object = cellElement.getValue();
            if (object instanceof DSColumn) {
                Condition condition;
                DSColumn dSColumn = (DSColumn)object;
                if (ComparatorUtils.equals(dSColumn.getDSName(), string2)) {
                    dSColumn.setDSName(string);
                }
                if ((condition = ((DSColumn)object).getCondition()) == null) continue;
                if (condition instanceof CommonCondition) {
                    this.dealWithTableDataNameChange((CommonCondition)condition, string2, string);
                }
                if (!(condition instanceof ListCondition)) continue;
                for (int i2 = 0; i2 < ((ListCondition)condition).getJoinConditionCount(); ++i2) {
                    JoinCondition joinCondition = ((ListCondition)condition).getJoinCondition(i2);
                    Condition condition2 = joinCondition.getCondition();
                    if (condition2 == null || !(condition2 instanceof CommonCondition)) continue;
                    this.dealWithTableDataNameChange((CommonCondition)condition2, string2, string);
                }
                continue;
            }
            if (!(object instanceof BaseChartCollection)) continue;
            this.setChartTableData(object, string, string2);
        }
    }

    private void dealWithTableDataNameChange(CommonCondition commonCondition, String string, String string2) {
        Compare compare = commonCondition.getCompare();
        Object object = compare.getValue();
        if (object instanceof SimpleDSColumn && ComparatorUtils.equals(((SimpleDSColumn)object).getDsName(), string)) {
            ((SimpleDSColumn)object).setDsName(string2);
        }
    }

    private void setChartTableData(Object object, String string, String string2) {
        BaseChartCollection baseChartCollection = (BaseChartCollection)object;
        int n2 = baseChartCollection.getChartCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            BaseTableDefinition baseTableDefinition;
            NameTableData nameTableData;
            BaseChart baseChart = baseChartCollection.getChartWithIndex(i2);
            if (!(baseChart.getFilterDefinition() instanceof BaseTableDefinition) || !ComparatorUtils.equals((nameTableData = (NameTableData)(baseTableDefinition = (BaseTableDefinition)((Object)baseChart.getFilterDefinition())).getTableData()).getName(), string2)) continue;
            baseTableDefinition.setTableData(new NameTableData(string));
        }
    }

    private void setPresentAndDictionary(CellElement cellElement, String string, String string2) {
        ComboBox comboBox;
        TemplateCellElement templateCellElement = (TemplateCellElement)cellElement;
        Present present = templateCellElement.getPresent();
        if (!(present instanceof DictPresent)) {
            return;
        }
        DictPresent dictPresent = (DictPresent)present;
        if (!(dictPresent.getDictionary() instanceof TableDataDictionary)) {
            return;
        }
        TableDataDictionary tableDataDictionary = (TableDataDictionary)dictPresent.getDictionary();
        if (!(tableDataDictionary.getTableData() instanceof NameTableData)) {
            return;
        }
        NameTableData nameTableData = (NameTableData)tableDataDictionary.getTableData();
        if (ComparatorUtils.equals(nameTableData.getName(), string2)) {
            tableDataDictionary.setTableData(new NameTableData(string));
        }
        if (templateCellElement.getWidget() instanceof ComboBox && (comboBox = (ComboBox)templateCellElement.getWidget()) != null && comboBox.getDictionary() instanceof TableDataDictionary) {
            TableDataDictionary tableDataDictionary2 = (TableDataDictionary)comboBox.getDictionary();
            NameTableData nameTableData2 = (NameTableData)tableDataDictionary2.getTableData();
            if (ComparatorUtils.equals(nameTableData.getName(), string2)) {
                tableDataDictionary.setTableData(new NameTableData(string));
            }
        }
    }

    @Override
    public String openTag() {
        return XML_TAG;
    }

    @Override
    public void mainContentWriteXML(XMLPrintWriter xMLPrintWriter) {
        this.writeXML(xMLPrintWriter);
    }

    @Override
    public void readStream(InputStream inputStream) throws Exception {
        this.readStream(inputStream, true);
    }

    public void readStream(InputStream inputStream, boolean bl) throws Exception {
        String string;
        XMLableReader xMLableReader = XMLReadHelper.createXMLableReader(inputStream, "UTF-8");
        this.xmlVersion = xMLableReader.getXMLVersion();
        if (xMLableReader == null) {
            throw new RuntimeException(Inter.getLocText("NS_exception_readError"));
        }
        if (bl) {
            xMLableReader.setContextAttribute(STRING_TO_FORMULA, bl);
        }
        if (XML_TAG.equals(string = xMLableReader.getTagName())) {
            xMLableReader.readXMLObject(this);
            this.compatibleParameterUI(xMLableReader);
        } else if ("Report".equals(string)) {
            TemplateReport templateReport = null;
            String string2 = xMLableReader.getAttrAsString("class", null);
            if (string2 != null) {
                Report report = ReportXMLUtils.readReportFromClassName(string2);
                if (report instanceof TemplateReport) {
                    templateReport = (TemplateReport)report;
                } else {
                    throw new Exception("Error Report Class (" + report.getClass().getName() + ") in Template File.");
                }
            }
            if (templateReport == null) {
                templateReport = new WorkSheet();
            }
            this.addReport("Compatible0651WorkSheet", templateReport);
            xMLableReader.readXMLObject(templateReport);
            this.setReportName(0, "sheet1");
        } else if ("FREncrypted".equals(string)) {
            FRContext.getLogger().error(Inter.getLocText("ECP_decode_failed"));
        }
        this.compatibleWith6_5();
        SynchronizedFrozenColumnRow.getThreadColumnRowList().set(null);
        xMLableReader.close();
        inputStream.close();
    }

    private void compatibleParameterUI(XMLableReader xMLableReader) {
        if (this.reportParameterAttr != null && this.reportParameterAttr.getParameterUI() != null) {
            this.reportParameterAttr.getParameterUI().convert();
            if (!xMLableReader.getXMLVersion().isAfterREPORT_REFECT_FOR7_1_XML_VERSION() && xMLableReader.getXMLVersion().isAfterREPORT_REFECT_FOR65_4_XML_VERSION()) {
                this.reportParameterAttr.getParameterUI().setParamaterValueFor_7_0_Version(this.getParameters());
            }
            if (!xMLableReader.getXMLVersion().isAfterREPORT_REFECT_FOR7_0_3_XML_VERSION() && xMLableReader.getXMLVersion().isAfterREPORT_REFECT_FOR7_0_XML_VERSION() && this.reportParameterAttr.getParameterUI().isUseDefaultSize()) {
                this.reportParameterAttr.getParameterUI().setDesignSize(new Dimension(800, 200));
            }
        }
    }

    private void compatibleWith6_5() {
        SynchronizedReportSettings.flushSynchronizedReportSettings();
        ColumnRow columnRow = (ColumnRow)SynchronizedFrozenColumnRow.getThreadColumnRowList().get();
        if (columnRow != null) {
            for (int i2 = 0; i2 < this.getReportCount(); ++i2) {
                if (this.getReport(i2) == null) continue;
                ReportSettingsProvider reportSettingsProvider = this.getReport(i2).getReportSettings();
                if (reportSettingsProvider == null) {
                    reportSettingsProvider = new ReportSettings();
                    this.getReport(i2).setReportSettings(reportSettingsProvider);
                }
                reportSettingsProvider.setWriteFrozenColumnRow(columnRow);
            }
        }
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && object instanceof WorkBook;
    }
}

