/*
 * Decompiled with CFR 0.152.
 */
package com.fr.js;

import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.privilege.NoCheckHyperLinkSessionAttribute;
import com.fr.js.Hyperlink;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import javax.servlet.http.HttpSession;

public class ReportletHyperlink
extends Hyperlink {
    private String reportPath = "";
    private String postMethod = "FR.doHyperlinkByPost";
    private String getMethod = "FR.doHyperlinkByGet4Reportlet";
    private boolean extendParameters = false;
    private boolean showParameterInterface = true;
    private boolean byPost = false;

    public ReportletHyperlink() {
    }

    public ReportletHyperlink(String string) {
        this(string, "");
    }

    public ReportletHyperlink(String string, String string2) {
        this.setReportletPath(string);
        this.setTargetFrame(string2);
    }

    public String getReportletPath() {
        return this.reportPath;
    }

    public void setReportletPath(String string) {
        this.reportPath = string;
    }

    public boolean isExtendParameters() {
        return this.extendParameters;
    }

    public void setExtendParameters(boolean bl) {
        this.extendParameters = bl;
    }

    public boolean isShowParameterInterface() {
        return this.showParameterInterface;
    }

    public void setShowParameterInterface(boolean bl) {
        this.showParameterInterface = bl;
    }

    public boolean isByPost() {
        return this.byPost;
    }

    public void setByPost(boolean bl) {
        this.byPost = bl;
    }

    protected boolean isPost() {
        return this.isByPost();
    }

    public String actionJS(Repository repository) {
        try {
            return this.createReportPath(repository);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createReportPath(Repository repository) throws Exception {
        String string;
        HttpSession httpSession;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.byPost) {
            stringBuffer.append(this.postMethod);
        } else {
            stringBuffer.append(this.getMethod);
        }
        stringBuffer.append("(\"");
        String string2 = this.getReportletPath();
        stringBuffer.append(repository.checkoutObject(string2, "reportlet", true));
        stringBuffer.append("\", ");
        JSONObject jSONObject = this.createParaPath(repository);
        stringBuffer.append(jSONObject);
        stringBuffer.append(", \"");
        stringBuffer.append(this.getTargetFrame());
        stringBuffer.append("\", \"");
        stringBuffer.append(this.features4NewWindow());
        stringBuffer.append("\")");
        if (repository.getHttpServletReques() != null && (httpSession = repository.getHttpServletReques().getSession(false)) != null && (string = (String)httpSession.getAttribute("fr_username")) != null) {
            HttpSession httpSession2 = httpSession;
            synchronized (httpSession2) {
                NoCheckHyperLinkSessionAttribute noCheckHyperLinkSessionAttribute = (NoCheckHyperLinkSessionAttribute)httpSession.getAttribute("fr_nocheck_hyperlinkinfo");
                if (noCheckHyperLinkSessionAttribute == null) {
                    httpSession.setAttribute("fr_nocheck_hyperlinkinfo", (Object)new NoCheckHyperLinkSessionAttribute(string, string2, this.getExtendsOP(jSONObject)));
                } else {
                    noCheckHyperLinkSessionAttribute.putHyperLinkInfo(string, string2, this.getExtendsOP(jSONObject));
                }
            }
        }
        return stringBuffer.toString();
    }

    private String getExtendsOP(JSONObject jSONObject) {
        if (jSONObject != null && jSONObject.has("op")) {
            try {
                return jSONObject.get("op").toString();
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return null;
    }

    private JSONObject createParaPath(Repository repository) throws Exception {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("__pi__", this.showParameterInterface);
        if (this.isExtendParameters()) {
            this.putExtendParameters(repository, jSONObject, false);
        }
        this.para2JSON(jSONObject, false);
        return jSONObject;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("JavaScript").attr("class", this.getClass().getName());
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("ReportletName");
        if (this.isExtendParameters()) {
            xMLPrintWriter.attr("extendParameters", this.isExtendParameters());
        }
        if (this.isShowParameterInterface()) {
            xMLPrintWriter.attr("showPI", this.isShowParameterInterface());
        }
        if (this.byPost) {
            xMLPrintWriter.attr("byPost", this.byPost);
        }
        String string = this.getReportletPath().replaceAll("\\\\", "/");
        xMLPrintWriter.textNode(string);
        xMLPrintWriter.end();
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("ReportletName")) {
            this.setExtendParameters(xMLableReader.getAttrAsBoolean("extendParameters", false));
            this.setShowParameterInterface(xMLableReader.getAttrAsBoolean("showPI", false));
            this.setByPost(xMLableReader.getAttrAsBoolean("byPost", false));
            String string = xMLableReader.getElementValue();
            if (StringUtils.isNotBlank(string)) {
                string = string.replaceAll("\\\\", "/");
                this.setReportletPath(string);
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ReportletHyperlink)) {
            return false;
        }
        return super.equals(object) && this.extendParameters == ((ReportletHyperlink)object).extendParameters && ComparatorUtils.equals(this.reportPath, ((ReportletHyperlink)object).reportPath) && this.byPost == ((ReportletHyperlink)object).byPost;
    }
}

