/*
 * Decompiled with CFR 0.152.
 */
package com.fr.io.exporter;

import com.fr.base.FRContext;
import com.fr.base.Utils;
import com.fr.file.CacheManager;
import com.fr.general.Inter;
import com.fr.io.core.LargeDataExcelExporterReport;
import com.fr.io.exporter.ExcelExporter;
import com.fr.io.exporter.POIWrapper.POIWorkbookAction;
import com.fr.main.workbook.PageRWorkBook;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.page.PageSetProvider;
import com.fr.page.PaperSettingProvider;
import com.fr.report.core.A.A.B;
import com.fr.report.report.Report;
import com.fr.report.report.ResultECReport;
import com.fr.report.stable.ReportSettings;
import com.fr.stable.ExportConstants;
import com.fr.stable.FT;
import com.fr.stable.StableUtils;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.tools.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LargeDataPageExcelExporter
extends ExcelExporter {
    protected boolean isPage = false;

    public LargeDataPageExcelExporter(List list, boolean bl) {
        super(list);
        this.isPage = bl;
    }

    @Override
    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook) throws Exception {
        this.export(outputStream, resultWorkBook, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook, boolean bl, int[] nArray) throws Exception {
        File file = new File(CacheManager.getInstance().getCacheDirectory(), "excel-temp");
        String string = "TEMP_" + System.currentTimeMillis() + "_" + (int)(Math.random() * 1000.0);
        File file2 = new File(file, string);
        int n2 = 0;
        while (file2.exists()) {
            file2 = new File(file, string + n2);
            ++n2;
        }
        StableUtils.mkdirs(file2);
        file2.deleteOnExit();
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        zipOutputStream.setEncoding("GBK");
        try {
            for (int i2 = 0; i2 < resultWorkBook.getReportCount(); ++i2) {
                ResultECReport resultECReport = (ResultECReport)resultWorkBook.getResultReport(i2);
                if (resultECReport == null) continue;
                if (resultECReport.getReportSettings() == null) {
                    resultECReport.setReportSettings(new ReportSettings());
                }
                resultECReport.getReportSettings().setPageOrder(1);
                PaperSettingProvider paperSettingProvider = this.paperSettingList.isEmpty() ? null : (PaperSettingProvider)this.paperSettingList.get(i2);
                this.export2temp(file2, resultWorkBook.getReportName(i2), resultECReport, paperSettingProvider, bl);
            }
            FRContext.getLogger().info("start compress files");
            Utils.zip(zipOutputStream, file2, null);
            zipOutputStream.closeEntry();
            zipOutputStream.close();
            FRContext.getLogger().info("complete compress files");
        }
        finally {
            StableUtils.deleteFile(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void export2temp(File file, String string, ResultECReport resultECReport, PaperSettingProvider paperSettingProvider, boolean bl) throws Exception {
        if (string == null || resultECReport == null) {
            return;
        }
        PageSetProvider pageSetProvider = resultECReport.generateReportPageSet(paperSettingProvider);
        pageSetProvider = pageSetProvider instanceof B._D ? ((B._D)pageSetProvider).A(this.isPage) : pageSetProvider.traverse4Export();
        try {
            int n2 = 1;
            FRContext.getLogger().info("\"" + string + "\"" + Inter.getLocText("Prepare_Export"));
            FT fT = new FT(0, 0);
            while (fT.to != -1) {
                fT.from = fT.to;
                String string2 = string + "_" + n2 + ".xls";
                FileOutputStream fileOutputStream = new FileOutputStream(file.getAbsolutePath() + File.separator + string2);
                PageRWorkBook pageRWorkBook = new PageRWorkBook();
                try {
                    pageRWorkBook.addReport(string, new LargeDataExcelExporterReport(resultECReport, pageSetProvider, fT, this.isPage, ExportConstants.MAX_ROWS));
                    this.exportFor2003(fileOutputStream, pageRWorkBook, false);
                    FRContext.getLogger().info("\"" + string2 + "\"" + Inter.getLocText("Finish_Export"));
                }
                finally {
                    fileOutputStream.close();
                }
                ++n2;
            }
        }
        finally {
            if (!bl || !pageSetProvider.isPageCached()) {
                pageSetProvider.release();
            }
        }
        FRContext.getLogger().info("\"" + string + Inter.getLocText("Finish_Export"));
    }

    @Override
    protected void exportBook(ResultWorkBook resultWorkBook, POIWorkbookAction pOIWorkbookAction, List list, List<String> list2, List<Report> list3, boolean bl) throws Exception {
        Report report;
        int n2;
        for (n2 = 0; n2 < resultWorkBook.getReportCount(); ++n2) {
            report = resultWorkBook.getReport(n2);
            list3.add(report);
        }
        for (n2 = 0; n2 < resultWorkBook.getReportCount(); ++n2) {
            report = list3.get(n2);
            this.innerExportReport(report, resultWorkBook.getReportExportAttr(), resultWorkBook.getReportName(n2), (HSSFWorkbook)pOIWorkbookAction.getWorkbook(), list, list2, n2);
        }
    }
}

