/*
 * Decompiled with CFR 0.152.
 */
package com.fr.io.exporter;

import com.fr.base.ConfigManager;
import com.fr.base.DynamicUnitList;
import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.GraphHelper;
import com.fr.base.Painter;
import com.fr.base.ResultFormula;
import com.fr.base.Style;
import com.fr.base.TextFormat;
import com.fr.base.Utils;
import com.fr.base.background.ColorBackground;
import com.fr.base.background.PatternBackground;
import com.fr.base.chart.BaseChartPainter;
import com.fr.cache.list.IntList;
import com.fr.general.Background;
import com.fr.general.DateUtils;
import com.fr.general.FRFont;
import com.fr.general.Inter;
import com.fr.general.PageCalObj;
import com.fr.io.attr.ExcelExportAttr;
import com.fr.io.attr.ReportExportAttr;
import com.fr.io.core.ExcelExporterReport;
import com.fr.io.exporter.AbstractExcelExporter;
import com.fr.io.exporter.POIPictureLocation;
import com.fr.io.exporter.POIWrapper.POIFontAction;
import com.fr.io.exporter.POIWrapper.POIHeaderFooterAction;
import com.fr.io.exporter.POIWrapper.POIWorkbookAction;
import com.fr.io.exporter.POIWrapper.PaperSettingWrapper;
import com.fr.io.exporter.POIWrapper.XssfCellStyleWrapper;
import com.fr.io.exporter.POIWrapper.XssfCellWrapper;
import com.fr.io.exporter.POIWrapper.XssfClientAnchorWrapper;
import com.fr.io.exporter.POIWrapper.XssfFontWrapper;
import com.fr.io.exporter.POIWrapper.XssfFooterWrapper;
import com.fr.io.exporter.POIWrapper.XssfHeaderWrapper;
import com.fr.io.exporter.POIWrapper.XssfPatriarchWrapper;
import com.fr.io.exporter.POIWrapper.XssfPrintSetupWrapper1;
import com.fr.io.exporter.POIWrapper.XssfSheetWrapper;
import com.fr.io.exporter.POIWrapper.XssfWorkbookWrapper;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.page.PaperSettingProvider;
import com.fr.page.ReportSettingsProvider;
import com.fr.report.ReportHelper;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.FloatElement;
import com.fr.report.cell.cellattr.CellGUIAttr;
import com.fr.report.cell.cellattr.core.CellUtils;
import com.fr.report.core.PaintUtils;
import com.fr.report.core.ReportUtils;
import com.fr.report.elementcase.ElementCase;
import com.fr.report.report.Report;
import com.fr.report.report.ResultECReport;
import com.fr.script.Calculator;
import com.fr.stable.ColumnRow;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.ExportConstants;
import com.fr.stable.StringUtils;
import com.fr.third.com.lowagie.text.Chunk;
import com.fr.third.com.lowagie.text.Font;
import com.fr.third.com.lowagie.text.Paragraph;
import com.fr.third.com.lowagie.text.html.simpleparser.HTMLWorker;
import com.fr.third.com.lowagie.text.html.simpleparser.StyleSheet;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFTextBox;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellBorder;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextAnchoringType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Excel2007Exporter
extends AbstractExcelExporter {
    private XSSFCellStyle defaultXSSFCellStyle = null;
    private XSSFDataFormat format = null;
    private static final int DEFAULT_SCALE = 1;

    public Excel2007Exporter() {
        this(null);
    }

    public Excel2007Exporter(List<PaperSettingProvider> list) {
        this.paperSettingList = list;
    }

    @Override
    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook) throws Exception {
        this.export(outputStream, resultWorkBook, false);
    }

    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook, boolean bl) throws Exception {
        if (resultWorkBook == null) {
            throw new Exception("Report can not be null!");
        }
        ArrayList<Report> arrayList = new ArrayList<Report>();
        this.defaultXSSFCellStyle = null;
        this.hssfFontHash.clear();
        this.hssfCellStyleHash.clear();
        this.format = null;
        XSSFWorkbook xSSFWorkbook = new XSSFWorkbook();
        this.setDefaultFont(new XssfWorkbookWrapper((Workbook)xSSFWorkbook));
        ArrayList<XSSFCell> arrayList2 = new ArrayList<XSSFCell>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        this.exportBook(resultWorkBook, new XssfWorkbookWrapper((Workbook)xSSFWorkbook), arrayList2, arrayList3, arrayList, bl);
        this.dealWithFormula(arrayList2, arrayList3);
        if (StringUtils.isNotEmpty(this.getPassword(resultWorkBook))) {
            FRContext.getLogger().error(Inter.getLocText("Excel2007-not-support-pwd"));
        }
        xSSFWorkbook.write(outputStream);
        outputStream.flush();
    }

    private void dealWithFormula(List<XSSFCell> list, List<String> list2) {
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            XSSFCell xSSFCell = list.get(i2);
            this.dealWithFormula(new XssfCellWrapper((Cell)xSSFCell), list2.get(i2));
        }
    }

    @Override
    protected void innerExportReports(ResultECReport resultECReport, ResultWorkBook resultWorkBook, POIWorkbookAction pOIWorkbookAction, List list, List<String> list2, List<Report> list3, int n2) {
        int n3 = resultECReport.getColumnCount();
        int n4 = resultECReport.getRowCount();
        Point point = new Point(0, 0);
        int n5 = 1;
        while (point.x < n3) {
            point.y = 0;
            while (point.y < n4) {
                try {
                    this.innerExportReport(new ExcelExporterReport(resultECReport, point.x, point.y, Math.min(n3 - point.x, ExportConstants.MAX_COLS_2007), Math.min(n4 - point.y, ExportConstants.MAX_ROWS_2007)), resultWorkBook.getReportExportAttr(), resultWorkBook.getReportName(n2) + (n5 == 1 ? "" : "_" + n5), (XSSFWorkbook)pOIWorkbookAction.getWorkbook(), list, list2, n2);
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage());
                }
                point.y += ExportConstants.MAX_ROWS_2007;
                ++n5;
            }
            point.x += ExportConstants.MAX_COLS_2007;
        }
    }

    protected void innerExportReport(Report report, ReportExportAttr reportExportAttr, String string, XSSFWorkbook xSSFWorkbook, List list, List list2, int n2) throws Exception {
        ExcelExportAttr excelExportAttr = reportExportAttr == null ? null : reportExportAttr.getExcelExportAttr();
        XSSFSheet xSSFSheet = xSSFWorkbook.createSheet();
        if (excelExportAttr != null && StringUtils.isNotEmpty(excelExportAttr.getProtectedWord())) {
            xSSFSheet.protectSheet(excelExportAttr.getProtectedWord());
        }
        this.setSheetName(new XssfWorkbookWrapper((Workbook)xSSFWorkbook), string);
        this.iterateReport((ElementCase)((Object)report), xSSFSheet, xSSFWorkbook, list, list2, excelExportAttr, n2);
    }

    protected void dealECReportAndBlockPageSetting(ElementCase elementCase, XSSFSheet xSSFSheet, int n2) {
        this.dealWithPageSetting((Report)((Object)elementCase), xSSFSheet, n2);
    }

    private void dealHid(ElementCase elementCase, XSSFSheet xSSFSheet, IntList intList, IntList intList2, DynamicUnitList dynamicUnitList, DynamicUnitList dynamicUnitList2, boolean bl, boolean bl2) {
        int n2;
        if (!bl) {
            for (n2 = dynamicUnitList.size() - 1; n2 >= 0; --n2) {
                if (!dynamicUnitList.get(n2).equal_zero()) continue;
                intList.add(n2);
                dynamicUnitList.remove(n2);
            }
        }
        if (!bl2) {
            for (n2 = dynamicUnitList2.size() - 1; n2 >= 0; --n2) {
                if (!dynamicUnitList2.get(n2).equal_zero()) continue;
                intList2.add(n2);
                dynamicUnitList2.remove(n2);
            }
        }
        if (elementCase.getReportPageAttr() != null && elementCase.getReportPageAttr().getFreezeColumnRow() != null) {
            int n3;
            ColumnRow columnRow = elementCase.getReportPageAttr().getFreezeColumnRow();
            int n4 = columnRow.getColumn();
            int n5 = columnRow.getRow();
            for (n3 = 0; n3 < columnRow.getColumn(); ++n3) {
                if (!intList2.contain(n3)) continue;
                --n4;
            }
            for (n3 = 0; n3 < columnRow.getRow(); ++n3) {
                if (!intList.contain(n3)) continue;
                --n5;
            }
            xSSFSheet.createFreezePane(n4, n5);
        }
    }

    private void iterateReport(ElementCase elementCase, XSSFSheet xSSFSheet, XSSFWorkbook xSSFWorkbook, List list, List list2, ExcelExportAttr excelExportAttr, int n2) throws Exception {
        this.dealECReportAndBlockPageSetting(elementCase, xSSFSheet, n2);
        xSSFSheet.setDefaultColumnWidth(9);
        Iterator iterator = elementCase.cellIterator();
        DynamicUnitList dynamicUnitList = ReportHelper.getRowHeightList(elementCase);
        DynamicUnitList dynamicUnitList2 = ReportHelper.getColumnWidthList(elementCase);
        IntList intList = new IntList();
        IntList intList2 = new IntList();
        boolean bl = excelExportAttr == null ? false : excelExportAttr.isExportHidedRow();
        boolean bl2 = excelExportAttr == null ? false : excelExportAttr.isExportHidedColumn();
        this.dealHid(elementCase, xSSFSheet, intList, intList2, dynamicUnitList, dynamicUnitList2, bl, bl2);
        int n3 = -1;
        int n4 = -1;
        XSSFRow xSSFRow = null;
        XSSFDrawing xSSFDrawing = xSSFSheet.createDrawingPatriarch();
        XSSFDrawing xSSFDrawing2 = null;
        if (this.columnRowPostileMaps != null && this.columnRowPostileMaps[n2] != null) {
            xSSFDrawing2 = xSSFSheet.createDrawingPatriarch();
        }
        Calculator calculator = Calculator.createCalculator();
        this.setAttr4ECReportSIL(calculator, intList, intList2, elementCase);
        while (iterator.hasNext()) {
            int n5;
            int n6;
            CellElement cellElement = (CellElement)iterator.next();
            int n7 = cellElement.getColumn();
            int n8 = cellElement.getRow();
            int n9 = cellElement.getColumnSpan();
            int n10 = cellElement.getRowSpan();
            int[] nArray = this.dealWithHiddenCR(n8, n10, intList);
            n8 = nArray[0];
            n10 = nArray[1];
            nArray = this.dealWithHiddenCR(n7, n9, intList2);
            n7 = nArray[0];
            n9 = nArray[1];
            if (n10 <= 0 || n9 <= 0) continue;
            int n11 = n7 + n9 - 1;
            int n12 = n8 + n10 - 1;
            if (n3 < n11) {
                for (n6 = Math.max(0, n3); n6 <= n11; ++n6) {
                    if (dynamicUnitList2.get(n6).toFU() <= 0L) {
                        xSSFSheet.setColumnHidden((int)((short)n6), bl2);
                        continue;
                    }
                    xSSFSheet.setColumnWidth((int)((short)n6), (int)((short)(dynamicUnitList2.get(n6).toPixD(96) * ConfigManager.getInstance().getExcelAdjustWidth())));
                }
                n3 = n11;
            }
            if (n4 < n12) {
                for (n6 = Math.max(0, n4); n6 <= n12; ++n6) {
                    XSSFRow xSSFRow2 = xSSFSheet.getRow(n6);
                    if (xSSFRow2 == null) {
                        xSSFRow2 = xSSFSheet.createRow(n6);
                    }
                    if (dynamicUnitList.get(n6).toFU() <= 0L) {
                        xSSFRow2.setZeroHeight(bl);
                        continue;
                    }
                    xSSFRow2.setHeight((short)(dynamicUnitList.get(n6).toPTValue4Scale2() * ConfigManager.getInstance().getExcelAdjustHeight()));
                }
                n4 = n12;
            }
            this.setColumnRowBreak(cellElement, new XssfSheetWrapper((Sheet)xSSFSheet), n9, n10, n11, n12);
            CellGUIAttr cellGUIAttr = cellElement.getCellGUIAttr();
            if (cellGUIAttr == null) {
                cellGUIAttr = CellGUIAttr.DEFAULT_CELLGUIATTR;
            }
            if (!cellGUIAttr.isPrintContent() && !cellGUIAttr.isPrintBackground()) continue;
            int n13 = n7 + n9;
            for (int i2 = n5 = n7; i2 < n13; ++i2) {
                int n14;
                int n15 = n8 + n10;
                for (int i3 = n14 = n8; i3 < n15; ++i3) {
                    XSSFCell xSSFCell = this.createXSSFCell(xSSFRow, xSSFSheet, i3, i2, n11, n8, n2, elementCase, xSSFDrawing2);
                    if (i2 != n5 || i3 != n14 || !cellGUIAttr.isPrintContent() && cellGUIAttr.isPrintBackground()) {
                        xSSFCell.setCellStyle((CellStyle)this.createXSSFCellStyle(xSSFWorkbook, cellElement.getStyle()));
                        continue;
                    }
                    this.dealWithValue(cellElement, list, xSSFCell, excelExportAttr, calculator, list2, cellGUIAttr, xSSFWorkbook, dynamicUnitList, dynamicUnitList2, n7, n8, n9, n10, xSSFDrawing);
                }
            }
            if (n10 <= 1 && n9 <= 1) continue;
            CellRangeAddress cellRangeAddress = new CellRangeAddress(n8, n8 + n10 - 1, (int)((short)n7), (int)((short)(n7 + n9 - 1)));
            xSSFSheet.addMergedRegion(cellRangeAddress);
        }
        this.dealWithFloatElement(elementCase, xSSFDrawing, dynamicUnitList, dynamicUnitList2, n3, n4, xSSFSheet, xSSFWorkbook);
    }

    private XSSFCell createXSSFCell(XSSFRow xSSFRow, XSSFSheet xSSFSheet, int n2, int n3, int n4, int n5, int n6, ElementCase elementCase, XSSFDrawing xSSFDrawing) {
        String string;
        if (xSSFRow == null || xSSFRow.getRowNum() != n2) {
            xSSFRow = xSSFSheet.getRow(n2);
        }
        XSSFCell xSSFCell = xSSFRow.createCell((int)((short)n3));
        if (n2 == n5 && n3 == n4 && this.columnRowPostileMaps != null && this.columnRowPostileMaps[n6] != null && (string = (String)this.columnRowPostileMaps[n6].get(ColumnRow.valueOf(n4, n5))) != null) {
            int n7;
            int n8 = n5;
            long l2 = 0L;
            long l3 = 0L;
            for (n7 = n4; n7 < elementCase.getColumnCount(); ++n7) {
                if ((l3 += elementCase.getColumnWidth(n7).getLen()) <= 3048000L) continue;
                ++n7;
                break;
            }
            while (n8 < elementCase.getRowCount()) {
                if ((l2 += elementCase.getRowHeight(n8).getLen()) > 4572000L) {
                    ++n8;
                    break;
                }
                ++n8;
            }
            XSSFClientAnchor xSSFClientAnchor = new XSSFClientAnchor(0, 0, 0, 0, (int)((short)n4), n5, (int)((short)n7), n8);
            XSSFComment xSSFComment = xSSFDrawing.createCellComment((ClientAnchor)xSSFClientAnchor);
            xSSFComment.setString((RichTextString)new XSSFRichTextString(string));
            xSSFComment.setAuthor("FineReport");
            xSSFCell.setCellComment((Comment)xSSFComment);
        }
        return xSSFCell;
    }

    protected void dealWithPageSetting(Report report, XSSFSheet xSSFSheet, int n2) {
        POIHeaderFooterAction pOIHeaderFooterAction;
        ReportSettingsProvider reportSettingsProvider = ReportUtils.getReportSettings(report);
        PaperSettingWrapper paperSettingWrapper = new PaperSettingWrapper(this.paperSettingList, n2, reportSettingsProvider);
        XssfSheetWrapper xssfSheetWrapper = new XssfSheetWrapper((Sheet)xSSFSheet);
        this.dealWithAlignAndMargin(xssfSheetWrapper, reportSettingsProvider, paperSettingWrapper.getMargin());
        XssfPrintSetupWrapper1 xssfPrintSetupWrapper1 = new XssfPrintSetupWrapper1((PrintSetup)xSSFSheet.getPrintSetup());
        this.dealWithPrintSetUp(xssfPrintSetupWrapper1, paperSettingWrapper.getPaperSize(), paperSettingWrapper.getOrientation(), reportSettingsProvider);
        if (reportSettingsProvider.getHeaderHeight().more_than_zero()) {
            pOIHeaderFooterAction = new XssfHeaderWrapper(xSSFSheet.getHeader());
            this.applyReportHFHeader(report.getHeader(0), pOIHeaderFooterAction);
        }
        if (reportSettingsProvider.getFooterHeight().more_than_zero()) {
            pOIHeaderFooterAction = new XssfFooterWrapper(xSSFSheet.getFooter());
            this.applyReportHFFooter(report.getFooter(0), pOIHeaderFooterAction);
        }
    }

    private void dealWithFloatElement(ElementCase elementCase, XSSFDrawing xSSFDrawing, DynamicUnitList dynamicUnitList, DynamicUnitList dynamicUnitList2, int n2, int n3, XSSFSheet xSSFSheet, XSSFWorkbook xSSFWorkbook) {
        Iterator iterator = elementCase.floatIterator();
        while (iterator.hasNext()) {
            BufferedImage bufferedImage;
            FloatElement floatElement = (FloatElement)iterator.next();
            Object object = floatElement.getValue();
            POIPictureLocation pOIPictureLocation = this.locateFloatElementInExcel(floatElement, dynamicUnitList, dynamicUnitList2, elementCase, object);
            XSSFClientAnchor xSSFClientAnchor = new XSSFClientAnchor(pOIPictureLocation.getFirst_cell_x(), pOIPictureLocation.getFirst_cell_y(), pOIPictureLocation.getSecond_cell_x(), pOIPictureLocation.getSecond_cell_y(), (int)pOIPictureLocation.getFirst_cell_col(), pOIPictureLocation.getFirst_cell_row(), (int)pOIPictureLocation.getSecond_cell_col(), pOIPictureLocation.getSecond_cell_row());
            Style style = floatElement.getStyle();
            if (style == null) {
                style = Style.DEFAULT_STYLE;
            }
            int n4 = floatElement.getWidth().toPixI(96);
            int n5 = floatElement.getHeight().toPixI(96);
            if (object instanceof String || object instanceof Number) {
                this.dealWithTextBox(object, xSSFDrawing, xSSFClientAnchor, xSSFWorkbook, style);
                continue;
            }
            if (object instanceof Image) {
                bufferedImage = GraphHelper.createBufferedImageFromImageWithLayout((Image)object, n4, n5, style);
                this.dealWithBufferImage(object, xSSFClientAnchor, xSSFDrawing, xSSFWorkbook, style, n4, n5, bufferedImage);
                continue;
            }
            if (!(object instanceof BaseChartPainter)) continue;
            bufferedImage = ((BaseChartPainter)object).toFloatImage(n4, n5, 96);
            this.dealWithBufferImage(object, xSSFClientAnchor, xSSFDrawing, xSSFWorkbook, style, n4, n5, bufferedImage);
        }
    }

    @Override
    protected int getFloatLeftMax(double d2) {
        return (int)(9525.0 * d2);
    }

    @Override
    protected int getFloatTopMax(double d2) {
        return (int)(9525.0 * d2);
    }

    private void dealWithBufferImage(Object object, XSSFClientAnchor xSSFClientAnchor, XSSFDrawing xSSFDrawing, XSSFWorkbook xSSFWorkbook, Style style, int n2, int n3, BufferedImage bufferedImage) {
        this.dealWithBufferImage(object, new XssfClientAnchorWrapper((ClientAnchor)xSSFClientAnchor), new XssfPatriarchWrapper((Drawing)xSSFDrawing), style, n2, n3, bufferedImage, new XssfWorkbookWrapper((Workbook)xSSFWorkbook));
    }

    private void dealWithTextBox(Object object, XSSFDrawing xSSFDrawing, XSSFClientAnchor xSSFClientAnchor, XSSFWorkbook xSSFWorkbook, Style style) {
        String string = object.toString();
        XSSFTextBox xSSFTextBox = xSSFDrawing.createTextbox(xSSFClientAnchor);
        Color color = Color.white;
        Background background = style.getBackground();
        if (background != null && background instanceof ColorBackground) {
            color = ((ColorBackground)background).getColor();
        }
        xSSFTextBox.getCTShape().getTxBody().getBodyPr().setAnchor(this.changeVertAlignment(style));
        if (color != null) {
            xSSFTextBox.setFillColor(color.getRed(), color.getGreen(), color.getBlue());
        }
        Color color2 = style.getBorderLeftColor();
        xSSFTextBox.setLineStyleColor(color2.getRed(), color2.getGreen(), color2.getBlue());
        XSSFRichTextString xSSFRichTextString = new XSSFRichTextString(string);
        XSSFFont xSSFFont = this.createFont(xSSFWorkbook, (java.awt.Font)style.getFRFont());
        if (style.getFRFont().getForeground() == Color.BLACK) {
            xSSFFont.setColor(new XSSFColor(new Color(Color.BLACK.getRed(), Color.BLACK.getGreen(), Color.BLACK.getBlue() + 1)));
        }
        xSSFRichTextString.applyFont((org.apache.poi.ss.usermodel.Font)xSSFFont);
        xSSFTextBox.setText(xSSFRichTextString);
    }

    private STTextAnchoringType.Enum changeVertAlignment(Style style) {
        int n2 = style.getVerticalAlignment();
        if (n2 == 3) {
            return STTextAnchoringType.B;
        }
        if (n2 == 1) {
            return STTextAnchoringType.T;
        }
        return STTextAnchoringType.CTR;
    }

    private void dealWithValue(CellElement cellElement, List list, XSSFCell xSSFCell, ExcelExportAttr excelExportAttr, Calculator calculator, List list2, CellGUIAttr cellGUIAttr, XSSFWorkbook xSSFWorkbook, DynamicUnitList dynamicUnitList, DynamicUnitList dynamicUnitList2, int n2, int n3, int n4, int n5, XSSFDrawing xSSFDrawing) {
        String string;
        int n6;
        Cloneable cloneable;
        boolean bl;
        Object object = cellElement.getShowValue();
        Style style = cellElement.getStyle();
        if (object == null) {
            object = "";
        }
        boolean bl2 = excelExportAttr == null ? true : excelExportAttr.isExportHidedRow();
        boolean bl3 = bl = excelExportAttr == null ? true : excelExportAttr.isExportHidedColumn();
        if (object instanceof Formula) {
            cloneable = (Formula)object;
            if (cloneable.isReserveInResult() && cloneable instanceof ResultFormula) {
                String string2 = cloneable.getContent();
                n6 = !bl2 || !bl ? 1 : 0;
                if ((string2 = this.dealWithSumFormula(string2, object, (Formula)cloneable, n6 != 0)) != null) {
                    if (string2.startsWith("=")) {
                        string2 = string2.substring(1);
                    }
                    list.add(xSSFCell);
                    if (n6 != 0 && StringUtils.isNotBlank(string2)) {
                        try {
                            string = calculator.exStatement(null, string2);
                            list2.add(string == null ? FORMULA_ERROR : string);
                        }
                        catch (Exception exception) {
                            list2.add(FORMULA_ERROR);
                        }
                    } else {
                        list2.add(string2);
                    }
                }
            } else {
                object = cloneable.getResult();
            }
        } else if (object instanceof PageCalObj) {
            object = cellElement.getValue();
        } else {
            object = Utils.resolveOtherValue(object, cellGUIAttr.isShowAsImage());
            int n7 = style.getTextStyle();
            if (this.isShowAsImage(n7, cellGUIAttr)) {
                int n8 = dynamicUnitList2.getRangeValue(n2, n2 + n4).toPixI(96);
                n6 = dynamicUnitList.getRangeValue(n3, n3 + n5).toPixI(96);
                object = CellUtils.value2ImageWithBackground(object, 96, style, n8, n6);
            }
        }
        if (object instanceof String && StringUtils.isNotEmpty((String)object)) {
            if (cellGUIAttr.isShowAsHTML()) {
                cloneable = null;
                try {
                    cloneable = this.html2XSSFRichTextString(xSSFWorkbook, (String)object, style);
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(Inter.getLocText("NS_export_excelHtml"));
                }
                if (cloneable != null && StringUtils.isNotEmpty(cloneable.getString())) {
                    object = cloneable;
                } else {
                    int n9 = dynamicUnitList2.getRangeValue(n2, n2 + n4).toPixI(96);
                    n6 = dynamicUnitList.getRangeValue(n3, n3 + n5).toPixI(96);
                    object = PaintUtils.createHTMLContentBufferedImage(object.toString(), new Rectangle(n9, n6), 1, 1);
                }
            } else if (style.getVerticalText() == 1) {
                object = this.checkValueVertical(n3, n5, n2, n4, Utils.objectToString(object), style, dynamicUnitList, dynamicUnitList2);
            }
        }
        cloneable = style.getFormat();
        XSSFCellStyle xSSFCellStyle = this.createXSSFCellStyle(xSSFWorkbook, style);
        if ((object = this.checkNumberFormat((Format)cloneable, object)) instanceof Formula) {
            this.dealDateFormula(xSSFCell, object, xSSFWorkbook, xSSFCellStyle, style);
        } else if (!(object instanceof Formula)) {
            if (object instanceof Number) {
                xSSFCell.setCellType(0);
                xSSFCell.setCellValue(((Number)object).doubleValue());
            } else if (object instanceof Boolean) {
                xSSFCell.setCellType(4);
                xSSFCell.setCellValue(((Boolean)object).booleanValue());
            } else if (object instanceof Painter || object instanceof Image) {
                this.scalePic(n2, n3, n4, n5, object, dynamicUnitList2, dynamicUnitList, style, xSSFDrawing, xSSFWorkbook);
            } else if (object instanceof XSSFRichTextString) {
                xSSFCell.setCellType(1);
                xSSFCell.setCellValue((RichTextString)((XSSFRichTextString)object));
            } else if (object instanceof Date) {
                Format format = style.getFormat() == null ? DateUtils.DATEFORMAT2 : style.getFormat();
                string = this.createXSSFCellStyle(xSSFWorkbook, style.deriveFormat(format));
                xSSFCell.setCellStyle((CellStyle)string);
                xSSFCell.setCellValue((Date)object);
            } else {
                String string3 = Style.valueToText(object, (Format)cloneable);
                if (string3 != null) {
                    if (string3.startsWith("=")) {
                        string = string3.substring(1);
                        list.add(xSSFCell);
                        if (!(bl2 && bl || !StringUtils.isNotBlank(string))) {
                            try {
                                String string4 = calculator.exStatement(null, string);
                                list2.add(string4 == null ? FORMULA_ERROR : string4);
                            }
                            catch (Exception exception) {
                                list2.add(FORMULA_ERROR);
                            }
                        } else {
                            list2.add(string);
                        }
                    } else if (string3.length() > 0) {
                        string3 = this.replaceNewLineChar(string3);
                        if (cloneable instanceof NumberFormat) {
                            try {
                                xSSFCell.setCellValue(Double.parseDouble(string3));
                                xSSFCell.setCellType(0);
                            }
                            catch (NumberFormatException numberFormatException) {
                                xSSFCell.setCellType(1);
                                xSSFCell.setCellValue(string3);
                            }
                        } else {
                            xSSFCell.setCellType(1);
                            xSSFCell.setCellValue(string3);
                        }
                    }
                }
            }
        }
        if (xSSFCell.getCellType() == 1 && xSSFCell.getStringCellValue().startsWith("--")) {
            style.deriveFormat(TextFormat.getInstance());
        }
        if (!cellGUIAttr.isPrintBackground()) {
            Style style2 = style.deriveBackground(null);
            xSSFCell.setCellStyle((CellStyle)this.createXSSFCellStyle(xSSFWorkbook, style2));
        } else if (!(object instanceof Date) && !(object instanceof Formula)) {
            xSSFCell.setCellStyle((CellStyle)xSSFCellStyle);
        }
    }

    private void scalePic(int n2, int n3, int n4, int n5, Object object, DynamicUnitList dynamicUnitList, DynamicUnitList dynamicUnitList2, Style style, XSSFDrawing xSSFDrawing, XSSFWorkbook xSSFWorkbook) {
        XSSFClientAnchor xSSFClientAnchor = new XSSFClientAnchor(0, 0, 0, 0, (int)((short)n2), n3, (int)((short)(n2 + n4)), n3 + n5);
        if (object != null) {
            xSSFClientAnchor.setAnchorType(0);
            double d2 = dynamicUnitList.getRangeValue(n2, n2 + n4).toPixI(96);
            double d3 = dynamicUnitList2.getRangeValue(n3, n3 + n5).toPixI(96);
            double d4 = 1.0;
            if (object instanceof Image && style.getImageLayout() == 2) {
                double d5 = ((Image)object).getWidth(null);
                double d6 = ((Image)object).getHeight(null);
                d4 = Math.min(d5 / d2, d6 / d3);
            }
            int n6 = (int)(d2 * d4);
            int n7 = (int)(d3 * d4);
            BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage(n6 + 1, n7 + 1, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.translate(style.getBorderLeftWidth(), style.getBorderTopWidth());
            Style.paintContent(graphics2D, object, style, n6 - style.getBorderLeftWidth(), n7 - style.getBorderTopWidth(), 96);
            bufferedImage.flush();
            graphics2D.dispose();
            try {
                int n8 = this.loadPicture(bufferedImage, new XssfWorkbookWrapper((Workbook)xSSFWorkbook));
                XSSFPicture xSSFPicture = xSSFDrawing.createPicture(xSSFClientAnchor, n8);
                if (d4 != 1.0) {
                    double d7 = (double)((int)(1.0 / d4 * 100.0)) / 100.0;
                    xSSFPicture.resize(d7);
                }
            }
            catch (IOException iOException) {
                FRContext.getLogger().error(iOException.getMessage());
            }
        }
    }

    private void dealDateFormula(XSSFCell xSSFCell, Object object, XSSFWorkbook xSSFWorkbook, XSSFCellStyle xSSFCellStyle, Style style) {
        xSSFCell.setCellType(2);
        String string = ((Formula)object).getContent();
        if (string.equalsIgnoreCase("=now()")) {
            xSSFCell.setCellFormula("now()");
            XSSFCellStyle xSSFCellStyle2 = this.createXSSFCellStyle(xSSFWorkbook, style.deriveFormat(DateUtils.DATETIMEFORMAT2));
            xSSFCell.setCellStyle((CellStyle)xSSFCellStyle2);
        } else if (string.equalsIgnoreCase("=today()")) {
            xSSFCell.setCellFormula("today()");
            XSSFCellStyle xSSFCellStyle3 = this.createXSSFCellStyle(xSSFWorkbook, style.deriveFormat(DateUtils.DATEFORMAT2));
            xSSFCell.setCellStyle((CellStyle)xSSFCellStyle3);
        } else {
            xSSFCell.setCellStyle((CellStyle)xSSFCellStyle);
        }
    }

    private XSSFCellStyle createXSSFCellStyle(XSSFWorkbook xSSFWorkbook, Style style) {
        if (style == null) {
            if (this.defaultXSSFCellStyle == null) {
                this.defaultXSSFCellStyle = xSSFWorkbook.createCellStyle();
                this.executeXSSFCellStyle(xSSFWorkbook, this.defaultXSSFCellStyle, Style.DEFAULT_STYLE);
            }
            return this.defaultXSSFCellStyle;
        }
        style = this.adjustProperFontSize(style);
        XSSFCellStyle xSSFCellStyle = null;
        Enumeration enumeration = this.hssfCellStyleHash.keys();
        while (enumeration.hasMoreElements()) {
            Object k2 = enumeration.nextElement();
            if (!style.equals(k2)) continue;
            xSSFCellStyle = (XSSFCellStyle)this.hssfCellStyleHash.get(k2);
            break;
        }
        if (xSSFCellStyle == null) {
            xSSFCellStyle = xSSFWorkbook.createCellStyle();
            this.executeXSSFCellStyle(xSSFWorkbook, xSSFCellStyle, style);
            this.hssfCellStyleHash.put(style, xSSFCellStyle);
        }
        if (style.getHorizontalAlignment() == 4) {
            int n2 = style.getPaddingRight() <= 2 ? 0 : style.getPaddingRight() / 27;
            xSSFCellStyle.setIndention((short)n2);
        } else {
            int n3 = style.getPaddingLeft() <= 2 ? 0 : style.getPaddingLeft() / 27;
            xSSFCellStyle.setIndention((short)n3);
        }
        return xSSFCellStyle;
    }

    private void executeXSSFCellStyle(XSSFWorkbook xSSFWorkbook, XSSFCellStyle xSSFCellStyle, Style style) {
        this.executeCellStyle(new XssfWorkbookWrapper((Workbook)xSSFWorkbook), new XssfCellStyleWrapper((CellStyle)xSSFCellStyle), style);
        xSSFCellStyle.setBorderColor(XSSFCellBorder.BorderSide.TOP, new XSSFColor(style.getBorderTopColor()));
        xSSFCellStyle.setBorderColor(XSSFCellBorder.BorderSide.LEFT, new XSSFColor(style.getBorderLeftColor()));
        xSSFCellStyle.setBorderColor(XSSFCellBorder.BorderSide.BOTTOM, new XSSFColor(style.getBorderBottomColor()));
        xSSFCellStyle.setBorderColor(XSSFCellBorder.BorderSide.RIGHT, new XSSFColor(style.getBorderRightColor()));
        Background background = style.getBackground();
        if (background != null) {
            if (background instanceof ColorBackground) {
                ColorBackground colorBackground = (ColorBackground)background;
                xSSFCellStyle.setFillPattern((short)1);
                xSSFCellStyle.setFillForegroundColor(new XSSFColor(colorBackground.getColor()));
                xSSFCellStyle.setFillBackgroundColor(new XSSFColor(colorBackground.getColor()));
            } else if (background instanceof PatternBackground) {
                PatternBackground patternBackground = (PatternBackground)background;
                xSSFCellStyle.setFillPattern((short)16);
                xSSFCellStyle.setFillBackgroundColor(new XSSFColor(patternBackground.getBackground()));
                xSSFCellStyle.setFillForegroundColor(new XSSFColor(patternBackground.getForeground()));
            }
        }
    }

    @Override
    protected short getRotation(Style style) {
        int n2 = style.getRotation();
        if (n2 > 90 || n2 < -90) {
            n2 = 0;
        }
        if (n2 < 0) {
            n2 = 90 - n2;
        }
        return (short)n2;
    }

    @Override
    protected POIFontAction createFont(POIWorkbookAction pOIWorkbookAction, java.awt.Font font) {
        return new XssfFontWrapper((org.apache.poi.ss.usermodel.Font)this.createFont((XSSFWorkbook)pOIWorkbookAction.getWorkbook(), font));
    }

    private XSSFFont createFont(XSSFWorkbook xSSFWorkbook, java.awt.Font font) {
        if (font == null) {
            return null;
        }
        XSSFFont xSSFFont = this.createSimpleXSSFFont(xSSFWorkbook, new AbstractExcelExporter.JavaFontAdapter(font), font.getName());
        if (font instanceof FRFont) {
            FRFont fRFont = (FRFont)font;
            Color color = fRFont.getForeground();
            if (color != Color.BLACK) {
                xSSFFont.setColor(new XSSFColor(color));
            }
            this.createComplexFont4FR(fRFont, new XssfFontWrapper((org.apache.poi.ss.usermodel.Font)xSSFFont));
        }
        return xSSFFont;
    }

    private XSSFDataFormat getXSSFDataFormat(XSSFWorkbook xSSFWorkbook) {
        return this.format == null ? xSSFWorkbook.createDataFormat() : this.format;
    }

    @Override
    protected short getFormat(POIWorkbookAction pOIWorkbookAction, String string) {
        return this.getXSSFDataFormat((XSSFWorkbook)pOIWorkbookAction.getWorkbook()).getFormat(string);
    }

    private XSSFRichTextString html2XSSFRichTextString(XSSFWorkbook xSSFWorkbook, String string, Style style) throws Exception {
        Object object;
        if (StringUtils.isNotEmpty(string) && string.indexOf("<li>") != -1) {
            FRContext.getLogger().error(Inter.getLocText("NS_export_excelHtml"));
            return new XSSFRichTextString(this.splitAndFilterString(string));
        }
        string = this.convertPx2Pt(string);
        ArrayList arrayList = HTMLWorker.parseToList((Reader)new StringReader(string), (StyleSheet)new StyleSheet());
        ArrayList<Paragraph> arrayList2 = new ArrayList<Paragraph>();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            Paragraph paragraph;
            if (arrayList.get(i2) instanceof Paragraph) {
                paragraph = (Paragraph)arrayList.get(i2);
                paragraph.getContent();
                object = paragraph.getChunks();
                arrayList2.addAll((Collection<Paragraph>)object);
                continue;
            }
            if (!(arrayList.get(i2) instanceof Chunk)) continue;
            paragraph = (Chunk)arrayList.get(i2);
            arrayList2.add(paragraph);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i3 = 0; i3 < arrayList2.size(); ++i3) {
            object = (Chunk)arrayList2.get(i3);
            stringBuffer.append(object.getContent());
        }
        XSSFRichTextString xSSFRichTextString = new XSSFRichTextString(stringBuffer.toString());
        int n2 = 0;
        int n3 = 0;
        for (int i4 = 0; i4 < arrayList2.size(); ++i4) {
            Chunk chunk = (Chunk)arrayList2.get(i4);
            Font font = chunk.getFont();
            XSSFFont xSSFFont = this.iTextFont2XSSFFont(xSSFWorkbook, font, chunk.getAttributes(), style);
            xSSFRichTextString.applyFont(n2, n3 += chunk.getContent().length(), (org.apache.poi.ss.usermodel.Font)xSSFFont);
            n2 = n3;
        }
        return xSSFRichTextString;
    }

    private String convertPx2Pt(String string) {
        try {
            int n2;
            while ((n2 = string.indexOf("px")) != -1) {
                double d2;
                int n3 = 0;
                for (int i2 = 0; i2 < 10 && ((n3 = n2 - i2) <= 0 || string.charAt(n3) != ' ' && string.charAt(n3) != ':'); ++i2) {
                }
                n3 = n3 == 0 ? n2 - 2 : n3;
                String string2 = string.substring(n3, n2).replaceAll(":", "").trim();
                try {
                    d2 = Double.parseDouble(string2);
                }
                catch (Exception exception) {
                    d2 = 0.0;
                }
                string = string.replaceAll(string2 + "px", d2 * 72.0 / 96.0 + "pt");
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        return string;
    }

    private XSSFFont createSimpleXSSFFont(XSSFWorkbook xSSFWorkbook, AbstractExcelExporter.FontAdapter fontAdapter, String string) {
        return (XSSFFont)this.createSimpleFont(new XssfWorkbookWrapper((Workbook)xSSFWorkbook), fontAdapter, new XssfFontWrapper(), string).getFont();
    }

    private XSSFFont iTextFont2XSSFFont(XSSFWorkbook xSSFWorkbook, Font font, Map map, Style style) {
        if (font == null) {
            return null;
        }
        XSSFFont xSSFFont = this.createSimpleXSSFFont(xSSFWorkbook, new AbstractExcelExporter.TextFontAdapter(font), style.getFRFont().getName());
        Color color = font.getColor();
        Color color2 = color = color != null ? color : style.getFRFont().getForeground();
        if (color != Color.BLACK) {
            xSSFFont.setColor(new XSSFColor(color));
        }
        this.createComplexFont4Itext(font, map, new XssfFontWrapper((org.apache.poi.ss.usermodel.Font)xSSFFont));
        return xSSFFont;
    }
}

