/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general.script;

import com.fr.general.GeneralUtils;
import com.fr.stable.Primitive;
import com.fr.stable.StableUtils;
import java.math.BigDecimal;

public class FunctionHelper {
    private FunctionHelper() {
    }

    public static String NumberToEnglish(BigDecimal bigDecimal) throws Exception {
        int n2;
        String string = "";
        int n3 = bigDecimal.intValue();
        if (n3 >= 20) {
            int n4 = n3 / 10 * 10;
            n2 = n3 - n4;
            switch (n4) {
                case 90: {
                    string = "NINETY";
                    break;
                }
                case 80: {
                    string = "EIGHTY";
                    break;
                }
                case 70: {
                    string = "SEVENTY";
                    break;
                }
                case 60: {
                    string = "SIXTY";
                    break;
                }
                case 50: {
                    string = "FIFTY";
                    break;
                }
                case 40: {
                    string = "FORTY";
                    break;
                }
                case 30: {
                    string = "THIRTY";
                    break;
                }
                case 20: {
                    string = "TWENTY";
                }
            }
            if (string.trim().length() > 0) {
                string = string + " ";
            }
        } else {
            n2 = n3;
        }
        switch (n2) {
            case 19: {
                string = string + "NINETEEN";
                break;
            }
            case 18: {
                string = string + "EIGHTEEN";
                break;
            }
            case 17: {
                string = string + "SEVENTEEN";
                break;
            }
            case 16: {
                string = string + "SIXTEEN";
                break;
            }
            case 15: {
                string = string + "FIFTEEN";
                break;
            }
            case 14: {
                string = string + "FOURTEEN";
                break;
            }
            case 13: {
                string = string + "THIRTEEN";
                break;
            }
            case 12: {
                string = string + "TWELVE";
                break;
            }
            case 11: {
                string = string + "ELEVEN";
                break;
            }
            case 10: {
                string = string + "TEN";
                break;
            }
            case 9: {
                string = string + "NINE";
                break;
            }
            case 8: {
                string = string + "EIGHT";
                break;
            }
            case 7: {
                string = string + "SEVEN";
                break;
            }
            case 6: {
                string = string + "SIX";
                break;
            }
            case 5: {
                string = string + "FIVE";
                break;
            }
            case 4: {
                string = string + "FOUR";
                break;
            }
            case 3: {
                string = string + "THREE";
                break;
            }
            case 2: {
                string = string + "TWO";
                break;
            }
            case 1: {
                string = string + "ONE";
            }
        }
        return string;
    }

    public static Number asNumber(long l2) {
        if (l2 > Integer.MAX_VALUE || l2 < Integer.MIN_VALUE) {
            return new Long(l2);
        }
        return new Integer((int)l2);
    }

    public static Number asNumber(double d2) {
        int n2 = (int)d2;
        if (d2 != (double)n2) {
            if (StableUtils.doubleToString(d2).equals("\u221e") || StableUtils.doubleToString(d2).equals("-\u221e")) {
                return new Double(d2);
            }
            return Double.valueOf(StableUtils.doubleToString(d2));
        }
        return FunctionHelper.asNumber((long)d2);
    }

    public static Object roundUpOrDown(Object[] objectArray, boolean bl) {
        if (objectArray.length < 1) {
            return Primitive.ERROR_NAME;
        }
        double d2 = GeneralUtils.objectToNumber(objectArray[0], false).doubleValue();
        int n2 = objectArray.length < 2 ? 0 : GeneralUtils.objectToNumber(objectArray[1], false).intValue();
        double d3 = d2;
        if (n2 >= 0) {
            d3 = new BigDecimal(d2 + "").setScale(n2, bl ? 0 : 1).doubleValue();
        } else if (n2 < 0) {
            double d4 = Math.pow(10.0, -n2 * 2);
            d3 = new BigDecimal(d2 / d4 + "").setScale(-n2, bl ? 0 : 1).doubleValue() * d4;
        }
        return FunctionHelper.asNumber(d3);
    }
}

