/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general.jsqlparser.util.deparser;

import com.fr.general.jsqlparser.expression.AllComparisonExpression;
import com.fr.general.jsqlparser.expression.AnyComparisonExpression;
import com.fr.general.jsqlparser.expression.BinaryExpression;
import com.fr.general.jsqlparser.expression.CaseExpression;
import com.fr.general.jsqlparser.expression.DateValue;
import com.fr.general.jsqlparser.expression.DoubleValue;
import com.fr.general.jsqlparser.expression.Expression;
import com.fr.general.jsqlparser.expression.ExpressionVisitor;
import com.fr.general.jsqlparser.expression.Function;
import com.fr.general.jsqlparser.expression.InverseExpression;
import com.fr.general.jsqlparser.expression.JdbcParameter;
import com.fr.general.jsqlparser.expression.LongValue;
import com.fr.general.jsqlparser.expression.NullValue;
import com.fr.general.jsqlparser.expression.Parenthesis;
import com.fr.general.jsqlparser.expression.StringValue;
import com.fr.general.jsqlparser.expression.TimeValue;
import com.fr.general.jsqlparser.expression.TimestampValue;
import com.fr.general.jsqlparser.expression.WhenClause;
import com.fr.general.jsqlparser.expression.operators.arithmetic.Addition;
import com.fr.general.jsqlparser.expression.operators.arithmetic.BitwiseAnd;
import com.fr.general.jsqlparser.expression.operators.arithmetic.BitwiseOr;
import com.fr.general.jsqlparser.expression.operators.arithmetic.BitwiseXor;
import com.fr.general.jsqlparser.expression.operators.arithmetic.Concat;
import com.fr.general.jsqlparser.expression.operators.arithmetic.Division;
import com.fr.general.jsqlparser.expression.operators.arithmetic.Multiplication;
import com.fr.general.jsqlparser.expression.operators.arithmetic.Subtraction;
import com.fr.general.jsqlparser.expression.operators.conditional.AndExpression;
import com.fr.general.jsqlparser.expression.operators.conditional.OrExpression;
import com.fr.general.jsqlparser.expression.operators.relational.Between;
import com.fr.general.jsqlparser.expression.operators.relational.EqualsTo;
import com.fr.general.jsqlparser.expression.operators.relational.ExistsExpression;
import com.fr.general.jsqlparser.expression.operators.relational.ExpressionList;
import com.fr.general.jsqlparser.expression.operators.relational.GreaterThan;
import com.fr.general.jsqlparser.expression.operators.relational.GreaterThanEquals;
import com.fr.general.jsqlparser.expression.operators.relational.InExpression;
import com.fr.general.jsqlparser.expression.operators.relational.IsNullExpression;
import com.fr.general.jsqlparser.expression.operators.relational.ItemsListVisitor;
import com.fr.general.jsqlparser.expression.operators.relational.LikeExpression;
import com.fr.general.jsqlparser.expression.operators.relational.Matches;
import com.fr.general.jsqlparser.expression.operators.relational.MinorThan;
import com.fr.general.jsqlparser.expression.operators.relational.MinorThanEquals;
import com.fr.general.jsqlparser.expression.operators.relational.NotEqualsTo;
import com.fr.general.jsqlparser.schema.Column;
import com.fr.general.jsqlparser.statement.select.SelectVisitor;
import com.fr.general.jsqlparser.statement.select.SubSelect;
import java.util.Iterator;
import java.util.List;

public class ExpressionDeParser
implements ExpressionVisitor,
ItemsListVisitor {
    protected StringBuffer buffer;
    protected SelectVisitor selectVisitor;
    protected boolean useBracketsInExprList = true;

    public ExpressionDeParser() {
    }

    public ExpressionDeParser(SelectVisitor selectVisitor, StringBuffer stringBuffer) {
        this.selectVisitor = selectVisitor;
        this.buffer = stringBuffer;
    }

    public StringBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuffer stringBuffer) {
        this.buffer = stringBuffer;
    }

    public void visit(Addition addition) {
        this.visitBinaryExpression(addition, " + ");
    }

    public void visit(AndExpression andExpression) {
        this.visitBinaryExpression(andExpression, " AND ");
    }

    public void visit(Between between) {
        between.getLeftExpression().accept(this);
        if (between.isNot()) {
            this.buffer.append(" NOT");
        }
        this.buffer.append(" BETWEEN ");
        between.getBetweenExpressionStart().accept(this);
        this.buffer.append(" AND ");
        between.getBetweenExpressionEnd().accept(this);
    }

    public void visit(Division division) {
        this.visitBinaryExpression(division, " / ");
    }

    public void visit(DoubleValue doubleValue) {
        this.buffer.append(doubleValue.getValue());
    }

    public void visit(EqualsTo equalsTo) {
        this.visitBinaryExpression(equalsTo, " = ");
    }

    public void visit(GreaterThan greaterThan) {
        this.visitBinaryExpression(greaterThan, " > ");
    }

    public void visit(GreaterThanEquals greaterThanEquals) {
        this.visitBinaryExpression(greaterThanEquals, " >= ");
    }

    public void visit(InExpression inExpression) {
        inExpression.getLeftExpression().accept(this);
        if (inExpression.isNot()) {
            this.buffer.append(" NOT");
        }
        this.buffer.append(" IN ");
        inExpression.getItemsList().accept(this);
    }

    public void visit(InverseExpression inverseExpression) {
        this.buffer.append("-");
        inverseExpression.getExpression().accept(this);
    }

    public void visit(IsNullExpression isNullExpression) {
        isNullExpression.getLeftExpression().accept(this);
        if (isNullExpression.isNot()) {
            this.buffer.append(" IS NOT NULL");
        } else {
            this.buffer.append(" IS NULL");
        }
    }

    public void visit(JdbcParameter jdbcParameter) {
        this.buffer.append("?");
    }

    public void visit(LikeExpression likeExpression) {
        this.visitBinaryExpression(likeExpression, " LIKE ");
    }

    public void visit(ExistsExpression existsExpression) {
        if (existsExpression.isNot()) {
            this.buffer.append(" NOT EXISTS ");
        } else {
            this.buffer.append(" EXISTS ");
        }
        existsExpression.getRightExpression().accept(this);
    }

    public void visit(LongValue longValue) {
        this.buffer.append(longValue.getStringValue());
    }

    public void visit(MinorThan minorThan) {
        this.visitBinaryExpression(minorThan, " < ");
    }

    public void visit(MinorThanEquals minorThanEquals) {
        this.visitBinaryExpression(minorThanEquals, " <= ");
    }

    public void visit(Multiplication multiplication) {
        this.visitBinaryExpression(multiplication, " * ");
    }

    public void visit(NotEqualsTo notEqualsTo) {
        this.visitBinaryExpression(notEqualsTo, " <> ");
    }

    public void visit(NullValue nullValue) {
        this.buffer.append("NULL");
    }

    public void visit(OrExpression orExpression) {
        this.visitBinaryExpression(orExpression, " OR ");
    }

    public void visit(Parenthesis parenthesis) {
        if (parenthesis.isNot()) {
            this.buffer.append(" NOT ");
        }
        this.buffer.append("(");
        parenthesis.getExpression().accept(this);
        this.buffer.append(")");
    }

    public void visit(StringValue stringValue) {
        this.buffer.append("'" + stringValue.getValue() + "'");
    }

    public void visit(Subtraction subtraction) {
        this.visitBinaryExpression(subtraction, "-");
    }

    private void visitBinaryExpression(BinaryExpression binaryExpression, String string) {
        if (binaryExpression.isNot()) {
            this.buffer.append(" NOT ");
        }
        binaryExpression.getLeftExpression().accept(this);
        this.buffer.append(string);
        binaryExpression.getRightExpression().accept(this);
    }

    public void visit(SubSelect subSelect) {
        this.buffer.append("(");
        subSelect.getSelectBody().accept(this.selectVisitor);
        this.buffer.append(")");
    }

    public void visit(Column column) {
        String string = column.getTable().getWholeTableName();
        if (string != null) {
            this.buffer.append(string + ".");
        }
        this.buffer.append(column.getColumnName());
    }

    public void visit(Function function) {
        if (function.isEscaped()) {
            this.buffer.append("{fn ");
        }
        this.buffer.append(function.getName());
        if (function.isAllColumns()) {
            this.buffer.append("(*)");
        } else if (function.getParameters() == null) {
            this.buffer.append("()");
        } else {
            boolean bl = this.useBracketsInExprList;
            if (function.isDistinct()) {
                this.useBracketsInExprList = false;
                this.buffer.append("(DISTINCT ");
            }
            this.visit(function.getParameters());
            this.useBracketsInExprList = bl;
            if (function.isDistinct()) {
                this.buffer.append(")");
            }
        }
        if (function.isEscaped()) {
            this.buffer.append("}");
        }
    }

    public void visit(ExpressionList expressionList) {
        if (this.useBracketsInExprList) {
            this.buffer.append("(");
        }
        Iterator iterator = expressionList.getExpressions().iterator();
        while (iterator.hasNext()) {
            Expression expression = (Expression)iterator.next();
            expression.accept(this);
            if (!iterator.hasNext()) continue;
            this.buffer.append(", ");
        }
        if (this.useBracketsInExprList) {
            this.buffer.append(")");
        }
    }

    public SelectVisitor getSelectVisitor() {
        return this.selectVisitor;
    }

    public void setSelectVisitor(SelectVisitor selectVisitor) {
        this.selectVisitor = selectVisitor;
    }

    public void visit(DateValue dateValue) {
        this.buffer.append("{d '" + dateValue.getValue().toString() + "'}");
    }

    public void visit(TimestampValue timestampValue) {
        this.buffer.append("{ts '" + timestampValue.getValue().toString() + "'}");
    }

    public void visit(TimeValue timeValue) {
        this.buffer.append("{t '" + timeValue.getValue().toString() + "'}");
    }

    public void visit(CaseExpression caseExpression) {
        this.buffer.append("CASE ");
        Expression expression = caseExpression.getSwitchExpression();
        if (expression != null) {
            expression.accept(this);
        }
        List list = caseExpression.getWhenClauses();
        for (Expression expression2 : list) {
            expression2.accept(this);
        }
        Expression expression3 = caseExpression.getElseExpression();
        if (expression3 != null) {
            expression3.accept(this);
        }
        this.buffer.append(" END");
    }

    public void visit(WhenClause whenClause) {
        this.buffer.append(" WHEN ");
        whenClause.getWhenExpression().accept(this);
        this.buffer.append(" THEN ");
        whenClause.getThenExpression().accept(this);
    }

    public void visit(AllComparisonExpression allComparisonExpression) {
        this.buffer.append(" ALL ");
        allComparisonExpression.GetSubSelect().accept(this);
    }

    public void visit(AnyComparisonExpression anyComparisonExpression) {
        this.buffer.append(" ANY ");
        anyComparisonExpression.GetSubSelect().accept(this);
    }

    public void visit(Concat concat) {
        this.visitBinaryExpression(concat, " || ");
    }

    public void visit(Matches matches) {
        this.visitBinaryExpression(matches, " @@ ");
    }

    public void visit(BitwiseAnd bitwiseAnd) {
        this.visitBinaryExpression(bitwiseAnd, " & ");
    }

    public void visit(BitwiseOr bitwiseOr) {
        this.visitBinaryExpression(bitwiseOr, " | ");
    }

    public void visit(BitwiseXor bitwiseXor) {
        this.visitBinaryExpression(bitwiseXor, " ^ ");
    }
}

