/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general;

import com.fr.general.ComparatorUtils;
import com.fr.general.DefaultValues;
import com.fr.general.EnvProvider;
import com.fr.general.FRLogger;
import com.fr.general.Inter;
import com.fr.stable.EnvChangedListener;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class GeneralContext {
    private static List envChangeListenerList = new ArrayList();
    private static List envWillChangeListenerList = new ArrayList();
    private static Locale locale = Locale.CHINA;
    private static DefaultValues defaultValues = null;
    private static EnvProvider envProvider = null;
    private static boolean shouldForceEnglish = false;

    private GeneralContext() {
    }

    public static EnvProvider getEnvProvider() {
        return envProvider;
    }

    public static void setEnvProvider(EnvProvider envProvider) {
        GeneralContext.envProvider = envProvider;
    }

    public static void addEnvChangedListener(EnvChangedListener envChangedListener) {
        envChangeListenerList.add(envChangedListener);
    }

    public static void addEnvWillChangedListener(EnvChangedListener envChangedListener) {
        envWillChangeListenerList.add(envChangedListener);
    }

    public static void fireEnvChangeListener() {
        for (int i2 = 0; i2 < envChangeListenerList.size(); ++i2) {
            ((EnvChangedListener)envChangeListenerList.get(i2)).envChanged();
        }
    }

    public static void fireEnvWillChangeListener() {
        for (int i2 = 0; i2 < envWillChangeListenerList.size(); ++i2) {
            ((EnvChangedListener)envWillChangeListenerList.get(i2)).envChanged();
        }
    }

    public static Locale getLocale() {
        return locale;
    }

    public static boolean isShouldForceEnglish() {
        return shouldForceEnglish;
    }

    public static void setShouldForceEnglish(boolean bl) {
        shouldForceEnglish = bl;
    }

    public static void setLanguage(int n2) {
        switch (n2) {
            case 2: {
                locale = Locale.US;
                break;
            }
            case 3: {
                locale = Locale.JAPAN;
                break;
            }
            case 1: {
                locale = Locale.CHINA;
                break;
            }
            case 4: {
                locale = Locale.TAIWAN;
                break;
            }
            default: {
                ResourceBundle resourceBundle = ResourceBundle.getBundle("com/fr/base/core/locale", Locale.getDefault());
                String string = resourceBundle.getString("language");
                locale = "zh".equals(string) ? Locale.CHINA : ("en".equals(string) ? Locale.US : (ComparatorUtils.equals(System.getProperty("user.language"), "en") ? Locale.ENGLISH : Locale.CHINA));
            }
        }
    }

    public static boolean isChineseEnv() {
        return ComparatorUtils.equals(locale, Locale.CHINA);
    }

    public static DefaultValues getDefaultValues() {
        if (defaultValues == null) {
            defaultValues = new DefaultValues();
        }
        return defaultValues;
    }

    public static void resetDefaultValues() {
        defaultValues = null;
    }

    public static InputStream getResourceStream(String string) {
        return GeneralContext.getResourceStream(string, true);
    }

    public static InputStream getResourceStream(String string, boolean bl) {
        EnvProvider envProvider = GeneralContext.getEnvProvider();
        if (envProvider != null) {
            try {
                InputStream inputStream = envProvider.readResource(string);
                if (bl && inputStream != null) {
                    FRLogger.getLogger().info(Inter.getLocText("Load_Resource_File") + ":\"" + string + "\".");
                }
                return inputStream;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getCurrentAppNameOfEnv() {
        return GeneralContext.getEnvProvider().getAppName();
    }
}

