/*
 * Decompiled with CFR 0.152.
 */
package com.fr.function;

import com.fr.script.AbstractFunction;
import com.fr.stable.script.Function;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class LUNAR
extends AbstractFunction {
    SimpleDateFormat chineseDateFormat = new SimpleDateFormat("yyyy,MM,dd");

    public Object run(Object[] objectArray) {
        if (objectArray.length != 3) {
            return new Integer(0);
        }
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] != null) continue;
            objectArray[i2] = new Integer(0);
        }
        Calendar calendar = Calendar.getInstance();
        String string = objectArray[0].toString() + "," + objectArray[1].toString() + "," + objectArray[2].toString();
        try {
            calendar.setTime(this.chineseDateFormat.parse(string));
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        Lunar lunar = new Lunar(calendar);
        return lunar;
    }

    public Function.Type getType() {
        return Function.DATETIME;
    }

    public String getCN() {
        return "LUNAR(year,day,month): \u8fd4\u56de\u5f53\u524d\u65e5\u671f\u5bf9\u5e94\u7684\u519c\u5386\u65f6\u95f4\u3002\nyear,month,day:\u5206\u522b\u5bf9\u5e94\u5e74\u6708\u65e5\u3002\n\u793a\u4f8b:\n\u5982\u679c\u9700\u8981\u67e5\u8be22011\u5e747\u670821\u65e5\u5bf9\u5e94\u7684\u519c\u5386\u65f6\u95f4\uff0c\u5219\u53ea\u9700\u8f93\u5165LUNAR(2011,7,21)\u7ed3\u679c\u5c06\u663e\u793a\u4e3a\uff1a\u8f9b\u536f\u5e74\u516d\u6708\u5eff\u4e00\n\u540c\u6837\uff0c\u5982\u8f93\u5165LUNAR(2001,7,21)\uff0c\u5219\u663e\u793a\uff1a\u8f9b\u5df3\u5e74\u516d\u6708\u521d\u4e00 \u3002\u672c\u516c\u5f0f\u652f\u6301\u7684\u65f6\u95f4\u6bb5\u4e3a1900-2049\u5e74\u3002";
    }

    public String getEN() {
        return "LUNAR (year, day, month): returns the current date corresponds to the lunar time. \nyear, month, day: month, day respectively. \nExample: \nIf you need to check July 21, 2011 corresponding to the lunar time, just enter the LUNAR (2011,7,21)The results will be displayed as: \u8f9b\u536f\u5e74\u516d\u6708\u5eff\u4e00 \nThe same as the input LUNAR (2001,7,21), is displayed: \u8f9b\u5df3\u5e74\u516d\u6708\u521d\u4e00 .The formula for the 1900-2049 period to support the years.";
    }

    class Lunar {
        private int year;
        private int month;
        private int day;
        private boolean leap;
        final String[] chineseNumber = new String[]{"\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u5341\u4e00", "\u5341\u4e8c"};
        final long[] lunarInfo = new long[]{19416L, 19168L, 42352L, 21717L, 53856L, 55632L, 91476L, 22176L, 39632L, 21970L, 19168L, 42422L, 42192L, 53840L, 119381L, 46400L, 54944L, 44450L, 38320L, 84343L, 18800L, 42160L, 46261L, 27216L, 27968L, 109396L, 11104L, 38256L, 21234L, 18800L, 25958L, 54432L, 59984L, 28309L, 23248L, 11104L, 100067L, 37600L, 116951L, 51536L, 54432L, 120998L, 46416L, 22176L, 107956L, 9680L, 37584L, 53938L, 43344L, 46423L, 27808L, 46416L, 86869L, 19872L, 42448L, 83315L, 21200L, 43432L, 59728L, 27296L, 44710L, 43856L, 19296L, 43748L, 42352L, 21088L, 62051L, 55632L, 23383L, 22176L, 38608L, 19925L, 19152L, 42192L, 54484L, 53840L, 54616L, 46400L, 46496L, 103846L, 38320L, 18864L, 43380L, 42160L, 45690L, 27216L, 27968L, 44870L, 43872L, 38256L, 19189L, 18800L, 25776L, 29859L, 59984L, 27480L, 21952L, 43872L, 38613L, 37600L, 51552L, 55636L, 54432L, 55888L, 30034L, 22176L, 43959L, 9680L, 37584L, 51893L, 43344L, 46240L, 47780L, 44368L, 21977L, 19360L, 42416L, 86390L, 21168L, 43312L, 31060L, 27296L, 44368L, 23378L, 19296L, 42726L, 42208L, 53856L, 60005L, 54576L, 23200L, 30371L, 38608L, 19415L, 19152L, 42192L, 118966L, 53840L, 54560L, 56645L, 46496L, 22224L, 21938L, 18864L, 42359L, 42160L, 43600L, 111189L, 27936L, 44448L};

        private final int yearDays(int n2) {
            int n3 = 348;
            for (int i2 = 32768; i2 > 8; i2 >>= 1) {
                if ((this.lunarInfo[n2 - 1900] & (long)i2) == 0L) continue;
                ++n3;
            }
            return n3 + this.leapDays(n2);
        }

        private final int leapDays(int n2) {
            if (this.leapMonth(n2) != 0) {
                if ((this.lunarInfo[n2 - 1900] & 0x10000L) != 0L) {
                    return 30;
                }
                return 29;
            }
            return 0;
        }

        private final int leapMonth(int n2) {
            return (int)(this.lunarInfo[n2 - 1900] & 0xFL);
        }

        private final int monthDays(int n2, int n3) {
            if ((this.lunarInfo[n2 - 1900] & (long)(65536 >> n3)) == 0L) {
                return 29;
            }
            return 30;
        }

        public final String animalsYear() {
            String[] stringArray = new String[]{"\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a", "\u7334", "\u9e21", "\u72d7", "\u732a"};
            return stringArray[(this.year - 4) % 12];
        }

        private final String cyclicalm(int n2) {
            String[] stringArray = new String[]{"\u7532", "\u4e59", "\u4e19", "\u4e01", "\u620a", "\u5df1", "\u5e9a", "\u8f9b", "\u58ec", "\u7678"};
            String[] stringArray2 = new String[]{"\u5b50", "\u4e11", "\u5bc5", "\u536f", "\u8fb0", "\u5df3", "\u5348", "\u672a", "\u7533", "\u9149", "\u620c", "\u4ea5"};
            return stringArray[n2 % 10] + stringArray2[n2 % 12];
        }

        public final String cyclical() {
            int n2 = this.year - 1900 + 36;
            return this.cyclicalm(n2);
        }

        public Lunar(Calendar calendar) {
            int n2;
            int n3;
            int n4 = 0;
            Date date = null;
            try {
                date = LUNAR.this.chineseDateFormat.parse("1900,1,31");
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
            int n5 = (int)((calendar.getTime().getTime() - date.getTime()) / 86400000L);
            int n6 = n5 + 40;
            int n7 = 14;
            int n8 = 0;
            for (n3 = 1900; n3 < 2050 && n5 > 0; ++n3) {
                n8 = this.yearDays(n3);
                n5 -= n8;
                n7 += 12;
            }
            if (n5 < 0) {
                n5 += n8;
                --n3;
                n7 -= 12;
            }
            this.year = n3;
            int n9 = n3 - 1864;
            n4 = this.leapMonth(n3);
            this.leap = false;
            int n10 = 0;
            for (n2 = 1; n2 < 13 && n5 > 0; ++n2) {
                if (n4 > 0 && n2 == n4 + 1 && !this.leap) {
                    --n2;
                    this.leap = true;
                    n10 = this.leapDays(this.year);
                } else {
                    n10 = this.monthDays(this.year, n2);
                }
                n5 -= n10;
                if (this.leap && n2 == n4 + 1) {
                    this.leap = false;
                }
                if (this.leap) continue;
                ++n7;
            }
            if (n5 == 0 && n4 > 0 && n2 == n4 + 1) {
                if (this.leap) {
                    this.leap = false;
                } else {
                    this.leap = true;
                    --n2;
                    --n7;
                }
            }
            if (n5 < 0) {
                n5 += n10;
                --n2;
                --n7;
            }
            this.month = n2;
            this.day = n5 + 1;
        }

        public String getChinaDayString(int n2) {
            int n3;
            String[] stringArray = new String[]{"\u521d", "\u5341", "\u5eff", "\u5345"};
            int n4 = n3 = n2 % 10 == 0 ? 9 : n2 % 10 - 1;
            if (n2 > 30) {
                return "";
            }
            if (n2 == 10) {
                return "\u521d\u5341";
            }
            return stringArray[n2 / 10] + this.chineseNumber[n3];
        }

        public String toString() {
            return this.cyclical() + "\u5e74" + (this.leap ? "\u95f0" : "") + this.chineseNumber[this.month - 1] + "\u6708" + this.getChinaDayString(this.day);
        }
    }
}

